// Generated by IcedCoffeeScript 1.8.0-c
(function() {
  var TtyLookup, fs, iced, make_esc, path, stateq, tty, __iced_k, __iced_k_noop;

  iced = require('iced-runtime');
  __iced_k = __iced_k_noop = function() {};

  fs = require('fs');

  tty = require('tty');

  path = require('path');

  make_esc = require('iced-error').make_esc;

  stateq = function(s1, s2) {
    var f, _i, _len, _ref;
    _ref = ['dev', 'rdev', 'ino'];
    for (_i = 0, _len = _ref.length; _i < _len; _i++) {
      f = _ref[_i];
      if (s1[f] !== s2[f]) {
        return false;
      }
    }
    return true;
  };

  TtyLookup = (function() {
    function TtyLookup(_arg) {
      this.fd = _arg.fd;
      this.fd || (this.fd = 0);
    }

    TtyLookup.prototype.assert_tty = function(cb) {
      var err;
      err = null;
      if (!tty.isatty(this.fd)) {
        err = new Error("stdin is not a tty");
      }
      return cb(err);
    };

    TtyLookup.prototype.os_check = function(cb) {
      var err, _ref;
      err = null;
      if ((_ref = process.platform) !== 'darwin' && _ref !== 'linux') {
        err = new Error("can only run on Linux and OSX");
      }
      return cb(err);
    };

    TtyLookup.prototype.find_tty_in = function(_arg, cb) {
      var dir, err, esc, file, files, regex, ret, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      dir = _arg.dir, regex = _arg.regex;
      ret = null;
      esc = make_esc(cb, "find_tty_in");
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/node-spotty/src/index.iced",
            funcname: "TtyLookup.find_tty_in"
          });
          fs.readdir(dir, esc(__iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                return files = arguments[0];
              };
            })(),
            lineno: 41
          })));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          (function(__iced_k) {
            var _i, _len, _ref, _results, _while;
            _ref = files;
            _len = _ref.length;
            _i = 0;
            _results = [];
            _while = function(__iced_k) {
              var _break, _continue, _next;
              _break = function() {
                return __iced_k(_results);
              };
              _continue = function() {
                return iced.trampoline(function() {
                  ++_i;
                  return _while(__iced_k);
                });
              };
              _next = function(__iced_next_arg) {
                _results.push(__iced_next_arg);
                return _continue();
              };
              if (!(_i < _len)) {
                return _break();
              } else {
                file = _ref[_i];
                (function(__iced_k) {
                  if (file.match(regex)) {
                    (function(__iced_k) {
                      __iced_deferrals = new iced.Deferrals(__iced_k, {
                        parent: ___iced_passed_deferral,
                        filename: "/Users/max/src/keybase/node-spotty/src/index.iced",
                        funcname: "TtyLookup.find_tty_in"
                      });
                      _this.try_file({
                        dir: dir,
                        file: file
                      }, __iced_deferrals.defer({
                        assign_fn: (function() {
                          return function() {
                            err = arguments[0];
                            return ret = arguments[1];
                          };
                        })(),
                        lineno: 44
                      }));
                      __iced_deferrals._fulfill();
                    })(function() {
                      (function(__iced_k) {
                        if (ret != null) {
                          (function(__iced_k) {
_break()
                          })(__iced_k);
                        } else {
                          return __iced_k();
                        }
                      })(__iced_k);
                    });
                  } else {
                    return __iced_k();
                  }
                })(_next);
              }
            };
            _while(__iced_k);
          })(function() {
            return cb(null, ret);
          });
        };
      })(this));
    };

    TtyLookup.prototype.try_file = function(_arg, cb) {
      var dir, err, file, p, ret, stat, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      dir = _arg.dir, file = _arg.file;
      p = path.join(dir, file);
      ret = null;
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/node-spotty/src/index.iced",
            funcname: "TtyLookup.try_file"
          });
          fs.stat(p, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                return stat = arguments[1];
              };
            })(),
            lineno: 53
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          if ((typeof err === "undefined" || err === null) && stateq(stat, _this._stat)) {
            ret = p;
          }
          return cb(err, ret);
        };
      })(this));
    };

    TtyLookup.prototype.find_tty = function(cb) {
      var err, res, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/node-spotty/src/index.iced",
            funcname: "TtyLookup.find_tty"
          });
          _this.find_tty_in({
            dir: "/dev",
            regex: /^tty[A-Za-z0-9]+$/
          }, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                return res = arguments[1];
              };
            })(),
            lineno: 60
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          (function(__iced_k) {
            if (typeof res === "undefined" || res === null) {
              (function(__iced_k) {
                __iced_deferrals = new iced.Deferrals(__iced_k, {
                  parent: ___iced_passed_deferral,
                  filename: "/Users/max/src/keybase/node-spotty/src/index.iced",
                  funcname: "TtyLookup.find_tty"
                });
                _this.find_tty_in({
                  dir: "/dev/pts",
                  regex: /^[0-9]+$/
                }, __iced_deferrals.defer({
                  assign_fn: (function() {
                    return function() {
                      err = arguments[0];
                      return res = arguments[1];
                    };
                  })(),
                  lineno: 62
                }));
                __iced_deferrals._fulfill();
              })(__iced_k);
            } else {
              return __iced_k();
            }
          })(function() {
            return cb(err, res);
          });
        };
      })(this));
    };

    TtyLookup.prototype.stat_fd = function(cb) {
      var err, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/node-spotty/src/index.iced",
            funcname: "TtyLookup.stat_fd"
          });
          fs.fstat(_this.fd, __iced_deferrals.defer({
            assign_fn: (function(__slot_1) {
              return function() {
                err = arguments[0];
                return __slot_1._stat = arguments[1];
              };
            })(_this),
            lineno: 68
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          return cb(err);
        };
      })(this));
    };

    TtyLookup.prototype.run = function(cb) {
      var esc, res, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      esc = make_esc(cb, "TtyLookup.run");
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/node-spotty/src/index.iced",
            funcname: "TtyLookup.run"
          });
          _this.assert_tty(esc(__iced_deferrals.defer({
            lineno: 75
          })));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          (function(__iced_k) {
            __iced_deferrals = new iced.Deferrals(__iced_k, {
              parent: ___iced_passed_deferral,
              filename: "/Users/max/src/keybase/node-spotty/src/index.iced",
              funcname: "TtyLookup.run"
            });
            _this.os_check(esc(__iced_deferrals.defer({
              lineno: 76
            })));
            __iced_deferrals._fulfill();
          })(function() {
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/Users/max/src/keybase/node-spotty/src/index.iced",
                funcname: "TtyLookup.run"
              });
              _this.stat_fd(esc(__iced_deferrals.defer({
                lineno: 77
              })));
              __iced_deferrals._fulfill();
            })(function() {
              (function(__iced_k) {
                __iced_deferrals = new iced.Deferrals(__iced_k, {
                  parent: ___iced_passed_deferral,
                  filename: "/Users/max/src/keybase/node-spotty/src/index.iced",
                  funcname: "TtyLookup.run"
                });
                _this.find_tty(esc(__iced_deferrals.defer({
                  assign_fn: (function() {
                    return function() {
                      return res = arguments[0];
                    };
                  })(),
                  lineno: 78
                })));
                __iced_deferrals._fulfill();
              })(function() {
                return cb(null, res);
              });
            });
          });
        };
      })(this));
    };

    return TtyLookup;

  })();

  exports.tty = function(cb) {
    return (new TtyLookup({})).run(cb);
  };

}).call(this);
