#!/usr/bin/env python2
#
# Copyright (C) 2009 Sebastian Pipping <sebastian@pipping.org>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.

class Distro:
    def _raise_abstract(self):
        raise Exception('Function must be overwritten.')

    def key(self):
        self._raise_abstract()

    def detected(self, debug=False):
        return False

    def gather(self, gate, debug=False):
        pass

    def data(self):
        self._raise_abstract()

    def html(self):
        self._raise_abstract()
