/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.nativec.type;

import de.intarsys.nativec.api.NativeInterface;
import de.intarsys.nativec.type.INativeObject;
import de.intarsys.nativec.type.INativeType;
import de.intarsys.nativec.type.NativeStruct;
import de.intarsys.nativec.type.NativeType;
import de.intarsys.nativec.type.StructMember;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NativeStructType
extends NativeType {
    private int byteBoundary = 1;
    private int byteOffset = 0;
    private int byteSize = 0;
    private final Map<String, StructMember> fields = new HashMap<String, StructMember>();
    private int fieldsSize = 0;
    private int packing = NativeInterface.get().pointerSize();

    protected NativeStructType() {
    }

    protected NativeStructType(Class<?> clazz) {
        super(clazz);
    }

    public StructMember declare(String string, INativeType iNativeType) {
        int n = iNativeType.getByteCount();
        int n2 = Math.min(iNativeType.getPreferredBoundary(), this.packing);
        this.byteBoundary = Math.max(this.byteBoundary, n2);
        this.byteOffset = this.byteOffset - ((this.byteOffset + n2 - 1) % n2 + 1) + n2;
        StructMember structMember = new StructMember(this, string, this.fieldsSize++, iNativeType, this.byteOffset);
        this.fields.put(string, structMember);
        this.byteOffset += n;
        this.byteSize = this.byteOffset;
        return structMember;
    }

    public int getByteBoundary() {
        return this.byteBoundary;
    }

    @Override
    public int getByteCount() {
        return this.getByteSize();
    }

    public int getByteSize() {
        return this.byteSize;
    }

    public StructMember getField(String string) {
        return this.fields.get(string);
    }

    public List<StructMember> getFields() {
        return new ArrayList<StructMember>(this.fields.values());
    }

    public int getFieldsSize() {
        return this.fieldsSize;
    }

    public INativeObject getNativeObject(NativeStruct nativeStruct, String string) {
        StructMember structMember = this.fields.get(string);
        return structMember.getNativeObject(nativeStruct);
    }

    public int getPacking() {
        return this.packing;
    }

    @Override
    public int getPreferredBoundary() {
        return this.getByteBoundary();
    }

    public void setPacking(int n) {
        if (!this.fields.isEmpty()) {
            throw new IllegalStateException("packing must be set before members are declared");
        }
        this.packing = n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (StructMember structMember : this.getFields()) {
            stringBuilder.append(structMember.toString());
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }
}

