/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient.business.environment;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Observable;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.pdfsam.guiclient.GuiClient;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.guiclient.gui.panels.JTreePanel;
import org.pdfsam.guiclient.plugins.interfaces.AbstractPlugablePanel;
import org.pdfsam.guiclient.plugins.models.PluginDataModel;
import org.pdfsam.i18n.GettextResource;

public class Environment
extends Observable {
    private static final Logger LOG = Logger.getLogger(Environment.class.getPackage().getName());
    private ResourceBundle i18nMessages;
    private Map<PluginDataModel, AbstractPlugablePanel> plugins;
    private JTreePanel treePanel;

    public Environment(Map<PluginDataModel, AbstractPlugablePanel> plugins, JTreePanel treePanel) {
        this.plugins = plugins;
        this.treePanel = treePanel;
        this.i18nMessages = Configuration.getInstance().getI18nResourceBundle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void saveEnvironment(File outFile, boolean savePasswords) {
        try {
            if (outFile != null) {
                Class<Environment> clazz = Environment.class;
                synchronized (Environment.class) {
                    Document document = DocumentHelper.createDocument();
                    Element root = document.addElement("pdfsam_saved_jobs");
                    root.addAttribute("version", GuiClient.getVersion());
                    root.addAttribute("savedate", new SimpleDateFormat("dd-MMM-yyyy").format(new Date()));
                    String selection = this.treePanel.getSelectedPlugin();
                    if (selection != null && selection.length() > 0) {
                        root.addAttribute("selection", selection);
                    }
                    for (AbstractPlugablePanel plugablePanel : this.plugins.values()) {
                        Element node = root.addElement("plugin");
                        node.addAttribute("class", plugablePanel.getClass().getName());
                        node.addAttribute("name", plugablePanel.getPluginName());
                        plugablePanel.getJobNode(node, savePasswords);
                        LOG.info(GettextResource.gettext((ResourceBundle)this.i18nMessages, (String)(plugablePanel.getPluginName() + " node environment loaded.")));
                    }
                    BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(outFile));
                    OutputFormat format = OutputFormat.createPrettyPrint();
                    format.setEncoding("UTF-8");
                    XMLWriter xmlWriter = new XMLWriter(bos, format);
                    xmlWriter.write(document);
                    xmlWriter.flush();
                    xmlWriter.close();
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    LOG.info(GettextResource.gettext((ResourceBundle)this.i18nMessages, (String)"Environment saved."));
                    return;
                }
            }
            LOG.error(GettextResource.gettext((ResourceBundle)this.i18nMessages, (String)"Error saving environment, output file is null."));
            return;
        }
        catch (Exception ex) {
            LOG.error(GettextResource.gettext((ResourceBundle)this.i18nMessages, (String)"Error saving environment."), ex);
        }
    }

    public void saveEnvironment(File outFile) {
        this.saveEnvironment(outFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadJobs(File inputFile) {
        if (inputFile != null && inputFile.exists() && inputFile.canRead()) {
            try {
                Class<Environment> clazz = Environment.class;
                synchronized (Environment.class) {
                    SAXReader reader = new SAXReader();
                    Document document = reader.read(inputFile);
                    for (AbstractPlugablePanel plugablePanel : this.plugins.values()) {
                        Node node = document.selectSingleNode("/pdfsam_saved_jobs/plugin[@class=\"" + plugablePanel.getClass().getName() + "\"]");
                        if (node == null) {
                            node = document.selectSingleNode("/pdfsam_saved_jobs/plugin[@class=\"" + plugablePanel.getClass().getName().replaceAll("^org.pdfsam", "it.pdfsam") + "\"]");
                        }
                        if (node == null) continue;
                        plugablePanel.resetPanel();
                        plugablePanel.loadJobNode(node);
                    }
                    Node node = document.selectSingleNode("/pdfsam_saved_jobs/@selection");
                    if (node != null) {
                        this.treePanel.setSelectedPlugin(node.getText());
                    }
                    LOG.info(GettextResource.gettext((ResourceBundle)this.i18nMessages, (String)"Environment loaded."));
                    this.setChanged();
                    this.notifyObservers(inputFile);
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                }
            }
            catch (Exception ex) {
                LOG.error(GettextResource.gettext((ResourceBundle)this.i18nMessages, (String)"Error loading environment."), ex);
            }
        } else {
            LOG.error(GettextResource.gettext((ResourceBundle)this.i18nMessages, (String)("Error loading environment from input file. " + inputFile)));
        }
        {
            return;
        }
    }
}

