/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.color.awt;

import de.intarsys.cwt.awt.image.CwtAwtImageTools;
import de.intarsys.pdf.pd.PDCSDeviceGray;
import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.pdf.pd.PDImage;
import de.intarsys.pdf.platform.cwt.color.awt.AwtCSDevice;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;

public class AwtCSDeviceGray
extends AwtCSDevice {
    public AwtCSDeviceGray(PDColorSpace pDColorSpace) {
        super(pDColorSpace);
    }

    @Override
    protected ColorSpace createColorSpace() {
        return ColorSpace.getInstance(1003);
    }

    @Override
    public ColorModel getColorModel(PDImage pDImage) {
        int n = pDImage.getBitsPerComponent();
        if (n < 8) {
            byte[] byArray = new byte[(int)Math.pow(2.0, n)];
            int n2 = 0;
            while (n2 < byArray.length) {
                int n3 = (int)((float)n2 * 255.0f / (float)(byArray.length - 1));
                byArray[n2] = (byte)(n3 & 0xFF);
                ++n2;
            }
            IndexColorModel indexColorModel = new IndexColorModel(n, byArray.length, byArray, byArray, byArray);
            return indexColorModel;
        }
        return CwtAwtImageTools.getGrayColorModel();
    }

    @Override
    public int getNumComponents() {
        return 1;
    }

    @Override
    public float[] getRGB(float[] fArray) {
        return new float[]{fArray[0], fArray[0], fArray[0]};
    }

    protected PDCSDeviceGray myPDColorSpace() {
        return (PDCSDeviceGray)this.getPDColorSpace();
    }
}

