/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.content;

import de.intarsys.pdf.content.TextState;
import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.pdf.pd.PDExtGState;
import de.intarsys.tools.attribute.AttributeMap;
import de.intarsys.tools.attribute.IAttributeSupport;
import java.awt.Shape;
import java.awt.geom.AffineTransform;

public final class GraphicsState
implements IAttributeSupport {
    private final AttributeMap attributes = new AttributeMap();
    public int capStyle;
    public Shape clip;
    public float[] dashPattern;
    public float dashPhase;
    public int joinStyle;
    public float lineWidth;
    public float miterLimit;
    public float nonStrokeAlphaValue;
    public PDColorSpace nonStrokeColorSpace;
    public float[] nonStrokeColorValues;
    public float strokeAlphaValue;
    public PDColorSpace strokeColorSpace;
    public PDExtGState extState;
    public float[] strokeColorValues;
    public TextState textState;
    public AffineTransform transform;

    public GraphicsState() {
        this.dashPattern = new float[0];
        this.dashPhase = 0.0f;
        this.capStyle = 0;
        this.joinStyle = 0;
        this.lineWidth = 1.0f;
        this.miterLimit = 10.0f;
        this.nonStrokeAlphaValue = 1.0f;
        this.strokeAlphaValue = 1.0f;
        this.textState = new TextState();
        this.extState = null;
        this.transform = new AffineTransform();
    }

    protected GraphicsState(GraphicsState graphicsState) {
        this.capStyle = graphicsState.capStyle;
        this.dashPattern = graphicsState.dashPattern;
        this.dashPhase = graphicsState.dashPhase;
        if (graphicsState.extState != null) {
            this.extState = (PDExtGState)PDExtGState.META.createFromCos(graphicsState.extState.cosGetObject().copyShallow());
        }
        this.joinStyle = graphicsState.joinStyle;
        this.lineWidth = graphicsState.lineWidth;
        this.miterLimit = graphicsState.miterLimit;
        this.nonStrokeAlphaValue = graphicsState.nonStrokeAlphaValue;
        this.nonStrokeColorSpace = graphicsState.nonStrokeColorSpace;
        this.nonStrokeColorValues = graphicsState.nonStrokeColorValues;
        this.strokeAlphaValue = graphicsState.strokeAlphaValue;
        this.strokeColorSpace = graphicsState.strokeColorSpace;
        this.strokeColorValues = graphicsState.strokeColorValues;
        this.textState = graphicsState.textState.copy();
        this.transform = graphicsState.transform;
        this.clip = graphicsState.clip;
    }

    public GraphicsState copy() {
        return new GraphicsState(this);
    }

    public final Object getAttribute(Object object) {
        return this.attributes.getAttribute(object);
    }

    public final Object removeAttribute(Object object) {
        return this.attributes.removeAttribute(object);
    }

    public final Object setAttribute(Object object, Object object2) {
        return this.attributes.setAttribute(object, object2);
    }
}

