/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.logging;

import de.intarsys.tools.format.TrivialDateFormat;
import de.intarsys.tools.logging.SDC;
import de.intarsys.tools.string.StringTools;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.Format;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public class SimpleFormatter
extends Formatter {
    private static final String LF = System.getProperty("line.separator");
    private Format dateFormat = new TrivialDateFormat();
    private final StringBuffer sb = new StringBuffer();
    private int widthSDC = 20;
    private boolean showDate = true;
    private boolean showLevel = true;
    private boolean showName = true;
    private boolean showSDC = false;
    private boolean showThread = true;
    private int widthLevel = 7;
    private int widthName = 30;
    private int widthThread = 15;

    static {
        new TrivialDateFormat();
        StringTools.isEmpty("");
        Calendar.getInstance();
        SDC.get();
    }

    public SimpleFormatter() {
        this.configure();
    }

    protected void configure() {
        String string = this.getClass().getName();
        this.setShowSDC(this.getBooleanProperty(String.valueOf(string) + ".sdc.show", this.isShowSDC()));
        this.setWidthSDC(this.getIntProperty(String.valueOf(string) + ".sdc.width", this.getWidthSDC()));
        this.setShowThread(this.getBooleanProperty(String.valueOf(string) + ".thread.show", this.isShowThread()));
        this.setWidthThread(this.getIntProperty(String.valueOf(string) + ".thread.width", this.getWidthThread()));
        this.setShowDate(this.getBooleanProperty(String.valueOf(string) + ".date.show", this.isShowDate()));
        this.setShowLevel(this.getBooleanProperty(String.valueOf(string) + ".level.show", this.isShowLevel()));
        this.setWidthLevel(this.getIntProperty(String.valueOf(string) + ".level.width", this.getWidthLevel()));
        this.setShowName(this.getBooleanProperty(String.valueOf(string) + ".name.show", this.isShowName()));
        this.setWidthName(this.getIntProperty(String.valueOf(string) + ".name.width", this.getWidthName()));
    }

    @Override
    public synchronized String format(LogRecord logRecord) {
        int n;
        this.sb.setLength(0);
        if (this.isShowDate()) {
            this.sb.append("[");
            int n2 = this.sb.length();
            this.dateFormat.format(new Date(logRecord.getMillis()), this.sb, null);
            n = this.sb.length() - n2;
            while (n < 24) {
                this.sb.append(' ');
                ++n;
            }
            this.sb.append("]");
        }
        if (this.isShowLevel()) {
            this.sb.append("[");
            String string = logRecord.getLevel().toString();
            this.sb.append(string);
            n = string.length();
            while (n < this.widthLevel) {
                this.sb.append(' ');
                ++n;
            }
            this.sb.append("]");
        }
        if (this.isShowName()) {
            String string = logRecord.getLoggerName();
            if (string == null) {
                string = "<unknown>";
            }
            if (string.length() > this.widthName) {
                string = StringTools.getTrailing(string, this.widthName);
            }
            this.sb.append("[");
            this.sb.append(string);
            n = string.length();
            while (n < this.widthName) {
                this.sb.append(' ');
                ++n;
            }
            this.sb.append("]");
        }
        if (this.isShowThread()) {
            String string = Thread.currentThread().getName();
            if (string.length() > this.widthThread) {
                string = StringTools.getTrailing(string, this.widthThread);
            }
            this.sb.append("[");
            this.sb.append(string);
            n = string.length();
            while (n < this.widthThread) {
                this.sb.append(' ');
                ++n;
            }
            this.sb.append("]");
        }
        if (this.isShowSDC()) {
            this.sb.append("[");
            String string = String.valueOf(SDC.get());
            this.sb.append(string);
            n = string.length();
            while (n < this.widthSDC) {
                this.sb.append(' ');
                ++n;
            }
            this.sb.append("]");
        }
        this.sb.append(" ");
        this.sb.append(logRecord.getMessage());
        this.sb.append(LF);
        if (logRecord.getThrown() != null) {
            try {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                logRecord.getThrown().printStackTrace(printWriter);
                printWriter.close();
                this.sb.append(stringWriter.toString());
                this.sb.append(LF);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.sb.toString();
    }

    protected boolean getBooleanProperty(String string, boolean bl) {
        LogManager logManager = LogManager.getLogManager();
        String string2 = logManager.getProperty(string);
        if (StringTools.isEmpty(string2)) {
            return bl;
        }
        return Boolean.valueOf(string2.trim());
    }

    protected int getIntProperty(String string, int n) {
        LogManager logManager = LogManager.getLogManager();
        String string2 = logManager.getProperty(string);
        if (StringTools.isEmpty(string2)) {
            return n;
        }
        try {
            return Integer.valueOf(string2.trim());
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public int getWidthLevel() {
        return this.widthLevel;
    }

    public int getWidthName() {
        return this.widthName;
    }

    public int getWidthSDC() {
        return this.widthSDC;
    }

    public int getWidthThread() {
        return this.widthThread;
    }

    public boolean isShowDate() {
        return this.showDate;
    }

    public boolean isShowLevel() {
        return this.showLevel;
    }

    public boolean isShowName() {
        return this.showName;
    }

    public boolean isShowSDC() {
        return this.showSDC;
    }

    public boolean isShowThread() {
        return this.showThread;
    }

    public void setShowDate(boolean bl) {
        this.showDate = bl;
    }

    public void setShowLevel(boolean bl) {
        this.showLevel = bl;
    }

    public void setShowName(boolean bl) {
        this.showName = bl;
    }

    public void setShowSDC(boolean bl) {
        this.showSDC = bl;
    }

    public void setShowThread(boolean bl) {
        this.showThread = bl;
    }

    public void setWidthLevel(int n) {
        this.widthLevel = n;
    }

    public void setWidthName(int n) {
        this.widthName = n;
    }

    public void setWidthSDC(int n) {
        this.widthSDC = n;
    }

    public void setWidthThread(int n) {
        this.widthThread = n;
    }
}

