/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.plugin.vcomposer.listeners;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.LinkedList;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.pdfsam.guiclient.business.listeners.AbstractRunButtonActionListener;
import org.pdfsam.guiclient.commons.business.SoundPlayer;
import org.pdfsam.guiclient.commons.business.WorkExecutor;
import org.pdfsam.guiclient.commons.business.WorkThread;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.guiclient.dto.StringItem;
import org.pdfsam.guiclient.utils.DialogUtility;
import org.pdfsam.i18n.GettextResource;
import org.pdfsam.plugin.vcomposer.GUI.VComposerMainGUI;

public class RunButtonActionListener
extends AbstractRunButtonActionListener {
    private static final Logger log = Logger.getLogger((String)RunButtonActionListener.class.getPackage().getName());
    private VComposerMainGUI panel;

    public RunButtonActionListener(VComposerMainGUI panel) {
        this.panel = panel;
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.panel.getComposerPanel().hasValidElements()) {
            JOptionPane.showMessageDialog((Component)((Object)this.panel), GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Please select a pdf document or undelete some pages"), GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Warning"), 2);
            return;
        }
        if (StringUtils.isEmpty((String)this.panel.getDestinationFileText().getText())) {
            DialogUtility.showWarningNoDestinationSelected((Component)((Object)this.panel), (int)0);
            return;
        }
        if (this.panel.getOverwriteCheckbox().isSelected() && Configuration.getInstance().isAskOverwriteConfirmation()) {
            int dialogRet = DialogUtility.askForOverwriteConfirmation((Component)((Object)this.panel));
            if (1 == dialogRet) {
                this.panel.getOverwriteCheckbox().setSelected(false);
            } else if (2 == dialogRet) {
                return;
            }
        }
        LinkedList<String> args = new LinkedList<String>();
        try {
            File destFile;
            int chosenOpt;
            args.addAll(this.panel.getComposerPanel().getValidConsoleParameters());
            String rotation = this.panel.getComposerPanel().getRotatedElementsString();
            if (rotation != null && rotation.length() > 0) {
                args.add("-r");
                args.add(rotation);
            }
            String destination = "";
            RunButtonActionListener.ensurePdfExtensionOnTextField((JTextField)this.panel.getDestinationFileText());
            File destinationDir = new File(this.panel.getDestinationFileText().getText());
            File parent = destinationDir.getParentFile();
            if (parent == null || !parent.exists()) {
                String suggestedDir = null;
                if (Configuration.getInstance().getDefaultWorkingDirectory() != null && Configuration.getInstance().getDefaultWorkingDirectory().length() > 0) {
                    suggestedDir = new File(Configuration.getInstance().getDefaultWorkingDirectory(), destinationDir.getName()).getAbsolutePath();
                }
                if (suggestedDir != null) {
                    chosenOpt = DialogUtility.showConfirmOuputLocationDialog((Component)((Object)this.panel), suggestedDir);
                    if (0 == chosenOpt) {
                        this.panel.getDestinationFileText().setText(suggestedDir);
                    } else if (2 == chosenOpt) {
                        return;
                    }
                }
            }
            File file = destFile = (destination = this.panel.getDestinationFileText().getText()) != null ? new File(destination) : null;
            if (destFile != null && destFile.exists() && !this.panel.getOverwriteCheckbox().isSelected()) {
                chosenOpt = DialogUtility.askForOverwriteOutputFileDialog((Component)((Object)this.panel), (String)destFile.getName());
                if (0 == chosenOpt) {
                    this.panel.getOverwriteCheckbox().setSelected(true);
                } else if (2 == chosenOpt) {
                    return;
                }
            }
            args.add("-o");
            args.add(destination);
            if (this.panel.getOverwriteCheckbox().isSelected()) {
                args.add("-overwrite");
            }
            if (this.panel.getOutputCompressedCheck().isSelected()) {
                args.add("-compressed");
            }
            args.add("-pdfversion");
            args.add(((StringItem)this.panel.getVersionCombo().getSelectedItem()).getId());
            args.add("concat");
            String[] myStringArray = args.toArray(new String[args.size()]);
            WorkExecutor.getInstance().execute((Runnable)new WorkThread(myStringArray));
        }
        catch (Exception ex) {
            log.error((Object)GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Error: "), (Throwable)ex);
            SoundPlayer.getInstance().playErrorSound();
        }
    }
}

