/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.diagram.draw;

import com.baselet.diagram.draw.DrawHandler;
import com.baselet.diagram.draw.helper.Style;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.ListIterator;

public class TextSplitter {
    private static LinkedHashMap<SplitStringCacheKey, String> splitStringCache = new LinkedHashMap(100);

    public static boolean checkifStringFits(String string, double d, DrawHandler drawHandler) {
        return TextSplitter.splitString(string, d, drawHandler).equals(string);
    }

    public static String splitString(String string, double d, DrawHandler drawHandler) {
        SplitStringCacheKey splitStringCacheKey = new SplitStringCacheKey(string, d, drawHandler.getStyleClone());
        String string2 = splitStringCache.get(splitStringCacheKey);
        if (string2 != null) {
            return string2;
        }
        string2 = TextSplitter.splitStringAlgorithm(string, d, drawHandler);
        splitStringCache.put(splitStringCacheKey, string2);
        return string2;
    }

    private static String splitStringAlgorithm(String string, double d, DrawHandler drawHandler) {
        String string2;
        String string3 = " ";
        d -= drawHandler.textWidth("n");
        ListIterator<String> listIterator = new ArrayList<String>(Arrays.asList(string.split(string3, -1))).listIterator();
        StringBuilder stringBuilder = new StringBuilder("");
        while (listIterator.hasNext()) {
            string2 = listIterator.next();
            StringBuilder stringBuilder2 = new StringBuilder();
            if (drawHandler.textWidth(stringBuilder2.append(stringBuilder.toString()).append(string2).toString()) > d) {
                listIterator.previous();
                break;
            }
            stringBuilder.append(string2).append(string3);
            listIterator.remove();
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        string2 = stringBuilder.toString();
        if (listIterator.hasNext() && string2.isEmpty()) {
            String string4;
            String string5 = string4 = listIterator.next();
            while (!string5.isEmpty() && drawHandler.textWidth(string5) > d) {
                string5 = string5.substring(0, string5.length() - 1);
            }
            string2 = string5;
        }
        return string2;
    }

    private static class SplitStringCacheKey {
        private final String input;
        private final double width;
        private final Style style;

        public SplitStringCacheKey(String string, double d, Style style) {
            this.input = string;
            this.width = d;
            this.style = style;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.input == null ? 0 : this.input.hashCode());
            n = 31 * n + (this.style == null ? 0 : this.style.hashCode());
            long l = Double.doubleToLongBits(this.width);
            n = 31 * n + (int)(l ^ l >>> 32);
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            SplitStringCacheKey splitStringCacheKey = (SplitStringCacheKey)object;
            if (this.input == null ? splitStringCacheKey.input != null : !this.input.equals(splitStringCacheKey.input)) {
                return false;
            }
            if (this.style == null ? splitStringCacheKey.style != null : !this.style.equals(splitStringCacheKey.style)) {
                return false;
            }
            return Double.doubleToLongBits(this.width) == Double.doubleToLongBits(splitStringCacheKey.width);
        }
    }
}

