/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.facet.common;

import com.baselet.diagram.draw.helper.ColorOwn;
import com.baselet.diagram.draw.helper.StyleException;
import com.baselet.element.facet.FirstRunKeyValueFacet;
import com.baselet.element.facet.KeyValueFacet;
import com.baselet.element.facet.PropertiesParserState;

public class TransparencyFacet
extends FirstRunKeyValueFacet {
    public static final TransparencyFacet INSTANCE = new TransparencyFacet();

    private TransparencyFacet() {
    }

    @Override
    public KeyValueFacet.KeyValue getKeyValue() {
        return new KeyValueFacet.KeyValue("transparency", false, "0", "background color transparency in percent");
    }

    @Override
    public void handleValue(String string, PropertiesParserState propertiesParserState) {
        try {
            int n = Integer.parseInt(string);
            if (n < 0 || n > 100) {
                throw new NumberFormatException();
            }
            double d = 255.0 - (double)n * 2.55;
            ColorOwn colorOwn = propertiesParserState.getDrawer().getBackgroundColor();
            propertiesParserState.getDrawer().setBackgroundColor(colorOwn.transparency((int)d));
        }
        catch (NumberFormatException numberFormatException) {
            throw new StyleException("The value must be between 0 and 100");
        }
    }
}

