(function(){
    "use strict";
    var _$rapyd$_iterator_symbol = (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") ? Symbol.iterator : "iterator-Symbol-5d0927e5554349048cf0e3762a228256";
    var _$rapyd$_kwargs_symbol = (typeof Symbol === "function") ? Symbol("kwargs-object") : "kwargs-object-Symbol-5d0927e5554349048cf0e3762a228256";
    var _$rapyd$_cond_temp;
    function _$rapyd$_extends(child, parent) {
            child.prototype = Object.create(parent.prototype);
            child.prototype.constructor = child;
        };
    function _$rapyd$_Iterable(iterable) {
            var iterator, ans, result;
            if (_$rapyd$_arraylike(iterable)) {
                return iterable;
            }
            if (typeof iterable[_$rapyd$_iterator_symbol] === "function") {
                iterator = (typeof Map === "function" && iterable instanceof Map) ? iterable.keys() : iterable[_$rapyd$_iterator_symbol]();
                ans = _$rapyd$_list_decorate([]);
                result = iterator.next();
                while (!result.done) {
                    ans.push(result.value);
                    result = iterator.next();
                }
                return ans;
            }
            return Object.keys(iterable);
        };
    var _$rapyd$_desugar_kwargs = (function _$rapyd$_desugar_kwargs() {
            if (typeof Object.assign === "function") {
                return function() {
                    var ans;
                    ans = {};
                    ans[_$rapyd$_kwargs_symbol] = true;
                    for (var i = 0; i < arguments.length; i++) {
                        Object.assign(ans, arguments[i]);
                    }
                    return ans;
                };
            }
            return function() {
                var ans, keys;
                ans = {};
                ans[_$rapyd$_kwargs_symbol] = true;
                for (var i = 0; i < arguments.length; i++) {
                    keys = Object.keys(arguments[i]);
                    for (var j = 0; j < keys.length; j++) {
                        ans[keys[j]] = arguments[i][keys[j]];
                    }
                }
                return ans;
            };
        })();
    function enumerate(iterable) {
            var ans, iterator;
            if (_$rapyd$_arraylike(iterable)) {
                ans = {
                    "_i": -1,
                    "next": function() {
                        this._i += 1;
                        if (this._i < iterable.length) {
                            return {
                                "done": false,
                                "value": _$rapyd$_list_decorate([ this._i, iterable[this._i] ])
                            };
                        }
                        return {
                            "done": true
                        };
                    }
                };
                ans[_$rapyd$_iterator_symbol] = function() {
                    return this;
                };
                return ans;
            }
            if (typeof iterable[_$rapyd$_iterator_symbol] === "function") {
                iterator = (typeof Map === "function" && iterable instanceof Map) ? iterable.keys() : iterable[_$rapyd$_iterator_symbol]();
                ans = {
                    "_iterator": iterator,
                    "_i": -1,
                    "next": function() {
                        var r;
                        r = this._iterator.next();
                        if (r.done) {
                            return {
                                "done": true
                            };
                        }
                        this._i += 1;
                        return {
                            "done": false,
                            "value": _$rapyd$_list_decorate([ this._i, r.value ])
                        };
                    }
                };
                ans[_$rapyd$_iterator_symbol] = function() {
                    return this;
                };
                return ans;
            }
            return enumerate(Object.keys(iterable));
        };
    function callable(x) {
            return typeof x === "function";
        };
    var _$rapyd$_in = (function _$rapyd$_in() {
            if (typeof Map === "function" && typeof Set === "function") {
                return function(val, arr) {
                    if (Array.isArray(arr) || typeof arr === "string") {
                        return arr.indexOf(val) !== -1;
                    }
                    if (typeof arr.__contains__ === "function") {
                        return arr.__contains__(val);
                    }
                    if ((arr instanceof Map || arr instanceof Set)) {
                        return arr.has(val);
                    }
                    return Object.prototype.hasOwnProperty.call(arr, val);
                };
            }
            return function(val, arr) {
                if (Array.isArray(arr) || typeof arr === "string") {
                    return arr.indexOf(val) !== -1;
                }
                if (typeof arr.__contains__ === "function") {
                    return arr.__contains__(val);
                }
                return Object.prototype.hasOwnProperty.call(arr, val);
            };
        })();
    function getattr(obj, name, defval) {
            var ret;
            try {
                ret = obj[name];
            } catch (_$rapyd$_Exception) {
                if (_$rapyd$_Exception instanceof TypeError) {
                    if (defval === undefined) {
                        throw new AttributeError("The attribute " + name + " is not present");
                    }
                    return defval;
                } else {
                    throw _$rapyd$_Exception;
                }
            }
            if (ret === undefined && !(name in obj)) {
                if (defval === undefined) {
                    throw new AttributeError("The attribute " + name + " is not present");
                }
                ret = defval;
            }
            return ret;
        };
    var len = (function _$rapyd$_len() {
            if (typeof Set === "function" && typeof Map === "function") {
                return function(obj) {
                    if (_$rapyd$_arraylike(obj)) {
                        return obj.length;
                    }
                    if (obj instanceof Set || obj instanceof Map) {
                        return obj.size;
                    }
                    if (typeof obj.__len__ === "function") {
                        return obj.__len__();
                    }
                    return Object.keys(obj).length;
                };
            }
            return function(obj) {
                if (_$rapyd$_arraylike(obj)) {
                    return obj.length;
                }
                if (typeof obj.__len__ === "function") {
                    return obj.__len__();
                }
                return Object.keys(obj).length;
            };
        })();
    function sum(iterable, start) {
    var ans, iterator, r;
    if (Array.isArray(iterable)) {
        return iterable.reduce(function(prev, cur) {
            return prev + cur;
        }, start || 0);
    }
    ans = start || 0;
    iterator = iter(iterable);
    r = iterator.next();
    while (!r.done) {
        ans += r.value;
        r = iterator.next();
    }
    return ans;
}
function map() {
    var func, iterators, args;
    func = arguments[0];
    iterators = new Array(arguments.length - 1);
    args = new Array(arguments.length - 1);
    for (var i = 1; i < arguments.length; i++) {
        iterators[i - 1] = iter(arguments[i]);
    }
    return (function(){
        var _$rapyd$_d = {};
        _$rapyd$_d["_func"] = func;
        _$rapyd$_d["_iterators"] = iterators;
        _$rapyd$_d["_args"] = args;
        _$rapyd$_d["next"] = function() {
            var r;
            for (var i = 0; i < this._iterators.length; i++) {
                r = this._iterators[i].next();
                if (r.done) {
                    return {
                        "done": true
                    };
                }
                this._args[i] = r.value;
            }
            return {
                "done": false,
                "value": this._func.apply(undefined, this._args)
            };
        };
        _$rapyd$_d[_$rapyd$_iterator_symbol] = function() {
            return this;
        };
        return _$rapyd$_d;
    })();
}
function filter(func_or_none, iterable) {
    return (function(){
        var _$rapyd$_d = {};
        _$rapyd$_d["_iterator"] = iter(iterable);
        _$rapyd$_d["_func"] = (func_or_none === null) ? bool : func_or_none;
        _$rapyd$_d["next"] = function() {
            var r;
            r = this._iterator.next();
            while (!r.done) {
                if (this._func(r.value)) {
                    return r;
                }
                r = this._iterator.next();
            }
            return {
                "done": true
            };
        };
        _$rapyd$_d[_$rapyd$_iterator_symbol] = function() {
            return this;
        };
        return _$rapyd$_d;
    })();
}
function zip() {
    var iterators;
    iterators = new Array(arguments.length);
    for (var i = 0; i < arguments.length; i++) {
        iterators[i] = iter(arguments[i]);
    }
    return (function(){
        var _$rapyd$_d = {};
        _$rapyd$_d["_iterators"] = iterators;
        _$rapyd$_d["next"] = function() {
            var args, r;
            args = new Array(this._iterators.length);
            for (var i = 0; i < this._iterators.length; i++) {
                r = this._iterators[i].next();
                if (r.done) {
                    return {
                        "done": true
                    };
                }
                args[i] = r.value;
            }
            return {
                "done": false,
                "value": args
            };
        };
        _$rapyd$_d[_$rapyd$_iterator_symbol] = function() {
            return this;
        };
        return _$rapyd$_d;
    })();
};
    var Exception = Error;
function AttributeError() {
    AttributeError.prototype.__init__.apply(this, arguments);
}
_$rapyd$_extends(AttributeError, Error);
AttributeError.prototype.__init__ = function __init__(msg) {
    var self = this;
    self.message = msg;
    self.stack = new Error().stack;
};
AttributeError.prototype.name = "AttributeError";

function IndexError() {
    IndexError.prototype.__init__.apply(this, arguments);
}
_$rapyd$_extends(IndexError, Error);
IndexError.prototype.__init__ = function __init__(msg) {
    var self = this;
    self.message = msg;
    self.stack = new Error().stack;
};
IndexError.prototype.name = "IndexError";

function KeyError() {
    KeyError.prototype.__init__.apply(this, arguments);
}
_$rapyd$_extends(KeyError, Error);
KeyError.prototype.__init__ = function __init__(msg) {
    var self = this;
    self.message = msg;
    self.stack = new Error().stack;
};
KeyError.prototype.name = "KeyError";

function ValueError() {
    ValueError.prototype.__init__.apply(this, arguments);
}
_$rapyd$_extends(ValueError, Error);
ValueError.prototype.__init__ = function __init__(msg) {
    var self = this;
    self.message = msg;
    self.stack = new Error().stack;
};
ValueError.prototype.name = "ValueError";
;
    var _$rapyd$_chain_assign_temp;
function _$rapyd$_equals(a, b) {
    try {
        return a.__eq__(b);
    } catch (_$rapyd$_Exception) {
        if (_$rapyd$_Exception instanceof TypeError) {
            return a === b;
        } else {
            throw _$rapyd$_Exception;
        }
    }
}
var equals = _$rapyd$_equals;;
function _$rapyd$_list_extend(iterable) {
    var start, iterator, result;
    if (Array.isArray(iterable) || typeof iterable === "string") {
        start = this.length;
        this.length += iterable.length;
        for (var i = 0; i < iterable.length; i++) {
            this[start + i] = iterable[i];
        }
    } else {
        iterator = (typeof Map === "function" && iterable instanceof Map) ? iterable.keys() : iterable[_$rapyd$_iterator_symbol]();
        result = iterator.next();
        while (!result.done) {
            this.push(result.value);
            result = iterator.next();
        }
    }
}
function _$rapyd$_list_index(val, start, stop) {
    var idx;
    start = start || 0;
    if (start < 0) {
        start = this.length + start;
    }
    if (start < 0) {
        throw new ValueError(val + " is not in list");
    }
    if (stop === undefined) {
        idx = this.indexOf(val, start);
        if (idx === -1) {
            throw new ValueError(val + " is not in list");
        }
        return idx;
    }
    if (stop < 0) {
        stop = this.length + stop;
    }
    for (var i = start; i < stop; i++) {
        if (this[i] === val) {
            return i;
        }
    }
    throw new ValueError(val + " is not in list");
}
function _$rapyd$_list_pop(index) {
    var ans;
    if (this.length === 0) {
        throw new IndexError("list is empty");
    }
    ans = this.splice(index, 1);
    if (!ans.length) {
        throw new IndexError("pop index out of range");
    }
    return ans[0];
}
function _$rapyd$_list_remove(value) {
    var idx;
    idx = this.indexOf(value);
    if (idx === -1) {
        throw new ValueError(value + " not in list");
    }
    this.splice(idx, 1);
}
function _$rapyd$_list_to_string() {
    return "[" + this.join(", ") + "]";
}
function _$rapyd$_list_insert(index, val) {
    if (index < 0) {
        index += this.length;
    }
    index = min(this.length, max(index, 0));
    if (index === 0) {
        this.unshift(val);
        return;
    }
    for (var i = this.length; i > index; i--) {
        this[i] = this[i - 1];
    }
    this[index] = val;
}
function _$rapyd$_list_copy() {
    return _$rapyd$_list_constructor(this);
}
function _$rapyd$_list_clear() {
    this.length = 0;
}
function _$rapyd$_list_as_array() {
    return Array.prototype.slice.call(this);
}
function _$rapyd$_list_count(value) {
    return this.reduce(function(n, val) {
        return n + (val === value);
    }, 0);
}
function _$rapyd$_list_sort_key(value) {
    var t;
    t = typeof value;
    if (t === "string" || t === "number") {
        return value;
    }
    return value.toString();
}
function _$rapyd$_list_sort_cmp(a, b) {
    if (a < b) {
        return -1;
    }
    if (a > b) {
        return 1;
    }
    return 0;
}
function _$rapyd$_list_sort() {
    var key = (arguments[0] === undefined || ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (null) : arguments[0];
    var reverse = (arguments[1] === undefined || ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (false) : arguments[1];
    var _$rapyd$_kwargs_obj = arguments[arguments.length-1];
    if (_$rapyd$_kwargs_obj === null || typeof _$rapyd$_kwargs_obj !== "object" || _$rapyd$_kwargs_obj [_$rapyd$_kwargs_symbol] !== true) _$rapyd$_kwargs_obj = {};
    if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "key")){
        key = _$rapyd$_kwargs_obj.key;
    }
    if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "reverse")){
        reverse = _$rapyd$_kwargs_obj.reverse;
    }
    var mult, keymap, k;
    key = key || _$rapyd$_list_sort_key;
    mult = (reverse) ? -1 : 1;
    keymap = dict();
    for (var i=0; i < this.length; i++) {
        k = this[i];
        keymap.set(k, key(k));
    }
    this.sort(function(a, b) {
        return mult * _$rapyd$_list_sort_cmp(keymap.get(a), keymap.get(b));
    });
}
function _$rapyd$_list_concat() {
    var ans;
    ans = Array.prototype.concat.apply(this, arguments);
    _$rapyd$_list_decorate(ans);
    return ans;
}
function _$rapyd$_list_slice() {
    var ans;
    ans = Array.prototype.slice.apply(this, arguments);
    _$rapyd$_list_decorate(ans);
    return ans;
}
function _$rapyd$_list_iterator(value) {
    var self;
    self = this;
    return {
        "_i": -1,
        "_list": self,
        "next": function() {
            this._i += 1;
            if (this._i >= this._list.length) {
                return {
                    "done": true
                };
            }
            return {
                "done": false,
                "value": this._list[this._i]
            };
        }
    };
}
function _$rapyd$_list_len() {
    return this.length;
}
function _$rapyd$_list_contains(val) {
    return this.indexOf(val) !== -1;
}
function _$rapyd$_list_eq(other) {
    if (!Array.isArray(other)) {
        return false;
    }
    if (other.length !== this.length) {
        return false;
    }
    if (other.length === 0) {
        return true;
    }
    for (var i = 0; i < other.length; i++) {
        if (!_$rapyd$_equals(this[i], other[i])) {
            return false;
        }
    }
    return true;
}
function _$rapyd$_list_decorate(ans) {
    ans.append = Array.prototype.push;
    ans.toString = _$rapyd$_list_to_string;
    ans.inspect = _$rapyd$_list_to_string;
    ans.extend = _$rapyd$_list_extend;
    ans.index = _$rapyd$_list_index;
    ans.pypop = _$rapyd$_list_pop;
    ans.remove = _$rapyd$_list_remove;
    ans.insert = _$rapyd$_list_insert;
    ans.copy = _$rapyd$_list_copy;
    ans.clear = _$rapyd$_list_clear;
    ans.count = _$rapyd$_list_count;
    ans.concat = _$rapyd$_list_concat;
    ans.pysort = _$rapyd$_list_sort;
    ans.slice = _$rapyd$_list_slice;
    ans.as_array = _$rapyd$_list_as_array;
    ans.__len__ = _$rapyd$_list_len;
    ans.__contains__ = _$rapyd$_list_contains;
    ans.__eq__ = _$rapyd$_list_eq;
    ans.constructor = _$rapyd$_list_constructor;
    if (typeof ans[_$rapyd$_iterator_symbol] !== "function") {
        ans[_$rapyd$_iterator_symbol] = _$rapyd$_list_iterator;
    }
    return ans;
}
function _$rapyd$_list_constructor(iterable) {
    var ans, iterator, result;
    if (iterable === undefined) {
        ans = [];
    } else if (_$rapyd$_arraylike(iterable)) {
        ans = new Array(iterable.length);
        for (var i = 0; i < iterable.length; i++) {
            ans[i] = iterable[i];
        }
    } else if (typeof iterable[_$rapyd$_iterator_symbol] === "function") {
        iterator = (typeof Map === "function" && iterable instanceof Map) ? iterable.keys() : iterable[_$rapyd$_iterator_symbol]();
        ans = _$rapyd$_list_decorate([]);
        result = iterator.next();
        while (!result.done) {
            ans.push(result.value);
            result = iterator.next();
        }
    } else if (typeof iterable === "number") {
        ans = new Array(iterable);
    } else {
        ans = Object.keys(iterable);
    }
    return _$rapyd$_list_decorate(ans);
}
_$rapyd$_list_constructor.__name__ = "list";
var list = _$rapyd$_list_constructor, list_wrap = _$rapyd$_list_decorate;
var _$rapyd$_global_object_id = 0, _$rapyd$_set_implementation;
function _$rapyd$_set_keyfor(x) {
    var t, ans;
    t = typeof x;
    if (t === "string" || t === "number" || t === "boolean") {
        return "_" + t[0] + x;
    }
    if (x === null) {
        return "__!@#$0";
    }
    ans = x._$rapyd$_hash_key_prop;
    if (ans === undefined) {
        ans = "_!@#$" + (++_$rapyd$_global_object_id);
        Object.defineProperty(x, "_$rapyd$_hash_key_prop", {
            "value": ans
        });
    }
    return ans;
}
function _$rapyd$_set_polyfill() {
    this._store = {};
    this.size = 0;
}
_$rapyd$_set_polyfill.prototype.add = function(x) {
    var key;
    key = _$rapyd$_set_keyfor(x);
    if (!Object.hasOwnProperty.call(this._store, key)) {
        this.size += 1;
        this._store[key] = x;
    }
    return this;
};
_$rapyd$_set_polyfill.prototype.clear = function(x) {
    this._store = {};
    this.size = 0;
};
_$rapyd$_set_polyfill.prototype.delete = function(x) {
    var key;
    key = _$rapyd$_set_keyfor(x);
    if (Object.hasOwnProperty.call(this._store, key)) {
        this.size -= 1;
        delete this._store[key];
        return true;
    }
    return false;
};
_$rapyd$_set_polyfill.prototype.has = function(x) {
    return Object.hasOwnProperty.call(this._store, _$rapyd$_set_keyfor(x));
};
_$rapyd$_set_polyfill.prototype.values = function(x) {
    var keys, s;
    keys = Object.keys(this._store);
    s = this._store;
    return (function(){
        var _$rapyd$_d = {};
        _$rapyd$_d["_keys"] = keys;
        _$rapyd$_d["_i"] = -1;
        _$rapyd$_d["_s"] = s;
        _$rapyd$_d[_$rapyd$_iterator_symbol] = function() {
            return this;
        };
        _$rapyd$_d["next"] = function() {
            this._i += 1;
            if (this._i >= this._keys.length) {
                return {
                    "done": true
                };
            }
            return {
                "done": false,
                "value": s[this._keys[this._i]]
            };
        };
        return _$rapyd$_d;
    })();
};
if (typeof Set !== "function" || typeof Set.prototype.delete !== "function") {
    _$rapyd$_set_implementation = _$rapyd$_set_polyfill;
} else {
    _$rapyd$_set_implementation = Set;
}
function _$rapyd$_set(iterable) {
    var ans, s, iterator, result, keys;
    if (this instanceof _$rapyd$_set) {
        this.jsset = new _$rapyd$_set_implementation();
        ans = this;
        if (iterable === undefined) {
            return ans;
        }
        s = ans.jsset;
        if (_$rapyd$_arraylike(iterable)) {
            for (var i = 0; i < iterable.length; i++) {
                s.add(iterable[i]);
            }
        } else if (typeof iterable[_$rapyd$_iterator_symbol] === "function") {
            iterator = (typeof Map === "function" && iterable instanceof Map) ? iterable.keys() : iterable[_$rapyd$_iterator_symbol]();
            result = iterator.next();
            while (!result.done) {
                s.add(result.value);
                result = iterator.next();
            }
        } else {
            keys = Object.keys(iterable);
            for (var i=0; i < keys.length; i++) {
                s.add(keys[i]);
            }
        }
        return ans;
    } else {
        return new _$rapyd$_set(iterable);
    }
}
_$rapyd$_set.prototype.__name__ = "set";
Object.defineProperties(_$rapyd$_set.prototype, {
    "length": {
        "get": function() {
            return this.jsset.size;
        }
    },
    "size": {
        "get": function() {
            return this.jsset.size;
        }
    }
});
_$rapyd$_set.prototype.__len__ = function() {
    return this.jsset.size;
};
_$rapyd$_chain_assign_temp = function(x) {
    return this.jsset.has(x);
};
_$rapyd$_set.prototype.has = _$rapyd$_chain_assign_temp;
_$rapyd$_set.prototype.__contains__ = _$rapyd$_chain_assign_temp;
;
_$rapyd$_set.prototype.add = function(x) {
    this.jsset.add(x);
};
_$rapyd$_set.prototype.clear = function() {
    this.jsset.clear();
};
_$rapyd$_set.prototype.copy = function() {
    return _$rapyd$_set(this);
};
_$rapyd$_set.prototype.discard = function(x) {
    this.jsset.delete(x);
};
_$rapyd$_set.prototype[_$rapyd$_iterator_symbol] = function() {
    return this.jsset.values();
};
_$rapyd$_set.prototype.difference = function() {
    var ans, s, iterator, r, x, has;
    ans = new _$rapyd$_set();
    s = ans.jsset;
    iterator = this.jsset.values();
    r = iterator.next();
    while (!r.done) {
        x = r.value;
        has = false;
        for (var i = 0; i < arguments.length; i++) {
            if (arguments[i].has(x)) {
                has = true;
                break;
            }
        }
        if (!has) {
            s.add(x);
        }
        r = iterator.next();
    }
    return ans;
};
_$rapyd$_set.prototype.difference_update = function() {
    var s, remove, iterator, r, x;
    s = this.jsset;
    remove = [];
    iterator = s.values();
    r = iterator.next();
    while (!r.done) {
        x = r.value;
        for (var i = 0; i < arguments.length; i++) {
            if (arguments[i].has(x)) {
                remove.push(x);
                break;
            }
        }
        r = iterator.next();
    }
    for (var i = 0; i < remove.length; i++) {
        s.delete(remove[i]);
    }
};
_$rapyd$_set.prototype.intersection = function() {
    var ans, s, iterator, r, x, has;
    ans = new _$rapyd$_set();
    s = ans.jsset;
    iterator = this.jsset.values();
    r = iterator.next();
    while (!r.done) {
        x = r.value;
        has = true;
        for (var i = 0; i < arguments.length; i++) {
            if (!arguments[i].has(x)) {
                has = false;
                break;
            }
        }
        if (has) {
            s.add(x);
        }
        r = iterator.next();
    }
    return ans;
};
_$rapyd$_set.prototype.intersection_update = function() {
    var s, remove, iterator, r, x;
    s = this.jsset;
    remove = [];
    iterator = s.values();
    r = iterator.next();
    while (!r.done) {
        x = r.value;
        for (var i = 0; i < arguments.length; i++) {
            if (!arguments[i].has(x)) {
                remove.push(x);
                break;
            }
        }
        r = iterator.next();
    }
    for (var i = 0; i < remove.length; i++) {
        s.delete(remove[i]);
    }
};
_$rapyd$_set.prototype.isdisjoint = function(other) {
    var iterator, r, x;
    iterator = this.jsset.values();
    r = iterator.next();
    while (!r.done) {
        x = r.value;
        if (other.has(x)) {
            return false;
        }
        r = iterator.next();
    }
    return true;
};
_$rapyd$_set.prototype.issubset = function(other) {
    var iterator, r, x;
    iterator = this.jsset.values();
    r = iterator.next();
    while (!r.done) {
        x = r.value;
        if (!other.has(x)) {
            return false;
        }
        r = iterator.next();
    }
    return true;
};
_$rapyd$_set.prototype.issuperset = function(other) {
    var s, iterator, r, x;
    s = this.jsset;
    iterator = other.jsset.values();
    r = iterator.next();
    while (!r.done) {
        x = r.value;
        if (!s.has(x)) {
            return false;
        }
        r = iterator.next();
    }
    return true;
};
_$rapyd$_set.prototype.pop = function() {
    var iterator, r;
    iterator = this.jsset.values();
    r = iterator.next();
    if (r.done) {
        throw new KeyError("pop from an empty set");
    }
    this.jsset.delete(r.value);
    return r.value;
};
_$rapyd$_set.prototype.remove = function(x) {
    if (!this.jsset.delete(x)) {
        throw new KeyError(x.toString());
    }
};
_$rapyd$_set.prototype.symmetric_difference = function(other) {
    return this.union(other).difference(this.intersection(other));
};
_$rapyd$_set.prototype.symmetric_difference_update = function(other) {
    var common;
    common = this.intersection(other);
    this.update(other);
    this.difference_update(common);
};
_$rapyd$_set.prototype.union = function() {
    var ans;
    ans = _$rapyd$_set(this);
    ans.update.apply(ans, arguments);
    return ans;
};
_$rapyd$_set.prototype.update = function() {
    var s, iterator, r;
    s = this.jsset;
    for (var i=0; i < arguments.length; i++) {
        iterator = arguments[i][_$rapyd$_iterator_symbol]();
        r = iterator.next();
        while (!r.done) {
            s.add(r.value);
            r = iterator.next();
        }
    }
};
_$rapyd$_chain_assign_temp = function() {
    return "{" + list(this).join(", ") + "}";
};
_$rapyd$_set.prototype.toString = _$rapyd$_chain_assign_temp;
_$rapyd$_set.prototype.inspect = _$rapyd$_chain_assign_temp;
;
_$rapyd$_set.prototype.__eq__ = function(other) {
    var iterator, r;
    if (!(other instanceof this.constructor)) {
        return false;
    }
    if (other.size !== this.size) {
        return false;
    }
    if (other.size === 0) {
        return true;
    }
    iterator = other[_$rapyd$_iterator_symbol]();
    r = iterator.next();
    while (!r.done) {
        if (!this.has(r.value)) {
            return false;
        }
        r = iterator.next();
    }
    return true;
};
function _$rapyd$_set_wrap(x) {
    var ans;
    ans = new _$rapyd$_set();
    ans.jsset = x;
    return ans;
}
var set = _$rapyd$_set, set_wrap = _$rapyd$_set_wrap;
var _$rapyd$_dict_implementation;
function _$rapyd$_dict_polyfill() {
    this._store = {};
    this.size = 0;
}
_$rapyd$_dict_polyfill.prototype.set = function(x, value) {
    var key;
    key = _$rapyd$_set_keyfor(x);
    if (!Object.hasOwnProperty.call(this._store, key)) {
        this.size += 1;
    }
    this._store[key] = [x, value];
    return this;
};
_$rapyd$_dict_polyfill.prototype.clear = function(x) {
    this._store = {};
    this.size = 0;
};
_$rapyd$_dict_polyfill.prototype.delete = function(x) {
    var key;
    key = _$rapyd$_set_keyfor(x);
    if (Object.hasOwnProperty.call(this._store, key)) {
        this.size -= 1;
        delete this._store[key];
        return true;
    }
    return false;
};
_$rapyd$_dict_polyfill.prototype.has = function(x) {
    return Object.hasOwnProperty.call(this._store, _$rapyd$_set_keyfor(x));
};
_$rapyd$_dict_polyfill.prototype.get = function(x) {
    try {
        return this._store[_$rapyd$_set_keyfor(x)][1];
    } catch (_$rapyd$_Exception) {
        if (_$rapyd$_Exception instanceof TypeError) {
            return undefined;
        } else {
            throw _$rapyd$_Exception;
        }
    }
};
_$rapyd$_dict_polyfill.prototype.values = function(x) {
    var keys, s;
    keys = Object.keys(this._store);
    s = this._store;
    return (function(){
        var _$rapyd$_d = {};
        _$rapyd$_d["_keys"] = keys;
        _$rapyd$_d["_i"] = -1;
        _$rapyd$_d["_s"] = s;
        _$rapyd$_d[_$rapyd$_iterator_symbol] = function() {
            return this;
        };
        _$rapyd$_d["next"] = function() {
            this._i += 1;
            if (this._i >= this._keys.length) {
                return {
                    "done": true
                };
            }
            return {
                "done": false,
                "value": s[this._keys[this._i]][1]
            };
        };
        return _$rapyd$_d;
    })();
};
_$rapyd$_dict_polyfill.prototype.keys = function(x) {
    var keys, s;
    keys = Object.keys(this._store);
    s = this._store;
    return (function(){
        var _$rapyd$_d = {};
        _$rapyd$_d["_keys"] = keys;
        _$rapyd$_d["_i"] = -1;
        _$rapyd$_d["_s"] = s;
        _$rapyd$_d[_$rapyd$_iterator_symbol] = function() {
            return this;
        };
        _$rapyd$_d["next"] = function() {
            this._i += 1;
            if (this._i >= this._keys.length) {
                return {
                    "done": true
                };
            }
            return {
                "done": false,
                "value": s[this._keys[this._i]][0]
            };
        };
        return _$rapyd$_d;
    })();
};
_$rapyd$_dict_polyfill.prototype.entries = function(x) {
    var keys, s;
    keys = Object.keys(this._store);
    s = this._store;
    return (function(){
        var _$rapyd$_d = {};
        _$rapyd$_d["_keys"] = keys;
        _$rapyd$_d["_i"] = -1;
        _$rapyd$_d["_s"] = s;
        _$rapyd$_d[_$rapyd$_iterator_symbol] = function() {
            return this;
        };
        _$rapyd$_d["next"] = function() {
            this._i += 1;
            if (this._i >= this._keys.length) {
                return {
                    "done": true
                };
            }
            return {
                "done": false,
                "value": s[this._keys[this._i]]
            };
        };
        return _$rapyd$_d;
    })();
};
if (typeof Map !== "function" || typeof Map.prototype.delete !== "function") {
    _$rapyd$_dict_implementation = _$rapyd$_dict_polyfill;
} else {
    _$rapyd$_dict_implementation = Map;
}
function _$rapyd$_dict(iterable) {
    if (this instanceof _$rapyd$_dict) {
        this.jsmap = new _$rapyd$_dict_implementation();
        if (iterable !== undefined) {
            this.update(iterable);
        }
        return this;
    } else {
        return new _$rapyd$_dict(iterable);
    }
}
_$rapyd$_dict.prototype.__name__ = "dict";
Object.defineProperties(_$rapyd$_dict.prototype, {
    "length": {
        "get": function() {
            return this.jsmap.size;
        }
    },
    "size": {
        "get": function() {
            return this.jsmap.size;
        }
    }
});
_$rapyd$_dict.prototype.__len__ = function() {
    return this.jsmap.size;
};
_$rapyd$_chain_assign_temp = function(x) {
    return this.jsmap.has(x);
};
_$rapyd$_dict.prototype.has = _$rapyd$_chain_assign_temp;
_$rapyd$_dict.prototype.__contains__ = _$rapyd$_chain_assign_temp;
;
_$rapyd$_chain_assign_temp = function(key, value) {
    this.jsmap.set(key, value);
};
_$rapyd$_dict.prototype.set = _$rapyd$_chain_assign_temp;
_$rapyd$_dict.prototype.__setitem__ = _$rapyd$_chain_assign_temp;
;
_$rapyd$_dict.prototype.clear = function() {
    this.jsmap.clear();
};
_$rapyd$_dict.prototype.copy = function() {
    return _$rapyd$_dict(this);
};
_$rapyd$_dict.prototype.keys = function() {
    return this.jsmap.keys();
};
_$rapyd$_dict.prototype.values = function() {
    return this.jsmap.values();
};
_$rapyd$_chain_assign_temp = function() {
    return this.jsmap.entries();
};
_$rapyd$_dict.prototype.items = _$rapyd$_chain_assign_temp;
_$rapyd$_dict.prototype.entries = _$rapyd$_chain_assign_temp;
;
_$rapyd$_dict.prototype[_$rapyd$_iterator_symbol] = function() {
    return this.jsmap.keys();
};
_$rapyd$_dict.prototype.__getitem__ = function(key) {
    var ans;
    ans = this.jsmap.get(key);
    if (ans === undefined && !this.jsmap.has(key)) {
        throw new KeyError(key + "");
    }
    return ans;
};
_$rapyd$_dict.prototype.get = function(key, defval) {
    var ans;
    ans = this.jsmap.get(key);
    if (ans === undefined && !this.jsmap.has(key)) {
        return (defval === undefined) ? null : defval;
    }
    return ans;
};
_$rapyd$_dict.prototype.set_default = function(key, defval) {
    var j;
    j = this.jsmap;
    if (!j.has(key)) {
        j.set(key, defval);
        return defval;
    }
    return j.get(key);
};
_$rapyd$_chain_assign_temp = function() {
    var iterable = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) ? undefined : arguments[0];
    var value = (arguments[1] === undefined || ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (null) : arguments[1];
    var _$rapyd$_kwargs_obj = arguments[arguments.length-1];
    if (_$rapyd$_kwargs_obj === null || typeof _$rapyd$_kwargs_obj !== "object" || _$rapyd$_kwargs_obj [_$rapyd$_kwargs_symbol] !== true) _$rapyd$_kwargs_obj = {};
    if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "value")){
        value = _$rapyd$_kwargs_obj.value;
    }
    var ans, iterator, r;
    ans = _$rapyd$_dict();
    iterator = iter(iterable);
    r = iterator.next();
    while (!r.done) {
        ans.set(r.value, value);
        r = iterator.next();
    }
    return ans;
};
_$rapyd$_dict.fromkeys = _$rapyd$_chain_assign_temp;
_$rapyd$_dict.prototype.fromkeys = _$rapyd$_chain_assign_temp;
;
_$rapyd$_dict.prototype.pop = function(key, defval) {
    var ans;
    ans = this.jsmap.get(key);
    if (ans === undefined && !this.jsmap.has(key)) {
        if (defval === undefined) {
            throw new KeyError(key);
        }
        return defval;
    }
    this.jsmap.delete(key);
    return ans;
};
_$rapyd$_dict.prototype.popitem = function() {
    var r;
    r = this.jsmap.entries().next();
    if (r.done) {
        throw new KeyError("dict is empty");
    }
    this.jsmap.delete(r.value[0]);
    return r.value;
};
_$rapyd$_dict.prototype.update = function() {
    var m, iterable, iterator, result, keys;
    if (arguments.length === 0) {
        return;
    }
    m = this.jsmap;
    iterable = arguments[0];
    if (Array.isArray(iterable)) {
        for (var i = 0; i < iterable.length; i++) {
            m.set(iterable[i][0], iterable[i][1]);
        }
    } else if (iterable instanceof _$rapyd$_dict) {
        iterator = iterable.items();
        result = iterator.next();
        while (!result.done) {
            m.set(result.value[0], result.value[1]);
            result = iterator.next();
        }
    } else if (typeof Map === "function" && iterable instanceof Map) {
        iterator = iterable.entries();
        result = iterator.next();
        while (!result.done) {
            m.set(result.value[0], result.value[1]);
            result = iterator.next();
        }
    } else if (typeof iterable[_$rapyd$_iterator_symbol] === "function") {
        iterator = iterable[_$rapyd$_iterator_symbol]();
        result = iterator.next();
        while (!result.done) {
            m.set(result.value[0], result.value[1]);
            result = iterator.next();
        }
    } else {
        keys = Object.keys(iterable);
        for (var i=0; i < keys.length; i++) {
            if (keys[i] !== _$rapyd$_iterator_symbol) {
                m.set(keys[i], iterable[keys[i]]);
            }
        }
    }
    if (arguments.length > 1) {
        _$rapyd$_dict.prototype.update.call(this, arguments[1]);
    }
};
_$rapyd$_chain_assign_temp = function() {
    var entries, iterator, r;
    entries = [];
    iterator = this.jsmap.entries();
    r = iterator.next();
    while (!r.done) {
        entries.push(r.value[0] + ": " + r.value[1]);
        r = iterator.next();
    }
    return "{" + entries.join(", ") + "}";
};
_$rapyd$_dict.prototype.toString = _$rapyd$_chain_assign_temp;
_$rapyd$_dict.prototype.inspect = _$rapyd$_chain_assign_temp;
;
_$rapyd$_dict.prototype.__eq__ = function(other) {
    var iterator, r, x;
    if (!(other instanceof this.constructor)) {
        return false;
    }
    if (other.size !== this.size) {
        return false;
    }
    if (other.size === 0) {
        return true;
    }
    iterator = other.items();
    r = iterator.next();
    while (!r.done) {
        x = this.jsmap.get(r.value[0]);
        if (x === undefined && !this.jsmap.has(r.value[0]) || x !== r.value[1]) {
            return false;
        }
        r = iterator.next();
    }
    return true;
};
_$rapyd$_dict.prototype.as_object = function(other) {
    var ans, iterator, r;
    ans = {};
    iterator = this.jsmap.entries();
    r = iterator.next();
    while (!r.done) {
        ans[r.value[0]] = r.value[1];
        r = iterator.next();
    }
    return ans;
};
function _$rapyd$_dict_wrap(x) {
    var ans;
    ans = new _$rapyd$_dict();
    ans.jsmap = x;
    return ans;
}
var dict = _$rapyd$_dict, dict_wrap = _$rapyd$_dict_wrap;;
    function _$rapyd$_bool(val) {
    return !!val;
}
function _$rapyd$_bind(fn, thisArg) {
    var ret;
    if (fn.orig) {
        fn = fn.orig;
    }
    if (thisArg === false) {
        return fn;
    }
    ret = function() {
        return fn.apply(thisArg, arguments);
    };
    ret.orig = fn;
    return ret;
}
function _$rapyd$_rebind_all(thisArg, rebind) {
    if (typeof rebind === "undefined") {
        rebind = true;
    }
    for (var p in thisArg) {
        if (thisArg[p] && thisArg[p].orig) {
            if (rebind) {
                thisArg[p] = _$rapyd$_bind(thisArg[p], thisArg);
            } else {
                thisArg[p] = thisArg[p].orig;
            }
        }
    }
}
function _$rapyd$_eslice(arr, step, start, end) {
    var isString;
    arr = arr.slice(0);
    if (typeof arr === "string" || arr instanceof String) {
        isString = true;
        arr = arr.split("");
    }
    if (step < 0) {
        step = -step;
        arr.reverse();
        if (typeof start !== "undefined") {
            start = arr.length - start - 1;
        }
        if (typeof end !== "undefined") {
            end = arr.length - end - 1;
        }
    }
    if (typeof start === "undefined") {
        start = 0;
    }
    if (typeof end === "undefined") {
        end = arr.length;
    }
    arr = arr.slice(start, end).filter(function(e, i) {
        return i % step === 0;
    });
    return (isString) ? arr.join("") : arr;
}
function _$rapyd$_mixin(target, source, overwrite) {
    for (var i in source) {
        if (source.hasOwnProperty(i) && overwrite || typeof target[i] === "undefined") {
            target[i] = source[i];
        }
    }
}
function _$rapyd$_print() {
    var parts, part;
    if (typeof console === "object") {
        parts = [];
        for (var i = 0; i < arguments.length; i++) {
            part = arguments[i];
            if (typeof part === "string") {
                parts.push(part);
            } else if (part === null) {
                parts.push("None");
            } else if (typeof part === "boolean") {
                parts.push((part) ? "True" : "False");
            } else {
                try {
                    parts.push(JSON.stringify(part));
                } catch (_$rapyd$_Exception) {
                    parts.push(part.toString());
                }
            }
        }
        console.log(parts.join(" "));
    }
}
function _$rapyd$_int(val, base) {
    var ans;
    ans = parseInt(val, base || 10);
    if (isNaN(ans)) {
        throw new ValueError("Invalid literal for int with base " + (base || 10) + ": " + val);
    }
    return ans;
}
function _$rapyd$_float() {
    var ans;
    ans = parseFloat.apply(null, arguments);
    if (isNaN(ans)) {
        throw new ValueError("Could not convert string to float: " + arguments[0]);
    }
    return ans;
}
function _$rapyd$_arraylike_creator() {
    if (typeof HTMLCollection === "function") {
        return function(x) {
            if (Array.isArray(x) || typeof x === "string" || (x instanceof HTMLCollection || x instanceof NodeList || x instanceof NamedNodeMap)) {
                return true;
            }
            return false;
        };
    }
    return function(x) {
        if (Array.isArray(x) || typeof x === "string") {
            return true;
        }
        return false;
    };
}
function options_object(f) {
    return function() {
        if (typeof arguments[arguments.length - 1] === "object") {
            arguments[arguments.length - 1][_$rapyd$_kwargs_symbol] = true;
        }
        return f.apply(this, arguments);
    };
}
var bool = _$rapyd$_bool, bind = _$rapyd$_bind, rebind_all = _$rapyd$_rebind_all;
var float = _$rapyd$_float, int = _$rapyd$_int, arraylike = _$rapyd$_arraylike_creator(), _$rapyd$_arraylike = arraylike;
var mixin = _$rapyd$_mixin, print = _$rapyd$_print, eslice = _$rapyd$_eslice;;
    function _$rapyd$_str() {
    return arguments[0] + "";
}
_$rapyd$_str.format = function() {
    var template, args, kwargs, explicit, implicit, _$rapyd$_chain_assign_temp, idx, ans, pos, in_brace, markup, ch;
    template = arguments[0];
    if (template === undefined) {
        throw new TypeError("Template is required");
    }
    args = Array.prototype.slice.call(arguments, 1);
    kwargs = {};
    if (args.length && args[args.length-1][_$rapyd$_kwargs_symbol] !== undefined) {
        kwargs = args[args.length-1];
        args = args.slice(0, -1);
    }
    _$rapyd$_chain_assign_temp = false;
    explicit = _$rapyd$_chain_assign_temp;
    implicit = _$rapyd$_chain_assign_temp;
;
    idx = 0;
    if (_$rapyd$_str.format._template_resolve_pat === undefined) {
        _$rapyd$_str.format._template_resolve_pat = /[.\[]/;
    }
    function resolve(arg, object) {
        var _$rapyd$_unpack, first, key, rest, ans;
        if (!arg) {
            return object;
        }
        _$rapyd$_unpack = [arg[0], arg.slice(1)];
        first = _$rapyd$_unpack[0];
        arg = _$rapyd$_unpack[1];
        key = arg.split(_$rapyd$_str.format._template_resolve_pat, 1)[0];
        rest = arg.slice(key.length);
        ans = (first === "[") ? object[key.slice(0, -1)] : getattr(object, key);
        if (ans === undefined) {
            throw new KeyError((first === "[") ? key.slice(0, -1) : key);
        }
        return resolve(rest, ans);
    }
    function resolve_format_spec(format_spec) {
        if (_$rapyd$_str.format._template_resolve_fs_pat === undefined) {
            _$rapyd$_str.format._template_resolve_fs_pat = /[{]([a-zA-Z0-9_]+)[}]/g;
        }
        return format_spec.replace(_$rapyd$_str.format._template_resolve_fs_pat, function(match, key) {
            if (!Object.prototype.hasOwnProperty.call(kwargs, key)) {
                return "";
            }
            return "" + kwargs[key];
        });
    }
    function apply_formatting(value, format_spec) {
        var _$rapyd$_unpack, fill, align, sign, fhash, zeropad, width, comma, precision, ftype, is_numeric, is_int, lftype, code, exp, nval, is_positive, left, right;
        if (format_spec.indexOf("{") !== -1) {
            format_spec = resolve_format_spec(format_spec);
        }
        if (_$rapyd$_str.format._template_format_pat === undefined) {
            _$rapyd$_str.format._template_format_pat = /([^{}](?=[<>=^]))?([<>=^])?([-+\x20])?(\#)?(0)?(\d+)?(,)?(?:\.(\d+))?([bcdeEfFgGnosxX%])?/;
        }
        try {
            _$rapyd$_unpack = format_spec.match(_$rapyd$_str.format._template_format_pat).slice(1);
            fill = _$rapyd$_unpack[0];
            align = _$rapyd$_unpack[1];
            sign = _$rapyd$_unpack[2];
            fhash = _$rapyd$_unpack[3];
            zeropad = _$rapyd$_unpack[4];
            width = _$rapyd$_unpack[5];
            comma = _$rapyd$_unpack[6];
            precision = _$rapyd$_unpack[7];
            ftype = _$rapyd$_unpack[8];
        } catch (_$rapyd$_Exception) {
            if (_$rapyd$_Exception instanceof TypeError) {
                return value;
            } else {
                throw _$rapyd$_Exception;
            }
        }
        if (zeropad) {
            fill = fill || "0";
            align = align || "=";
        } else {
            fill = fill || " ";
            align = align || ">";
        }
        is_numeric = Number(value) === value;
        is_int = is_numeric && value % 1 === 0;
        precision = parseInt(precision, 10);
        lftype = (ftype || "").toLowerCase();
        if (ftype === "n") {
            is_numeric = true;
            if (is_int) {
                if (comma) {
                    throw new ValueError("Cannot specify ',' with 'n'");
                }
                value = parseInt(value, 10).toLocaleString();
            } else {
                value = parseFloat(value).toLocaleString();
            }
        } else if (['b', 'c', 'd', 'o', 'x'].indexOf(lftype) !== -1) {
            value = parseInt(value, 10);
            is_numeric = true;
            if (!isNaN(value)) {
                if (ftype === "b") {
                    value = (value >>> 0).toString(2);
                    if (fhash) {
                        value = "0b" + value;
                    }
                } else if (ftype === "c") {
                    if (value > 65535) {
                        code = value - 65536;
                        value = String.fromCharCode(55296 + (code >> 10), 56320 + (code & 1023));
                    } else {
                        value = String.fromCharCode(value);
                    }
                } else if (ftype === "d") {
                    if (comma) {
                        value = value.toLocaleString("en-US");
                    } else {
                        value = value.toString(10);
                    }
                } else if (ftype === "o") {
                    value = value.toString(8);
                    if (fhash) {
                        value = "0o" + value;
                    }
                } else if (lftype === "x") {
                    value = value.toString(16);
                    value = (ftype === "x") ? value.toLowerCase() : value.toUpperCase();
                    if (fhash) {
                        value = "0x" + value;
                    }
                }
            }
        } else if (['e','f','g','%'].indexOf(lftype) !== -1) {
            is_numeric = true;
            value = parseFloat(value);
            if (lftype === "e") {
                value = value.toExponential((isNaN(precision)) ? 6 : precision);
                value = (ftype === "E") ? value.toUpperCase() : value.toLowerCase();
            } else if (lftype === "f") {
                value = value.toFixed((isNaN(precision)) ? 6 : precision);
                value = (ftype === "F") ? value.toUpperCase() : value.toLowerCase();
            } else if (ftype === "%") {
                value *= 100;
                value = value.toFixed((isNaN(precision)) ? 6 : precision) + "%";
            } else if (lftype === "g") {
                if (isNaN(precision)) {
                    precision = 6;
                }
                precision = max(1, precision);
                exp = parseInt(value.toExponential(precision - 1).toLowerCase().split("e")[1], 10);
                if (-4 <= exp && exp < precision) {
                    value = value.toFixed(precision - 1 - exp);
                } else {
                    value = value.toExponential(precision - 1);
                }
                value = value.replace(/0+$/g, "");
                if (value[value.length-1] === ".") {
                    value = value.slice(0, -1);
                }
                if (ftype === "G") {
                    value = value.toUpperCase();
                }
            }
        } else {
            value += "";
            if (!isNaN(precision)) {
                value = value.slice(0, precision);
            }
        }
        value += "";
        if (is_numeric && sign) {
            nval = Number(value);
            is_positive = !isNaN(nval) && nval >= 0;
            if (is_positive && (sign === " " || sign === "+")) {
                value = sign + value;
            }
        }
        function repeat(char, num) {
            return (new Array(num+1)).join(char);
        }
        if (is_numeric && width && width[0] === "0") {
            width = width.slice(1);
            _$rapyd$_unpack = ["0", "="];
            fill = _$rapyd$_unpack[0];
            align = _$rapyd$_unpack[1];
        }
        width = parseInt(width || "-1", 10);
        if (isNaN(width)) {
            throw new ValueError("Invalid width specification: " + width);
        }
        if (fill && value.length < width) {
            if (align === "<") {
                value = value + repeat(fill, width - value.length);
            } else if (align === ">") {
                value = repeat(fill, width - value.length) + value;
            } else if (align === "^") {
                left = Math.floor((width - value.length) / 2);
                right = width - left - value.length;
                value = repeat(fill, left) + value + repeat(fill, right);
            } else if (align === "=") {
                if (_$rapyd$_in(value[0], "+- ")) {
                    value = value[0] + repeat(fill, width - value.length) + value.slice(1);
                } else {
                    value = repeat(fill, width - value.length) + value;
                }
            } else {
                throw new ValueError("Unrecognized alignment: " + align);
            }
        }
        return value;
    }
    function parse_markup(markup) {
        var key, transformer, format_spec, _$rapyd$_chain_assign_temp, pos, state, ch;
        _$rapyd$_chain_assign_temp = "";
        key = _$rapyd$_chain_assign_temp;
        transformer = _$rapyd$_chain_assign_temp;
        format_spec = _$rapyd$_chain_assign_temp;
;
        pos = 0;
        state = 0;
        while (pos < markup.length) {
            ch = markup[pos];
            if (state === 0) {
                if (ch === "!") {
                    state = 1;
                } else if (ch === ":") {
                    state = 2;
                } else {
                    key += ch;
                }
            } else if (state === 1) {
                if (ch === ":") {
                    state = 2;
                } else {
                    transformer += ch;
                }
            } else {
                format_spec += ch;
            }
            pos += 1;
        }
        return [key, transformer, format_spec];
    }
    function render_markup(markup) {
        var _$rapyd$_unpack, key, transformer, format_spec, lkey, nvalue, object, ans;
        _$rapyd$_unpack = parse_markup(markup);
        key = _$rapyd$_unpack[0];
        transformer = _$rapyd$_unpack[1];
        format_spec = _$rapyd$_unpack[2];
        if (transformer && ['a', 'r', 's'].indexOf(transformer) === -1) {
            throw new ValueError("Unknown conversion specifier: " + transformer);
        }
        lkey = key.length && key.split(/[.\[]/, 1)[0];
        if (lkey) {
            explicit = true;
            if (implicit) {
                throw new ValueError("cannot switch from automatic field numbering to manual field specification");
            }
            nvalue = parseInt(lkey);
            object = (isNaN(nvalue)) ? kwargs[lkey] : args[nvalue];
            if (object === undefined) {
                if (isNaN(nvalue)) {
                    throw new KeyError(lkey);
                }
                throw new IndexError(lkey);
            }
            object = resolve(key.slice(lkey.length), object);
        } else {
            implicit = true;
            if (explicit) {
                throw new ValueError("cannot switch from manual field specification to automatic field numbering");
            }
            if (idx >= args.length) {
                throw new IndexError("Not enough arguments to match template: " + template);
            }
            object = args[idx];
            idx += 1;
        }
        if (typeof object === "function") {
            object = object();
        }
        ans = "" + object;
        if (format_spec) {
            ans = apply_formatting(ans, format_spec);
        }
        return ans;
    }
    ans = "";
    pos = 0;
    in_brace = 0;
    markup = "";
    while (pos < template.length) {
        ch = template[pos];
        if (in_brace) {
            if (ch === "{") {
                in_brace += 1;
                markup += "{";
            } else if (ch === "}") {
                in_brace -= 1;
                if (in_brace > 0) {
                    markup += "}";
                } else {
                    ans += render_markup(markup);
                }
            } else {
                markup += ch;
            }
        } else {
            if (ch === "{") {
                if (template[pos + 1] === "{") {
                    pos += 1;
                    ans += "{";
                } else {
                    in_brace = 1;
                    markup = "";
                }
            } else {
                ans += ch;
            }
        }
        pos += 1;
    }
    if (in_brace) {
        throw new ValueError("expected '}' before end of string");
    }
    return ans;
};
_$rapyd$_str.capitalize = function(string) {
    if (string) {
        string = string[0].toUpperCase() + string.slice(1).toLowerCase();
    }
    return string;
};
_$rapyd$_str.center = function(string, width, fill) {
    var left, right;
    left = Math.floor((width - string.length) / 2);
    right = width - left - string.length;
    fill = fill || " ";
    return new Array(left+1).join(fill) + string + new Array(right+1).join(fill);
};
_$rapyd$_str.count = function(string, needle, start, end) {
    var _$rapyd$_unpack, pos, step, ans;
    start = start || 0;
    end = end || string.length;
    if (start < 0 || end < 0) {
        string = string.slice(start, end);
        _$rapyd$_unpack = [0, string.length];
        start = _$rapyd$_unpack[0];
        end = _$rapyd$_unpack[1];
    }
    pos = start;
    step = needle.length;
    ans = 0;
    while (pos !== -1) {
        pos = string.indexOf(needle, pos);
        if (pos !== -1) {
            ans += 1;
            pos += step;
        }
    }
    return ans;
};
_$rapyd$_str.endswith = function(string, suffixes, start, end) {
    var q;
    start = start || 0;
    if (typeof suffixes === "string") {
        suffixes = [suffixes];
    }
    if (end !== undefined) {
        string = string.slice(0, end);
    }
    for (var i = 0; i < suffixes.length; i++) {
        q = suffixes[i];
        if (string.indexOf(q, Math.max(start, string.length - q.length)) !== -1) {
            return true;
        }
    }
    return false;
};
_$rapyd$_str.startswith = function(string, prefixes, start, end) {
    var prefix;
    start = start || 0;
    if (typeof prefixes === "string") {
        prefixes = [prefixes];
    }
    for (var i = 0; i < prefixes.length; i++) {
        prefix = prefixes[i];
        end = (end === undefined) ? string.length : end;
        if (end - start >= prefix.length && prefix === string.slice(start, start + prefix.length)) {
            return true;
        }
    }
    return false;
};
_$rapyd$_str.find = function(string, needle, start, end) {
    var ans;
    while (start < 0) {
        start += string.length;
    }
    ans = string.indexOf(needle, start);
    if (end !== undefined && ans !== -1) {
        while (end < 0) {
            end += string.length;
        }
        if (ans >= end - needle.length) {
            return -1;
        }
    }
    return ans;
};
_$rapyd$_str.rfind = function(string, needle, start, end) {
    var ans;
    while (end < 0) {
        end += string.length;
    }
    ans = string.lastIndexOf(needle, end - 1);
    if (start !== undefined && ans !== -1) {
        while (start < 0) {
            start += string.length;
        }
        if (ans < start) {
            return -1;
        }
    }
    return ans;
};
_$rapyd$_str.index = function(string, needle, start, end) {
    var ans;
    ans = _$rapyd$_str.find.apply(null, arguments);
    if (ans === -1) {
        throw new ValueError("substring not found");
    }
    return ans;
};
_$rapyd$_str.rindex = function(string, needle, start, end) {
    var ans;
    ans = _$rapyd$_str.rfind.apply(null, arguments);
    if (ans === -1) {
        throw new ValueError("substring not found");
    }
    return ans;
};
_$rapyd$_str.islower = function(string) {
    return string.length > 0 && string.toUpperCase() !== string;
};
_$rapyd$_str.isupper = function(string) {
    return string.length > 0 && string.toLowerCase() !== string;
};
_$rapyd$_str.isspace = function(string) {
    return string.length > 0 && /^\s+$/.test(string);
};
_$rapyd$_str.join = function(string, iterable) {
    var ans, r;
    if (Array.isArray(iterable)) {
        return iterable.join(string);
    }
    ans = "";
    r = iterable.next();
    while (!r.done) {
        if (ans) {
            ans += string;
        }
        ans += r.value;
        r = iterable.next();
    }
    return ans;
};
_$rapyd$_str.ljust = function(string, width, fill) {
    if (width > string.length) {
        fill = fill || " ";
        string += new Array(width - string.length + 1).join(fill);
    }
    return string;
};
_$rapyd$_str.rjust = function(string, width, fill) {
    if (width > string.length) {
        fill = fill || " ";
        string = new Array(width - string.length + 1).join(fill) + string;
    }
    return string;
};
_$rapyd$_str.lower = function(string) {
    return string.toLowerCase();
};
_$rapyd$_str.upper = function(string) {
    return string.toUpperCase();
};
_$rapyd$_str.lstrip = function(string, chars) {
    var pos;
    pos = 0;
    chars = chars || _$rapyd$_str.whitespace;
    while (chars.indexOf(string[pos]) !== -1) {
        pos += 1;
    }
    if (pos) {
        string = string.slice(pos);
    }
    return string;
};
_$rapyd$_str.rstrip = function(string, chars) {
    var pos;
    pos = string.length - 1;
    chars = chars || _$rapyd$_str.whitespace;
    while (chars.indexOf(string[pos]) !== -1) {
        pos -= 1;
    }
    if (pos < string.length - 1) {
        string = string.slice(0, pos + 1);
    }
    return string;
};
_$rapyd$_str.strip = function(string, chars) {
    return _$rapyd$_str.lstrip(_$rapyd$_str.rstrip(string, chars), chars);
};
_$rapyd$_str.partition = function(string, sep) {
    var idx;
    idx = string.indexOf(sep);
    if (idx === -1) {
        return [string, "", ""];
    }
    return [string.slice(0, idx), sep, string.slice(idx + sep.length)];
};
_$rapyd$_str.rpartition = function(string, sep) {
    var idx;
    idx = string.lastIndexOf(sep);
    if (idx === -1) {
        return ["", "", string];
    }
    return [string.slice(0, idx), sep, string.slice(idx + sep.length)];
};
_$rapyd$_str.replace = function(string, old, repl, count) {
    var pos, idx;
    if (count === 1) {
        return string.replace(old, repl);
    }
    if (count < 1) {
        return string;
    }
    count = count || Number.MAX_VALUE;
    pos = 0;
    while (count > 0) {
        count -= 1;
        idx = string.indexOf(old, pos);
        if (idx === -1) {
            break;
        }
        pos = idx + repl.length;
        string = string.slice(0, idx) + repl + string.slice(idx + old.length);
    }
    return string;
};
_$rapyd$_str.split = function(string, sep, maxsplit) {
    var ans, extra, parts;
    if (maxsplit === 0) {
        return _$rapyd$_list_decorate([ string ]);
    }
    if (sep === undefined || sep === null) {
        if (maxsplit > 0) {
            ans = string.split(/(\s+)/);
            extra = "";
            parts = [];
            for (var i = 0; i < ans.length; i++) {
                if (parts.length >= maxsplit + 1) {
                    extra += ans[i];
                } else if (i % 2 === 0) {
                    parts.push(ans[i]);
                }
            }
            parts[parts.length-1] += extra;
            ans = parts;
        } else {
            ans = string.split(/\s+/);
        }
    } else {
        if (sep === "") {
            throw new ValueError("empty separator");
        }
        ans = string.split(sep);
        if (maxsplit > 0 && ans.length > maxsplit) {
            extra = ans.slice(maxsplit).join(sep);
            ans = ans.slice(0, maxsplit);
            ans.push(extra);
        }
    }
    return _$rapyd$_list_decorate(ans);
};
_$rapyd$_str.rsplit = function(string, sep, maxsplit) {
    var ans, is_space, pos, current, spc, ch, end, _$rapyd$_chain_assign_temp, idx;
    if (!maxsplit) {
        return _$rapyd$_str.split.call(null, string, sep, maxsplit);
    }
    if (sep === undefined || sep === null) {
        if (maxsplit > 0) {
            ans = [];
            is_space = /\s/;
            pos = string.length - 1;
            current = "";
            while (pos > -1 && maxsplit > 0) {
                spc = false;
                ch = string[pos];
                while (pos > -1 && is_space.test(ch)) {
                    spc = true;
                    ch = string[--pos];
                }
                if (spc) {
                    if (current) {
                        ans.push(current);
                        maxsplit -= 1;
                    }
                    current = ch;
                } else {
                    current += ch;
                }
                pos -= 1;
            }
            ans.push(string.slice(0, pos + 1) + current);
            ans.reverse();
        } else {
            ans = string.split(/\s+/);
        }
    } else {
        if (sep === "") {
            throw new ValueError("empty separator");
        }
        ans = [];
        _$rapyd$_chain_assign_temp = string.length;
        pos = _$rapyd$_chain_assign_temp;
        end = _$rapyd$_chain_assign_temp;
;
        while (pos > -1 && maxsplit > 0) {
            maxsplit -= 1;
            idx = string.lastIndexOf(sep, pos);
            if (idx === -1) {
                break;
            }
            ans.push(string.slice(idx + sep.length, end));
            pos = idx - 1;
            end = idx;
        }
        ans.push(string.slice(0, end));
        ans.reverse();
    }
    return _$rapyd$_list_decorate(ans);
};
_$rapyd$_str.splitlines = function(string, keepends) {
    var parts, ans;
    if (keepends) {
        parts = string.split(/((?:\r?\n)|\r)/);
        ans = [];
        for (var i = 0; i < parts.length; i++) {
            if (i % 2 === 0) {
                ans.push(parts[i]);
            } else {
                ans[ans.length-1] += parts[i];
            }
        }
    } else {
        ans = string.split(/(?:\r?\n)|\r/);
    }
    return _$rapyd$_list_decorate(ans);
};
_$rapyd$_str.swapcase = function(string) {
    var ans, a, b;
    ans = new Array(string.length);
    for (var i = 0; i < ans.length; i++) {
        a = string[i];
        b = a.toLowerCase();
        if (a === b) {
            b = a.toUpperCase();
        }
        ans[i] = b;
    }
    return ans.join("");
};
_$rapyd$_str.zfill = function(string, width) {
    if (width > string.length) {
        string = new Array(width - string.length + 1).join("0") + string;
    }
    return string;
};
_$rapyd$_str.uchrs = function(string, with_positions) {
    return (function(){
        var _$rapyd$_d = {};
        _$rapyd$_d["_string"] = string;
        _$rapyd$_d["_pos"] = 0;
        _$rapyd$_d[_$rapyd$_iterator_symbol] = function() {
            return this;
        };
        _$rapyd$_d["next"] = function() {
            var length, pos, value, ans, extra;
            length = this._string.length;
            if (this._pos >= length) {
                return {
                    "done": true
                };
            }
            pos = this._pos;
            value = this._string.charCodeAt(this._pos++);
            ans = "\ufffd";
            if (55296 <= value && value <= 56319) {
                if (this._pos < length) {
                    extra = this._string.charCodeAt(this._pos++);
                    if ((extra & 56320) === 56320) {
                        ans = String.fromCharCode(value, extra);
                    }
                }
            } else if ((value & 56320) !== 56320) {
                ans = String.fromCharCode(value);
            }
            if (with_positions) {
                return {
                    "done": false,
                    "value": _$rapyd$_list_decorate([ pos, ans ])
                };
            } else {
                return {
                    "done": false,
                    "value": ans
                };
            }
        };
        return _$rapyd$_d;
    })();
};
_$rapyd$_str.uslice = function(string, start, end) {
    var items, iterator, r;
    items = [];
    iterator = _$rapyd$_str.uchrs(string);
    r = iterator.next();
    while (!r.done) {
        items.push(r.value);
        r = iterator.next();
    }
    return items.slice(start || 0, (end === undefined) ? items.length : end).join("");
};
_$rapyd$_str.ulen = function(string) {
    var iterator, r, ans;
    iterator = _$rapyd$_str.uchrs(string);
    r = iterator.next();
    ans = 0;
    while (!r.done) {
        r = iterator.next();
        ans += 1;
    }
    return ans;
};
_$rapyd$_str.ascii_lowercase = "abcdefghijklmnopqrstuvwxyz";
_$rapyd$_str.ascii_uppercase = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
_$rapyd$_str.ascii_letters = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
_$rapyd$_str.digits = "0123456789";
_$rapyd$_str.punctuation = "!\"#$%&'()*+,-./:;<=>?@[\\]^_`{|}~";
_$rapyd$_str.printable = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ!\"#$%&'()*+,-./:;<=>?@[\\]^_`{|}~ \t\n\r\u000b\f";
_$rapyd$_str.whitespace = " \t\n\r\u000b\f";
var str = _$rapyd$_str;;
    function iter(iterable) {
            var ans;
            if (typeof iterable[_$rapyd$_iterator_symbol] === "function") {
                return (typeof Map === "function" && iterable instanceof Map) ? iterable.keys() : iterable[_$rapyd$_iterator_symbol]();
            }
            if (_$rapyd$_arraylike(iterable)) {
                ans = {
                    "_i": -1,
                    "next": function() {
                        this._i += 1;
                        if (this._i < iterable.length) {
                            return {
                                "done": false,
                                "value": iterable[this._i]
                            };
                        }
                        return {
                            "done": true
                        };
                    }
                };
                ans[_$rapyd$_iterator_symbol] = function() {
                    return this;
                };
                return ans;
            }
            return iter(Object.keys(iterable));
        };
    var min = (function min() {
            return Math.min;
        })();
    var max = (function max() {
            return Math.max;
        })();
    var _$rapyd$_modules = {};
    _$rapyd$_modules["gettext"] = {};
    _$rapyd$_modules["ajax"] = {};
    _$rapyd$_modules["elementmaker"] = {};
    _$rapyd$_modules["session"] = {};
    _$rapyd$_modules["utils"] = {};
    _$rapyd$_modules["book_list"] = {};
    _$rapyd$_modules["dom"] = {};
    _$rapyd$_modules["book_list.theme"] = {};
    _$rapyd$_modules["modals"] = {};
    _$rapyd$_modules["widgets"] = {};
    _$rapyd$_modules["book_list.globals"] = {};
    _$rapyd$_modules["book_list.search"] = {};
    _$rapyd$_modules["book_list.top_bar"] = {};
    _$rapyd$_modules["book_list.views"] = {};
    _$rapyd$_modules["book_list.item_list"] = {};
    _$rapyd$_modules["book_list.ui"] = {};
    _$rapyd$_modules["book_list.boss"] = {};

    (function(){
        var __name__ = "gettext";
        var Jed, plural_forms_parser, _gettext, _ngettext;
        Jed = {};
        
  Jed.PF = {};

  Jed.PF.parse = function ( p ) {
    var plural_str = Jed.PF.extractPluralExpr( p );
    return Jed.PF.parser.parse.call(Jed.PF.parser, plural_str);
  };

  Jed.PF.compile = function ( p ) {
    // Handle trues and falses as 0 and 1
    function imply( val ) {
      return (val === true ? 1 : val ? val : 0);
    }

    var ast = Jed.PF.parse( p );
    return function ( n ) {
      return imply( Jed.PF.interpreter( ast )( n ) );
    };
  };

  Jed.PF.interpreter = function ( ast ) {
    return function ( n ) {
      var res;
      switch ( ast.type ) {
        case 'GROUP':
          return Jed.PF.interpreter( ast.expr )( n );
        case 'TERNARY':
          if ( Jed.PF.interpreter( ast.expr )( n ) ) {
            return Jed.PF.interpreter( ast.truthy )( n );
          }
          return Jed.PF.interpreter( ast.falsey )( n );
        case 'OR':
          return Jed.PF.interpreter( ast.left )( n ) || Jed.PF.interpreter( ast.right )( n );
        case 'AND':
          return Jed.PF.interpreter( ast.left )( n ) && Jed.PF.interpreter( ast.right )( n );
        case 'LT':
          return Jed.PF.interpreter( ast.left )( n ) < Jed.PF.interpreter( ast.right )( n );
        case 'GT':
          return Jed.PF.interpreter( ast.left )( n ) > Jed.PF.interpreter( ast.right )( n );
        case 'LTE':
          return Jed.PF.interpreter( ast.left )( n ) <= Jed.PF.interpreter( ast.right )( n );
        case 'GTE':
          return Jed.PF.interpreter( ast.left )( n ) >= Jed.PF.interpreter( ast.right )( n );
        case 'EQ':
          return Jed.PF.interpreter( ast.left )( n ) == Jed.PF.interpreter( ast.right )( n );
        case 'NEQ':
          return Jed.PF.interpreter( ast.left )( n ) != Jed.PF.interpreter( ast.right )( n );
        case 'MOD':
          return Jed.PF.interpreter( ast.left )( n ) % Jed.PF.interpreter( ast.right )( n );
        case 'VAR':
          return n;
        case 'NUM':
          return ast.val;
        default:
          throw new Error("Invalid Token found.");
      }
    };
  };

  Jed.PF.extractPluralExpr = function ( p ) {
    // trim first
    p = p.replace(/^\s\s*/, '').replace(/\s\s*$/, '');

    if (! /;\s*$/.test(p)) {
      p = p.concat(';');
    }

    var nplurals_re = /nplurals\=(\d+);/,
        plural_re = /plural\=(.*);/,
        nplurals_matches = p.match( nplurals_re ),
        res = {},
        plural_matches;

    // Find the nplurals number
    if ( nplurals_matches.length > 1 ) {
      res.nplurals = nplurals_matches[1];
    }
    else {
      throw new Error('nplurals not found in plural_forms string: ' + p );
    }

    // remove that data to get to the formula
    p = p.replace( nplurals_re, "" );
    plural_matches = p.match( plural_re );

    if (!( plural_matches && plural_matches.length > 1 ) ) {
      throw new Error('`plural` expression not found: ' + p);
    }
    return plural_matches[ 1 ];
  };

  /* Jison generated parser */
  Jed.PF.parser = (function(){

var parser = {trace: function trace() { },
yy: {},
symbols_: {"error":2,"expressions":3,"e":4,"EOF":5,"?":6,":":7,"||":8,"&&":9,"<":10,"<=":11,">":12,">=":13,"!=":14,"==":15,"%":16,"(":17,")":18,"n":19,"NUMBER":20,"$accept":0,"$end":1},
terminals_: {2:"error",5:"EOF",6:"?",7:":",8:"||",9:"&&",10:"<",11:"<=",12:">",13:">=",14:"!=",15:"==",16:"%",17:"(",18:")",19:"n",20:"NUMBER"},
productions_: [0,[3,2],[4,5],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,1],[4,1]],
performAction: function anonymous(yytext,yyleng,yylineno,yy,yystate,$$,_$) {

var $0 = $$.length - 1;
switch (yystate) {
case 1: return { type : 'GROUP', expr: $$[$0-1] };
case 2:this.$ = { type: 'TERNARY', expr: $$[$0-4], truthy : $$[$0-2], falsey: $$[$0] };
break;
case 3:this.$ = { type: "OR", left: $$[$0-2], right: $$[$0] };
break;
case 4:this.$ = { type: "AND", left: $$[$0-2], right: $$[$0] };
break;
case 5:this.$ = { type: 'LT', left: $$[$0-2], right: $$[$0] };
break;
case 6:this.$ = { type: 'LTE', left: $$[$0-2], right: $$[$0] };
break;
case 7:this.$ = { type: 'GT', left: $$[$0-2], right: $$[$0] };
break;
case 8:this.$ = { type: 'GTE', left: $$[$0-2], right: $$[$0] };
break;
case 9:this.$ = { type: 'NEQ', left: $$[$0-2], right: $$[$0] };
break;
case 10:this.$ = { type: 'EQ', left: $$[$0-2], right: $$[$0] };
break;
case 11:this.$ = { type: 'MOD', left: $$[$0-2], right: $$[$0] };
break;
case 12:this.$ = { type: 'GROUP', expr: $$[$0-1] };
break;
case 13:this.$ = { type: 'VAR' };
break;
case 14:this.$ = { type: 'NUM', val: Number(yytext) };
break;
}
},
table: [{3:1,4:2,17:[1,3],19:[1,4],20:[1,5]},{1:[3]},{5:[1,6],6:[1,7],8:[1,8],9:[1,9],10:[1,10],11:[1,11],12:[1,12],13:[1,13],14:[1,14],15:[1,15],16:[1,16]},{4:17,17:[1,3],19:[1,4],20:[1,5]},{5:[2,13],6:[2,13],7:[2,13],8:[2,13],9:[2,13],10:[2,13],11:[2,13],12:[2,13],13:[2,13],14:[2,13],15:[2,13],16:[2,13],18:[2,13]},{5:[2,14],6:[2,14],7:[2,14],8:[2,14],9:[2,14],10:[2,14],11:[2,14],12:[2,14],13:[2,14],14:[2,14],15:[2,14],16:[2,14],18:[2,14]},{1:[2,1]},{4:18,17:[1,3],19:[1,4],20:[1,5]},{4:19,17:[1,3],19:[1,4],20:[1,5]},{4:20,17:[1,3],19:[1,4],20:[1,5]},{4:21,17:[1,3],19:[1,4],20:[1,5]},{4:22,17:[1,3],19:[1,4],20:[1,5]},{4:23,17:[1,3],19:[1,4],20:[1,5]},{4:24,17:[1,3],19:[1,4],20:[1,5]},{4:25,17:[1,3],19:[1,4],20:[1,5]},{4:26,17:[1,3],19:[1,4],20:[1,5]},{4:27,17:[1,3],19:[1,4],20:[1,5]},{6:[1,7],8:[1,8],9:[1,9],10:[1,10],11:[1,11],12:[1,12],13:[1,13],14:[1,14],15:[1,15],16:[1,16],18:[1,28]},{6:[1,7],7:[1,29],8:[1,8],9:[1,9],10:[1,10],11:[1,11],12:[1,12],13:[1,13],14:[1,14],15:[1,15],16:[1,16]},{5:[2,3],6:[2,3],7:[2,3],8:[2,3],9:[1,9],10:[1,10],11:[1,11],12:[1,12],13:[1,13],14:[1,14],15:[1,15],16:[1,16],18:[2,3]},{5:[2,4],6:[2,4],7:[2,4],8:[2,4],9:[2,4],10:[1,10],11:[1,11],12:[1,12],13:[1,13],14:[1,14],15:[1,15],16:[1,16],18:[2,4]},{5:[2,5],6:[2,5],7:[2,5],8:[2,5],9:[2,5],10:[2,5],11:[2,5],12:[2,5],13:[2,5],14:[2,5],15:[2,5],16:[1,16],18:[2,5]},{5:[2,6],6:[2,6],7:[2,6],8:[2,6],9:[2,6],10:[2,6],11:[2,6],12:[2,6],13:[2,6],14:[2,6],15:[2,6],16:[1,16],18:[2,6]},{5:[2,7],6:[2,7],7:[2,7],8:[2,7],9:[2,7],10:[2,7],11:[2,7],12:[2,7],13:[2,7],14:[2,7],15:[2,7],16:[1,16],18:[2,7]},{5:[2,8],6:[2,8],7:[2,8],8:[2,8],9:[2,8],10:[2,8],11:[2,8],12:[2,8],13:[2,8],14:[2,8],15:[2,8],16:[1,16],18:[2,8]},{5:[2,9],6:[2,9],7:[2,9],8:[2,9],9:[2,9],10:[2,9],11:[2,9],12:[2,9],13:[2,9],14:[2,9],15:[2,9],16:[1,16],18:[2,9]},{5:[2,10],6:[2,10],7:[2,10],8:[2,10],9:[2,10],10:[2,10],11:[2,10],12:[2,10],13:[2,10],14:[2,10],15:[2,10],16:[1,16],18:[2,10]},{5:[2,11],6:[2,11],7:[2,11],8:[2,11],9:[2,11],10:[2,11],11:[2,11],12:[2,11],13:[2,11],14:[2,11],15:[2,11],16:[2,11],18:[2,11]},{5:[2,12],6:[2,12],7:[2,12],8:[2,12],9:[2,12],10:[2,12],11:[2,12],12:[2,12],13:[2,12],14:[2,12],15:[2,12],16:[2,12],18:[2,12]},{4:30,17:[1,3],19:[1,4],20:[1,5]},{5:[2,2],6:[1,7],7:[2,2],8:[1,8],9:[1,9],10:[1,10],11:[1,11],12:[1,12],13:[1,13],14:[1,14],15:[1,15],16:[1,16],18:[2,2]}],
defaultActions: {6:[2,1]},
parseError: function parseError(str, hash) {
    throw new Error(str);
},
parse: function parse(input) {
    var self = this,
        stack = [0],
        vstack = [null], // semantic value stack
        lstack = [], // location stack
        table = this.table,
        yytext = '',
        yylineno = 0,
        yyleng = 0,
        recovering = 0,
        TERROR = 2,
        EOF = 1;

    //this.reductionCount = this.shiftCount = 0;

    this.lexer.setInput(input);
    this.lexer.yy = this.yy;
    this.yy.lexer = this.lexer;
    if (typeof this.lexer.yylloc == 'undefined')
        this.lexer.yylloc = {};
    var yyloc = this.lexer.yylloc;
    lstack.push(yyloc);

    if (typeof this.yy.parseError === 'function')
        this.parseError = this.yy.parseError;

    function popStack (n) {
        stack.length = stack.length - 2*n;
        vstack.length = vstack.length - n;
        lstack.length = lstack.length - n;
    }

    function lex() {
        var token;
        token = self.lexer.lex() || 1; // $end = 1
        // if token isn't its numeric value, convert
        if (typeof token !== 'number') {
            token = self.symbols_[token] || token;
        }
        return token;
    }

    var symbol, preErrorSymbol, state, action, a, r, yyval={},p,len,newState, expected, errStr;
    while (true) {
        // retreive state number from top of stack
        state = stack[stack.length-1];

        // use default actions if available
        if (this.defaultActions[state]) {
            action = this.defaultActions[state];
        } else {
            if (symbol === null || symbol === undefined)
                symbol = lex();
            // read action for current state and first input
            action = table[state] && table[state][symbol];
        }

        // handle parse error
        _handle_error:
        if (typeof action === 'undefined' || !action.length || !action[0]) {

            if (!recovering) {
                // Report error
                expected = [];
                for (p in table[state]) if (this.terminals_[p] && p > 2) {
                    expected.push("'"+this.terminals_[p]+"'");
                }
                errStr = '';
                if (this.lexer.showPosition) {
                    errStr = 'Parse error on line '+(yylineno+1)+":\n"+this.lexer.showPosition()+"\nExpecting "+expected.join(', ') + ", got '" + this.terminals_[symbol]+ "'";
                } else {
                    errStr = 'Parse error on line '+(yylineno+1)+": Unexpected " +
                                  (symbol == 1 /*EOF*/ ? "end of input" :
                                              ("'"+(this.terminals_[symbol] || symbol)+"'"));
                }
                this.parseError(errStr,
                    {text: this.lexer.match, token: this.terminals_[symbol] || symbol, line: this.lexer.yylineno, loc: yyloc, expected: expected});
            }

            // just recovered from another error
            if (recovering == 3) {
                if (symbol == EOF) {
                    throw new Error(errStr || 'Parsing halted.');
                }

                // discard current lookahead and grab another
                yyleng = this.lexer.yyleng;
                yytext = this.lexer.yytext;
                yylineno = this.lexer.yylineno;
                yyloc = this.lexer.yylloc;
                symbol = lex();
            }

            // try to recover from error
            while (1) {
                // check for error recovery rule in this state
                if ((TERROR.toString()) in table[state]) {
                    break;
                }
                if (state === 0) {
                    throw new Error(errStr || 'Parsing halted.');
                }
                popStack(1);
                state = stack[stack.length-1];
            }

            preErrorSymbol = symbol; // save the lookahead token
            symbol = TERROR;         // insert generic error symbol as new lookahead
            state = stack[stack.length-1];
            action = table[state] && table[state][TERROR];
            recovering = 3; // allow 3 real symbols to be shifted before reporting a new error
        }

        // this shouldn't happen, unless resolve defaults are off
        if (action[0] instanceof Array && action.length > 1) {
            throw new Error('Parse Error: multiple actions possible at state: '+state+', token: '+symbol);
        }

        switch (action[0]) {

            case 1: // shift
                //this.shiftCount++;

                stack.push(symbol);
                vstack.push(this.lexer.yytext);
                lstack.push(this.lexer.yylloc);
                stack.push(action[1]); // push state
                symbol = null;
                if (!preErrorSymbol) { // normal execution/no error
                    yyleng = this.lexer.yyleng;
                    yytext = this.lexer.yytext;
                    yylineno = this.lexer.yylineno;
                    yyloc = this.lexer.yylloc;
                    if (recovering > 0)
                        recovering--;
                } else { // error just occurred, resume old lookahead f/ before error
                    symbol = preErrorSymbol;
                    preErrorSymbol = null;
                }
                break;

            case 2: // reduce
                //this.reductionCount++;

                len = this.productions_[action[1]][1];

                // perform semantic action
                yyval.$ = vstack[vstack.length-len]; // default to $$ = $1
                // default location, uses first token for firsts, last for lasts
                yyval._$ = {
                    first_line: lstack[lstack.length-(len||1)].first_line,
                    last_line: lstack[lstack.length-1].last_line,
                    first_column: lstack[lstack.length-(len||1)].first_column,
                    last_column: lstack[lstack.length-1].last_column
                };
                r = this.performAction.call(yyval, yytext, yyleng, yylineno, this.yy, action[1], vstack, lstack);

                if (typeof r !== 'undefined') {
                    return r;
                }

                // pop off stack
                if (len) {
                    stack = stack.slice(0,-1*len*2);
                    vstack = vstack.slice(0, -1*len);
                    lstack = lstack.slice(0, -1*len);
                }

                stack.push(this.productions_[action[1]][0]);    // push nonterminal (reduce)
                vstack.push(yyval.$);
                lstack.push(yyval._$);
                // goto new state = table[STATE][NONTERMINAL]
                newState = table[stack[stack.length-2]][stack[stack.length-1]];
                stack.push(newState);
                break;

            case 3: // accept
                return true;
        }

    }

    return true;
}};/* Jison generated lexer */
var lexer = (function(){

var lexer = ({EOF:1,
parseError:function parseError(str, hash) {
        if (this.yy.parseError) {
            this.yy.parseError(str, hash);
        } else {
            throw new Error(str);
        }
    },
setInput:function (input) {
        this._input = input;
        this._more = this._less = this.done = false;
        this.yylineno = this.yyleng = 0;
        this.yytext = this.matched = this.match = '';
        this.conditionStack = ['INITIAL'];
        this.yylloc = {first_line:1,first_column:0,last_line:1,last_column:0};
        return this;
    },
input:function () {
        var ch = this._input[0];
        this.yytext+=ch;
        this.yyleng++;
        this.match+=ch;
        this.matched+=ch;
        var lines = ch.match(/\n/);
        if (lines) this.yylineno++;
        this._input = this._input.slice(1);
        return ch;
    },
unput:function (ch) {
        this._input = ch + this._input;
        return this;
    },
more:function () {
        this._more = true;
        return this;
    },
pastInput:function () {
        var past = this.matched.substr(0, this.matched.length - this.match.length);
        return (past.length > 20 ? '...':'') + past.substr(-20).replace(/\n/g, "");
    },
upcomingInput:function () {
        var next = this.match;
        if (next.length < 20) {
            next += this._input.substr(0, 20-next.length);
        }
        return (next.substr(0,20)+(next.length > 20 ? '...':'')).replace(/\n/g, "");
    },
showPosition:function () {
        var pre = this.pastInput();
        var c = new Array(pre.length + 1).join("-");
        return pre + this.upcomingInput() + "\n" + c+"^";
    },
next:function () {
        if (this.done) {
            return this.EOF;
        }
        if (!this._input) this.done = true;

        var token,
            match,
            col,
            lines;
        if (!this._more) {
            this.yytext = '';
            this.match = '';
        }
        var rules = this._currentRules();
        for (var i=0;i < rules.length; i++) {
            match = this._input.match(this.rules[rules[i]]);
            if (match) {
                lines = match[0].match(/\n.*/g);
                if (lines) this.yylineno += lines.length;
                this.yylloc = {first_line: this.yylloc.last_line,
                               last_line: this.yylineno+1,
                               first_column: this.yylloc.last_column,
                               last_column: lines ? lines[lines.length-1].length-1 : this.yylloc.last_column + match[0].length};
                this.yytext += match[0];
                this.match += match[0];
                this.matches = match;
                this.yyleng = this.yytext.length;
                this._more = false;
                this._input = this._input.slice(match[0].length);
                this.matched += match[0];
                token = this.performAction.call(this, this.yy, this, rules[i],this.conditionStack[this.conditionStack.length-1]);
                if (token) return token;
                else return;
            }
        }
        if (this._input === "") {
            return this.EOF;
        } else {
            this.parseError('Lexical error on line '+(this.yylineno+1)+'. Unrecognized text.\n'+this.showPosition(),
                    {text: "", token: null, line: this.yylineno});
        }
    },
lex:function lex() {
        var r = this.next();
        if (typeof r !== 'undefined') {
            return r;
        } else {
            return this.lex();
        }
    },
begin:function begin(condition) {
        this.conditionStack.push(condition);
    },
popState:function popState() {
        return this.conditionStack.pop();
    },
_currentRules:function _currentRules() {
        return this.conditions[this.conditionStack[this.conditionStack.length-1]].rules;
    },
topState:function () {
        return this.conditionStack[this.conditionStack.length-2];
    },
pushState:function begin(condition) {
        this.begin(condition);
    }});
lexer.performAction = function anonymous(yy,yy_,$avoiding_name_collisions,YY_START) {

var YYSTATE=YY_START;
switch($avoiding_name_collisions) {
case 0:/* skip whitespace */
break;
case 1:return 20
break;
case 2:return 19
break;
case 3:return 8
break;
case 4:return 9
break;
case 5:return 6
break;
case 6:return 7
break;
case 7:return 11
break;
case 8:return 13
break;
case 9:return 10
break;
case 10:return 12
break;
case 11:return 14
break;
case 12:return 15
break;
case 13:return 16
break;
case 14:return 17
break;
case 15:return 18
break;
case 16:return 5
break;
case 17:return 'INVALID'
break;
}
};
lexer.rules = [/^\s+/,/^[0-9]+(\.[0-9]+)?\b/,/^n\b/,/^\|\|/,/^&&/,/^\?/,/^:/,/^<=/,/^>=/,/^</,/^>/,/^!=/,/^==/,/^%/,/^\(/,/^\)/,/^$/,/^./];
lexer.conditions = {"INITIAL":{"rules":[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17],"inclusive":true}};return lexer;})()
parser.lexer = lexer;
return parser;
})();
;
        plural_forms_parser = Jed.PF;
        function _get_plural_forms_function(plural_forms_string) {
            return plural_forms_parser.compile(plural_forms_string || "nplurals=2; plural=(n != 1);");
        }
        _gettext = function(text) {
            return text;
        };
        _ngettext = function(text, plural, n) {
            return (n === 1) ? text : plural;
        };
        function gettext(text) {
            return _gettext(text);
        }
        function ngettext(text, plural, n) {
            return _ngettext(text, plural, n);
        }
        function install(translation_data) {
            var t;
            t = new Translations(translation_data);
            t.install();
            return t;
        }
        function Translations() {
            Translations.prototype.__init__.apply(this, arguments);
        }
        Translations.prototype.__init__ = function __init__(translation_data) {
            var self = this;
            translation_data = translation_data || {};
            translation_data["func"] = _get_plural_forms_function(translation_data["plural_forms"]);
            self.translations = [translation_data];
            self.language = translation_data["language"];
        };
        Translations.prototype.add_fallback = function add_fallback(fallback) {
            var self = this;
            fallback["func"] = _get_plural_forms_function(fallback["plural_forms"]);
            self.translations.push(fallback || {});
        };
        Translations.prototype.gettext = function gettext(text) {
            var self = this;
            var m, t;
            var _$rapyd$_Iter0 = _$rapyd$_Iterable(self.translations);
            for (var _$rapyd$_Index0 = 0; _$rapyd$_Index0 < _$rapyd$_Iter0.length; _$rapyd$_Index0++) {
                t = _$rapyd$_Iter0[_$rapyd$_Index0];
                m = t["entries"];
                if (Object.prototype.hasOwnProperty.call(m, text)) {
                    return m[text][0];
                }
            }
            return text;
        };
        Translations.prototype.ngettext = function ngettext(text, plural, n) {
            var self = this;
            var m, idx, t;
            var _$rapyd$_Iter1 = _$rapyd$_Iterable(self.translations);
            for (var _$rapyd$_Index1 = 0; _$rapyd$_Index1 < _$rapyd$_Iter1.length; _$rapyd$_Index1++) {
                t = _$rapyd$_Iter1[_$rapyd$_Index1];
                m = t["entries"];
                if (Object.prototype.hasOwnProperty.call(m, text)) {
                    idx = t["func"](n);
                    return m[text][idx] || ((n === 1) ? text : plural);
                }
            }
            return (n === 1) ? text : plural;
        };
        Translations.prototype.install = function install() {
            var self = this;
            _gettext = function() {
                return self.gettext.apply(self, arguments);
            };
            _ngettext = function() {
                return self.ngettext.apply(self, arguments);
            };
        };

        _$rapyd$_modules["gettext"]["Jed"] = Jed;

        _$rapyd$_modules["gettext"]["plural_forms_parser"] = plural_forms_parser;

        _$rapyd$_modules["gettext"]["_gettext"] = _gettext;

        _$rapyd$_modules["gettext"]["_ngettext"] = _ngettext;

        _$rapyd$_modules["gettext"]["_get_plural_forms_function"] = _get_plural_forms_function;

        _$rapyd$_modules["gettext"]["gettext"] = gettext;

        _$rapyd$_modules["gettext"]["ngettext"] = ngettext;

        _$rapyd$_modules["gettext"]["install"] = install;

        _$rapyd$_modules["gettext"]["Translations"] = Translations;
    })();

    (function(){
        var __name__ = "ajax";
        var _ = _$rapyd$_modules["gettext"].gettext;
        
        function encode_query(query) {
            var keys, has_query, path, val, k;
            if (!query) {
                return "";
            }
            keys = Object.keys(query);
            has_query = false;
            path = "";
            if (keys.length) {
                var _$rapyd$_Iter0 = _$rapyd$_Iterable(keys);
                for (var _$rapyd$_Index0 = 0; _$rapyd$_Index0 < _$rapyd$_Iter0.length; _$rapyd$_Index0++) {
                    k = _$rapyd$_Iter0[_$rapyd$_Index0];
                    val = query[k];
                    if (val === undefined || val === null) {
                        continue;
                    }
                    path += ((has_query) ? "&" : "?") + encodeURIComponent(k) + "=" + encodeURIComponent(val.toString());
                    has_query = true;
                }
            }
            return path;
        }
        function ajax() {
            var path = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) ? undefined : arguments[0];
            var on_complete = ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) ? undefined : arguments[1];
            var on_progress = (arguments[2] === undefined || ( 2 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (null) : arguments[2];
            var bypass_cache = (arguments[3] === undefined || ( 3 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (true) : arguments[3];
            var method = (arguments[4] === undefined || ( 4 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? ("GET") : arguments[4];
            var query = (arguments[5] === undefined || ( 5 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (null) : arguments[5];
            var timeout = (arguments[6] === undefined || ( 6 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (30 * 1e3) : arguments[6];
            var ok_code = (arguments[7] === undefined || ( 7 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (200) : arguments[7];
            var _$rapyd$_kwargs_obj = arguments[arguments.length-1];
            if (_$rapyd$_kwargs_obj === null || typeof _$rapyd$_kwargs_obj !== "object" || _$rapyd$_kwargs_obj [_$rapyd$_kwargs_symbol] !== true) _$rapyd$_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "on_progress")){
                on_progress = _$rapyd$_kwargs_obj.on_progress;
            }
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "bypass_cache")){
                bypass_cache = _$rapyd$_kwargs_obj.bypass_cache;
            }
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "method")){
                method = _$rapyd$_kwargs_obj.method;
            }
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "query")){
                query = _$rapyd$_kwargs_obj.query;
            }
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "timeout")){
                timeout = _$rapyd$_kwargs_obj.timeout;
            }
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "ok_code")){
                ok_code = _$rapyd$_kwargs_obj.ok_code;
            }
            var xhr, eq, has_query;
            query = query || {};
            xhr = new XMLHttpRequest();
            eq = encode_query(query);
            has_query = eq.length > 0;
            path += eq;
            if (bypass_cache) {
                path += ((has_query) ? "&" : "?") + new Date().getTime();
            }
            xhr.request_path = path;
            xhr.error_html = "";
            function set_error(event) {
                var rtext;
                if (event === "timeout") {
                    xhr.error_html = str.format(_("Failed to communicate with \"{}\", timed out after: {} seconds"), xhr.request_path, timeout / 1e3);
                } else if (event === "abort") {
                    xhr.error_html = str.format(_("Failed to communicate with \"{}\", aborted"), xhr.request_path);
                } else {
                    rtext = xhr.responseText || "";
                    xhr.error_html = str.format(_("Failed to communicate with \"{}\", with status: [{}] {}<br>{}"), xhr.request_path, xhr.status, xhr.statusText, rtext.slice(0, 200));
                }
            }
            function progress_callback(ev) {
                var ul;
                if (ev.lengthComputable) {
                    on_progress(ev.loaded, ev.total, xhr);
                } else if (ev.loaded) {
                    ul = xhr.getResponseHeader("Calibre-Uncompressed-Length");
                    if (ul) {
                        try {
                            ul = int(ul);
                        } catch (_$rapyd$_Exception) {
                            if (_$rapyd$_Exception instanceof Exception) {
                                return;
                            } else {
                                throw _$rapyd$_Exception;
                            }
                        }
                        on_progress(ev.loaded, ul, xhr);
                    }
                }
            }
            function complete_callback(end_type, ev) {
                if (xhr.status !== ok_code && end_type === "load") {
                    end_type = "error";
                }
                if (end_type !== "load") {
                    set_error(end_type);
                }
                on_complete(end_type, xhr, ev);
            }
            if (on_progress) {
                xhr.addEventListener("progress", progress_callback);
            }
            xhr.addEventListener("abort", function(ev) {
                complete_callback("abort", ev);
            });
            xhr.addEventListener("error", function(ev) {
                complete_callback("error", ev);
            });
            xhr.addEventListener("load", function(ev) {
                complete_callback("load", ev);
            });
            xhr.addEventListener("timeout", function(ev) {
                complete_callback("timeout", ev);
            });
            xhr.open(method, path);
            xhr.timeout = timeout;
            return xhr;
        }
        function ajax_send() {
            var path = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) ? undefined : arguments[0];
            var data = ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) ? undefined : arguments[1];
            var on_complete = ( 2 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) ? undefined : arguments[2];
            var on_progress = (arguments[3] === undefined || ( 3 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (null) : arguments[3];
            var query = (arguments[4] === undefined || ( 4 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (null) : arguments[4];
            var timeout = (arguments[5] === undefined || ( 5 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (30 * 1e3) : arguments[5];
            var ok_code = (arguments[6] === undefined || ( 6 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (200) : arguments[6];
            var _$rapyd$_kwargs_obj = arguments[arguments.length-1];
            if (_$rapyd$_kwargs_obj === null || typeof _$rapyd$_kwargs_obj !== "object" || _$rapyd$_kwargs_obj [_$rapyd$_kwargs_symbol] !== true) _$rapyd$_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "on_progress")){
                on_progress = _$rapyd$_kwargs_obj.on_progress;
            }
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "query")){
                query = _$rapyd$_kwargs_obj.query;
            }
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "timeout")){
                timeout = _$rapyd$_kwargs_obj.timeout;
            }
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "ok_code")){
                ok_code = _$rapyd$_kwargs_obj.ok_code;
            }
            var xhr;
            xhr = ajax(path, on_complete, on_progress, false, "POST", query, timeout, ok_code);
            xhr.setRequestHeader("Content-Type", "application/json;charset=UTF-8");
            xhr.send(JSON.stringify(data));
            return xhr;
        }
        _$rapyd$_modules["ajax"]["encode_query"] = encode_query;

        _$rapyd$_modules["ajax"]["ajax"] = ajax;

        _$rapyd$_modules["ajax"]["ajax_send"] = ajax_send;
    })();

    (function(){
        var __name__ = "elementmaker";
        var html_elements, mathml_elements, svg_elements, html5_tags, create_element, create_text_node, tag;
        html_elements = (function(){
            var s = _$rapyd$_set();
            s.jsset.add("a");
            s.jsset.add("abbr");
            s.jsset.add("acronym");
            s.jsset.add("address");
            s.jsset.add("area");
            s.jsset.add("article");
            s.jsset.add("aside");
            s.jsset.add("audio");
            s.jsset.add("b");
            s.jsset.add("big");
            s.jsset.add("blockquote");
            s.jsset.add("br");
            s.jsset.add("button");
            s.jsset.add("canvas");
            s.jsset.add("caption");
            s.jsset.add("center");
            s.jsset.add("cite");
            s.jsset.add("code");
            s.jsset.add("col");
            s.jsset.add("colgroup");
            s.jsset.add("command");
            s.jsset.add("datagrid");
            s.jsset.add("datalist");
            s.jsset.add("dd");
            s.jsset.add("del");
            s.jsset.add("details");
            s.jsset.add("dfn");
            s.jsset.add("dialog");
            s.jsset.add("dir");
            s.jsset.add("div");
            s.jsset.add("dl");
            s.jsset.add("dt");
            s.jsset.add("em");
            s.jsset.add("event-source");
            s.jsset.add("fieldset");
            s.jsset.add("figcaption");
            s.jsset.add("figure");
            s.jsset.add("footer");
            s.jsset.add("font");
            s.jsset.add("form");
            s.jsset.add("header");
            s.jsset.add("h1");
            s.jsset.add("h2");
            s.jsset.add("h3");
            s.jsset.add("h4");
            s.jsset.add("h5");
            s.jsset.add("h6");
            s.jsset.add("hr");
            s.jsset.add("i");
            s.jsset.add("img");
            s.jsset.add("input");
            s.jsset.add("ins");
            s.jsset.add("keygen");
            s.jsset.add("kbd");
            s.jsset.add("label");
            s.jsset.add("legend");
            s.jsset.add("li");
            s.jsset.add("m");
            s.jsset.add("map");
            s.jsset.add("menu");
            s.jsset.add("meter");
            s.jsset.add("multicol");
            s.jsset.add("nav");
            s.jsset.add("nextid");
            s.jsset.add("ol");
            s.jsset.add("output");
            s.jsset.add("optgroup");
            s.jsset.add("option");
            s.jsset.add("p");
            s.jsset.add("pre");
            s.jsset.add("progress");
            s.jsset.add("q");
            s.jsset.add("s");
            s.jsset.add("samp");
            s.jsset.add("script");
            s.jsset.add("section");
            s.jsset.add("select");
            s.jsset.add("small");
            s.jsset.add("sound");
            s.jsset.add("source");
            s.jsset.add("spacer");
            s.jsset.add("span");
            s.jsset.add("strike");
            s.jsset.add("strong");
            s.jsset.add("style");
            s.jsset.add("sub");
            s.jsset.add("sup");
            s.jsset.add("table");
            s.jsset.add("tbody");
            s.jsset.add("td");
            s.jsset.add("textarea");
            s.jsset.add("time");
            s.jsset.add("tfoot");
            s.jsset.add("th");
            s.jsset.add("thead");
            s.jsset.add("tr");
            s.jsset.add("tt");
            s.jsset.add("u");
            s.jsset.add("ul");
            s.jsset.add("var");
            s.jsset.add("video");
            return s;
        })();
        mathml_elements = (function(){
            var s = _$rapyd$_set();
            s.jsset.add("maction");
            s.jsset.add("math");
            s.jsset.add("merror");
            s.jsset.add("mfrac");
            s.jsset.add("mi");
            s.jsset.add("mmultiscripts");
            s.jsset.add("mn");
            s.jsset.add("mo");
            s.jsset.add("mover");
            s.jsset.add("mpadded");
            s.jsset.add("mphantom");
            s.jsset.add("mprescripts");
            s.jsset.add("mroot");
            s.jsset.add("mrow");
            s.jsset.add("mspace");
            s.jsset.add("msqrt");
            s.jsset.add("mstyle");
            s.jsset.add("msub");
            s.jsset.add("msubsup");
            s.jsset.add("msup");
            s.jsset.add("mtable");
            s.jsset.add("mtd");
            s.jsset.add("mtext");
            s.jsset.add("mtr");
            s.jsset.add("munder");
            s.jsset.add("munderover");
            s.jsset.add("none");
            return s;
        })();
        svg_elements = (function(){
            var s = _$rapyd$_set();
            s.jsset.add("a");
            s.jsset.add("animate");
            s.jsset.add("animateColor");
            s.jsset.add("animateMotion");
            s.jsset.add("animateTransform");
            s.jsset.add("clipPath");
            s.jsset.add("circle");
            s.jsset.add("defs");
            s.jsset.add("desc");
            s.jsset.add("ellipse");
            s.jsset.add("font-face");
            s.jsset.add("font-face-name");
            s.jsset.add("font-face-src");
            s.jsset.add("g");
            s.jsset.add("glyph");
            s.jsset.add("hkern");
            s.jsset.add("linearGradient");
            s.jsset.add("line");
            s.jsset.add("marker");
            s.jsset.add("metadata");
            s.jsset.add("missing-glyph");
            s.jsset.add("mpath");
            s.jsset.add("path");
            s.jsset.add("polygon");
            s.jsset.add("polyline");
            s.jsset.add("radialGradient");
            s.jsset.add("rect");
            s.jsset.add("set");
            s.jsset.add("stop");
            s.jsset.add("svg");
            s.jsset.add("switch");
            s.jsset.add("text");
            s.jsset.add("title");
            s.jsset.add("tspan");
            s.jsset.add("use");
            return s;
        })();
        html5_tags = html_elements.union(mathml_elements).union(svg_elements);
        function _dummy_create_element(name) {
            return {
                "name": name,
                "children": _$rapyd$_list_decorate([]),
                "attributes": {},
                "setAttribute": function(name, val) {
                    this.attributes[name] = val;
                },
                "appendChild": function(child) {
                    this.children.push(child);
                }
            };
        }
        function _dummy_create_text(value) {
            return value;
        }
        if (typeof document === "undefined") {
            create_element = _dummy_create_element;
            create_text_node = _dummy_create_text;
        } else {
            create_element = function(name) {
                return document.createElement(name);
            };
            create_text_node = function(val) {
                return document.createTextNode(val);
            };
        }
        function E() {
            var tag = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) ? undefined : arguments[0];
            var kwargs = arguments[arguments.length-1];
            if (kwargs === null || typeof kwargs !== "object" || kwargs [_$rapyd$_kwargs_symbol] !== true) kwargs = {};
            var args = Array.prototype.slice.call(arguments, 1 );
            if (kwargs !== null && typeof kwargs === "object" && kwargs [_$rapyd$_kwargs_symbol] === true) args .pop();
            var ans, vattr, attr, arg;
            ans = create_element(tag);
            var _$rapyd$_Iter0 = _$rapyd$_Iterable(kwargs);
            for (var _$rapyd$_Index0 = 0; _$rapyd$_Index0 < _$rapyd$_Iter0.length; _$rapyd$_Index0++) {
                attr = _$rapyd$_Iter0[_$rapyd$_Index0];
                vattr = str.replace(str.rstrip(attr, "_"), "_", "-");
                ans.setAttribute(vattr, kwargs[attr]);
            }
            var _$rapyd$_Iter1 = _$rapyd$_Iterable(args);
            for (var _$rapyd$_Index1 = 0; _$rapyd$_Index1 < _$rapyd$_Iter1.length; _$rapyd$_Index1++) {
                arg = _$rapyd$_Iter1[_$rapyd$_Index1];
                if (typeof arg === "string") {
                    ans.appendChild(create_text_node(arg));
                } else {
                    ans.appendChild(arg);
                }
            }
            return ans;
        }
        function bind_e(tag) {
            return function() {
                var kwargs = arguments[arguments.length-1];
                if (kwargs === null || typeof kwargs !== "object" || kwargs [_$rapyd$_kwargs_symbol] !== true) kwargs = {};
                var args = Array.prototype.slice.call(arguments, 0 );
                if (kwargs !== null && typeof kwargs === "object" && kwargs [_$rapyd$_kwargs_symbol] === true) args .pop();
                return E.apply(this, [tag].concat(args).concat([_$rapyd$_desugar_kwargs(kwargs)]));
            };
        }
        var _$rapyd$_Iter2 = _$rapyd$_Iterable(html5_tags);
        for (var _$rapyd$_Index2 = 0; _$rapyd$_Index2 < _$rapyd$_Iter2.length; _$rapyd$_Index2++) {
            tag = _$rapyd$_Iter2[_$rapyd$_Index2];
            Object.defineProperty(E, tag, {
                "value": bind_e(tag)
            });
        }
        _$rapyd$_modules["elementmaker"]["html_elements"] = html_elements;

        _$rapyd$_modules["elementmaker"]["mathml_elements"] = mathml_elements;

        _$rapyd$_modules["elementmaker"]["svg_elements"] = svg_elements;

        _$rapyd$_modules["elementmaker"]["html5_tags"] = html5_tags;

        _$rapyd$_modules["elementmaker"]["create_element"] = create_element;

        _$rapyd$_modules["elementmaker"]["create_text_node"] = create_text_node;

        _$rapyd$_modules["elementmaker"]["tag"] = tag;

        _$rapyd$_modules["elementmaker"]["_dummy_create_element"] = _dummy_create_element;

        _$rapyd$_modules["elementmaker"]["_dummy_create_text"] = _dummy_create_text;

        _$rapyd$_modules["elementmaker"]["E"] = E;

        _$rapyd$_modules["elementmaker"]["bind_e"] = bind_e;
    })();

    (function(){
        var __name__ = "session";
        var defaults, session_storage;
        var ajax_send = _$rapyd$_modules["ajax"].ajax_send;
        
        defaults = {
            "view_mode": "cover_grid",
            "sort": "timestamp.desc",
            "partition_method": "first letter",
            "collapse_at": 25,
            "dont_collapse": "",
            "sort_tags_by": "name"
        };
        function storage_available(which) {
            var storage, x;
            which = which || "localStorage";
            try {
                storage = window[which];
                x = "__storage__test__";
                storage.setItem(x, x);
                storage.removeItem(x);
                return true;
            } catch (_$rapyd$_Exception) {
                return false;
            }
        }
        session_storage = null;
        function FakeStorage() {
            FakeStorage.prototype.__init__.apply(this, arguments);
        }
        FakeStorage.prototype.__init__ = function __init__() {
            var self = this;
            self.data = {};
        };
        FakeStorage.prototype.getItem = function getItem(key) {
            var self = this;
            return self.data[key];
        };
        FakeStorage.prototype.setItem = function setItem(key, value) {
            var self = this;
            if (typeof value !== "string") {
                value = JSON.stringify(value);
            }
            self.data[key] = value;
        };
        FakeStorage.prototype.clear = function clear() {
            var self = this;
            self.data = {};
        };

        function get_session_storage() {
            if (session_storage === null) {
                if (storage_available("localStorage")) {
                    session_storage = window.localStorage;
                } else if (storage_available("sessionStorage")) {
                    session_storage = window.sessionStorage;
                    console.error("localStorage not available using sessionStorage instead");
                } else {
                    session_storage = new FakeStorage();
                    console.error("sessionStorage and localStorage not available using a temp cache instead");
                }
            }
            return session_storage;
        }
        function SessionData() {
            SessionData.prototype.__init__.apply(this, arguments);
        }
        SessionData.prototype.__init__ = function __init__() {
            var self = this;
            self.storage = get_session_storage();
            self.overflow_storage = {};
            self.has_overflow = false;
        };
        SessionData.prototype.get = function get(key, defval) {
            var self = this;
            var ans;
            key = self.global_prefix + key;
            if (self.has_overflow) {
                ans = self.overflow_storage[key];
                if (ans === undefined) {
                    ans = self.storage.getItem(key);
                }
            } else {
                ans = self.storage.getItem(key);
            }
            if (ans === undefined || ans === null) {
                if (defval === undefined) {
                    defval = null;
                }
                return defval;
            }
            return JSON.parse(ans);
        };
        SessionData.prototype.set = function set(key, value) {
            var self = this;
            key = self.global_prefix + key;
            if (value === null) {
                self.storage.removeItem(key);
                delete self.overflow_storage[key];
                return true;
            }
            value = JSON.stringify(value);
            try {
                self.storage.setItem(key, value);
                delete self.overflow_storage[key];
                return true;
            } catch (_$rapyd$_Exception) {
                self.overflow_storage[key] = value;
                self.has_overflow = true;
                console.error("session storage has overflowed, using a temp cache instead");
            }
            return false;
        };
        SessionData.prototype.clear = function clear() {
            var self = this;
            self.storage.clear();
            self.overflow_storage = {};
            self.has_overflow = false;
        };
        SessionData.prototype.global_prefix = "calibre-";

        function UserSessionData() {
            UserSessionData.prototype.__init__.apply(this, arguments);
        }
        _$rapyd$_extends(UserSessionData, SessionData);
        UserSessionData.prototype.__init__ = function __init__(username, saved_data) {
            var self = this;
            var key;
            self.prefix = (username || "") + "-";
            self.has_user = bool(username);
            self.username = username;
            SessionData.prototype.constructor.call(self);
            self.echo_changes = false;
            self.changes = {};
            self.has_changes = false;
            self.push_timer_id = null;
            if (saved_data) {
                var _$rapyd$_Iter0 = _$rapyd$_Iterable(saved_data);
                for (var _$rapyd$_Index0 = 0; _$rapyd$_Index0 < _$rapyd$_Iter0.length; _$rapyd$_Index0++) {
                    key = _$rapyd$_Iter0[_$rapyd$_Index0];
                    self.set(key, saved_data[key]);
                }
            }
            self.echo_changes = true;
        };
        UserSessionData.prototype.get = function get(key, defval) {
            var self = this;
            if (defval === undefined) {
                defval = defaults[key];
            }
            return SessionData.prototype.get.call(self, self.prefix + key, defval);
        };
        UserSessionData.prototype.set = function set(key, value) {
            var self = this;
            if (self.echo_changes && self.has_user) {
                self.changes[key] = value;
                self.has_changes = true;
                if (self.push_timer_id !== null) {
                    clearTimeout(self.push_timer_id);
                }
                self.push_timer_id = setTimeout(self.push_to_server.bind(self), 1e3);
            }
            return SessionData.prototype.set.call(self, self.prefix + key, value);
        };
        UserSessionData.prototype.push_to_server = function push_to_server() {
            var self = this;
            if (self.has_changes) {
                ajax_send("interface-data/set-session-data", self.changes, function(end_type, xhr, ev) {
                    if (end_type !== "load") {
                        console.error("Failed to send session data to server: " + xhr.error_html);
                    }
                });
                self.changes = {};
                self.has_changes = false;
            }
        };

        _$rapyd$_modules["session"]["defaults"] = defaults;

        _$rapyd$_modules["session"]["session_storage"] = session_storage;

        _$rapyd$_modules["session"]["storage_available"] = storage_available;

        _$rapyd$_modules["session"]["FakeStorage"] = FakeStorage;

        _$rapyd$_modules["session"]["get_session_storage"] = get_session_storage;

        _$rapyd$_modules["session"]["SessionData"] = SessionData;

        _$rapyd$_modules["session"]["UserSessionData"] = UserSessionData;
    })();

    (function(){
        var __name__ = "utils";
        function debounce() {
            var func = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) ? undefined : arguments[0];
            var wait = ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) ? undefined : arguments[1];
            var immediate = (arguments[2] === undefined || ( 2 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (false) : arguments[2];
            var _$rapyd$_kwargs_obj = arguments[arguments.length-1];
            if (_$rapyd$_kwargs_obj === null || typeof _$rapyd$_kwargs_obj !== "object" || _$rapyd$_kwargs_obj [_$rapyd$_kwargs_symbol] !== true) _$rapyd$_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "immediate")){
                immediate = _$rapyd$_kwargs_obj.immediate;
            }
            var timeout;
            timeout = null;
            return function debounce_inner() {
                var _$rapyd$_unpack, context, args, call_now;
                _$rapyd$_unpack = [this, arguments];
                context = _$rapyd$_unpack[0];
                args = _$rapyd$_unpack[1];
                function later() {
                    timeout = null;
                    if (!immediate) {
                        func.apply(context, args);
                    }
                }
                call_now = immediate && !timeout;
                window.clearTimeout(timeout);
                timeout = window.setTimeout(later, wait);
                if (call_now) {
                    func.apply(context, args);
                }
            };
        }
        function to_utf8(string) {
            var escstr, binstr, ua;
            if (typeof TextEncoder === "function") {
                return new TextEncoder("utf-8").encode(string);
            }
            escstr = encodeURIComponent(string);
            binstr = escstr.replace(/%([0-9A-F]{2})/g, function(match, p1) {
                return String.fromCharCode("0x" + p1);
            });
            ua = new Uint8Array(binstr.length);
            Array.prototype.forEach.call(binstr, function(ch, i) {
                ua[i] = ch.charCodeAt(0);
            });
            return ua;
        }
        function parse_url_params() {
            var url = (arguments[0] === undefined || ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (null) : arguments[0];
            var allow_multiple = (arguments[1] === undefined || ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (false) : arguments[1];
            var _$rapyd$_kwargs_obj = arguments[arguments.length-1];
            if (_$rapyd$_kwargs_obj === null || typeof _$rapyd$_kwargs_obj !== "object" || _$rapyd$_kwargs_obj [_$rapyd$_kwargs_symbol] !== true) _$rapyd$_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "url")){
                url = _$rapyd$_kwargs_obj.url;
            }
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "allow_multiple")){
                allow_multiple = _$rapyd$_kwargs_obj.allow_multiple;
            }
            var qs, ans, q, pairs, _$rapyd$_unpack, key, val, pair;
            url = url || window.location.href;
            qs = url.indexOf("?");
            ans = {};
            if (qs < 0) {
                return ans;
            }
            q = url.slice(qs + 1, url.indexOf("#") + 1 || url.length + 1);
            if (!q) {
                return ans;
            }
            pairs = q.replace(/\+/g, " ").split("&");
            var _$rapyd$_Iter0 = _$rapyd$_Iterable(pairs);
            for (var _$rapyd$_Index0 = 0; _$rapyd$_Index0 < _$rapyd$_Iter0.length; _$rapyd$_Index0++) {
                pair = _$rapyd$_Iter0[_$rapyd$_Index0];
                _$rapyd$_unpack = _$rapyd$_eslice(str.partition(pair, "="), 2);
                key = _$rapyd$_unpack[0];
                val = _$rapyd$_unpack[1];
                _$rapyd$_unpack = [decodeURIComponent(key), decodeURIComponent(val)];
                key = _$rapyd$_unpack[0];
                val = _$rapyd$_unpack[1];
                if (allow_multiple) {
                    if (!Object.prototype.hasOwnProperty.call(ans, key)) {
                        ans[key] = _$rapyd$_list_decorate([]);
                    }
                    ans[key].append(val);
                } else {
                    ans[key] = val;
                }
            }
            return ans;
        }
        _$rapyd$_modules["utils"]["debounce"] = debounce;

        _$rapyd$_modules["utils"]["to_utf8"] = to_utf8;

        _$rapyd$_modules["utils"]["parse_url_params"] = parse_url_params;
    })();

    (function(){
        var __name__ = "book_list";
        _$rapyd$_modules["book_list"]["theme"] = _$rapyd$_modules["book_list.theme"];
        _$rapyd$_modules["book_list"]["globals"] = _$rapyd$_modules["book_list.globals"];
        _$rapyd$_modules["book_list"]["search"] = _$rapyd$_modules["book_list.search"];
        _$rapyd$_modules["book_list"]["top_bar"] = _$rapyd$_modules["book_list.top_bar"];
        _$rapyd$_modules["book_list"]["views"] = _$rapyd$_modules["book_list.views"];
        _$rapyd$_modules["book_list"]["item_list"] = _$rapyd$_modules["book_list.item_list"];
        _$rapyd$_modules["book_list"]["ui"] = _$rapyd$_modules["book_list.ui"];
        _$rapyd$_modules["book_list"]["boss"] = _$rapyd$_modules["book_list.boss"];
    })();

    (function(){
        var __name__ = "dom";
        var simple_vendor_prefixes;
        simple_vendor_prefixes = {
            "animation": ['webkit', 'moz', 'o'],
            "animation-name": ['webkit', 'moz', 'o'],
            "animation-duration": ['webkit', 'moz', 'o'],
            "animation-timing-function": ['webkit', 'moz', 'o'],
            "animation-delay": ['webkit', 'moz', 'o'],
            "animation-iteration-count": ['webkit', 'moz', 'o'],
            "animation-direction": ['webkit', 'moz', 'o'],
            "animation-fill-mode": ['webkit', 'moz', 'o'],
            "animation-play-state": ['webkit', 'moz', 'o'],
            "transform": ['webkit', 'ms', 'moz', 'o'],
            "transition": ['webkit', 'moz', 'o'],
            "filter": ['webkit'],
            "user-select": ['webkit', 'moz', 'ms']
        };
        function set_css() {
            var elem = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) ? undefined : arguments[0];
            var kw = arguments[arguments.length-1];
            if (kw === null || typeof kw !== "object" || kw [_$rapyd$_kwargs_symbol] !== true) kw = {};
            var s, _$rapyd$_unpack, name, val, prefixes, prefix, prop;
            s = elem.style;
            if (s) {
                var _$rapyd$_Iter0 = _$rapyd$_Iterable(kw);
                for (var _$rapyd$_Index0 = 0; _$rapyd$_Index0 < _$rapyd$_Iter0.length; _$rapyd$_Index0++) {
                    prop = _$rapyd$_Iter0[_$rapyd$_Index0];
                    _$rapyd$_unpack = [str.replace(str.rstrip(prop, "_"), "_", "-"), kw[prop]];
                    name = _$rapyd$_unpack[0];
                    val = _$rapyd$_unpack[1];
                    if (val === null || val === undefined) {
                        s.removeProperty(name);
                    } else {
                        s.setProperty(name, val);
                    }
                    prefixes = simple_vendor_prefixes[name];
                    if (prefixes) {
                        var _$rapyd$_Iter1 = _$rapyd$_Iterable(prefixes);
                        for (var _$rapyd$_Index1 = 0; _$rapyd$_Index1 < _$rapyd$_Iter1.length; _$rapyd$_Index1++) {
                            prefix = _$rapyd$_Iter1[_$rapyd$_Index1];
                            if (val === null || val === undefined) {
                                s.removeProperty("-" + prefix + "-" + name);
                            } else {
                                s.setProperty("-" + prefix + "-" + name, val);
                            }
                        }
                    }
                }
            }
        }
        function build_rule() {
            var selector = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) ? undefined : arguments[0];
            var kw = arguments[arguments.length-1];
            if (kw === null || typeof kw !== "object" || kw [_$rapyd$_kwargs_symbol] !== true) kw = {};
            var ans, _$rapyd$_unpack, name, val, prefixes, prefix, prop;
            ans = [selector + " { "];
            var _$rapyd$_Iter2 = _$rapyd$_Iterable(kw);
            for (var _$rapyd$_Index2 = 0; _$rapyd$_Index2 < _$rapyd$_Iter2.length; _$rapyd$_Index2++) {
                prop = _$rapyd$_Iter2[_$rapyd$_Index2];
                _$rapyd$_unpack = [str.replace(str.rstrip(prop, "_"), "_", "-"), kw[prop]];
                name = _$rapyd$_unpack[0];
                val = _$rapyd$_unpack[1];
                ans.push(name + ":" + val + ";");
                prefixes = simple_vendor_prefixes[name];
                if (prefixes) {
                    var _$rapyd$_Iter3 = _$rapyd$_Iterable(prefixes);
                    for (var _$rapyd$_Index3 = 0; _$rapyd$_Index3 < _$rapyd$_Iter3.length; _$rapyd$_Index3++) {
                        prefix = _$rapyd$_Iter3[_$rapyd$_Index3];
                        ans.push("-" + prefix + "-" + name + ":" + val + ";");
                    }
                }
            }
            ans.push("}");
            return ans.join("\n") + "\n";
        }
        function clear() {
            var nodes = Array.prototype.slice.call(arguments, 0 );
            if (arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) nodes .pop();
            var node;
            var _$rapyd$_Iter4 = _$rapyd$_Iterable(nodes);
            for (var _$rapyd$_Index4 = 0; _$rapyd$_Index4 < _$rapyd$_Iter4.length; _$rapyd$_Index4++) {
                node = _$rapyd$_Iter4[_$rapyd$_Index4];
                while (node.firstChild) {
                    node.removeChild(node.firstChild);
                }
            }
        }
        function create_keyframes() {
            var animation_name = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) ? undefined : arguments[0];
            var frames = Array.prototype.slice.call(arguments, 1 );
            if (arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) frames .pop();
            var ans, frame, prefix;
            ans = [];
            var _$rapyd$_Iter5 = _$rapyd$_Iterable(_$rapyd$_list_decorate([ "-webkit-", "-moz-", "-o-", "" ]));
            for (var _$rapyd$_Index5 = 0; _$rapyd$_Index5 < _$rapyd$_Iter5.length; _$rapyd$_Index5++) {
                prefix = _$rapyd$_Iter5[_$rapyd$_Index5];
                ans.push("@" + prefix + "keyframes " + animation_name + " {");
                var _$rapyd$_Iter6 = _$rapyd$_Iterable(frames);
                for (var _$rapyd$_Index6 = 0; _$rapyd$_Index6 < _$rapyd$_Iter6.length; _$rapyd$_Index6++) {
                    frame = _$rapyd$_Iter6[_$rapyd$_Index6];
                    ans.push(frame);
                }
                ans.push("}");
            }
            return ans.join("\n") + "\n";
        }
        _$rapyd$_modules["dom"]["simple_vendor_prefixes"] = simple_vendor_prefixes;

        _$rapyd$_modules["dom"]["set_css"] = set_css;

        _$rapyd$_modules["dom"]["build_rule"] = build_rule;

        _$rapyd$_modules["dom"]["clear"] = clear;

        _$rapyd$_modules["dom"]["create_keyframes"] = create_keyframes;
    })();

    (function(){
        var __name__ = "book_list.theme";
        var DARK, LIGHT, LIGHT_GRADIENT;
        DARK = "#39322B";
        LIGHT = "#F6F3E9";
        LIGHT_GRADIENT = "linear-gradient(to bottom, " + LIGHT + ", #b6b3a8)";
        function get_color(name) {
            return {
                "window-background": LIGHT,
                "window-foreground": DARK,
                "bar-background": DARK,
                "bar-foreground": LIGHT,
                "bar-highlight": "yellow",
                "heart": "#B92111",
                "list-hover-background": DARK,
                "list-hover-foreground": LIGHT,
                "button-start": DARK,
                "button-end": "#49423B",
                "button-text": LIGHT,
                "dialog-background": LIGHT,
                "dialog-background-image": LIGHT_GRADIENT,
                "dialog-foreground": DARK
            }[name];
        }
        function get_font_size(name) {
            return {
                "title": "1.4rem",
                "item-list-title": "1.2rem",
                "item-list-subtitle": "0.8 rem"
            }[name];
        }
        _$rapyd$_modules["book_list.theme"]["DARK"] = DARK;

        _$rapyd$_modules["book_list.theme"]["LIGHT"] = LIGHT;

        _$rapyd$_modules["book_list.theme"]["LIGHT_GRADIENT"] = LIGHT_GRADIENT;

        _$rapyd$_modules["book_list.theme"]["get_color"] = get_color;

        _$rapyd$_modules["book_list.theme"]["get_font_size"] = get_font_size;
    })();

    (function(){
        var __name__ = "modals";
        var modal_container, modal_count;
        var ajax = _$rapyd$_modules["ajax"].ajax;
        var ajax_send = _$rapyd$_modules["ajax"].ajax_send;
        
        var E = _$rapyd$_modules["elementmaker"].E;
        
        var set_css = _$rapyd$_modules["dom"].set_css;
        var clear = _$rapyd$_modules["dom"].clear;
        var build_rule = _$rapyd$_modules["dom"].build_rule;
        
        var _ = _$rapyd$_modules["gettext"].gettext;
        
        var get_color = _$rapyd$_modules["book_list.theme"].get_color;
        var get_font_size = _$rapyd$_modules["book_list.theme"].get_font_size;
        
        modal_container = null;
        modal_count = 0;
        function Modal() {
            Modal.prototype.__init__.apply(this, arguments);
        }
        Modal.prototype.__init__ = function __init__(create_func, on_close, show_close) {
            var self = this;
            var _$rapyd$_unpack;
            _$rapyd$_unpack = [create_func, on_close, show_close];
            self.create_func = _$rapyd$_unpack[0];
            self.on_close = _$rapyd$_unpack[1];
            self.show_close = _$rapyd$_unpack[2];
            modal_count += 1;
            self.id = modal_count;
        };

        function ModalContainer() {
            Object.defineProperties(this,  {
                "modal_container": {
                    "enumerable": true, 
                    "get": function modal_container() {
                        var self = this;
                        return document.getElementById("modal-container");
                    }, 
                    "set": function () { throw new AttributeError("can't set attribute") }
                }, 
            });
            ModalContainer.prototype.__init__.apply(this, arguments);
        }
        ModalContainer.prototype.__init__ = function __init__() {
            var self = this;
            var div;
            div = E.div(E.div(E.div(), E.a(E.i(_$rapyd$_desugar_kwargs({class_: "fa fa-close", style: "vertical-align:bottom;"})), _$rapyd$_desugar_kwargs({title: _("Close")}))), E.style(build_rule("#modal-container > div > a:hover", _$rapyd$_desugar_kwargs({color: get_color("dialog-foreground") + " !important", background_color: get_color("dialog-background") + " !important"})) + build_rule("#modal-container a.dialog-simple-link:hover", _$rapyd$_desugar_kwargs({color: "red !important"}))), _$rapyd$_desugar_kwargs({id: "modal-container"}));
            document.body.appendChild(div);
            set_css(div, _$rapyd$_desugar_kwargs({position: "fixed", top: "0", right: "0", bottom: "0", left: "0", background_color: "rgba(0,0,0,0.8)", z_index: "1000", display: "none", text_align: "center", user_select: "none"}));
            set_css(div.firstChild, get_color("dialog-background"), get_color("dialog-background2"), _$rapyd$_desugar_kwargs({position: "relative", display: "inline-block", top: "50vh", transform: "translateY(-50%)", min_width: "25vw", max_width: "75vw", border_radius: "1em", padding: "1em 2em", margin_right: "1em", margin_left: "1em", background: get_color("dialog-background"), color: get_color("dialog-foreground"), background_image: get_color("dialog-background-image")}));
            set_css(div.firstChild.lastChild, _$rapyd$_desugar_kwargs({font_size: "1.5em", line_height: "100%", cursor: "pointer", position: "absolute", right: "-0.5em", top: "-0.5em", width: "1em", height: "1em", background_color: get_color("window-foreground"), color: get_color("window-background"), display: "inline-box", border_radius: "50%", padding: "4px", text_align: "center", box_shadow: "1px 1px 3px black"}));
            div.firstChild.lastChild.addEventListener("click", function(event) {
                [event.preventDefault(), self.close_current_modal(event)];
            });
            set_css(div.firstChild.firstChild, _$rapyd$_desugar_kwargs({user_select: "text", max_height: "60vh", overflow: "auto"}));
            self.modals = [];
            self.current_modal = null;
            self.hide = self.close_current_modal.bind(self);
        };
        ModalContainer.prototype.show_modal = function show_modal() {
            var self = this;
            var create_func = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) ? undefined : arguments[0];
            var on_close = (arguments[1] === undefined || ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (null) : arguments[1];
            var show_close = (arguments[2] === undefined || ( 2 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (true) : arguments[2];
            var _$rapyd$_kwargs_obj = arguments[arguments.length-1];
            if (_$rapyd$_kwargs_obj === null || typeof _$rapyd$_kwargs_obj !== "object" || _$rapyd$_kwargs_obj [_$rapyd$_kwargs_symbol] !== true) _$rapyd$_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "on_close")){
                on_close = _$rapyd$_kwargs_obj.on_close;
            }
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "show_close")){
                show_close = _$rapyd$_kwargs_obj.show_close;
            }
            var modal_id;
            self.modals.push(new Modal(create_func, on_close, show_close));
            modal_id = self.modals[self.modals.length-1].id;
            self.update();
            return modal_id;
        };
        ModalContainer.prototype.hide_modal = function hide_modal(modal_id) {
            var self = this;
            var doomed_modal, _$rapyd$_unpack, i, modal;
            if (self.current_modal !== null && self.current_modal.id === modal_id) {
                self.clear_current_modal();
            } else {
                doomed_modal = null;
                var _$rapyd$_Iter0 = _$rapyd$_Iterable(enumerate(self.modals));
                for (var _$rapyd$_Index0 = 0; _$rapyd$_Index0 < _$rapyd$_Iter0.length; _$rapyd$_Index0++) {
                    _$rapyd$_unpack = _$rapyd$_Iter0[_$rapyd$_Index0];
                    i = _$rapyd$_unpack[0];
                    modal = _$rapyd$_unpack[1];
                    if (modal.id === modal_id) {
                        doomed_modal = i;
                        break;
                    }
                }
                if (doomed_modal !== null) {
                    self.modals.splice(doomed_modal, 1);
                }
            }
        };
        ModalContainer.prototype.update = function update() {
            var self = this;
            var c;
            if (self.current_modal === null && self.modals) {
                self.current_modal = self.modals.shift();
                c = self.modal_container;
                try {
                    self.current_modal.create_func(c.firstChild.firstChild, self.hide);
                } catch (_$rapyd$_Exception) {
                    self.current_modal = null;
                    throw _$rapyd$_Exception;
                }
                if (c.style.display === "none") {
                    set_css(c, _$rapyd$_desugar_kwargs({display: "block"}));
                }
                c.firstChild.lastChild.style.visibility = (self.current_modal.show_close) ? "visible" : "hidden";
            }
        };
        ModalContainer.prototype.clear_current_modal = function clear_current_modal() {
            var self = this;
            var c;
            self.current_modal = null;
            c = self.modal_container;
            clear(c.firstChild.firstChild);
            if (self.modals.length === 0) {
                set_css(c, _$rapyd$_desugar_kwargs({display: "none"}));
            } else {
                self.update();
            }
        };
        ModalContainer.prototype.close_current_modal = function close_current_modal(event) {
            var self = this;
            if (self.current_modal !== null) {
                if (self.current_modal.on_close !== null && self.current_modal.on_close(event) === true) {
                    return;
                }
                self.clear_current_modal();
            }
        };
        

        function create_simple_dialog(title, msg, details, icon_name, prefix) {
            details = details || "";
            function create_func(parent) {
                var show_details, is_html_msg, html_container;
                show_details = E.a(_("Show details"), _$rapyd$_desugar_kwargs({class_: "dialog-simple-link", style: "cursor:pointer; color: blue; padding-top:1em; display:inline-block; margin-left: auto"}));
                show_details.addEventListener("click", function() {
                    show_details.style.display = "none";
                    show_details.nextSibling.style.display = "block";
                });
                is_html_msg = /<[a-zA-Z]/.test(msg);
                html_container = E.div();
                if (is_html_msg) {
                    html_container.innerHTML = msg;
                }
                parent.appendChild(E.div(E.h2(E.i(_$rapyd$_desugar_kwargs({class_: "fa fa-lg fa-" + icon_name, style: "color:red"})), E.span(" " + prefix + " ", _$rapyd$_desugar_kwargs({style: "font-variant:small-caps"})), title, _$rapyd$_desugar_kwargs({style: "font-weight: bold; font-size: " + get_font_size("title")})), E.div((is_html_msg) ? html_container : msg, _$rapyd$_desugar_kwargs({style: "padding-top: 1em; margin-top: 1em; border-top: 1px solid currentColor"})), E.div(show_details, E.div(details, _$rapyd$_desugar_kwargs({style: "display:none; white-space:pre-wrap; font-size: smaller; margin-top: 1em; border-top: solid 1px currentColor; padding-top: 1em"})), _$rapyd$_desugar_kwargs({style: "display: " + ((details) ? "block" : "none")})), _$rapyd$_desugar_kwargs({style: "max-width:60em; text-align: left"})));
            }
            show_modal(create_func);
        }
        function create_progress_dialog(msg, on_close) {
            var _$rapyd$_unpack, pbar, msg_div, show_close, modal_id;
            msg = msg || _("Loading, please wait...");
            _$rapyd$_unpack = [E.progress(_$rapyd$_desugar_kwargs({style: "display:inline-block"})), 
            E.div(msg, _$rapyd$_desugar_kwargs({style: "text-align:center; padding-top:1ex"}))];
            pbar = _$rapyd$_unpack[0];
            msg_div = _$rapyd$_unpack[1];
            function create_func(parent) {
                parent.appendChild(E.div(pbar, msg_div, _$rapyd$_desugar_kwargs({style: "text-align: center"})));
            }
            show_close = on_close !== null;
            modal_id = show_modal(create_func, on_close, show_close);
            return {
                "close": function() {
                    modal_container.hide_modal(modal_id);
                },
                "update_progress": function(amount, total) {
                    var _$rapyd$_unpack;
                    _$rapyd$_unpack = [total, amount];
                    pbar.max = _$rapyd$_unpack[0];
                    pbar.value = _$rapyd$_unpack[1];
                },
                "set_msg": function(new_msg) {
                    msg_div.innerHTML = new_msg;
                }
            };
        }
        function create_modal_container() {
            if (modal_container === null) {
                modal_container = new ModalContainer();
            }
            return modal_container;
        }
        function show_modal() {
            var create_func = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) ? undefined : arguments[0];
            var on_close = (arguments[1] === undefined || ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (null) : arguments[1];
            var show_close = (arguments[2] === undefined || ( 2 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (true) : arguments[2];
            var _$rapyd$_kwargs_obj = arguments[arguments.length-1];
            if (_$rapyd$_kwargs_obj === null || typeof _$rapyd$_kwargs_obj !== "object" || _$rapyd$_kwargs_obj [_$rapyd$_kwargs_symbol] !== true) _$rapyd$_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "on_close")){
                on_close = _$rapyd$_kwargs_obj.on_close;
            }
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "show_close")){
                show_close = _$rapyd$_kwargs_obj.show_close;
            }
            return modal_container.show_modal(create_func, on_close, show_close);
        }
        function error_dialog() {
            var title = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) ? undefined : arguments[0];
            var msg = ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) ? undefined : arguments[1];
            var details = (arguments[2] === undefined || ( 2 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (null) : arguments[2];
            var _$rapyd$_kwargs_obj = arguments[arguments.length-1];
            if (_$rapyd$_kwargs_obj === null || typeof _$rapyd$_kwargs_obj !== "object" || _$rapyd$_kwargs_obj [_$rapyd$_kwargs_symbol] !== true) _$rapyd$_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "details")){
                details = _$rapyd$_kwargs_obj.details;
            }
            create_simple_dialog(title, msg, details, "bug", _("Error:"));
        }
        function warning_dialog() {
            var title = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) ? undefined : arguments[0];
            var msg = ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) ? undefined : arguments[1];
            var details = (arguments[2] === undefined || ( 2 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (null) : arguments[2];
            var _$rapyd$_kwargs_obj = arguments[arguments.length-1];
            if (_$rapyd$_kwargs_obj === null || typeof _$rapyd$_kwargs_obj !== "object" || _$rapyd$_kwargs_obj [_$rapyd$_kwargs_symbol] !== true) _$rapyd$_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "details")){
                details = _$rapyd$_kwargs_obj.details;
            }
            create_simple_dialog(title, msg, details, "warning", _("Warning:"));
        }
        function progress_dialog() {
            var msg = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) ? undefined : arguments[0];
            var on_close = (arguments[1] === undefined || ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (null) : arguments[1];
            var _$rapyd$_kwargs_obj = arguments[arguments.length-1];
            if (_$rapyd$_kwargs_obj === null || typeof _$rapyd$_kwargs_obj !== "object" || _$rapyd$_kwargs_obj [_$rapyd$_kwargs_symbol] !== true) _$rapyd$_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "on_close")){
                on_close = _$rapyd$_kwargs_obj.on_close;
            }
            return create_progress_dialog(msg, on_close);
        }
        function ajax_progress_dialog() {
            var path = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) ? undefined : arguments[0];
            var on_complete = ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) ? undefined : arguments[1];
            var msg = ( 2 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) ? undefined : arguments[2];
            var kw = arguments[arguments.length-1];
            if (kw === null || typeof kw !== "object" || kw [_$rapyd$_kwargs_symbol] !== true) kw = {};
            var pd, xhr;
            pd = null;
            function on_complete_callback(event_type, xhr, ev) {
                pd.close();
                pd = undefined;
                return on_complete(event_type, xhr, ev);
            }
            function on_progress_callback(loaded, total, xhr) {
                pd.update_progress(loaded, total);
            }
            xhr = ajax.apply(this, [path, on_complete_callback].concat([_$rapyd$_desugar_kwargs(kw, {on_progress: on_progress_callback})]));
            pd = progress_dialog(msg, xhr.abort.bind(xhr));
            xhr.send();
            return [xhr, pd];
        }
        function ajax_send_progress_dialog() {
            var path = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) ? undefined : arguments[0];
            var data = ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) ? undefined : arguments[1];
            var on_complete = ( 2 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) ? undefined : arguments[2];
            var msg = ( 3 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) ? undefined : arguments[3];
            var kw = arguments[arguments.length-1];
            if (kw === null || typeof kw !== "object" || kw [_$rapyd$_kwargs_symbol] !== true) kw = {};
            var pd, xhr;
            pd = null;
            function on_complete_callback(event_type, xhr, ev) {
                pd.close();
                pd = undefined;
                return on_complete(event_type, xhr, ev);
            }
            function on_progress_callback(loaded, total, xhr) {
                pd.update_progress(loaded, total);
            }
            xhr = ajax_send.apply(this, [path, data, on_complete_callback].concat([_$rapyd$_desugar_kwargs(kw, {on_progress: on_progress_callback})]));
            pd = progress_dialog(msg, xhr.abort.bind(xhr));
            return [xhr, pd];
        }
        _$rapyd$_modules["modals"]["modal_container"] = modal_container;

        _$rapyd$_modules["modals"]["modal_count"] = modal_count;

        _$rapyd$_modules["modals"]["Modal"] = Modal;

        _$rapyd$_modules["modals"]["ModalContainer"] = ModalContainer;

        _$rapyd$_modules["modals"]["create_simple_dialog"] = create_simple_dialog;

        _$rapyd$_modules["modals"]["create_progress_dialog"] = create_progress_dialog;

        _$rapyd$_modules["modals"]["create_modal_container"] = create_modal_container;

        _$rapyd$_modules["modals"]["show_modal"] = show_modal;

        _$rapyd$_modules["modals"]["error_dialog"] = error_dialog;

        _$rapyd$_modules["modals"]["warning_dialog"] = warning_dialog;

        _$rapyd$_modules["modals"]["progress_dialog"] = progress_dialog;

        _$rapyd$_modules["modals"]["ajax_progress_dialog"] = ajax_progress_dialog;

        _$rapyd$_modules["modals"]["ajax_send_progress_dialog"] = ajax_send_progress_dialog;
    })();

    (function(){
        var __name__ = "widgets";
        var BUTTON_VPADDING;
        var build_rule = _$rapyd$_modules["dom"].build_rule;
        
        var E = _$rapyd$_modules["elementmaker"].E;
        
        var get_color = _$rapyd$_modules["book_list.theme"].get_color;
        
        BUTTON_VPADDING = "0.5ex";
        function create_button() {
            var text = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) ? undefined : arguments[0];
            var icon = (arguments[1] === undefined || ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (null) : arguments[1];
            var action = (arguments[2] === undefined || ( 2 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (null) : arguments[2];
            var tooltip = (arguments[3] === undefined || ( 3 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (null) : arguments[3];
            var _$rapyd$_kwargs_obj = arguments[arguments.length-1];
            if (_$rapyd$_kwargs_obj === null || typeof _$rapyd$_kwargs_obj !== "object" || _$rapyd$_kwargs_obj [_$rapyd$_kwargs_symbol] !== true) _$rapyd$_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "icon")){
                icon = _$rapyd$_kwargs_obj.icon;
            }
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "action")){
                action = _$rapyd$_kwargs_obj.action;
            }
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "tooltip")){
                tooltip = _$rapyd$_kwargs_obj.tooltip;
            }
            var cls, ans;
            cls = "";
            if (icon) {
                cls = str.format("fa fa-{} fa-lg", icon);
                text = " " + text;
            }
            ans = E.button(E.i(_$rapyd$_desugar_kwargs({class_: cls})), text, _$rapyd$_desugar_kwargs({class_: "calibre-push-button", type: "button", title: tooltip || ""}));
            if (action !== null) {
                ans.addEventListener("click", function(event) {
                    [event.preventDefault(), action(event)];
                });
            }
            return ans;
        }
        create_button.style = build_rule("button.calibre-push-button", _$rapyd$_desugar_kwargs({border_radius: "1em", background_clip: "padding-box", background_color: get_color("button-start"), background_image: str.format("linear-gradient(to bottom, {}, {})", get_color("button-start"), get_color("button-end")), padding: BUTTON_VPADDING + " 1em", color: get_color("button-text"), cursor: "pointer", font_size: "inherit"}));
        create_button.style += build_rule("button.calibre-push-button:hover", _$rapyd$_desugar_kwargs({transform: "scale(1.2)"}));
        create_button.style += build_rule("button.calibre-push-button:active", _$rapyd$_desugar_kwargs({transform: "scale(2)"}));
        function create_spinner() {
            return E.i(_$rapyd$_desugar_kwargs({class_: "fa fa-spin fa-spinner"}));
        }
        function get_widget_css() {
            var ans;
            ans = "a, button:focus { outline: none }; a, button::-moz-focus-inner { border: 0 }\n";
            ans += create_button.style;
            return ans;
        }
        _$rapyd$_modules["widgets"]["BUTTON_VPADDING"] = BUTTON_VPADDING;

        _$rapyd$_modules["widgets"]["create_button"] = create_button;

        _$rapyd$_modules["widgets"]["create_spinner"] = create_spinner;

        _$rapyd$_modules["widgets"]["get_widget_css"] = get_widget_css;
    })();

    (function(){
        var __name__ = "book_list.globals";
        var boss, session_data;
        boss = null;
        session_data = null;
        function get_boss() {
            return boss;
        }
        function set_boss(obj) {
            boss = obj;
            return boss;
        }
        function set_session_data(sd) {
            session_data = sd;
            return session_data;
        }
        function get_session_data() {
            return session_data;
        }
        _$rapyd$_modules["book_list.globals"]["boss"] = boss;

        _$rapyd$_modules["book_list.globals"]["session_data"] = session_data;

        _$rapyd$_modules["book_list.globals"]["get_boss"] = get_boss;

        _$rapyd$_modules["book_list.globals"]["set_boss"] = set_boss;

        _$rapyd$_modules["book_list.globals"]["set_session_data"] = set_session_data;

        _$rapyd$_modules["book_list.globals"]["get_session_data"] = get_session_data;
    })();

    (function(){
        var __name__ = "book_list.search";
        var sp_counter;
        var E = _$rapyd$_modules["elementmaker"].E;
        
        var _ = _$rapyd$_modules["gettext"].gettext;
        
        var create_button = _$rapyd$_modules["widgets"].create_button;
        var BUTTON_VPADDING = _$rapyd$_modules["widgets"].BUTTON_VPADDING;
        
        var get_boss = _$rapyd$_modules["book_list.globals"].get_boss;
        
        sp_counter = 0;
        function SearchPanel() {
            Object.defineProperties(this,  {
                "container": {
                    "enumerable": true, 
                    "get": function container() {
                        var self = this;
                        return document.getElementById(self.container_id);
                    }, 
                    "set": function () { throw new AttributeError("can't set attribute") }
                }, 
                "is_visible": {
                    "enumerable": true, 
                    "get": function is_visible() {
                        var self = this;
                        self.container.style.display === "block";
                    }, 
                    "set": function is_visible(val) {
                        var self = this;
                        self.container.style.display = (val) ? "block" : "none";
                    }
                }, 
            });
            SearchPanel.prototype.__init__.apply(this, arguments);
        }
        SearchPanel.prototype.__init__ = function __init__(interface_data, book_list_container) {
            var self = this;
            var style, div, search_container;
            sp_counter += 1;
            self.container_id = "search-panel-" + sp_counter;
            self.interface_data = interface_data;
            style = "";
            div = E.div(E.style(style, _$rapyd$_desugar_kwargs({type: "text/css"})), E.div(_$rapyd$_desugar_kwargs({style: "text-align:center; padding:1ex 1em; border-bottom: solid 1px currentColor; margin-bottom: 0.5ex"})), E.div(E.div(), E.div()), _$rapyd$_desugar_kwargs({id: self.container_id, style: "display:none"}));
            book_list_container.appendChild(div);
            search_container = div.firstChild.nextSibling;
            search_container.appendChild(E.div(E.input(_$rapyd$_desugar_kwargs({type: "text", autocomplete: "on", autosave: "search", inputmode: "latin", name: "search-books", title: _("Search for books"), placeholder: _("Enter the search query"), spellcheck: "false", style: str.format("flex-grow: 10; padding: {} 0.5em; margin-right: 0.5em", BUTTON_VPADDING)})), create_button(_("Search"), _$rapyd$_desugar_kwargs({icon: "search", action: self.execute_search.bind(self), tooltip: _("Do the search")})), _$rapyd$_desugar_kwargs({style: "display: flex; width: 100%;"})));
            search_container.firstChild.firstChild.addEventListener("keypress", function(event) {
                if (event.keyCode === 13) {
                    self.execute_search();
                    [event.preventDefault(), event.stopPropagation()];
                }
            });
        };
        SearchPanel.prototype.init = function init() {
            var self = this;
            var tb;
            tb = self.container.querySelector("input[name=\"search-books\"]");
            tb.focus();
            tb.setSelectionRange(0, tb.value.length);
        };
        SearchPanel.prototype.execute_search = function execute_search() {
            var self = this;
            var text;
            text = self.container.querySelector("input[name=\"search-books\"]").value || "";
            get_boss().ui.books_view.change_search(text);
        };
        
        
        

        _$rapyd$_modules["book_list.search"]["sp_counter"] = sp_counter;

        _$rapyd$_modules["book_list.search"]["SearchPanel"] = SearchPanel;
    })();

    (function(){
        var __name__ = "book_list.top_bar";
        var bar_counter;
        var get_color = _$rapyd$_modules["book_list.theme"].get_color;
        var get_font_size = _$rapyd$_modules["book_list.theme"].get_font_size;
        
        var set_css = _$rapyd$_modules["dom"].set_css;
        var clear = _$rapyd$_modules["dom"].clear;
        var create_keyframes = _$rapyd$_modules["dom"].create_keyframes;
        var build_rule = _$rapyd$_modules["dom"].build_rule;
        
        var E = _$rapyd$_modules["elementmaker"].E;
        
        var _ = _$rapyd$_modules["gettext"].gettext;
        
        bar_counter = 0;
        function TopBar() {
            Object.defineProperties(this,  {
                "bar": {
                    "enumerable": true, 
                    "get": function bar() {
                        var self = this;
                        return document.getElementById(self.bar_id);
                    }, 
                    "set": function () { throw new AttributeError("can't set attribute") }
                }, 
                "dummy_bar": {
                    "enumerable": true, 
                    "get": function dummy_bar() {
                        var self = this;
                        return document.getElementById(self.dummy_bar_id);
                    }, 
                    "set": function () { throw new AttributeError("can't set attribute") }
                }, 
            });
            TopBar.prototype.__init__.apply(this, arguments);
        }
        TopBar.prototype.__init__ = function __init__(book_list_container) {
            var self = this;
            var _$rapyd$_unpack, style, sel, bar, bid;
            bar_counter += 1;
            self.current_left_data = {};
            _$rapyd$_unpack = ["top-bar-" + bar_counter, "dummy-top-bar-" + bar_counter];
            self.bar_id = _$rapyd$_unpack[0];
            self.dummy_bar_id = _$rapyd$_unpack[1];
            self.throbber_name = self.bar_id + "-throbber";
            style = create_keyframes(self.throbber_name, "from { transform: scale(1); } 50% { transform: scale(0.5); } to { transform: scale(1); }");
            var _$rapyd$_Iter0 = _$rapyd$_Iterable(_$rapyd$_list_decorate([ self.dummy_bar_id, self.bar_id ]));
            for (var _$rapyd$_Index0 = 0; _$rapyd$_Index0 < _$rapyd$_Iter0.length; _$rapyd$_Index0++) {
                sel = _$rapyd$_Iter0[_$rapyd$_Index0];
                sel = "#" + sel + " a";
                style += build_rule(sel, _$rapyd$_desugar_kwargs({display: "inline-block", vertical_align: "middle", overflow: "hidden", cursor: "pointer", color: get_color("bar-foreground"), background: "none", padding_top: self.VSPACING, padding_bottom: self.VSPACING}));
            }
            style += build_rule(sel + ":hover", _$rapyd$_desugar_kwargs({transform: "scale(1.5)"}));
            style += build_rule(sel + ":active", _$rapyd$_desugar_kwargs({transform: "scale(2)"}));
            style += build_rule(sel + ":focus", _$rapyd$_desugar_kwargs({outline: "none"}));
            style += build_rule(sel + ".top-bar-title:hover", _$rapyd$_desugar_kwargs({transform: "scale(1)", color: get_color("bar-highlight"), font_style: "italic"}));
            style += build_rule(sel + ".top-bar-title:active", _$rapyd$_desugar_kwargs({transform: "scale(1)", color: get_color("bar-highlight"), font_style: "italic"}));
            var _$rapyd$_Iter1 = _$rapyd$_Iterable(_$rapyd$_list_decorate([ self.dummy_bar_id, self.bar_id ]));
            for (var _$rapyd$_Index1 = 0; _$rapyd$_Index1 < _$rapyd$_Iter1.length; _$rapyd$_Index1++) {
                bid = _$rapyd$_Iter1[_$rapyd$_Index1];
                bar = E.div(E.div(_$rapyd$_desugar_kwargs({style: "white-space:nowrap; overflow:hidden; text-overflow: ellipsis; padding-left: 0.5em;"})), E.div(_$rapyd$_desugar_kwargs({style: "white-space:nowrap; text-align:right; padding-right: 0.5em;"})), _$rapyd$_desugar_kwargs({id: bid}));
                if (bid === self.bar_id) {
                    set_css(bar, _$rapyd$_desugar_kwargs({position: "fixed", left: "0", top: "0", z_index: "1"}));
                    bar.appendChild(E.style(style, _$rapyd$_desugar_kwargs({type: "text/css"})));
                }
                set_css(bar, _$rapyd$_desugar_kwargs({width: "100%", display: "flex", flex_direction: "row", flex_wrap: "wrap", justify_content: "space-between", font_size: get_font_size("title"), user_select: "none", color: get_color("bar-foreground"), background_color: get_color("bar-background")}));
                book_list_container.appendChild(bar);
            }
        };
        TopBar.prototype.set_left = function set_left() {
            var self = this;
            var title = (arguments[0] === undefined || ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? ("calibre") : arguments[0];
            var icon_name = (arguments[1] === undefined || ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? ("heart") : arguments[1];
            var action = (arguments[2] === undefined || ( 2 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (null) : arguments[2];
            var tooltip = (arguments[3] === undefined || ( 3 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? ("") : arguments[3];
            var run_animation = (arguments[4] === undefined || ( 4 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (false) : arguments[4];
            var _$rapyd$_kwargs_obj = arguments[arguments.length-1];
            if (_$rapyd$_kwargs_obj === null || typeof _$rapyd$_kwargs_obj !== "object" || _$rapyd$_kwargs_obj [_$rapyd$_kwargs_symbol] !== true) _$rapyd$_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "title")){
                title = _$rapyd$_kwargs_obj.title;
            }
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "icon_name")){
                icon_name = _$rapyd$_kwargs_obj.icon_name;
            }
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "action")){
                action = _$rapyd$_kwargs_obj.action;
            }
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "tooltip")){
                tooltip = _$rapyd$_kwargs_obj.tooltip;
            }
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "run_animation")){
                run_animation = _$rapyd$_kwargs_obj.run_animation;
            }
            var title_action, title_tooltip, _$rapyd$_chain_assign_temp, data, _$rapyd$_unpack, left, title_elem, a, bar;
            self.current_left_data = {
                "title": title,
                "icon_name": icon_name,
                "action": action,
                "tooltip": tooltip
            };
            if (icon_name === "heart") {
                if (!tooltip) {
                    tooltip = _("Donate to support calibre development");
                }
            }
            _$rapyd$_chain_assign_temp = null;
            title_action = _$rapyd$_chain_assign_temp;
            title_tooltip = _$rapyd$_chain_assign_temp;
;
            if (callable(title)) {
                data = title();
                _$rapyd$_unpack = [data.title, data.title_action, data.title_tooltip];
                title = _$rapyd$_unpack[0];
                title_action = _$rapyd$_unpack[1];
                title_tooltip = _$rapyd$_unpack[2];
            }
            var _$rapyd$_Iter2 = _$rapyd$_Iterable(_$rapyd$_list_decorate([ self.bar, self.dummy_bar ]));
            for (var _$rapyd$_Index2 = 0; _$rapyd$_Index2 < _$rapyd$_Iter2.length; _$rapyd$_Index2++) {
                bar = _$rapyd$_Iter2[_$rapyd$_Index2];
                left = bar.firstChild;
                clear(left);
                title_elem = (callable(title_action)) ? "a" : "span";
                left.appendChild(E.a(E.i(_$rapyd$_desugar_kwargs({class_: "fa fa-" + icon_name + " fa-fw"})), _$rapyd$_desugar_kwargs({title: tooltip})));
                left.appendChild(E(title_elem, title, _$rapyd$_desugar_kwargs({title: title_tooltip, class_: "top-bar-title", style: str.format("margin-left: {0}; font-weight: bold; padding-top: {1}; padding-bottom: {1}; vertical-align: middle", self.SPACING, self.VSPACING)})));
                if (bar === self.bar) {
                    a = left.firstChild;
                    if (icon_name === "heart") {
                        set_css(a, _$rapyd$_desugar_kwargs({animation_name: self.throbber_name, animation_duration: "1s", animation_timing_function: "ease-in-out", animation_iteration_count: "5", animation_play_state: (run_animation) ? "running" : "paused"}));
                        set_css(a.firstChild, _$rapyd$_desugar_kwargs({color: get_color("heart")}));
                        a.setAttribute("href", "http://calibre-ebook.com/donate");
                        a.setAttribute("target", "donate-to-calibre");
                    }
                    if (action !== null) {
                        a.addEventListener("click", function(event) {
                            [event.preventDefault(), action()];
                        });
                    }
                    if (callable(title_action)) {
                        a = a.nextSibling;
                        a.addEventListener("click", function(event) {
                            [event.preventDefault(), title_action()];
                        });
                    }
                }
            }
        };
        TopBar.prototype.refresh_left = function refresh_left() {
            var self = this;
            var kw;
            kw = self.current_left_data;
            self.set_left.apply(self, [_$rapyd$_desugar_kwargs(kw)]);
        };
        TopBar.prototype.add_button = function add_button() {
            var self = this;
            var icon_name = (arguments[0] === undefined || ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (null) : arguments[0];
            var action = (arguments[1] === undefined || ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (null) : arguments[1];
            var tooltip = (arguments[2] === undefined || ( 2 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? ("") : arguments[2];
            var _$rapyd$_kwargs_obj = arguments[arguments.length-1];
            if (_$rapyd$_kwargs_obj === null || typeof _$rapyd$_kwargs_obj !== "object" || _$rapyd$_kwargs_obj [_$rapyd$_kwargs_symbol] !== true) _$rapyd$_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "icon_name")){
                icon_name = _$rapyd$_kwargs_obj.icon_name;
            }
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "action")){
                action = _$rapyd$_kwargs_obj.action;
            }
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "tooltip")){
                tooltip = _$rapyd$_kwargs_obj.tooltip;
            }
            var right, bar;
            if (!icon_name) {
                return;
            }
            var _$rapyd$_Iter3 = _$rapyd$_Iterable(_$rapyd$_list_decorate([ self.bar, self.dummy_bar ]));
            for (var _$rapyd$_Index3 = 0; _$rapyd$_Index3 < _$rapyd$_Iter3.length; _$rapyd$_Index3++) {
                bar = _$rapyd$_Iter3[_$rapyd$_Index3];
                right = bar.firstChild.nextSibling;
                right.appendChild(E.a(E.i(_$rapyd$_desugar_kwargs({class_: "fa fa-" + icon_name + " fa-fw"})), _$rapyd$_desugar_kwargs({style: "margin-left: " + self.SPACING, title: tooltip})));
                if (bar === self.bar) {
                    if (action !== null) {
                        right.lastChild.addEventListener("click", function(event) {
                            [event.preventDefault(), action()];
                        });
                    }
                }
            }
        };
        TopBar.prototype.apply_state = function apply_state(left, buttons) {
            var self = this;
            var right, bar, button;
            self.set_left.apply(self, [_$rapyd$_desugar_kwargs(left)]);
            var _$rapyd$_Iter4 = _$rapyd$_Iterable(_$rapyd$_list_decorate([ self.bar, self.dummy_bar ]));
            for (var _$rapyd$_Index4 = 0; _$rapyd$_Index4 < _$rapyd$_Iter4.length; _$rapyd$_Index4++) {
                bar = _$rapyd$_Iter4[_$rapyd$_Index4];
                right = bar.firstChild.nextSibling;
                clear(right);
            }
            var _$rapyd$_Iter5 = _$rapyd$_Iterable(buttons);
            for (var _$rapyd$_Index5 = 0; _$rapyd$_Index5 < _$rapyd$_Iter5.length; _$rapyd$_Index5++) {
                button = _$rapyd$_Iter5[_$rapyd$_Index5];
                self.add_button.apply(self, [_$rapyd$_desugar_kwargs(button)]);
            }
        };
        TopBar.prototype.SPACING = "0.75em";
        TopBar.prototype.VSPACING = "0.5ex";
        
        

        _$rapyd$_modules["book_list.top_bar"]["bar_counter"] = bar_counter;

        _$rapyd$_modules["book_list.top_bar"]["TopBar"] = TopBar;
    })();

    (function(){
        var __name__ = "book_list.views";
        var THUMBNAIL_MAX_WIDTH, THUMBNAIL_MAX_HEIGHT, bv_counter;
        var ajax_send = _$rapyd$_modules["ajax"].ajax_send;
        var encode_query = _$rapyd$_modules["ajax"].encode_query;
        
        var set_css = _$rapyd$_modules["dom"].set_css;
        var build_rule = _$rapyd$_modules["dom"].build_rule;
        var clear = _$rapyd$_modules["dom"].clear;
        
        var E = _$rapyd$_modules["elementmaker"].E;
        
        var _ = _$rapyd$_modules["gettext"].gettext;
        
        var error_dialog = _$rapyd$_modules["modals"].error_dialog;
        var ajax_progress_dialog = _$rapyd$_modules["modals"].ajax_progress_dialog;
        
        var get_session_data = _$rapyd$_modules["book_list.globals"].get_session_data;
        var get_boss = _$rapyd$_modules["book_list.globals"].get_boss;
        
        var create_button = _$rapyd$_modules["widgets"].create_button;
        var create_spinner = _$rapyd$_modules["widgets"].create_spinner;
        
        THUMBNAIL_MAX_WIDTH = 300;
        THUMBNAIL_MAX_HEIGHT = 400;
        bv_counter = 0;
        function BooksView() {
            Object.defineProperties(this,  {
                "container": {
                    "enumerable": true, 
                    "get": function container() {
                        var self = this;
                        return document.getElementById(self.container_id);
                    }, 
                    "set": function () { throw new AttributeError("can't set attribute") }
                }, 
                "grid": {
                    "enumerable": true, 
                    "get": function grid() {
                        var self = this;
                        return self.container.lastChild.previousSibling;
                    }, 
                    "set": function () { throw new AttributeError("can't set attribute") }
                }, 
                "is_visible": {
                    "enumerable": true, 
                    "get": function is_visible() {
                        var self = this;
                        self.container.style.display === "block";
                    }, 
                    "set": function is_visible(val) {
                        var self = this;
                        self.container.style.display = (val) ? "block" : "none";
                    }
                }, 
            });
            BooksView.prototype.__init__.apply(this, arguments);
        }
        BooksView.prototype.__init__ = function __init__(interface_data, book_list_container) {
            var self = this;
            var style, div;
            bv_counter += 1;
            self.interface_data = interface_data;
            self.is_fetching = null;
            self.shown_book_ids = set();
            self.container_id = "books-view-" + bv_counter;
            style = build_rule("#" + self.container_id + " .cover_grid > div:hover", _$rapyd$_desugar_kwargs({transform: "scale(1.2)"}));
            style += build_rule("#" + self.container_id + " .cover_grid > div:active", _$rapyd$_desugar_kwargs({transform: "scale(2.0)"}));
            div = E.div(E.style(style), E.div(), E.div(), _$rapyd$_desugar_kwargs({id: self.container_id, style: "display:block"}));
            book_list_container.appendChild(div);
            self.set_view_mode(get_session_data().get("view_mode"));
            self.create_more_button(div);
        };
        BooksView.prototype.create_more_button = function create_more_button(div) {
            var self = this;
            var more;
            more = div.lastChild;
            more.appendChild(create_button(_("Show more books"), "cloud-download", function() {
                self.get_more_books();
            }));
            more.lastChild.setAttribute("rel", "next");
            set_css(more.firstChild, _$rapyd$_desugar_kwargs({display: "block", margin_left: "auto", margin_right: "auto"}));
            set_css(more, _$rapyd$_desugar_kwargs({font_size: "1.5rem", padding_top: "1.5rem", margin_bottom: "1.5rem", width: "100%", text_align: "center"}));
            more.appendChild(E.div(create_spinner(), " " + _("Fetching metadata for more books, please wait") + "…", _$rapyd$_desugar_kwargs({style: "margin-left:auto; margin-right:auto; display:none"})));
            self.update_fetching_status();
        };
        BooksView.prototype.set_view_mode = function set_view_mode() {
            var self = this;
            var mode = (arguments[0] === undefined || ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? ("cover_grid") : arguments[0];
            var _$rapyd$_kwargs_obj = arguments[arguments.length-1];
            if (_$rapyd$_kwargs_obj === null || typeof _$rapyd$_kwargs_obj !== "object" || _$rapyd$_kwargs_obj [_$rapyd$_kwargs_symbol] !== true) _$rapyd$_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "mode")){
                mode = _$rapyd$_kwargs_obj.mode;
            }
            if (self.mode === mode) {
                return;
            }
            if (!(_$rapyd$_in(mode, ['cover_grid']))) {
                mode = "cover_grid";
            }
            self.mode = mode;
            if (mode === "cover_grid") {
                self.render_book = self.cover_grid_item.bind(self);
                self.init_grid = self.init_cover_grid.bind(self);
            }
            self.clear();
            self.render_ids();
        };
        BooksView.prototype.clear = function clear() {
            var self = this;
            var c;
            c = self.container;
            c.removeChild(self.grid);
            c.insertBefore(E.div(), c.lastChild);
            self.shown_book_ids.clear();
            self.init_grid();
        };
        BooksView.prototype.render_id = function render_id(book_id) {
            var self = this;
            var l;
            l = self.shown_book_ids.length;
            self.shown_book_ids.add(book_id);
            if (l < self.shown_book_ids.length) {
                return self.render_book(book_id);
            }
        };
        BooksView.prototype.render_ids = function render_ids(book_ids) {
            var self = this;
            var div, child, book_id;
            book_ids = book_ids || self.interface_data["search_result"]["book_ids"];
            div = self.grid;
            var _$rapyd$_Iter0 = _$rapyd$_Iterable(book_ids);
            for (var _$rapyd$_Index0 = 0; _$rapyd$_Index0 < _$rapyd$_Iter0.length; _$rapyd$_Index0++) {
                book_id = _$rapyd$_Iter0[_$rapyd$_Index0];
                child = self.render_id(book_id);
                if (child !== null) {
                    div.appendChild(self.render_book(book_id));
                }
            }
        };
        BooksView.prototype.update_fetching_status = function update_fetching_status() {
            var self = this;
            var c, more;
            c = self.container;
            more = c.lastChild;
            if (self.is_fetching !== null) {
                more.firstChild.style.display = "none";
                more.lastChild.style.display = "block";
            } else if (self.interface_data["search_result"]["total_num"] > self.shown_book_ids.length) {
                more.firstChild.style.display = "block";
                more.lastChild.style.display = "none";
            } else {
                more.firstChild.style.display = "none";
                more.lastChild.style.display = "none";
            }
        };
        BooksView.prototype.get_more_books = function get_more_books() {
            var self = this;
            var data, key;
            data = {
                "offset": self.shown_book_ids.length
            };
            var _$rapyd$_Iter1 = _$rapyd$_Iterable(_$rapyd$_list_decorate([ "query", "sort", "sort_order" ]));
            for (var _$rapyd$_Index1 = 0; _$rapyd$_Index1 < _$rapyd$_Iter1.length; _$rapyd$_Index1++) {
                key = _$rapyd$_Iter1[_$rapyd$_Index1];
                data[key] = self.interface_data["search_result"][key];
            }
            self.is_fetching = ajax_send("interface-data/more-books", data, self.got_more_books.bind(self), _$rapyd$_desugar_kwargs({query: {
                "library_id": self.interface_data.library_id
            }}));
            self.update_fetching_status();
        };
        BooksView.prototype.abort_get_more_books = function abort_get_more_books() {
            var self = this;
            var _$rapyd$_unpack, a;
            if (self.is_fetching) {
                _$rapyd$_unpack = [self.is_fetching, null];
                a = _$rapyd$_unpack[0];
                self.is_fetching = _$rapyd$_unpack[1];
                a.abort();
                self.update_fetching_status();
            }
        };
        BooksView.prototype.got_more_books = function got_more_books(end_type, xhr, event) {
            var self = this;
            var data, key;
            if (self.is_fetching === null || self.is_fetching !== xhr) {
                return;
            }
            self.is_fetching = null;
            self.update_fetching_status();
            if (end_type === "load") {
                try {
                    data = JSON.parse(xhr.responseText);
                    var _$rapyd$_Iter2 = _$rapyd$_Iterable(data.metadata);
                    for (var _$rapyd$_Index2 = 0; _$rapyd$_Index2 < _$rapyd$_Iter2.length; _$rapyd$_Index2++) {
                        key = _$rapyd$_Iter2[_$rapyd$_Index2];
                        self.interface_data.metadata[key] = data.metadata[key];
                    }
                    if (!data.search_result.book_ids) {
                        throw new Exception("No books ids object in search result from server");
                    }
                    self.render_ids(data.search_result.book_ids);
                    self.interface_data.search_result = data.search_result;
                } catch (_$rapyd$_Exception) {
                    if (_$rapyd$_Exception instanceof Exception) {
                        var err = _$rapyd$_Exception;
                        error_dialog(_("Could not get more books"), _("Server returned an invalid response"), err.stack || err.toString());
                    } else {
                        throw _$rapyd$_Exception;
                    }
                }
            } else if (end_type !== "abort") {
                error_dialog(_("Could not get more books"), xhr.error_html);
            }
        };
        BooksView.prototype.init_cover_grid = function init_cover_grid() {
            var self = this;
            var div;
            div = self.grid;
            set_css(div, _$rapyd$_desugar_kwargs({display: "flex", flex_wrap: "wrap", justify_content: "flex-start", align_items: "flex-end", align_content: "flex-start", user_select: "none"}));
            div.setAttribute("class", "cover_grid");
        };
        BooksView.prototype.cover_grid_item = function cover_grid_item(book_id) {
            var self = this;
            var cover_url, metadata, alt, img;
            cover_url = str.format("get/thumb/{}/{}?sz={}x{}", book_id, self.interface_data["library_id"], THUMBNAIL_MAX_WIDTH, THUMBNAIL_MAX_HEIGHT);
            metadata = self.interface_data["metadata"][book_id];
            alt = str.format(_("{} by {}"), metadata["title"], metadata["authors"].join(" & "));
            img = E.img(_$rapyd$_desugar_kwargs({src: cover_url, alt: alt, title: alt, data_title: metadata["title"], data_authors: metadata["authors"].join(" & "), style: "max-width: 100%; max-height: 100%; display: block; width:auto; height:auto"}));
            img.onerror = function(err) {
                var img, div;
                img = err.target;
                div = img.parentNode;
                if (!div) {
                    return;
                }
                clear(div);
                div.appendChild(E.div(E.h2(img.getAttribute("data-title"), _$rapyd$_desugar_kwargs({style: "text-align:center; font-size:larger; font-weight: bold"})), E.div(_("by"), _$rapyd$_desugar_kwargs({style: "text-align: center"})), E.h2(img.getAttribute("data-authors"), _$rapyd$_desugar_kwargs({style: "text-align:center; font-size:larger; font-weight: bold"})), _$rapyd$_desugar_kwargs({style: "position:relative; top:-50%; transform: translateY(50%)"})));
                set_css(div, _$rapyd$_desugar_kwargs({border: "dashed 1px currentColor", border_radius: "10px"}));
            };
            return E.div(img, _$rapyd$_desugar_kwargs({style: str.format("margin: 10px; display: flex; align-content: flex-end; align-items: flex-end; justify-content: space-around;width: 21vw; height: 28vw; max-width: {}px; max-height: {}px; min-width: {}px; min-height: {}px; cursor:pointer", THUMBNAIL_MAX_WIDTH, THUMBNAIL_MAX_HEIGHT, Math.floor(THUMBNAIL_MAX_WIDTH / 2), Math.floor(THUMBNAIL_MAX_HEIGHT / 2)), data_book_id: str(book_id)}));
        };
        BooksView.prototype.sort_panel_data = function sort_panel_data(create_item) {
            var self = this;
            var current_sorted_field, current_sorted_field_order, new_sort_order, ans, subtitle, icon_name, _$rapyd$_chain_assign_temp, action, _$rapyd$_unpack, field, name;
            current_sorted_field = str.partition(self.interface_data.search_result.sort, ",")[0];
            current_sorted_field_order = str.partition(self.interface_data.search_result.sort_order, ",")[0];
            new_sort_order = (current_sorted_field_order === "asc") ? "desc" : "asc";
            if (current_sorted_field === "date") {
                current_sorted_field = "timestamp";
            }
            ans = _$rapyd$_list_decorate([]);
            ans.subtitle = _("Change how the list of books is sorted");
            var _$rapyd$_Iter3 = _$rapyd$_Iterable(self.interface_data.sortable_fields);
            for (var _$rapyd$_Index3 = 0; _$rapyd$_Index3 < _$rapyd$_Iter3.length; _$rapyd$_Index3++) {
                _$rapyd$_unpack = _$rapyd$_Iter3[_$rapyd$_Index3];
                field = _$rapyd$_unpack[0];
                name = _$rapyd$_unpack[1];
                _$rapyd$_chain_assign_temp = null;
                subtitle = _$rapyd$_chain_assign_temp;
                icon_name = _$rapyd$_chain_assign_temp;
;
                if (field === current_sorted_field) {
                    subtitle = _("Reverse current sort order");
                    icon_name = (current_sorted_field_order === "asc") ? "sort-amount-asc" : "sort-amount-desc";
                    action = self.change_sort.bind(self, field, new_sort_order);
                } else {
                    action = self.change_sort.bind(self, field, null);
                }
                ans.push(create_item(name, _$rapyd$_desugar_kwargs({subtitle: subtitle, icon_name: icon_name, action: action})));
            }
            return ans;
        };
        BooksView.prototype.change_sort = function change_sort(field, order) {
            var self = this;
            var key, sd, sr, sort, data;
            self.abort_get_more_books();
            key = "sort-order-for-" + field;
            sd = get_session_data();
            order = order || sd.get(key, "asc");
            order = (order === "asc") ? "asc" : "desc";
            sd.set(key, order);
            sr = self.interface_data.search_result;
            sort = field + "." + order + "," + sr.sort + "." + sr.order;
            data = {
                "search": sr.query || "",
                "sort": sort,
                "num": self.shown_book_ids.length,
                "library_id": self.interface_data.library_id
            };
            ajax_progress_dialog("interface-data/get-books", self.sort_change_completed.bind(self), _("Fetching data from server, please wait") + "…", _$rapyd$_desugar_kwargs({query: data}));
        };
        BooksView.prototype.sort_change_completed = function sort_change_completed(end_type, xhr, ev) {
            var self = this;
            var boss, data;
            if (end_type === "load") {
                boss = get_boss();
                try {
                    data = JSON.parse(xhr.responseText);
                    boss.change_books(data);
                } catch (_$rapyd$_Exception) {
                    if (_$rapyd$_Exception instanceof Exception) {
                        var err = _$rapyd$_Exception;
                        return error_dialog(_("Could not change sort order"), err + "", _$rapyd$_desugar_kwargs({details: err.stack}));
                    } else {
                        throw _$rapyd$_Exception;
                    }
                }
                boss.ui.close_panel();
                window.scrollTo(0, 0);
            } else if (end_type !== "abort") {
                error_dialog(_("Could not change sort order"), xhr.error_html);
            }
        };
        BooksView.prototype.change_search = function change_search(query) {
            var self = this;
            var sd, data;
            self.abort_get_more_books();
            query = query || "";
            sd = get_session_data();
            data = {
                "search": query,
                "sort": sd.get("sort"),
                "library_id": self.interface_data.library_id
            };
            ajax_progress_dialog("interface-data/get-books", self.search_change_completed.bind(self), _("Fetching data from server, please wait") + "…", _$rapyd$_desugar_kwargs({query: data}));
        };
        BooksView.prototype.search_change_completed = function search_change_completed(end_type, xhr, ev) {
            var self = this;
            var boss, data, query, msg;
            if (end_type === "load") {
                boss = get_boss();
                try {
                    data = JSON.parse(xhr.responseText);
                    boss.change_books(data);
                } catch (_$rapyd$_Exception) {
                    if (_$rapyd$_Exception instanceof Exception) {
                        var err = _$rapyd$_Exception;
                        return error_dialog(_("Could not change search query"), err + "", _$rapyd$_desugar_kwargs({details: err.stack}));
                    } else {
                        throw _$rapyd$_Exception;
                    }
                }
                query = {
                    "search": self.interface_data.search_result.query,
                    "library_id": self.interface_data.library_id
                };
                window.history.pushState(null, "", encode_query(query));
                boss.ui.close_panel();
                self.update_fetching_status();
                window.scrollTo(0, 0);
            } else if (end_type !== "abort") {
                msg = xhr.error_html;
                if (xhr.status === 400 && str.startswith(xhr.responseText, "Invalid search expression:")) {
                    msg = _("The search expression could not be parsed: ") + xhr.responseText;
                }
                error_dialog(_("Could not change search query"), msg);
            }
        };
        BooksView.prototype.refresh = function refresh() {
            var self = this;
            self.clear();
            self.render_ids();
        };
        
        
        
        

        _$rapyd$_modules["book_list.views"]["THUMBNAIL_MAX_WIDTH"] = THUMBNAIL_MAX_WIDTH;

        _$rapyd$_modules["book_list.views"]["THUMBNAIL_MAX_HEIGHT"] = THUMBNAIL_MAX_HEIGHT;

        _$rapyd$_modules["book_list.views"]["bv_counter"] = bv_counter;

        _$rapyd$_modules["book_list.views"]["BooksView"] = BooksView;
    })();

    (function(){
        var __name__ = "book_list.item_list";
        var iv_counter;
        var build_rule = _$rapyd$_modules["dom"].build_rule;
        
        var E = _$rapyd$_modules["elementmaker"].E;
        
        var get_font_size = _$rapyd$_modules["book_list.theme"].get_font_size;
        var get_color = _$rapyd$_modules["book_list.theme"].get_color;
        
        iv_counter = 0;
        function ItemsView() {
            Object.defineProperties(this,  {
                "container": {
                    "enumerable": true, 
                    "get": function container() {
                        var self = this;
                        return document.getElementById(self.container_id);
                    }, 
                    "set": function () { throw new AttributeError("can't set attribute") }
                }, 
                "is_visible": {
                    "enumerable": true, 
                    "get": function is_visible() {
                        var self = this;
                        self.container.style.display === "block";
                    }, 
                    "set": function is_visible(val) {
                        var self = this;
                        self.container.style.display = (val) ? "block" : "none";
                    }
                }, 
            });
            ItemsView.prototype.__init__.apply(this, arguments);
        }
        ItemsView.prototype.__init__ = function __init__(interface_data, book_list_container) {
            var self = this;
            var style, cid, div;
            iv_counter += 1;
            self.container_id = "items-view-" + iv_counter;
            style = "";
            cid = "#" + self.container_id;
            style += build_rule(cid + " li", _$rapyd$_desugar_kwargs({padding: "1em", border_bottom: "solid 1px " + get_color("window-foreground"), border_top: "solid 1px " + get_color("window-background"), cursor: "pointer", list_style: "none"}));
            style += build_rule(cid + " .item-title", _$rapyd$_desugar_kwargs({font_size: get_font_size("item-list-title")}));
            style += build_rule(cid + " .item-subtitle", _$rapyd$_desugar_kwargs({font_size: get_font_size("item-list-subtitle"), font_style: "italic"}));
            style += build_rule(cid + " li:hover", _$rapyd$_desugar_kwargs({color: get_color("list-hover-foreground"), background_color: get_color("list-hover-background"), border_top_color: get_color("list-hover-foreground")}));
            style += build_rule(cid + " li:active", _$rapyd$_desugar_kwargs({transform: "scale(1, 1.5)"}));
            self.base_style = style;
            div = E.div(E.style(style, _$rapyd$_desugar_kwargs({type: "text/css"})), _$rapyd$_desugar_kwargs({id: self.container_id, style: "display:none"}));
            book_list_container.appendChild(div);
        };
        ItemsView.prototype.clear = function clear() {
            var self = this;
            var c;
            c = self.container;
            while (c.lastChild !== c.firstChild) {
                c.removeChild(c.lastChild);
            }
            return c;
        };
        ItemsView.prototype.init = function init(data) {
            var self = this;
            var items, subtitle, c, ul, has_icons, item, ic, a;
            items = getattr(data, "items", data);
            subtitle = getattr(data, "subtitle", null);
            c = self.clear();
            if (subtitle) {
                c.appendChild(E.p(subtitle, _$rapyd$_desugar_kwargs({style: "font-style:italic; padding: 1em 1ex; border-bottom: solid 1px currentColor"})));
            }
            ul = E.ul();
            c.appendChild(ul);
            has_icons = false;
            var _$rapyd$_Iter0 = _$rapyd$_Iterable(items);
            for (var _$rapyd$_Index0 = 0; _$rapyd$_Index0 < _$rapyd$_Iter0.length; _$rapyd$_Index0++) {
                item = _$rapyd$_Iter0[_$rapyd$_Index0];
                if (item.icon_name) {
                    has_icons = true;
                    break;
                }
            }
            var _$rapyd$_Iter1 = _$rapyd$_Iterable(items);
            for (var _$rapyd$_Index1 = 0; _$rapyd$_Index1 < _$rapyd$_Iter1.length; _$rapyd$_Index1++) {
                item = _$rapyd$_Iter1[_$rapyd$_Index1];
                ic = "";
                if (has_icons) {
                    ic = "fa fa-fw ";
                    if (item.icon_name) {
                        ic += " fa-" + item.icon_name;
                    }
                    ic = E.span(" ", _$rapyd$_desugar_kwargs({class_: ic}));
                }
                ul.appendChild(E.li(E.a(E.div(ic, item.title, _$rapyd$_desugar_kwargs({class_: "item-title"})), _$rapyd$_desugar_kwargs({href: "javascript:void(0)"}))));
                a = ul.lastChild.firstChild;
                if (item.subtitle) {
                    a.appendChild(E.div(item.subtitle, _$rapyd$_desugar_kwargs({class_: "item-subtitle", style: "padding-top:1ex"})));
                }
                a.addEventListener("click", function(event) {
                    event.preventDefault();
                });
                if (item.action) {
                    ul.lastChild.addEventListener("click", item.action);
                }
            }
        };
        
        
        

        function create_item() {
            var title = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) ? undefined : arguments[0];
            var action = (arguments[1] === undefined || ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (null) : arguments[1];
            var subtitle = (arguments[2] === undefined || ( 2 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (null) : arguments[2];
            var icon_name = (arguments[3] === undefined || ( 3 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (null) : arguments[3];
            var _$rapyd$_kwargs_obj = arguments[arguments.length-1];
            if (_$rapyd$_kwargs_obj === null || typeof _$rapyd$_kwargs_obj !== "object" || _$rapyd$_kwargs_obj [_$rapyd$_kwargs_symbol] !== true) _$rapyd$_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "action")){
                action = _$rapyd$_kwargs_obj.action;
            }
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "subtitle")){
                subtitle = _$rapyd$_kwargs_obj.subtitle;
            }
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "icon_name")){
                icon_name = _$rapyd$_kwargs_obj.icon_name;
            }
            return {
                "title": title,
                "action": action,
                "subtitle": subtitle,
                "icon_name": icon_name
            };
        }
        _$rapyd$_modules["book_list.item_list"]["iv_counter"] = iv_counter;

        _$rapyd$_modules["book_list.item_list"]["ItemsView"] = ItemsView;

        _$rapyd$_modules["book_list.item_list"]["create_item"] = create_item;
    })();

    (function(){
        var __name__ = "book_list.ui";
        var panels, create_panel;
        var get_boss = _$rapyd$_modules["book_list.globals"].get_boss;
        
        var SearchPanel = _$rapyd$_modules["book_list.search"].SearchPanel;
        
        var TopBar = _$rapyd$_modules["book_list.top_bar"].TopBar;
        
        var BooksView = _$rapyd$_modules["book_list.views"].BooksView;
        
        var ItemsView = _$rapyd$_modules["book_list.item_list"].ItemsView;
        var create_item = _$rapyd$_modules["book_list.item_list"].create_item;
        
        var _ = _$rapyd$_modules["gettext"].gettext;
        
        var debounce = _$rapyd$_modules["utils"].debounce;
        
        function BarState() {
            BarState.prototype.__init__.apply(this, arguments);
        }
        BarState.prototype.__init__ = function __init__() {
            var self = this;
            var kw = arguments[arguments.length-1];
            if (kw === null || typeof kw !== "object" || kw [_$rapyd$_kwargs_symbol] !== true) kw = {};
            self.left_state = kw;
            self.buttons = [];
        };
        BarState.prototype.add_button = function add_button() {
            var self = this;
            var kw = arguments[arguments.length-1];
            if (kw === null || typeof kw !== "object" || kw [_$rapyd$_kwargs_symbol] !== true) kw = {};
            self.buttons.push(kw);
        };

        function ClosePanelBar() {
            ClosePanelBar.prototype.__init__.apply(this, arguments);
        }
        _$rapyd$_extends(ClosePanelBar, BarState);
        ClosePanelBar.prototype.__init__ = function __init__() {
            var self = this;
            var title = ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true) ? undefined : arguments[0];
            var tooltip = (arguments[1] === undefined || ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? ("") : arguments[1];
            var _$rapyd$_kwargs_obj = arguments[arguments.length-1];
            if (_$rapyd$_kwargs_obj === null || typeof _$rapyd$_kwargs_obj !== "object" || _$rapyd$_kwargs_obj [_$rapyd$_kwargs_symbol] !== true) _$rapyd$_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "tooltip")){
                tooltip = _$rapyd$_kwargs_obj.tooltip;
            }
            tooltip = tooltip || _("Close this panel");
            BarState.prototype.constructor.call(self, _$rapyd$_desugar_kwargs({title: title, tooltip: tooltip, action: close_panel, icon_name: "times"}));
        };

        function UIState() {
            UIState.prototype.__init__.apply(this, arguments);
        }
        UIState.prototype.__init__ = function __init__() {
            var self = this;
            var top_bar_state = (arguments[0] === undefined || ( 0 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (null) : arguments[0];
            var main_panel = (arguments[1] === undefined || ( 1 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (null) : arguments[1];
            var panel_data = (arguments[2] === undefined || ( 2 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (null) : arguments[2];
            var is_cacheable = (arguments[3] === undefined || ( 3 === arguments.length-1 && arguments[arguments.length-1] !== null && typeof arguments[arguments.length-1] === "object" && arguments[arguments.length-1] [_$rapyd$_kwargs_symbol] === true)) ? (true) : arguments[3];
            var _$rapyd$_kwargs_obj = arguments[arguments.length-1];
            if (_$rapyd$_kwargs_obj === null || typeof _$rapyd$_kwargs_obj !== "object" || _$rapyd$_kwargs_obj [_$rapyd$_kwargs_symbol] !== true) _$rapyd$_kwargs_obj = {};
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "top_bar_state")){
                top_bar_state = _$rapyd$_kwargs_obj.top_bar_state;
            }
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "main_panel")){
                main_panel = _$rapyd$_kwargs_obj.main_panel;
            }
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "panel_data")){
                panel_data = _$rapyd$_kwargs_obj.panel_data;
            }
            if (Object.prototype.hasOwnProperty.call(_$rapyd$_kwargs_obj, "is_cacheable")){
                is_cacheable = _$rapyd$_kwargs_obj.is_cacheable;
            }
            self.top_bar_state = top_bar_state;
            self.main_panel = main_panel || get_boss().ui.items_view;
            if (typeof self.main_panel === "string") {
                self.main_panel = getattr(get_boss().ui, self.main_panel);
            }
            self.panel_data = panel_data;
            self.is_cacheable = is_cacheable;
        };
        UIState.prototype.add_button = function add_button() {
            var self = this;
            var kw = arguments[arguments.length-1];
            if (kw === null || typeof kw !== "object" || kw [_$rapyd$_kwargs_symbol] !== true) kw = {};
            self.top_bar_state.add_button.apply(undefined, [_$rapyd$_desugar_kwargs(kw)]);
        };

        panels = {};
        function panel(key) {
            var ans;
            ans = panels[key];
            if (!ans) {
                ans = create_panel[key]();
                if (ans.is_cacheable) {
                    panels[key] = ans;
                }
            }
            return ans;
        }
        function close_panel() {
            get_boss().ui.close_panel();
        }
        function replace_panel_action(replacement) {
            return function() {
                get_boss().ui.replace_panel(panel(replacement));
            };
        }
        function show_panel_action(key) {
            return function() {
                get_boss().ui.show_panel(panel(key));
            };
        }
        create_panel = {
            "more-actions-menu": function more_actions_menu() {
                return new UIState(new ClosePanelBar(_("More actions")), _$rapyd$_desugar_kwargs({panel_data: _$rapyd$_list_decorate([ create_item(_("Book List Mode"), replace_panel_action("booklist-mode-menu"), _("Change how the list of books is displayed")) ])}));
            },
            "booklist-mode-menu": function booklist_mode_menu() {
                return new UIState(new ClosePanelBar(_("Book List Mode")), _$rapyd$_desugar_kwargs({panel_data: _$rapyd$_list_decorate([])}));
            },
            "booklist-sort-menu": function change_booklist_sort() {
                var data;
                data = get_boss().ui.books_view.sort_panel_data(create_item);
                return new UIState(new ClosePanelBar(_("Sort books")), _$rapyd$_desugar_kwargs({panel_data: data, is_cacheable: false}));
            },
            "booklist-search": function search_panel() {
                return new UIState(new ClosePanelBar(_("Search for books")), _$rapyd$_desugar_kwargs({main_panel: "search_panel"}));
            }
        };
        function UI() {
            UI.prototype.__init__.apply(this, arguments);
        }
        UI.prototype.__init__ = function __init__(interface_data, book_list_container) {
            var self = this;
            var _$rapyd$_unpack, ibs;
            _$rapyd$_unpack = [_$rapyd$_list_decorate([]), _$rapyd$_list_decorate([])];
            self.states = _$rapyd$_unpack[0];
            self.panels = _$rapyd$_unpack[1];
            self.top_bar = new TopBar(book_list_container);
            self.books_view = new BooksView(interface_data, book_list_container);
            self.items_view = new ItemsView(interface_data, book_list_container);
            self.search_panel = new SearchPanel(interface_data, book_list_container);
            ibs = new BarState(_$rapyd$_desugar_kwargs({run_animation: true, title: function() {
                var q;
                q = self.books_view.interface_data["search_result"]["query"];
                if (q) {
                    return {
                        "title": _("Books matching") + "::  " + q,
                        "title_tooltip": _("Click to clear this search"),
                        "title_action": function() {
                            self.books_view.change_search("");
                        }
                    };
                }
                return {
                    "title": "calibre"
                };
            }}));
            ibs.add_button(_$rapyd$_desugar_kwargs({icon_name: "sort-amount-desc", tooltip: _("Sort books"), action: show_panel_action("booklist-sort-menu")}));
            ibs.add_button(_$rapyd$_desugar_kwargs({icon_name: "search", tooltip: _("Search for books"), action: show_panel_action("booklist-search")}));
            ibs.add_button(_$rapyd$_desugar_kwargs({icon_name: "ellipsis-v", tooltip: _("More actions"), action: show_panel_action("more-actions-menu")}));
            self.states.append(new UIState(ibs, self.books_view));
            self.apply_state(self.states[0]);
            ibs.left_state.run_animation = false;
            window.addEventListener("resize", debounce(self.on_resize.bind(self), 250));
            self.panels = _$rapyd$_list_decorate([ self.books_view, self.items_view, self.search_panel ]);
        };
        UI.prototype.on_resize = function on_resize() {
            var self = this;
        };
        UI.prototype.apply_state = function apply_state(state) {
            var self = this;
            var panel;
            self.top_bar.apply_state(state.top_bar_state.left_state, state.top_bar_state.buttons);
            var _$rapyd$_Iter0 = _$rapyd$_Iterable(self.panels);
            for (var _$rapyd$_Index0 = 0; _$rapyd$_Index0 < _$rapyd$_Iter0.length; _$rapyd$_Index0++) {
                panel = _$rapyd$_Iter0[_$rapyd$_Index0];
                panel.is_visible = panel === state.main_panel;
            }
            if (callable(state.main_panel.init)) {
                state.main_panel.init(state.panel_data);
            }
        };
        UI.prototype.close_panel = function close_panel() {
            var self = this;
            if (len(self.states) > 1) {
                self.states.pop();
                self.apply_state(self.states[self.states.length-1]);
            }
        };
        UI.prototype.replace_panel = function replace_panel(state) {
            var self = this;
            if (len(self.states) > 1) {
                self.states.pop();
                self.states.append(state);
                self.apply_state(self.states[self.states.length-1]);
            }
        };
        UI.prototype.show_panel = function show_panel(state) {
            var self = this;
            self.states.append(state);
            self.apply_state(self.states[self.states.length-1]);
        };
        UI.prototype.refresh_books_view = function refresh_books_view() {
            var self = this;
            self.books_view.refresh();
            if (len(self.states) === 1) {
                self.top_bar.refresh_left();
            }
        };

        _$rapyd$_modules["book_list.ui"]["panels"] = panels;

        _$rapyd$_modules["book_list.ui"]["create_panel"] = create_panel;

        _$rapyd$_modules["book_list.ui"]["BarState"] = BarState;

        _$rapyd$_modules["book_list.ui"]["ClosePanelBar"] = ClosePanelBar;

        _$rapyd$_modules["book_list.ui"]["UIState"] = UIState;

        _$rapyd$_modules["book_list.ui"]["panel"] = panel;

        _$rapyd$_modules["book_list.ui"]["close_panel"] = close_panel;

        _$rapyd$_modules["book_list.ui"]["replace_panel_action"] = replace_panel_action;

        _$rapyd$_modules["book_list.ui"]["show_panel_action"] = show_panel_action;

        _$rapyd$_modules["book_list.ui"]["UI"] = UI;
    })();

    (function(){
        var __name__ = "book_list.boss";
        var set_css = _$rapyd$_modules["dom"].set_css;
        
        var E = _$rapyd$_modules["elementmaker"].E;
        
        var error_dialog = _$rapyd$_modules["modals"].error_dialog;
        var create_modal_container = _$rapyd$_modules["modals"].create_modal_container;
        
        var _ = _$rapyd$_modules["gettext"].gettext;
        
        var get_widget_css = _$rapyd$_modules["widgets"].get_widget_css;
        
        var parse_url_params = _$rapyd$_modules["utils"].parse_url_params;
        
        var get_session_data = _$rapyd$_modules["book_list.globals"].get_session_data;
        
        var get_color = _$rapyd$_modules["book_list.theme"].get_color;
        
        var UI = _$rapyd$_modules["book_list.ui"].UI;
        
        function Boss() {
            Boss.prototype.__init__.apply(this, arguments);
        }
        Boss.prototype.__init__ = function __init__(interface_data) {
            var self = this;
            var div;
            document.head.appendChild(E.style(get_widget_css()));
            set_css(document.body, _$rapyd$_desugar_kwargs({background_color: get_color("window-background"), color: get_color("window-foreground")}));
            create_modal_container();
            self.interface_data = interface_data;
            self.current_library_id = interface_data["default_library"];
            self.current_library_name = interface_data["library_map"][self.current_library_id];
            self.update_window_title();
            div = E.div(_$rapyd$_desugar_kwargs({id: "book-list-container"}));
            document.body.appendChild(div);
            self.ui = new UI(interface_data, div);
            window.onerror = self.onerror.bind(self);
            setTimeout(function() {
                window.onpopstate = self.onpopstate.bind(self);
            }, 0);
        };
        Boss.prototype.update_window_title = function update_window_title() {
            var self = this;
            document.title = "calibre :: " + self.current_library_name;
        };
        Boss.prototype.onerror = function onerror(msg, script_url, line_number, column_number, error_object) {
            var self = this;
            var fname, details;
            try {
                fname = str.rpartition(script_url, "/")[str.rpartition(script_url, "/").length-1] || script_url;
                msg = msg + "<br><span style=\"font-size:smaller\">" + str.format("Error at {}:{}:{}", fname, line_number, column_number || "") + "</span>";
                details = "";
                if (error_object && error_object.stack) {
                    details = error_object.stack;
                }
                error_dialog(_("Unhandled error"), msg, details);
                return true;
            } catch (_$rapyd$_Exception) {
                console.error("There was an error in the unhandled exception handler");
            }
        };
        Boss.prototype.onpopstate = function onpopstate(ev) {
            var self = this;
            var data, search;
            data = parse_url_params();
            if (!data.mode || data.mode === "book_list") {
                search = data.search || "";
                if (search !== self.ui.books_view.interface_data.search_result.query) {
                    self.ui.books_view.change_search(search);
                }
            }
        };
        Boss.prototype.change_books = function change_books(data) {
            var self = this;
            var sval, _$rapyd$_unpack, field, order;
            data.search_result.sort = str.split(data.search_result.sort, ",").slice(0, 2).join(",");
            data.search_result.sort_order = str.split(data.search_result.sort_order, ",").slice(0, 2).join(",");
            sval = "";
            var _$rapyd$_Iter0 = _$rapyd$_Iterable(zip(str.split(data.search_result.sort, ","), str.split(data.search_result.sort_order, ",")));
            for (var _$rapyd$_Index0 = 0; _$rapyd$_Index0 < _$rapyd$_Iter0.length; _$rapyd$_Index0++) {
                _$rapyd$_unpack = _$rapyd$_Iter0[_$rapyd$_Index0];
                field = _$rapyd$_unpack[0];
                order = _$rapyd$_unpack[1];
                sval += field + "." + order + ",";
            }
            get_session_data().set("sort", str.rstrip(sval, ","));
            self.interface_data.metadata = data.metadata;
            self.interface_data.search_result = data.search_result;
            self.ui.refresh_books_view();
        };

        _$rapyd$_modules["book_list.boss"]["Boss"] = Boss;
    })();

    (function(){

        var __name__ = "__main__";


        var ajax = _$rapyd$_modules["ajax"].ajax;
        
        var E = _$rapyd$_modules["elementmaker"].E;
        
        var _ = _$rapyd$_modules["gettext"].gettext;
        
        var UserSessionData = _$rapyd$_modules["session"].UserSessionData;
        
        var parse_url_params = _$rapyd$_modules["utils"].parse_url_params;
        
        var Boss = _$rapyd$_modules["book_list.boss"].Boss;
        
        var set_boss = _$rapyd$_modules["book_list.globals"].set_boss;
        var set_session_data = _$rapyd$_modules["book_list.globals"].set_session_data;
        
        function on_library_loaded(end_type, xhr, ev) {
            var p, interface_data, sd, boss;
            p = document.getElementById("page_load_progress");
            p.parentNode.removeChild(p);
            if (end_type === "load") {
                interface_data = JSON.parse(xhr.responseText);
                sd = new UserSessionData(interface_data["username"], interface_data["user_session_data"]);
                set_session_data(sd);
                boss = new Boss(interface_data);
                set_boss(boss);
            } else {
                p = E.p(_$rapyd$_desugar_kwargs({style: "color:red; font-weight: bold; font-size:1.5em"}));
                if (xhr.status === 401) {
                    p.innerHTML = _("You are not authorized to view this site");
                } else {
                    p.innerHTML = xhr.error_html;
                }
                document.body.appendChild(p);
            }
        }
        function on_library_load_progress(loaded, total) {
            var p;
            p = document.querySelector("#page_load_progress > progress");
            p.max = total;
            p.value = loaded;
        }
        function load_book_list() {
            var temp, query, url_query, key;
            temp = new UserSessionData(null, {});
            query = (function() {
                var _$rapyd$_Iter = _$rapyd$_Iterable(str.split("library_id sort partition_method collapse_at dont_collapse sort_tags_by")), _$rapyd$_Result = {}, k;
                for (var _$rapyd$_Index = 0; _$rapyd$_Index < _$rapyd$_Iter.length; _$rapyd$_Index++) {
                    k = _$rapyd$_Iter[_$rapyd$_Index];
                    _$rapyd$_Result[k] = (temp.get(k));
                }
                return _$rapyd$_Result;
            })();
            url_query = parse_url_params();
            var _$rapyd$_Iter0 = _$rapyd$_Iterable(url_query);
            for (var _$rapyd$_Index0 = 0; _$rapyd$_Index0 < _$rapyd$_Iter0.length; _$rapyd$_Index0++) {
                key = _$rapyd$_Iter0[_$rapyd$_Index0];
                query[key] = url_query[key];
            }
            ajax("interface-data/init", on_library_loaded, on_library_load_progress, _$rapyd$_desugar_kwargs({query: query})).send();
        }
        function on_load() {
            if (window.calibre_entry_point === "book list") {
                print("calibre loaded at:", new Date().toString());
                load_book_list();
            }
        }
        window.addEventListener("load", on_load);
    })();
})();