/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core.hash;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.BranchProfile;
import com.oracle.truffle.api.utilities.ConditionProfile;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.BasicObjectNodes;
import org.jruby.truffle.nodes.core.BasicObjectNodesFactory;
import org.jruby.truffle.nodes.core.hash.HashGuards;
import org.jruby.truffle.nodes.core.hash.HashNode;
import org.jruby.truffle.nodes.core.hash.LookupEntryNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.nodes.objects.IsFrozenNode;
import org.jruby.truffle.nodes.objects.IsFrozenNodeGen;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.hash.BucketsStrategy;
import org.jruby.truffle.runtime.hash.Entry;
import org.jruby.truffle.runtime.hash.HashLookupResult;
import org.jruby.truffle.runtime.hash.HashOperations;
import org.jruby.truffle.runtime.hash.PackedArrayStrategy;
import org.jruby.truffle.runtime.layouts.Layouts;

@ImportStatic(value={HashGuards.class})
@NodeChildren(value={@NodeChild(value="hash", type=RubyNode.class), @NodeChild(value="key", type=RubyNode.class), @NodeChild(value="value", type=RubyNode.class), @NodeChild(value="byIdentity", type=RubyNode.class)})
public abstract class SetNode
extends RubyNode {
    @Node.Child
    private HashNode hashNode;
    @Node.Child
    private CallDispatchHeadNode eqlNode;
    @Node.Child
    private BasicObjectNodes.ReferenceEqualNode equalNode;
    @Node.Child
    private LookupEntryNode lookupEntryNode;
    private final ConditionProfile byIdentityProfile = ConditionProfile.createBinaryProfile();
    private final BranchProfile extendProfile = BranchProfile.create();
    private final ConditionProfile strategyProfile = ConditionProfile.createBinaryProfile();
    @Node.Child
    private IsFrozenNode isFrozenNode;
    @Node.Child
    private CallDispatchHeadNode dupNode;
    @Node.Child
    private CallDispatchHeadNode freezeNode;
    private final ConditionProfile frozenProfile = ConditionProfile.createBinaryProfile();
    private final ConditionProfile foundProfile = ConditionProfile.createBinaryProfile();
    private final ConditionProfile bucketCollisionProfile = ConditionProfile.createBinaryProfile();
    private final ConditionProfile appendingProfile = ConditionProfile.createBinaryProfile();
    private final ConditionProfile resizeProfile = ConditionProfile.createBinaryProfile();

    public SetNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
        this.hashNode = new HashNode(context, sourceSection);
        this.eqlNode = DispatchHeadNodeFactory.createMethodCall(context);
        this.equalNode = BasicObjectNodesFactory.ReferenceEqualNodeFactory.create(context, sourceSection, null, null);
    }

    public abstract Object executeSet(VirtualFrame var1, DynamicObject var2, Object var3, Object var4, boolean var5);

    @Specialization(guards={"isNullHash(hash)", "!isRubyString(key)"})
    public Object setNull(VirtualFrame frame, DynamicObject hash, Object key, Object value, boolean byIdentity) {
        Object[] store = PackedArrayStrategy.createStore(this.getContext(), this.hashNode.hash(frame, key), key, value);
        assert (HashOperations.verifyStore(this.getContext(), store, 1, null, null));
        Layouts.HASH.setStore(hash, store);
        Layouts.HASH.setSize(hash, 1);
        Layouts.HASH.setFirstInSequence(hash, null);
        Layouts.HASH.setLastInSequence(hash, null);
        assert (HashOperations.verifyStore(this.getContext(), hash));
        return value;
    }

    @Specialization(guards={"isNullHash(hash)", "byIdentity", "isRubyString(key)"})
    public Object setNullByIdentity(VirtualFrame frame, DynamicObject hash, DynamicObject key, Object value, boolean byIdentity) {
        return this.setNull(frame, hash, key, value, byIdentity);
    }

    @Specialization(guards={"isNullHash(hash)", "!byIdentity", "isRubyString(key)"})
    public Object setNullNotByIdentity(VirtualFrame frame, DynamicObject hash, DynamicObject key, Object value, boolean byIdentity) {
        return this.setNull(frame, hash, this.freezeAndDupIfNeeded(frame, key), value, byIdentity);
    }

    @ExplodeLoop
    @Specialization(guards={"isPackedHash(hash)", "!isRubyString(key)"})
    public Object setPackedArray(VirtualFrame frame, DynamicObject hash, Object key, Object value, boolean byIdentity) {
        assert (HashOperations.verifyStore(this.getContext(), hash));
        int hashed = this.hashNode.hash(frame, key);
        Object[] store = (Object[])Layouts.HASH.getStore(hash);
        int size = Layouts.HASH.getSize(hash);
        for (int n = 0; n < this.getContext().getOptions().HASH_PACKED_ARRAY_MAX; ++n) {
            boolean equal;
            if (n >= size || hashed != PackedArrayStrategy.getHashed(store, n) || !(equal = this.byIdentityProfile.profile(byIdentity) ? this.equalNode.executeReferenceEqual(frame, key, PackedArrayStrategy.getKey(store, n)) : this.eqlNode.callBoolean(frame, key, "eql?", null, PackedArrayStrategy.getKey(store, n)))) continue;
            PackedArrayStrategy.setValue(store, n, value);
            assert (HashOperations.verifyStore(this.getContext(), hash));
            return value;
        }
        this.extendProfile.enter();
        if (this.strategyProfile.profile(size + 1 <= this.getContext().getOptions().HASH_PACKED_ARRAY_MAX)) {
            PackedArrayStrategy.setHashedKeyValue(store, size, hashed, key, value);
            Layouts.HASH.setSize(hash, size + 1);
            return value;
        }
        PackedArrayStrategy.promoteToBuckets(this.getContext(), hash, store, size);
        BucketsStrategy.addNewEntry(this.getContext(), hash, hashed, key, value);
        assert (HashOperations.verifyStore(this.getContext(), hash));
        return value;
    }

    @Specialization(guards={"isPackedHash(hash)", "byIdentity", "isRubyString(key)"})
    public Object setPackedArrayByIdentity(VirtualFrame frame, DynamicObject hash, DynamicObject key, Object value, boolean byIdentity) {
        return this.setPackedArray(frame, hash, key, value, byIdentity);
    }

    @Specialization(guards={"isPackedHash(hash)", "!byIdentity", "isRubyString(key)"})
    public Object setPackedArrayNotByIdentity(VirtualFrame frame, DynamicObject hash, DynamicObject key, Object value, boolean byIdentity) {
        return this.setPackedArray(frame, hash, this.freezeAndDupIfNeeded(frame, key), value, byIdentity);
    }

    @Specialization(guards={"isBucketHash(hash)", "!isRubyString(key)"})
    public Object setBuckets(VirtualFrame frame, DynamicObject hash, Object key, Object value, boolean byIdentity) {
        HashLookupResult result;
        Entry entry;
        assert (HashOperations.verifyStore(this.getContext(), hash));
        if (this.lookupEntryNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.lookupEntryNode = this.insert(new LookupEntryNode(this.getContext(), this.getEncapsulatingSourceSection()));
        }
        if (this.foundProfile.profile((entry = (result = this.lookupEntryNode.lookup(frame, hash, key)).getEntry()) == null)) {
            Entry[] entries = (Entry[])Layouts.HASH.getStore(hash);
            Entry newEntry = new Entry(result.getHashed(), key, value);
            if (this.bucketCollisionProfile.profile(result.getPreviousEntry() == null)) {
                entries[result.getIndex()] = newEntry;
            } else {
                result.getPreviousEntry().setNextInLookup(newEntry);
            }
            Entry lastInSequence = Layouts.HASH.getLastInSequence(hash);
            if (this.appendingProfile.profile(lastInSequence == null)) {
                Layouts.HASH.setFirstInSequence(hash, newEntry);
            } else {
                lastInSequence.setNextInSequence(newEntry);
                newEntry.setPreviousInSequence(lastInSequence);
            }
            Layouts.HASH.setLastInSequence(hash, newEntry);
            int newSize = Layouts.HASH.getSize(hash) + 1;
            Layouts.HASH.setSize(hash, newSize);
            if (this.resizeProfile.profile((double)newSize / (double)entries.length > 0.75)) {
                BucketsStrategy.resize(this.getContext(), hash);
            }
        } else {
            entry.setKeyValue(result.getHashed(), key, value);
        }
        assert (HashOperations.verifyStore(this.getContext(), hash));
        return value;
    }

    @Specialization(guards={"isBucketHash(hash)", "byIdentity", "isRubyString(key)"})
    public Object setBucketsByIdentity(VirtualFrame frame, DynamicObject hash, DynamicObject key, Object value, boolean byIdentity) {
        return this.setBuckets(frame, hash, key, value, byIdentity);
    }

    @Specialization(guards={"isBucketHash(hash)", "!byIdentity", "isRubyString(key)"})
    public Object setBucketsNotByIdentity(VirtualFrame frame, DynamicObject hash, DynamicObject key, Object value, boolean byIdentity) {
        return this.setBuckets(frame, hash, this.freezeAndDupIfNeeded(frame, key), value, byIdentity);
    }

    private Object freezeAndDupIfNeeded(VirtualFrame frame, DynamicObject key) {
        if (this.isFrozenNode == null) {
            CompilerDirectives.transferToInterpreter();
            this.isFrozenNode = this.insert(IsFrozenNodeGen.create(this.getContext(), this.getSourceSection(), null));
        }
        if (!this.frozenProfile.profile(this.isFrozenNode.executeIsFrozen(key))) {
            if (this.dupNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.dupNode = this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
            }
            if (this.freezeNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.freezeNode = this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
            }
            return this.freezeNode.call(frame, this.dupNode.call(frame, key, "dup", null, new Object[0]), "freeze", null, new Object[0]);
        }
        return key;
    }
}

