/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.load;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyFile;
import org.jruby.RubyHash;
import org.jruby.RubyString;
import org.jruby.ir.IRScope;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.ClassExtensionLibrary;
import org.jruby.runtime.load.CompiledScriptLoader;
import org.jruby.runtime.load.DebugLog;
import org.jruby.runtime.load.Library;
import org.jruby.runtime.load.LoadService;
import org.jruby.runtime.load.LoadServiceResourceInputStream;
import org.jruby.util.FileResource;
import org.jruby.util.JRubyFile;
import org.jruby.util.URLResource;

class LibrarySearcher {
    private final LoadService loadService;
    private final Ruby runtime;
    private final Map<String, Library> builtinLibraries;

    public LibrarySearcher(LoadService loadService) {
        this.loadService = loadService;
        this.runtime = loadService.runtime;
        this.builtinLibraries = loadService.builtinLibraries;
    }

    public FoundLibrary findBySearchState(LoadService.SearchState state2) {
        FoundLibrary lib = this.findLibrary(state2.searchFile, state2.suffixType);
        if (lib != null) {
            state2.library = lib;
            state2.setLoadName(lib.getLoadName());
        }
        return lib;
    }

    public FoundLibrary findLibrary(String baseName, LoadService.SuffixType suffixType) {
        for (String suffix : suffixType.getSuffixes()) {
            FoundLibrary library2 = this.findBuiltinLibrary(baseName, suffix);
            if (library2 == null) {
                library2 = this.findResourceLibrary(baseName, suffix);
            }
            if (library2 == null) continue;
            return library2;
        }
        return this.findServiceLibrary(baseName);
    }

    private FoundLibrary findBuiltinLibrary(String name2, String suffix) {
        String namePlusSuffix = name2 + suffix;
        DebugLog.Builtin.logTry(namePlusSuffix);
        if (this.builtinLibraries.containsKey(namePlusSuffix)) {
            DebugLog.Builtin.logFound(namePlusSuffix);
            return new FoundLibrary(this.builtinLibraries.get(namePlusSuffix), namePlusSuffix);
        }
        return null;
    }

    private FoundLibrary findServiceLibrary(String name2) {
        DebugLog.JarExtension.logTry(name2);
        ClassExtensionLibrary extensionLibrary = ClassExtensionLibrary.tryFind(this.runtime, name2);
        if (extensionLibrary != null) {
            DebugLog.JarExtension.logFound(name2);
            return new FoundLibrary(extensionLibrary, name2);
        }
        return null;
    }

    private FoundLibrary findResourceLibrary(String baseName, String suffix) {
        FoundLibrary library2;
        if (baseName.startsWith("./")) {
            return this.findFileResource(baseName, suffix);
        }
        if (baseName.startsWith("../")) {
            return this.findFileResource(baseName, suffix);
        }
        if (baseName.startsWith("~/")) {
            RubyString env_home;
            RubyHash env = (RubyHash)this.runtime.getObject().getConstant("ENV");
            if (env.has_key_p(env_home = this.runtime.newString("HOME")).isFalse()) {
                return null;
            }
            String home2 = env.op_aref(this.runtime.getCurrentContext(), env_home).toString();
            String path2 = home2 + "/" + baseName.substring(2);
            return this.findFileResource(path2, suffix);
        }
        if (LibrarySearcher.isAbsolute(baseName)) {
            return this.findFileResource(baseName, suffix);
        }
        try {
            for (IRubyObject loadPathEntry : this.loadService.loadPath.toJavaArray()) {
                FoundLibrary library3 = this.findFileResourceWithLoadPath(baseName, suffix, this.getPath(loadPathEntry));
                if (library3 == null) continue;
                return library3;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        if (!this.runtime.getCurrentDirectory().startsWith(URLResource.URI_CLASSLOADER) && (library2 = this.findFileResourceWithLoadPath(baseName, suffix, ".")) != null) {
            return null;
        }
        return this.findFileResourceWithLoadPath(baseName, suffix, URLResource.URI_CLASSLOADER);
    }

    private String getPath(IRubyObject loadPathEntry) {
        return RubyFile.get_path(this.runtime.getCurrentContext(), loadPathEntry).asJavaString();
    }

    private FoundLibrary findFileResource(String searchName, String suffix) {
        return this.findFileResourceWithLoadPath(searchName, suffix, null);
    }

    private FoundLibrary findFileResourceWithLoadPath(String searchName, String suffix, String loadPath) {
        String fullPath = loadPath != null ? loadPath + "/" + searchName : searchName;
        String pathWithSuffix = fullPath + suffix;
        DebugLog.Resource.logTry(pathWithSuffix);
        FileResource resource2 = JRubyFile.createResourceAsFile(this.runtime, pathWithSuffix);
        if (resource2.exists()) {
            DebugLog.Resource.logFound(pathWithSuffix);
            String scriptName = this.resolveScriptName(resource2, pathWithSuffix);
            String loadName = this.resolveLoadName(resource2, searchName + suffix);
            return new FoundLibrary(ResourceLibrary.create(searchName, scriptName, resource2), loadName);
        }
        return null;
    }

    private static boolean isAbsolute(String path2) {
        if (path2.startsWith("jar:")) {
            path2 = path2.substring(4);
        }
        if (path2.startsWith("file:")) {
            return true;
        }
        if (path2.startsWith("uri:")) {
            return true;
        }
        return new File(path2).isAbsolute();
    }

    protected String resolveLoadName(FileResource resource2, String ruby18path) {
        return resource2.absolutePath();
    }

    protected String resolveScriptName(FileResource resource2, String ruby18Path) {
        return resource2.absolutePath();
    }

    static class JarResourceLibrary
    extends ResourceLibrary {
        public JarResourceLibrary(String searchName, String scriptName, FileResource resource2) {
            super(searchName, scriptName, resource2);
        }

        @Override
        public void load(Ruby runtime, boolean wrap2) {
            try {
                URL url;
                if (this.location.startsWith(URLResource.URI)) {
                    url = URLResource.getResourceURL(runtime, this.location);
                } else {
                    File f = new File(this.location);
                    if (f.exists() || this.location.contains("!")) {
                        url = f.toURI().toURL();
                        if (this.location.contains("!")) {
                            url = new URL("jar:" + url);
                        }
                    } else {
                        url = new URL(this.location);
                    }
                }
                runtime.getJRubyClassLoader().addURL(url);
            }
            catch (MalformedURLException badUrl) {
                runtime.newIOErrorFromException(badUrl);
            }
            ClassExtensionLibrary serviceExtension = ClassExtensionLibrary.tryFind(runtime, this.searchName);
            if (serviceExtension != null) {
                serviceExtension.load(runtime, wrap2);
            }
        }
    }

    static class ClassResourceLibrary
    extends ResourceLibrary {
        public ClassResourceLibrary(String searchName, String scriptName, FileResource resource2) {
            super(searchName, scriptName, resource2);
        }

        @Override
        public void load(Ruby runtime, boolean wrap2) {
            InputStream is = null;
            try {
                is = new BufferedInputStream(this.resource.inputStream(), 32768);
                IRScope script = CompiledScriptLoader.loadScriptFromFile(runtime, is, null, this.scriptName, false);
                if (script == null) {
                    return;
                }
                script.setFileName(this.scriptName);
                runtime.loadScope(script, wrap2);
            }
            catch (IOException e) {
                throw runtime.newLoadError("no such file to load -- " + this.searchName, this.searchName);
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException ioE) {}
            }
        }
    }

    static class ResourceLibrary
    implements Library {
        protected final String searchName;
        protected final String scriptName;
        protected final FileResource resource;
        protected final String location;

        public static ResourceLibrary create(String searchName, String scriptName, FileResource resource2) {
            String location = resource2.absolutePath();
            if (location.endsWith(".class")) {
                return new ClassResourceLibrary(searchName, scriptName, resource2);
            }
            if (location.endsWith(".jar")) {
                return new JarResourceLibrary(searchName, scriptName, resource2);
            }
            return new ResourceLibrary(searchName, scriptName, resource2);
        }

        public ResourceLibrary(String searchName, String scriptName, FileResource resource2) {
            this.searchName = searchName;
            this.scriptName = scriptName;
            this.location = resource2.absolutePath();
            this.resource = resource2;
        }

        @Override
        public void load(Ruby runtime, boolean wrap2) {
            InputStream ris = null;
            try {
                ris = this.resource.inputStream();
                runtime.loadFile(this.scriptName, new LoadServiceResourceInputStream(ris), wrap2);
            }
            catch (IOException e) {
                throw runtime.newLoadError("no such file to load -- " + this.searchName, this.searchName);
            }
            finally {
                try {
                    if (ris != null) {
                        ris.close();
                    }
                }
                catch (IOException ioE) {}
            }
        }
    }

    static class FoundLibrary
    implements Library {
        private final Library delegate;
        private final String loadName;

        public FoundLibrary(Library delegate, String loadName) {
            this.delegate = delegate;
            this.loadName = loadName;
        }

        @Override
        public void load(Ruby runtime, boolean wrap2) throws IOException {
            this.delegate.load(runtime, wrap2);
        }

        public String getLoadName() {
            return this.loadName;
        }
    }
}

