/* pantheon-files-core.vapi generated by valac 0.30.0, do not modify. */

[CCode (cprefix = "Marlin", lower_case_cprefix = "marlin_")]
namespace Marlin {
	namespace Plugins {
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public abstract class Base {
			public Gtk.Widget window;
			public Base ();
			public virtual void context_menu (Gtk.Widget? widget, GLib.List<weak GOF.File> files);
			public virtual void directory_loaded (void* data);
			public void interface_loaded (Gtk.Widget? widget);
			public virtual void ui (Gtk.UIManager? widget);
			public virtual void update_file_info (GOF.File file);
			public virtual void update_sidebar (Gtk.Widget widget);
		}
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public abstract class AbstractSidebar : Gtk.ScrolledWindow {
		public enum Column {
			NAME,
			URI,
			DRIVE,
			VOLUME,
			MOUNT,
			ROW_TYPE,
			ICON,
			INDEX,
			EJECT,
			NO_EJECT,
			BOOKMARK,
			TOOLTIP,
			EJECT_ICON,
			SHOW_SPINNER,
			SPINNER_PULSE,
			FREE_SPACE,
			DISK_SIZE,
			PLUGIN_CALLBACK,
			COUNT
		}
		protected Gtk.Box content_box;
		protected Gtk.TreeRowReference network_category_reference;
		protected Gtk.TreeStore store;
		public AbstractSidebar ();
		public void add_extra_item (Gtk.TreeRowReference category, string text, string tooltip, GLib.Icon? icon, Marlin.PluginCallbackFunc? cb);
		public void add_extra_network_item (string text, string tooltip, GLib.Icon? icon, Marlin.PluginCallbackFunc? cb);
		protected abstract Gtk.TreeIter add_place (Marlin.PlaceType place_type, Gtk.TreeIter? parent, string name, GLib.Icon? icon, string? uri, GLib.Drive? drive, GLib.Volume? volume, GLib.Mount? mount, uint index, string tooltip);
		protected void init ();
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public class PluginManager : GLib.Object {
		[Deprecated (replacement = "Marlin.PluginManager.menuitem_references")]
		public GLib.List<Gtk.Widget>? menus;
		public PluginManager (string plugin_dir);
		public void directory_loaded (void* path);
		public Gee.List<string> get_available_plugins ();
		public void hook_context_menu (Gtk.Widget menu, GLib.List<weak GOF.File> files);
		public void interface_loaded (Gtk.Widget win);
		public void load_plugins ();
		public void ui (Gtk.UIManager data);
		public void update_file_info (GOF.File file);
		public void update_sidebar (Gtk.Widget widget);
		public Gee.List<Gtk.Widget> menuitem_references { get; private set; }
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public enum PlaceType {
		BUILT_IN,
		MOUNTED_VOLUME,
		BOOKMARK,
		BOOKMARKS_CATEGORY,
		PERSONAL_CATEGORY,
		STORAGE_CATEGORY,
		NETWORK_CATEGORY,
		PLUGIN_ITEM
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public delegate void PluginCallbackFunc (Gtk.Widget widget);
}
[CCode (cprefix = "GOF", lower_case_cprefix = "gof_", ref_function = "gof_file_ref", unref_function = "gof_file_unref")]
namespace GOF {
	namespace Directory {
		[CCode (cheader_filename = "pantheon-files-core.h")]
		public class Async : GLib.Object {
			public enum State {
				NOT_LOADED,
				LOADING,
				LOADED
			}
			public delegate void GOFFileLoadedFunc (GOF.File file);
			public bool can_load;
			public GOF.File file;
			public uint files_count;
			public bool has_mounts;
			public bool has_trash_dirs;
			public int icon_size;
			public bool is_local;
			public bool is_recent;
			public bool is_trash;
			public GLib.File location;
			public string longest_file_name;
			public bool permission_denied;
			public GLib.File? selected_file;
			public GOF.Directory.Async.State state;
			public bool track_longest_name;
			public bool uri_contain_keypath_icons;
			public void block_monitor ();
			public static GOF.Directory.Async? cache_lookup (GLib.File? file);
			public static GOF.Directory.Async? cache_lookup_parent (GLib.File file);
			public void cancel ();
			public bool check_network ();
			public void clear_directory_info ();
			public GOF.File file_cache_find_or_insert (GLib.File file, bool update_hash = false);
			public void file_hash_add_file (GOF.File gof);
			public GOF.File? file_hash_lookup_location (GLib.File? location);
			public static GOF.Directory.Async from_file (GOF.File gof);
			public static GOF.Directory.Async from_gfile (GLib.File file);
			public GLib.File get_parent ();
			public unowned GLib.List<weak GOF.File>? get_sorted_dirs ();
			public bool has_parent ();
			public bool is_empty ();
			public bool is_loaded ();
			public bool is_loading ();
			public void load (GOF.Directory.Async.GOFFileLoadedFunc? file_loaded_func = null);
			public void load_hiddens ();
			public async void mount_mountable () throws GLib.Error;
			public static void notify_files_added (GLib.List<GLib.File> files);
			public static void notify_files_changed (GLib.List<GLib.File> files);
			public static void notify_files_moved (GLib.List<GLib.Array<GLib.File>> files);
			public static void notify_files_removed (GLib.List<GLib.File> files);
			public bool purge_dir_from_cache ();
			public void queue_load_thumbnails (int size);
			public bool remove_dir_from_cache ();
			public static void remove_file_from_cache (GOF.File gof);
			public void unblock_monitor ();
			public void update_desktop_files ();
			public void update_files ();
			public bool freeze_update { get; set; }
			public bool is_cancelled { get; }
			public bool is_ready { get; private set; }
			public signal void done_loading ();
			public signal void file_added (GOF.File file);
			public signal void file_changed (GOF.File file);
			public signal void file_deleted (GOF.File file);
			public signal void file_loaded (GOF.File file);
			public signal void icon_changed (GOF.File file);
			public signal void need_reload ();
			public signal void thumbs_loaded ();
		}
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public abstract class AbstractSlot : GLib.Object {
		protected Gtk.Box content_box;
		protected Gtk.Box extra_location_widgets;
		protected int slot_number;
		protected int width;
		public AbstractSlot ();
		public void add_extra_widget (Gtk.Widget widget);
		public abstract void cancel ();
		public abstract void close ();
		public virtual Gtk.Widget get_content_box ();
		public abstract unowned GOF.AbstractSlot? get_current_slot ();
		public virtual bool get_realized ();
		public virtual string? get_root_uri ();
		public abstract unowned GLib.List<weak GOF.File>? get_selected_files ();
		public virtual string? get_tip_uri ();
		public abstract void grab_focus ();
		protected void init ();
		protected abstract void make_view ();
		public abstract void reload (bool non_local_only = false);
		public abstract void select_first_for_empty_selection ();
		public abstract void select_glib_files (GLib.List<GLib.File> locations, GLib.File? focus_location);
		public abstract void set_active_state (bool set_active);
		public virtual bool set_all_selected (bool all_selected);
		public abstract void user_path_change_request (GLib.File loc, bool allow_mode_change = true);
		public virtual void zoom_in ();
		public virtual void zoom_normal ();
		public virtual void zoom_out ();
		public bool can_create { get; }
		public GOF.Directory.Async? directory { get; protected set; }
		public GLib.File location { get; }
		public virtual bool locked_focus { get; }
		public string uri { get; }
		public signal void active (bool scroll = true);
		public signal void inactive ();
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public class CallWhenReady : GLib.Object {
		public delegate void call_when_ready_func (GLib.List<GOF.File> files);
		public GLib.List<GOF.File> files;
		public CallWhenReady (GLib.List<GOF.File> _files, GOF.CallWhenReady.call_when_ready_func? _f = null);
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public class Preferences : GLib.Object {
		public bool pref_confirm_trash;
		public string pref_date_format;
		public bool pref_force_icon_size;
		public bool pref_interpret_desktop_files;
		public bool pref_show_hidden_files;
		public const string TAGS_COLORS[10];
		public Preferences ();
		public static GOF.Preferences get_default ();
		public bool confirm_trash { get; set; }
		public string date_format { get; set; }
		public bool force_icon_size { get; set; }
		public bool interpret_desktop_files { get; set; }
		public bool show_hidden_files { get; set; }
	}
	[CCode (cheader_filename = "pantheon-files-core.h")]
	public static GOF.Preferences? preferences;
}
[CCode (cheader_filename = "pantheon-files-core.h")]
public static Marlin.PluginManager plugins;
