/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient.commons.panels;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pdfsam.guiclient.business.ClosableTabbedPanelAdder;
import org.pdfsam.guiclient.commons.components.CommonComponentsFactory;
import org.pdfsam.guiclient.commons.components.sharedchooser.SharedJFileChooser;
import org.pdfsam.guiclient.commons.components.sharedchooser.SharedJFileChooserType;
import org.pdfsam.guiclient.commons.dnd.droppers.JVisualMultiSelectionDropper;
import org.pdfsam.guiclient.commons.panels.CloseableTabbedPane;
import org.pdfsam.guiclient.commons.panels.JVisualPdfPageSelectionPanel;
import org.pdfsam.guiclient.dto.PdfFile;
import org.pdfsam.guiclient.dto.VisualPageListItem;

public class JVisualMultiSelectionPanel
extends JPanel {
    private static final long serialVersionUID = -1794723446687409093L;
    private final JButton openButton = CommonComponentsFactory.getInstance().createButton(3);
    private final CloseableTabbedPane inputTabbedPanel = new CloseableTabbedPane();
    private final JPanel topPanel = new JPanel();
    private JPanel currentTopPanel = new JPanel();
    private ClosableTabbedPanelAdder tabsAdder;
    private DropTarget tabbedPanelDropTarget;

    public JVisualMultiSelectionPanel() {
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        this.topPanel.setLayout(new BoxLayout(this.topPanel, 2));
        this.topPanel.setPreferredSize(new Dimension(400, 30));
        this.topPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.topPanel.add(this.openButton);
        this.topPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.topPanel.add(this.currentTopPanel);
        ImageIcon normal = new ImageIcon(this.getClass().getResource("/images/crossclose.png"));
        ImageIcon hover = new ImageIcon(this.getClass().getResource("/images/crosscloseover.png"));
        ImageIcon pressed = new ImageIcon(this.getClass().getResource("/images/crossclosedown.png"));
        this.inputTabbedPanel.setTabLayoutPolicy(0);
        this.inputTabbedPanel.setCloseIcons(normal, hover, pressed);
        this.inputTabbedPanel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                CloseableTabbedPane source = (CloseableTabbedPane)e.getSource();
                Component selected = source.getSelectedComponent();
                JPanel subTopPanel = new JPanel();
                if (selected != null) {
                    subTopPanel = ((JVisualPdfPageSelectionPanel)selected).getTopPanel();
                }
                JVisualMultiSelectionPanel.this.topPanel.remove(JVisualMultiSelectionPanel.this.currentTopPanel);
                JVisualMultiSelectionPanel.this.currentTopPanel = subTopPanel;
                JVisualMultiSelectionPanel.this.topPanel.add(JVisualMultiSelectionPanel.this.currentTopPanel);
                JVisualMultiSelectionPanel.this.topPanel.revalidate();
                JVisualMultiSelectionPanel.this.topPanel.repaint();
            }
        });
        this.tabsAdder = new ClosableTabbedPanelAdder(this.inputTabbedPanel);
        JVisualMultiSelectionDropper dropper = new JVisualMultiSelectionDropper(this.tabsAdder);
        this.tabbedPanelDropTarget = new DropTarget(this.inputTabbedPanel, dropper);
        this.openButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fileChooser = SharedJFileChooser.getInstance(SharedJFileChooserType.PDF_FILE, 0);
                fileChooser.setMultiSelectionEnabled(true);
                if (fileChooser.showOpenDialog(JVisualMultiSelectionPanel.this) == 0) {
                    File[] chosenFiles = fileChooser.getSelectedFiles();
                    JVisualMultiSelectionPanel.this.tabsAdder.addTabs(chosenFiles);
                }
            }
        });
        GridBagConstraints topConstraints = new GridBagConstraints();
        topConstraints.fill = 1;
        topConstraints.gridx = 0;
        topConstraints.gridy = 0;
        topConstraints.gridwidth = 3;
        topConstraints.gridheight = 1;
        topConstraints.insets = new Insets(5, 5, 5, 5);
        topConstraints.weightx = 1.0;
        topConstraints.weighty = 0.0;
        this.add((Component)this.topPanel, topConstraints);
        GridBagConstraints thumbConstraints = new GridBagConstraints();
        thumbConstraints.fill = 1;
        thumbConstraints.gridx = 0;
        thumbConstraints.gridy = 1;
        thumbConstraints.gridwidth = 3;
        thumbConstraints.gridheight = 2;
        thumbConstraints.insets = new Insets(5, 5, 5, 5);
        thumbConstraints.weightx = 1.0;
        thumbConstraints.weighty = 1.0;
        this.add((Component)this.inputTabbedPanel, thumbConstraints);
    }

    public DropTarget getTabbedPanelDropTarget() {
        return this.tabbedPanelDropTarget;
    }

    public void setTabbedPanelDropTarget(DropTarget tabbedPanelDropTarget) {
        this.tabbedPanelDropTarget = tabbedPanelDropTarget;
    }

    public VisualPageListItem[] getSelectedElements() {
        Component currentTab;
        VisualPageListItem[] retVal = new VisualPageListItem[]{};
        if (this.inputTabbedPanel != null && this.inputTabbedPanel.getTabCount() > 0 && (currentTab = this.inputTabbedPanel.getSelectedComponent()) != null) {
            retVal = ((JVisualPdfPageSelectionPanel)currentTab).getSelectedElements();
        }
        return retVal;
    }

    public PdfFile[] getInputDocuments() {
        PdfFile[] retVal = null;
        if (this.inputTabbedPanel != null && this.inputTabbedPanel.getTabCount() > 0) {
            retVal = new PdfFile[this.inputTabbedPanel.getComponentCount()];
            for (int i = 0; i < this.inputTabbedPanel.getComponentCount(); ++i) {
                JVisualPdfPageSelectionPanel currentPanel = (JVisualPdfPageSelectionPanel)this.inputTabbedPanel.getComponentAt(i);
                retVal[i] = new PdfFile(currentPanel.getSelectedPdfDocument(), currentPanel.getSelectedPdfDocumentPassword());
            }
        }
        return retVal;
    }

    public JButton getCurrentZoomOutButton() {
        Component currentTab;
        JButton retVal = null;
        if (this.inputTabbedPanel != null && this.inputTabbedPanel.getTabCount() > 0 && (currentTab = this.inputTabbedPanel.getSelectedComponent()) != null) {
            retVal = ((JVisualPdfPageSelectionPanel)currentTab).getZoomOutButton();
        }
        return retVal;
    }

    public JButton getCurrentZoomInButton() {
        Component currentTab;
        JButton retVal = null;
        if (this.inputTabbedPanel != null && this.inputTabbedPanel.getTabCount() > 0 && (currentTab = this.inputTabbedPanel.getSelectedComponent()) != null) {
            retVal = ((JVisualPdfPageSelectionPanel)currentTab).getZoomInButton();
        }
        return retVal;
    }

    public void setOutputPathPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.tabsAdder != null) {
            this.tabsAdder.setOutputPathPropertyChangeListener(propertyChangeListener);
        }
    }

    public JButton getOpenButton() {
        return this.openButton;
    }

    public JPanel getCurrentTopPanel() {
        return this.currentTopPanel;
    }

    public void addTabs(List<File> fileList) {
        if (fileList != null && fileList.size() > 0) {
            this.tabsAdder.addTabs(fileList);
        }
    }

    public void addTab(File file, String password) {
        if (file != null) {
            this.tabsAdder.addTab(file, password);
        }
    }

    public void addTab(File file) {
        this.addTab(file, null);
    }

    public void removeAllTabs() {
        this.inputTabbedPanel.removeAll();
    }
}

