/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.dom;

import de.intarsys.tools.dom.PACKAGE;
import de.intarsys.tools.stream.StreamTools;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class LoggingErrorHander
implements ErrorHandler {
    private final Logger log;
    private static int filesCounter = 1;
    private int fileNumber = -1;
    private InputStream fileInputStream;

    public LoggingErrorHander() {
        this(null);
    }

    public LoggingErrorHander(Logger logger) {
        this.log = logger == null ? PACKAGE.Log : logger;
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        this.log.log(Level.SEVERE, sAXParseException.getLocalizedMessage());
        this.logFile();
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.log.log(Level.SEVERE, sAXParseException.getLocalizedMessage());
        this.logFile();
    }

    private String getFileContent() {
        try {
            return StreamTools.toString(this.getFileInputStream(), "UTF-8");
        }
        catch (IOException iOException) {
            return iOException.getLocalizedMessage();
        }
    }

    public Level getFileContentLogLevel() {
        return Level.FINE;
    }

    public InputStream getFileInputStream() {
        return this.fileInputStream;
    }

    private void logFile() {
        if (this.log.isLoggable(this.getFileContentLogLevel()) && this.fileInputStream != null) {
            if (this.fileNumber != -1) {
                this.log.log(this.getFileContentLogLevel(), "file number #" + this.fileNumber + " was logged above");
            } else {
                this.fileNumber = filesCounter++;
                this.log.log(this.getFileContentLogLevel(), "file number #" + this.fileNumber + ", related to the error above:\n" + this.getFileContent());
            }
        }
    }

    public void setFileInputStream(InputStream inputStream) {
        this.fileInputStream = inputStream;
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXException {
        this.log.log(Level.WARNING, sAXParseException.getLocalizedMessage());
    }
}

