/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.geo3d;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.apache.lucene.geo3d.GeoCompositeMembershipShape;
import org.apache.lucene.geo3d.GeoConvexPolygon;
import org.apache.lucene.geo3d.GeoMembershipShape;
import org.apache.lucene.geo3d.GeoPoint;
import org.apache.lucene.geo3d.PlanetModel;
import org.apache.lucene.geo3d.SidedPlane;
import org.apache.lucene.geo3d.Vector;

public class GeoPolygonFactory {
    private GeoPolygonFactory() {
    }

    public static GeoMembershipShape makeGeoPolygon(PlanetModel planetModel, List<GeoPoint> pointList, int convexPointIndex) {
        return GeoPolygonFactory.buildPolygonShape(planetModel, pointList, convexPointIndex, GeoPolygonFactory.getLegalIndex(convexPointIndex + 1, pointList.size()), new SidedPlane((Vector)pointList.get(GeoPolygonFactory.getLegalIndex(convexPointIndex - 1, pointList.size())), (Vector)pointList.get(convexPointIndex), pointList.get(GeoPolygonFactory.getLegalIndex(convexPointIndex + 1, pointList.size()))), false);
    }

    public static GeoMembershipShape buildPolygonShape(PlanetModel planetModel, List<GeoPoint> pointsList, int startPointIndex, int endPointIndex, SidedPlane startingEdge, boolean isInternalEdge) {
        boolean returnEdgeInternalBoundary;
        GeoCompositeMembershipShape rval = new GeoCompositeMembershipShape();
        ArrayList<GeoPoint> recursionList = new ArrayList<GeoPoint>();
        ArrayList<GeoPoint> currentList = new ArrayList<GeoPoint>();
        BitSet internalEdgeList = new BitSet();
        ArrayList<SidedPlane> currentPlanes = new ArrayList<SidedPlane>();
        currentList.add(pointsList.get(startPointIndex));
        currentList.add(pointsList.get(endPointIndex));
        internalEdgeList.set(currentPlanes.size(), isInternalEdge);
        currentPlanes.add(startingEdge);
        for (int i = 0; i < pointsList.size() - 2; ++i) {
            GeoPoint newPoint = pointsList.get(GeoPolygonFactory.getLegalIndex(i + endPointIndex + 1, pointsList.size()));
            if (GeoPolygonFactory.isWithin(newPoint, currentPlanes)) {
                SidedPlane newBoundary = new SidedPlane((Vector)currentList.get(currentList.size() - 2), (Vector)newPoint, (Vector)currentList.get(currentList.size() - 1));
                SidedPlane returnBoundary = new SidedPlane((Vector)currentList.get(currentList.size() - 1), (Vector)currentList.get(0), newPoint);
                boolean pointInside = false;
                for (int j = i + 1; j < pointsList.size() - 2; ++j) {
                    GeoPoint checkPoint = pointsList.get(GeoPolygonFactory.getLegalIndex(j + endPointIndex + 1, pointsList.size()));
                    boolean isInside = true;
                    if (isInside && !newBoundary.isWithin(checkPoint)) {
                        isInside = false;
                    }
                    if (isInside && !returnBoundary.isWithin(checkPoint)) {
                        isInside = false;
                    }
                    if (isInside) {
                        for (SidedPlane plane : currentPlanes) {
                            if (plane.isWithin(checkPoint)) continue;
                            isInside = false;
                            break;
                        }
                    }
                    if (!isInside) continue;
                    pointInside = true;
                    break;
                }
                if (!pointInside) {
                    boolean isInternalBoundary;
                    boolean bl = isInternalBoundary = recursionList.size() > 0;
                    if (isInternalBoundary) {
                        recursionList.add(newPoint);
                        recursionList.add((GeoPoint)currentList.get(currentList.size() - 1));
                        if (recursionList.size() == pointsList.size()) {
                            throw new IllegalArgumentException("Polygon is illegal; cannot be decomposed into convex parts");
                        }
                        SidedPlane otherSideNewBoundary = new SidedPlane(newBoundary);
                        rval.addShape(GeoPolygonFactory.buildPolygonShape(planetModel, recursionList, recursionList.size() - 2, recursionList.size() - 1, otherSideNewBoundary, true));
                        recursionList.clear();
                    }
                    currentList.add(newPoint);
                    internalEdgeList.set(currentPlanes.size(), isInternalBoundary);
                    currentPlanes.add(newBoundary);
                    continue;
                }
                recursionList.add(newPoint);
                continue;
            }
            recursionList.add(newPoint);
        }
        boolean bl = returnEdgeInternalBoundary = recursionList.size() > 0;
        if (returnEdgeInternalBoundary) {
            recursionList.add((GeoPoint)currentList.get(0));
            recursionList.add((GeoPoint)currentList.get(currentList.size() - 1));
            if (recursionList.size() == pointsList.size()) {
                throw new IllegalArgumentException("Polygon is illegal; cannot be decomposed into convex parts");
            }
            SidedPlane newBoundary = new SidedPlane((Vector)currentList.get(currentList.size() - 2), (Vector)currentList.get(0), (Vector)currentList.get(currentList.size() - 1));
            SidedPlane otherSideNewBoundary = new SidedPlane(newBoundary);
            rval.addShape(GeoPolygonFactory.buildPolygonShape(planetModel, recursionList, recursionList.size() - 2, recursionList.size() - 1, otherSideNewBoundary, true));
            recursionList.clear();
        }
        rval.addShape(new GeoConvexPolygon(planetModel, currentList, internalEdgeList, returnEdgeInternalBoundary));
        return rval;
    }

    protected static boolean isWithin(GeoPoint newPoint, List<SidedPlane> currentPlanes) {
        for (SidedPlane p : currentPlanes) {
            if (p.isWithin(newPoint)) continue;
            return false;
        }
        return true;
    }

    protected static int getLegalIndex(int index, int size) {
        while (index < 0) {
            index += size;
        }
        while (index >= size) {
            index -= size;
        }
        return index;
    }
}

