/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.translog;

import java.io.Closeable;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TwoPhaseCommit;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.CollectionUtil;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.ReleasablePagedBytesReference;
import org.elasticsearch.common.io.stream.ReleasableBytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.Callback;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.FutureUtils;
import org.elasticsearch.common.util.concurrent.ReleasableLock;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.IndexShardComponent;
import org.elasticsearch.index.translog.BufferedChecksumStreamInput;
import org.elasticsearch.index.translog.BufferedChecksumStreamOutput;
import org.elasticsearch.index.translog.ChannelReference;
import org.elasticsearch.index.translog.Checkpoint;
import org.elasticsearch.index.translog.ImmutableTranslogReader;
import org.elasticsearch.index.translog.MultiSnapshot;
import org.elasticsearch.index.translog.TranslogConfig;
import org.elasticsearch.index.translog.TranslogCorruptedException;
import org.elasticsearch.index.translog.TranslogException;
import org.elasticsearch.index.translog.TranslogReader;
import org.elasticsearch.index.translog.TranslogStats;
import org.elasticsearch.index.translog.TranslogWriter;
import org.elasticsearch.index.translog.TruncatedTranslogException;
import org.elasticsearch.threadpool.ThreadPool;

public class Translog
extends AbstractIndexShardComponent
implements IndexShardComponent,
Closeable,
TwoPhaseCommit {
    public static final String TRANSLOG_GENERATION_KEY = "translog_generation";
    public static final String TRANSLOG_UUID_KEY = "translog_uuid";
    public static final String TRANSLOG_FILE_PREFIX = "translog-";
    public static final String TRANSLOG_FILE_SUFFIX = ".tlog";
    public static final String CHECKPOINT_SUFFIX = ".ckp";
    public static final String CHECKPOINT_FILE_NAME = "translog.ckp";
    static final Pattern PARSE_STRICT_ID_PATTERN = Pattern.compile("^translog-(\\d+)(\\.tlog)$");
    private final List<ImmutableTranslogReader> recoveredTranslogs;
    private volatile ScheduledFuture<?> syncScheduler;
    private final Set<View> outstandingViews = ConcurrentCollections.newConcurrentSet();
    private BigArrays bigArrays;
    protected final ReleasableLock readLock;
    protected final ReleasableLock writeLock;
    private final Path location;
    private TranslogWriter current;
    private volatile ImmutableTranslogReader currentCommittingTranslog;
    private volatile long lastCommittedTranslogFileGeneration = -1L;
    private final AtomicBoolean closed = new AtomicBoolean();
    private final TranslogConfig config;
    private final String translogUUID;
    private Callback<View> onViewClose = new Callback<View>(){

        @Override
        public void handle(View view) {
            Translog.this.logger.trace("closing view starting at translog [{}]", view.minTranslogGeneration());
            boolean removed = Translog.this.outstandingViews.remove(view);
            assert (removed) : "View was never set but was supposed to be removed";
        }
    };

    public Translog(TranslogConfig config) throws IOException {
        super(config.getShardId(), config.getIndexSettings());
        this.config = config;
        TranslogGeneration translogGeneration = config.getTranslogGeneration();
        this.translogUUID = translogGeneration == null || translogGeneration.translogUUID == null ? Strings.randomBase64UUID() : translogGeneration.translogUUID;
        this.bigArrays = config.getBigArrays();
        ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
        this.readLock = new ReleasableLock(rwl.readLock());
        this.writeLock = new ReleasableLock(rwl.writeLock());
        this.location = config.getTranslogPath();
        Files.createDirectories(this.location, new FileAttribute[0]);
        if (config.getSyncInterval().millis() > 0L && config.getThreadPool() != null) {
            this.syncScheduler = config.getThreadPool().schedule(config.getSyncInterval(), "same", new Sync());
        }
        try {
            if (translogGeneration != null) {
                Checkpoint checkpoint = Checkpoint.read(this.location.resolve(CHECKPOINT_FILE_NAME));
                this.recoveredTranslogs = this.recoverFromFiles(translogGeneration, checkpoint);
                if (this.recoveredTranslogs.isEmpty()) {
                    throw new IllegalStateException("at least one reader must be recovered");
                }
                this.current = this.createWriter(checkpoint.generation + 1L);
                this.lastCommittedTranslogFileGeneration = translogGeneration.translogFileGeneration;
            } else {
                this.recoveredTranslogs = Collections.EMPTY_LIST;
                IOUtils.rm((Path[])new Path[]{this.location});
                this.logger.debug("wipe translog location - creating new translog", new Object[0]);
                Files.createDirectories(this.location, new FileAttribute[0]);
                long generation = 1L;
                Checkpoint checkpoint = new Checkpoint(0L, 0, 1L);
                Checkpoint.write(this.location.resolve(CHECKPOINT_FILE_NAME), checkpoint, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW);
                this.current = this.createWriter(1L);
                this.lastCommittedTranslogFileGeneration = -1L;
            }
        }
        catch (Throwable t) {
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.currentCommittingTranslog, this.current});
            throw t;
        }
    }

    public static void upgradeLegacyTranslog(ESLogger logger, TranslogConfig config) throws IOException {
        Path translogPath = config.getTranslogPath();
        TranslogGeneration translogGeneration = config.getTranslogGeneration();
        if (translogGeneration == null) {
            throw new IllegalArgumentException("TranslogGeneration must be set in order to upgrade");
        }
        if (translogGeneration.translogUUID != null) {
            throw new IllegalArgumentException("TranslogGeneration has a non-null UUID - index must have already been upgraded");
        }
        try {
            if (Checkpoint.read(translogPath.resolve(CHECKPOINT_FILE_NAME)) != null) {
                throw new IllegalStateException("translog.ckp file already present, translog is already upgraded");
            }
        }
        catch (FileNotFoundException | NoSuchFileException ex) {
            logger.debug("upgrading translog - no checkpoint found", new Object[0]);
        }
        final Pattern parseLegacyIdPattern = Pattern.compile("^translog-(\\d+)((\\.recovering))?$");
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(translogPath, (DirectoryStream.Filter<? super Path>)new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path entry) throws IOException {
                Matcher matcher = parseLegacyIdPattern.matcher(entry.getFileName().toString());
                if (!matcher.matches()) {
                    Matcher newIdMatcher = PARSE_STRICT_ID_PATTERN.matcher(entry.getFileName().toString());
                    return newIdMatcher.matches();
                }
                return true;
            }
        });){
            long generation;
            long latestGeneration = -1L;
            ArrayList<PathWithGeneration> filesToUpgrade = new ArrayList<PathWithGeneration>();
            for (Path path : stream) {
                Matcher matcher = parseLegacyIdPattern.matcher(path.getFileName().toString());
                if (matcher.matches()) {
                    generation = Long.parseLong(matcher.group(1));
                    if (generation >= translogGeneration.translogFileGeneration) {
                        latestGeneration = Math.max(translogGeneration.translogFileGeneration, generation);
                    }
                    filesToUpgrade.add(new PathWithGeneration(path, generation));
                    continue;
                }
                Matcher strict_matcher = PARSE_STRICT_ID_PATTERN.matcher(path.getFileName().toString());
                if (!strict_matcher.matches()) continue;
                throw new IllegalStateException("non-legacy translog file [" + path.getFileName().toString() + "] found on a translog that wasn't upgraded yet");
            }
            if (latestGeneration < translogGeneration.translogFileGeneration) {
                throw new IllegalStateException("latest found translog has a lower generation that the excepcted uncommitted " + translogGeneration.translogFileGeneration + " > " + latestGeneration);
            }
            CollectionUtil.timSort(filesToUpgrade, (Comparator)new Comparator<PathWithGeneration>(){

                @Override
                public int compare(PathWithGeneration o1, PathWithGeneration o2) {
                    long gen1 = o1.getGeneration();
                    long gen2 = o2.getGeneration();
                    return Long.compare(gen1, gen2);
                }
            });
            for (PathWithGeneration pathAndGeneration : filesToUpgrade) {
                Checkpoint checkpoint;
                Path path = pathAndGeneration.getPath();
                generation = pathAndGeneration.getGeneration();
                Path target = path.resolveSibling(Translog.getFilename(generation));
                logger.debug("upgrading translog copy file from {} to {}", path, target);
                Files.move(path, target, StandardCopyOption.ATOMIC_MOVE);
                logger.debug("write commit point for {}", target);
                if (generation == latestGeneration) {
                    checkpoint = new Checkpoint(Files.size(translogPath.resolve(Translog.getFilename(latestGeneration))), -1, latestGeneration);
                    Checkpoint.write(translogPath.resolve(CHECKPOINT_FILE_NAME), checkpoint, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW);
                    continue;
                }
                checkpoint = new Checkpoint(Files.size(target), -1, generation);
                Checkpoint.write(translogPath.resolve(Translog.getCommitCheckpointFileName(generation)), checkpoint, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW);
            }
            IOUtils.fsync((Path)translogPath, (boolean)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ArrayList<ImmutableTranslogReader> recoverFromFiles(TranslogGeneration translogGeneration, Checkpoint checkpoint) throws IOException {
        boolean tempFileRenamed;
        Path tempFile;
        ArrayList<ImmutableTranslogReader> foundTranslogs;
        block27: {
            boolean success = false;
            foundTranslogs = new ArrayList<ImmutableTranslogReader>();
            tempFile = Files.createTempFile(this.location, TRANSLOG_FILE_PREFIX, TRANSLOG_FILE_SUFFIX, new FileAttribute[0]);
            tempFileRenamed = false;
            try {
                try (ReleasableLock lock = this.writeLock.acquire();){
                    this.logger.debug("open uncommitted translog checkpoint {}", checkpoint);
                    String checkpointTranslogFile = Translog.getFilename(checkpoint.generation);
                    for (long i = translogGeneration.translogFileGeneration; i < checkpoint.generation; ++i) {
                        Path committedTranslogFile = this.location.resolve(Translog.getFilename(i));
                        if (!Files.exists(committedTranslogFile, new LinkOption[0])) {
                            throw new IllegalStateException("translog file doesn't exist with generation: " + i + " lastCommitted: " + this.lastCommittedTranslogFileGeneration + " checkpoint: " + checkpoint.generation + " - translog ids must be consecutive");
                        }
                        ImmutableTranslogReader reader = this.openReader(committedTranslogFile, Checkpoint.read(this.location.resolve(Translog.getCommitCheckpointFileName(i))));
                        foundTranslogs.add(reader);
                        this.logger.debug("recovered local translog from checkpoint {}", checkpoint);
                    }
                    foundTranslogs.add(this.openReader(this.location.resolve(checkpointTranslogFile), checkpoint));
                    Path commitCheckpoint = this.location.resolve(Translog.getCommitCheckpointFileName(checkpoint.generation));
                    if (Files.exists(commitCheckpoint, new LinkOption[0])) {
                        Checkpoint checkpointFromDisk = Checkpoint.read(commitCheckpoint);
                        if (!checkpoint.equals(checkpointFromDisk)) {
                            throw new IllegalStateException("Checkpoint file " + commitCheckpoint.getFileName() + " already exists but has corrupted content expected: " + checkpoint + " but got: " + checkpointFromDisk);
                        }
                    } else {
                        Files.copy(this.location.resolve(CHECKPOINT_FILE_NAME), tempFile, StandardCopyOption.REPLACE_EXISTING);
                        IOUtils.fsync((Path)tempFile, (boolean)false);
                        Files.move(tempFile, commitCheckpoint, StandardCopyOption.ATOMIC_MOVE);
                        tempFileRenamed = true;
                        IOUtils.fsync((Path)commitCheckpoint.getParent(), (boolean)true);
                    }
                    success = true;
                }
                if (success) break block27;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException(foundTranslogs);
                }
                if (!tempFileRenamed) {
                    try {
                        Files.delete(tempFile);
                    }
                    catch (IOException ex) {
                        this.logger.warn("failed to delete temp file {}", ex, tempFile);
                    }
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(foundTranslogs);
        }
        if (!tempFileRenamed) {
            try {
                Files.delete(tempFile);
            }
            catch (IOException ex) {
                this.logger.warn("failed to delete temp file {}", ex, tempFile);
            }
        }
        return foundTranslogs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ImmutableTranslogReader openReader(Path path, Checkpoint checkpoint) throws IOException {
        ImmutableTranslogReader immutableTranslogReader;
        long generation;
        try {
            generation = Translog.parseIdFromFileName(path);
        }
        catch (IllegalArgumentException ex) {
            throw new TranslogException(this.shardId, "failed to parse generation from file name matching pattern " + path, ex);
        }
        FileChannel channel = FileChannel.open(path, StandardOpenOption.READ);
        try {
            ChannelReference raf = new ChannelReference(path, generation, channel, new OnCloseRunnable());
            ImmutableTranslogReader reader = ImmutableTranslogReader.open(raf, checkpoint, this.translogUUID);
            channel = null;
            immutableTranslogReader = reader;
        }
        catch (Throwable throwable) {
            IOUtils.close((Closeable[])new Closeable[]{channel});
            throw throwable;
        }
        IOUtils.close((Closeable[])new Closeable[]{channel});
        return immutableTranslogReader;
    }

    public static long parseIdFromFileName(Path translogFile) {
        String fileName = translogFile.getFileName().toString();
        Matcher matcher = PARSE_STRICT_ID_PATTERN.matcher(fileName);
        if (matcher.matches()) {
            try {
                return Long.parseLong(matcher.group(1));
            }
            catch (NumberFormatException e) {
                throw new IllegalStateException("number formatting issue in a file that passed PARSE_STRICT_ID_PATTERN: " + fileName + "]", e);
            }
        }
        throw new IllegalArgumentException("can't parse id from file: " + fileName);
    }

    public void updateBuffer(ByteSizeValue bufferSize) {
        this.config.setBufferSize(bufferSize.bytesAsInt());
        try (ReleasableLock lock = this.writeLock.acquire();){
            this.current.updateBufferSize(this.config.getBufferSize());
        }
    }

    public boolean isOpen() {
        return !this.closed.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            try (ReleasableLock lock = this.writeLock.acquire();){
                try {
                    this.current.sync();
                }
                catch (Throwable throwable) {
                    try {
                        IOUtils.close((Closeable[])new Closeable[]{this.current, this.currentCommittingTranslog});
                    }
                    finally {
                        IOUtils.close(this.recoveredTranslogs);
                        this.recoveredTranslogs.clear();
                    }
                    throw throwable;
                }
                try {
                    IOUtils.close((Closeable[])new Closeable[]{this.current, this.currentCommittingTranslog});
                }
                finally {
                    IOUtils.close(this.recoveredTranslogs);
                    this.recoveredTranslogs.clear();
                }
            }
            finally {
                FutureUtils.cancel(this.syncScheduler);
                this.logger.debug("translog closed", new Object[0]);
            }
        }
    }

    public Path location() {
        return this.location;
    }

    public long currentFileGeneration() {
        try (ReleasableLock lock = this.readLock.acquire();){
            long l = this.current.getGeneration();
            return l;
        }
    }

    public int totalOperations() {
        int ops = 0;
        try (ReleasableLock lock = this.readLock.acquire();){
            ops += this.current.totalOperations();
            if (this.currentCommittingTranslog != null) {
                int tops = this.currentCommittingTranslog.totalOperations();
                assert (tops != -1);
                assert (tops >= 0);
                ops += tops;
            }
        }
        return ops;
    }

    public long sizeInBytes() {
        long size = 0L;
        try (ReleasableLock lock = this.readLock.acquire();){
            size += this.current.sizeInBytes();
            if (this.currentCommittingTranslog != null) {
                size += this.currentCommittingTranslog.sizeInBytes();
            }
        }
        return size;
    }

    TranslogWriter createWriter(long fileGeneration) throws IOException {
        TranslogWriter newFile;
        try {
            newFile = TranslogWriter.create(this.config.getType(), this.shardId, this.translogUUID, fileGeneration, this.location.resolve(Translog.getFilename(fileGeneration)), new OnCloseRunnable(), this.config.getBufferSize(), this.getChannelFactory());
        }
        catch (IOException e) {
            throw new TranslogException(this.shardId, "failed to create new translog file", e);
        }
        return newFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Operation read(Location location) {
        try (ReleasableLock lock = this.readLock.acquire();){
            TranslogReader reader;
            long currentGeneration = this.current.getGeneration();
            if (currentGeneration == location.generation) {
                reader = this.current;
            } else if (this.currentCommittingTranslog != null && this.currentCommittingTranslog.getGeneration() == location.generation) {
                reader = this.currentCommittingTranslog;
            } else {
                if (currentGeneration < location.generation) {
                    throw new IllegalStateException("location generation [" + location.generation + "] is greater than the current generation [" + currentGeneration + "]");
                }
                Operation operation = null;
                return operation;
            }
            Operation operation = reader.read(location);
            return operation;
        }
        catch (IOException e) {
            throw new ElasticsearchException("failed to read source from translog location " + location, (Throwable)e, new Object[0]);
        }
    }

    /*
     * Exception decompiling
     */
    public Location add(Operation operation) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Snapshot newSnapshot() {
        this.ensureOpen();
        try (ReleasableLock lock = this.readLock.acquire();){
            ArrayList<TranslogReader> toOpen = new ArrayList<TranslogReader>();
            toOpen.addAll(this.recoveredTranslogs);
            if (this.currentCommittingTranslog != null) {
                toOpen.add(this.currentCommittingTranslog);
            }
            toOpen.add(this.current);
            Snapshot snapshot = Translog.createSnapshot(toOpen.toArray(new TranslogReader[toOpen.size()]));
            return snapshot;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Snapshot createSnapshot(TranslogReader ... translogs) {
        Releasable[] snapshots = new Snapshot[translogs.length];
        boolean success = false;
        try {
            for (int i = 0; i < translogs.length; ++i) {
                snapshots[i] = translogs[i].newSnapshot();
            }
            MultiSnapshot snapshot = new MultiSnapshot((Snapshot[])snapshots);
            success = true;
            MultiSnapshot multiSnapshot = snapshot;
            return multiSnapshot;
        }
        finally {
            if (!success) {
                Releasables.close(snapshots);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public View newView() {
        Throwable throwable = null;
        try (ReleasableLock lock = this.readLock.acquire();){
            View view;
            ArrayList<TranslogReader> translogs = new ArrayList<TranslogReader>();
            try {
                if (this.currentCommittingTranslog != null) {
                    translogs.add(this.currentCommittingTranslog.clone());
                }
                translogs.add(this.current.newReaderFromWriter());
                View view2 = new View(translogs, this.onViewClose);
                this.outstandingViews.add(view2);
                translogs.clear();
                view = view2;
            }
            catch (Throwable throwable2) {
                try {
                    IOUtils.closeWhileHandlingException(translogs);
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            IOUtils.closeWhileHandlingException(translogs);
            return view;
        }
    }

    public void sync() throws IOException {
        try (ReleasableLock lock = this.readLock.acquire();){
            if (!this.closed.get()) {
                this.current.sync();
            }
        }
        catch (IOException | AlreadyClosedException ex) {
            if (this.current.getTragicException() != null) {
                try {
                    this.close();
                }
                catch (Exception inner) {
                    ex.addSuppressed(inner);
                }
            }
            throw ex;
        }
    }

    public boolean syncNeeded() {
        try (ReleasableLock lock = this.readLock.acquire();){
            boolean bl = this.current.syncNeeded();
            return bl;
        }
    }

    public static String getFilename(long generation) {
        return TRANSLOG_FILE_PREFIX + generation + TRANSLOG_FILE_SUFFIX;
    }

    static String getCommitCheckpointFileName(long generation) {
        return TRANSLOG_FILE_PREFIX + generation + CHECKPOINT_SUFFIX;
    }

    public boolean ensureSynced(Location location) throws IOException {
        try (ReleasableLock lock = this.readLock.acquire();){
            if (location.generation == this.current.generation) {
                this.ensureOpen();
                boolean bl = this.current.syncUpTo(location.translogLocation + (long)location.size);
                return bl;
            }
        }
        return false;
    }

    public TranslogStats stats() {
        try (ReleasableLock lock = this.readLock.acquire();){
            TranslogStats translogStats = new TranslogStats(this.totalOperations(), this.sizeInBytes());
            return translogStats;
        }
    }

    private boolean isReferencedGeneration(long generation) {
        return generation >= this.lastCommittedTranslogFileGeneration;
    }

    public TranslogConfig getConfig() {
        return this.config;
    }

    private static void verifyChecksum(BufferedChecksumStreamInput in) throws IOException {
        long expectedChecksum = in.getChecksum();
        long readChecksum = (long)in.readInt() & 0xFFFFFFFFL;
        if (readChecksum != expectedChecksum) {
            throw new TranslogCorruptedException("translog stream is corrupted, expected: 0x" + Long.toHexString(expectedChecksum) + ", got: 0x" + Long.toHexString(readChecksum));
        }
    }

    public static List<Operation> readOperations(StreamInput input) throws IOException {
        ArrayList<Operation> operations = new ArrayList<Operation>();
        int numOps = input.readInt();
        BufferedChecksumStreamInput checksumStreamInput = new BufferedChecksumStreamInput(input);
        for (int i = 0; i < numOps; ++i) {
            operations.add(Translog.readOperation(checksumStreamInput));
        }
        return operations;
    }

    static Operation readOperation(BufferedChecksumStreamInput in) throws IOException {
        Operation operation;
        try {
            int opSize = in.readInt();
            if (opSize < 4) {
                throw new AssertionError((Object)("operation size must be at least 4 but was: " + opSize));
            }
            in.resetDigest();
            if (in.markSupported()) {
                in.mark(opSize);
                in.skip(opSize - 4);
                Translog.verifyChecksum(in);
                in.reset();
            }
            Operation.Type type = Operation.Type.fromId(in.readByte());
            operation = Translog.newOperationFromType(type);
            operation.readFrom(in);
            Translog.verifyChecksum(in);
        }
        catch (EOFException e) {
            throw new TruncatedTranslogException("reached premature end of file, translog is truncated", e);
        }
        catch (AssertionError | Exception e) {
            throw new TranslogCorruptedException("translog corruption while reading from stream", (Throwable)e);
        }
        return operation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeOperations(StreamOutput outStream, List<Operation> toWrite) throws IOException {
        ReleasableBytesStreamOutput out = new ReleasableBytesStreamOutput(BigArrays.NON_RECYCLING_INSTANCE);
        try {
            outStream.writeInt(toWrite.size());
            BufferedChecksumStreamOutput checksumStreamOutput = new BufferedChecksumStreamOutput(out);
            for (Operation op : toWrite) {
                out.reset();
                long start = out.position();
                out.skip(4);
                Translog.writeOperationNoSize(checksumStreamOutput, op);
                long end = out.position();
                int operationSize = (int)(out.position() - 4L - start);
                out.seek(start);
                out.writeInt(operationSize);
                out.seek(end);
                ReleasablePagedBytesReference bytes = out.bytes();
                bytes.writeTo(outStream);
            }
        }
        catch (Throwable throwable) {
            Releasables.close(out.bytes());
            throw throwable;
        }
        Releasables.close(out.bytes());
    }

    public static void writeOperationNoSize(BufferedChecksumStreamOutput out, Operation op) throws IOException {
        out.resetDigest();
        out.writeByte(op.opType().id());
        op.writeTo(out);
        long checksum = out.getChecksum();
        out.writeInt((int)checksum);
    }

    static Operation newOperationFromType(Operation.Type type) throws IOException {
        switch (type) {
            case CREATE: {
                return new Create();
            }
            case DELETE: {
                return new Delete();
            }
            case DELETE_BY_QUERY: {
                return new DeleteByQuery();
            }
            case SAVE: {
                return new Index();
            }
        }
        throw new IOException("No type for [" + (Object)((Object)type) + "]");
    }

    public void prepareCommit() throws IOException {
        try (ReleasableLock lock = this.writeLock.acquire();){
            this.ensureOpen();
            if (this.currentCommittingTranslog != null) {
                throw new IllegalStateException("already committing a translog with generation: " + this.currentCommittingTranslog.getGeneration());
            }
            TranslogWriter oldCurrent = this.current;
            oldCurrent.ensureOpen();
            oldCurrent.sync();
            this.currentCommittingTranslog = this.current.immutableReader();
            Path checkpoint = this.location.resolve(CHECKPOINT_FILE_NAME);
            assert (Checkpoint.read((Path)checkpoint).generation == this.currentCommittingTranslog.getGeneration());
            Path commitCheckpoint = this.location.resolve(Translog.getCommitCheckpointFileName(this.currentCommittingTranslog.getGeneration()));
            Files.copy(checkpoint, commitCheckpoint, new CopyOption[0]);
            IOUtils.fsync((Path)commitCheckpoint, (boolean)false);
            IOUtils.fsync((Path)commitCheckpoint.getParent(), (boolean)true);
            this.current = this.createWriter(this.current.getGeneration() + 1L);
            for (View view : this.outstandingViews) {
                view.onNewTranslog(this.currentCommittingTranslog.clone(), this.current.newReaderFromWriter());
            }
            IOUtils.close((Closeable[])new Closeable[]{oldCurrent});
            this.logger.trace("current translog set to [{}]", this.current.getGeneration());
            assert (!oldCurrent.syncNeeded()) : "old translog oldCurrent must not need a sync";
        }
        catch (Throwable t) {
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this});
            throw t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws IOException {
        ImmutableTranslogReader toClose = null;
        try (ReleasableLock lock = this.writeLock.acquire();){
            this.ensureOpen();
            if (this.currentCommittingTranslog == null) {
                this.prepareCommit();
            }
            this.lastCommittedTranslogFileGeneration = this.current.getGeneration();
            if (!this.recoveredTranslogs.isEmpty()) {
                IOUtils.close(this.recoveredTranslogs);
                this.recoveredTranslogs.clear();
            }
            toClose = this.currentCommittingTranslog;
            this.currentCommittingTranslog = null;
        }
        catch (Throwable throwable) {
            IOUtils.close((Closeable[])new Closeable[]{toClose});
            throw throwable;
        }
        IOUtils.close((Closeable[])new Closeable[]{toClose});
    }

    public void rollback() throws IOException {
        this.ensureOpen();
        this.close();
    }

    public TranslogGeneration getGeneration() {
        try (ReleasableLock lock = this.writeLock.acquire();){
            TranslogGeneration translogGeneration = new TranslogGeneration(this.translogUUID, this.currentFileGeneration());
            return translogGeneration;
        }
    }

    public boolean isCurrent(TranslogGeneration generation) {
        try (ReleasableLock lock = this.writeLock.acquire();){
            if (generation != null) {
                if (!generation.translogUUID.equals(this.translogUUID)) {
                    throw new IllegalArgumentException("commit belongs to a different translog: " + generation.translogUUID + " vs. " + this.translogUUID);
                }
                boolean bl = generation.translogFileGeneration == this.currentFileGeneration();
                return bl;
            }
        }
        return false;
    }

    long getFirstOperationPosition() {
        return this.current.getFirstOperationOffset();
    }

    List<ImmutableTranslogReader> getRecoveredReaders() {
        return this.recoveredTranslogs;
    }

    private void ensureOpen() {
        if (this.closed.get()) {
            throw new AlreadyClosedException("translog is already closed", this.current.getTragicException());
        }
    }

    int getNumOpenViews() {
        return this.outstandingViews.size();
    }

    TranslogWriter.ChannelFactory getChannelFactory() {
        return TranslogWriter.ChannelFactory.DEFAULT;
    }

    public Throwable getTragicException() {
        return this.current.getTragicException();
    }

    private static class PathWithGeneration {
        private final Path path;
        private final long generation;

        public PathWithGeneration(Path path, long generation) {
            this.path = path;
            this.generation = generation;
        }

        public Path getPath() {
            return this.path;
        }

        public long getGeneration() {
            return this.generation;
        }
    }

    public static final class TranslogGeneration {
        public final String translogUUID;
        public final long translogFileGeneration;

        public TranslogGeneration(String translogUUID, long translogFileGeneration) {
            this.translogUUID = translogUUID;
            this.translogFileGeneration = translogFileGeneration;
        }
    }

    public static enum Durabilty {
        ASYNC,
        REQUEST;

    }

    @Deprecated
    public static class DeleteByQuery
    implements Operation {
        public static final int SERIALIZATION_FORMAT = 2;
        private BytesReference source;
        @Nullable
        private String[] filteringAliases;
        private String[] types = Strings.EMPTY_ARRAY;

        public DeleteByQuery() {
        }

        public DeleteByQuery(Engine.DeleteByQuery deleteByQuery) {
            this(deleteByQuery.source(), deleteByQuery.filteringAliases(), deleteByQuery.types());
        }

        public DeleteByQuery(BytesReference source, String[] filteringAliases, String ... types) {
            this.source = source;
            this.types = types == null ? Strings.EMPTY_ARRAY : types;
            this.filteringAliases = filteringAliases;
        }

        @Override
        public Operation.Type opType() {
            return Operation.Type.DELETE_BY_QUERY;
        }

        @Override
        public long estimateSize() {
            return this.source.length() + 8;
        }

        public BytesReference source() {
            return this.source;
        }

        public String[] filteringAliases() {
            return this.filteringAliases;
        }

        public String[] types() {
            return this.types;
        }

        @Override
        public Source getSource() {
            throw new IllegalStateException("trying to read doc source from delete_by_query operation");
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            int aliasesSize;
            int typesSize;
            int version = in.readVInt();
            this.source = in.readBytesReference();
            if (version < 2 && in.readBoolean()) {
                in.readString();
            }
            if ((typesSize = in.readVInt()) > 0) {
                this.types = new String[typesSize];
                for (int i = 0; i < typesSize; ++i) {
                    this.types[i] = in.readString();
                }
            }
            if (version >= 1 && (aliasesSize = in.readVInt()) > 0) {
                this.filteringAliases = new String[aliasesSize];
                for (int i = 0; i < aliasesSize; ++i) {
                    this.filteringAliases[i] = in.readString();
                }
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(2);
            out.writeBytesReference(this.source);
            out.writeVInt(this.types.length);
            for (String type : this.types) {
                out.writeString(type);
            }
            if (this.filteringAliases != null) {
                out.writeVInt(this.filteringAliases.length);
                for (String alias : this.filteringAliases) {
                    out.writeString(alias);
                }
            } else {
                out.writeVInt(0);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DeleteByQuery that = (DeleteByQuery)o;
            if (!Arrays.equals(this.filteringAliases, that.filteringAliases)) {
                return false;
            }
            if (!Arrays.equals(this.types, that.types)) {
                return false;
            }
            return this.source.equals(that.source);
        }

        public int hashCode() {
            int result = this.source.hashCode();
            result = 31 * result + (this.filteringAliases != null ? Arrays.hashCode(this.filteringAliases) : 0);
            result = 31 * result + Arrays.hashCode(this.types);
            return result;
        }

        public String toString() {
            return "DeleteByQuery{types=" + Arrays.toString(this.types) + '}';
        }
    }

    public static class Delete
    implements Operation {
        public static final int SERIALIZATION_FORMAT = 2;
        private Term uid;
        private long version = -3L;
        private VersionType versionType = VersionType.INTERNAL;

        public Delete() {
        }

        public Delete(Engine.Delete delete) {
            this(delete.uid());
            this.version = delete.version();
            this.versionType = delete.versionType();
        }

        public Delete(Term uid) {
            this.uid = uid;
        }

        public Delete(Term uid, long version, VersionType versionType) {
            this.uid = uid;
            this.version = version;
            this.versionType = versionType;
        }

        @Override
        public Operation.Type opType() {
            return Operation.Type.DELETE;
        }

        @Override
        public long estimateSize() {
            return (this.uid.field().length() + this.uid.text().length()) * 2 + 20;
        }

        public Term uid() {
            return this.uid;
        }

        public long version() {
            return this.version;
        }

        public VersionType versionType() {
            return this.versionType;
        }

        @Override
        public Source getSource() {
            throw new IllegalStateException("trying to read doc source from delete operation");
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            int version = in.readVInt();
            this.uid = new Term(in.readString(), in.readString());
            if (version >= 1) {
                this.version = in.readLong();
            }
            if (version >= 2) {
                this.versionType = VersionType.fromValue(in.readByte());
            }
            assert (this.versionType.validateVersionForWrites(version));
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(2);
            out.writeString(this.uid.field());
            out.writeString(this.uid.text());
            out.writeLong(this.version);
            out.writeByte(this.versionType.getValue());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Delete delete = (Delete)o;
            return this.version == delete.version && this.uid.equals((Object)delete.uid) && this.versionType == delete.versionType;
        }

        public int hashCode() {
            int result = this.uid.hashCode();
            result = 31 * result + (int)(this.version ^ this.version >>> 32);
            result = 31 * result + this.versionType.hashCode();
            return result;
        }

        public String toString() {
            return "Delete{uid=" + this.uid + '}';
        }
    }

    public static class Index
    implements Operation {
        public static final int SERIALIZATION_FORMAT = 6;
        private String id;
        private String type;
        private long version = -3L;
        private VersionType versionType = VersionType.INTERNAL;
        private BytesReference source;
        private String routing;
        private String parent;
        private long timestamp;
        private long ttl;

        public Index() {
        }

        public Index(Engine.Index index) {
            this.id = index.id();
            this.type = index.type();
            this.source = index.source();
            this.routing = index.routing();
            this.parent = index.parent();
            this.version = index.version();
            this.timestamp = index.timestamp();
            this.ttl = index.ttl();
            this.versionType = index.versionType();
        }

        public Index(String type, String id, byte[] source) {
            this.type = type;
            this.id = id;
            this.source = new BytesArray(source);
        }

        @Override
        public Operation.Type opType() {
            return Operation.Type.SAVE;
        }

        @Override
        public long estimateSize() {
            return (this.id.length() + this.type.length()) * 2 + this.source.length() + 12;
        }

        public String type() {
            return this.type;
        }

        public String id() {
            return this.id;
        }

        public String routing() {
            return this.routing;
        }

        public String parent() {
            return this.parent;
        }

        public long timestamp() {
            return this.timestamp;
        }

        public long ttl() {
            return this.ttl;
        }

        public BytesReference source() {
            return this.source;
        }

        public long version() {
            return this.version;
        }

        public VersionType versionType() {
            return this.versionType;
        }

        @Override
        public Source getSource() {
            return new Source(this.source, this.routing, this.parent, this.timestamp, this.ttl);
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            int version = in.readVInt();
            this.id = in.readString();
            this.type = in.readString();
            this.source = in.readBytesReference();
            try {
                if (version >= 1 && in.readBoolean()) {
                    this.routing = in.readString();
                }
                if (version >= 2 && in.readBoolean()) {
                    this.parent = in.readString();
                }
                if (version >= 3) {
                    this.version = in.readLong();
                }
                if (version >= 4) {
                    this.timestamp = in.readLong();
                }
                if (version >= 5) {
                    this.ttl = in.readLong();
                }
                if (version >= 6) {
                    this.versionType = VersionType.fromValue(in.readByte());
                }
            }
            catch (Exception e) {
                throw new ElasticsearchException("failed to read [" + this.type + "][" + this.id + "]", (Throwable)e, new Object[0]);
            }
            assert (this.versionType.validateVersionForWrites(version));
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(6);
            out.writeString(this.id);
            out.writeString(this.type);
            out.writeBytesReference(this.source);
            if (this.routing == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeString(this.routing);
            }
            if (this.parent == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeString(this.parent);
            }
            out.writeLong(this.version);
            out.writeLong(this.timestamp);
            out.writeLong(this.ttl);
            out.writeByte(this.versionType.getValue());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Index index = (Index)o;
            if (!(this.version == index.version && this.timestamp == index.timestamp && this.ttl == index.ttl && this.id.equals(index.id) && this.type.equals(index.type) && this.versionType == index.versionType && this.source.equals(index.source))) {
                return false;
            }
            if (this.routing != null ? !this.routing.equals(index.routing) : index.routing != null) {
                return false;
            }
            return !(this.parent == null ? index.parent != null : !this.parent.equals(index.parent));
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = 31 * result + this.type.hashCode();
            result = 31 * result + (int)(this.version ^ this.version >>> 32);
            result = 31 * result + this.versionType.hashCode();
            result = 31 * result + this.source.hashCode();
            result = 31 * result + (this.routing != null ? this.routing.hashCode() : 0);
            result = 31 * result + (this.parent != null ? this.parent.hashCode() : 0);
            result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
            result = 31 * result + (int)(this.ttl ^ this.ttl >>> 32);
            return result;
        }

        public String toString() {
            return "Index{id='" + this.id + '\'' + ", type='" + this.type + '\'' + '}';
        }
    }

    public static class Create
    implements Operation {
        public static final int SERIALIZATION_FORMAT = 6;
        private String id;
        private String type;
        private BytesReference source;
        private String routing;
        private String parent;
        private long timestamp;
        private long ttl;
        private long version = -3L;
        private VersionType versionType = VersionType.INTERNAL;

        public Create() {
        }

        public Create(Engine.Create create) {
            this.id = create.id();
            this.type = create.type();
            this.source = create.source();
            this.routing = create.routing();
            this.parent = create.parent();
            this.timestamp = create.timestamp();
            this.ttl = create.ttl();
            this.version = create.version();
            this.versionType = create.versionType();
        }

        public Create(String type, String id, byte[] source) {
            this.id = id;
            this.type = type;
            this.source = new BytesArray(source);
        }

        @Override
        public Operation.Type opType() {
            return Operation.Type.CREATE;
        }

        @Override
        public long estimateSize() {
            return (this.id.length() + this.type.length()) * 2 + this.source.length() + 12;
        }

        public String id() {
            return this.id;
        }

        public BytesReference source() {
            return this.source;
        }

        public String type() {
            return this.type;
        }

        public String routing() {
            return this.routing;
        }

        public String parent() {
            return this.parent;
        }

        public long timestamp() {
            return this.timestamp;
        }

        public long ttl() {
            return this.ttl;
        }

        public long version() {
            return this.version;
        }

        public VersionType versionType() {
            return this.versionType;
        }

        @Override
        public Source getSource() {
            return new Source(this.source, this.routing, this.parent, this.timestamp, this.ttl);
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            int version = in.readVInt();
            this.id = in.readString();
            this.type = in.readString();
            this.source = in.readBytesReference();
            if (version >= 1 && in.readBoolean()) {
                this.routing = in.readString();
            }
            if (version >= 2 && in.readBoolean()) {
                this.parent = in.readString();
            }
            if (version >= 3) {
                this.version = in.readLong();
            }
            if (version >= 4) {
                this.timestamp = in.readLong();
            }
            if (version >= 5) {
                this.ttl = in.readLong();
            }
            if (version >= 6) {
                this.versionType = VersionType.fromValue(in.readByte());
            }
            assert (this.versionType.validateVersionForWrites(version));
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(6);
            out.writeString(this.id);
            out.writeString(this.type);
            out.writeBytesReference(this.source);
            if (this.routing == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeString(this.routing);
            }
            if (this.parent == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeString(this.parent);
            }
            out.writeLong(this.version);
            out.writeLong(this.timestamp);
            out.writeLong(this.ttl);
            out.writeByte(this.versionType.getValue());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Create create = (Create)o;
            if (!(this.timestamp == create.timestamp && this.ttl == create.ttl && this.version == create.version && this.id.equals(create.id) && this.type.equals(create.type) && this.source.equals(create.source))) {
                return false;
            }
            if (this.routing != null ? !this.routing.equals(create.routing) : create.routing != null) {
                return false;
            }
            if (this.parent != null ? !this.parent.equals(create.parent) : create.parent != null) {
                return false;
            }
            return this.versionType == create.versionType;
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = 31 * result + this.type.hashCode();
            result = 31 * result + this.source.hashCode();
            result = 31 * result + (this.routing != null ? this.routing.hashCode() : 0);
            result = 31 * result + (this.parent != null ? this.parent.hashCode() : 0);
            result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
            result = 31 * result + (int)(this.ttl ^ this.ttl >>> 32);
            result = 31 * result + (int)(this.version ^ this.version >>> 32);
            result = 31 * result + this.versionType.hashCode();
            return result;
        }

        public String toString() {
            return "Create{id='" + this.id + '\'' + ", type='" + this.type + '\'' + '}';
        }
    }

    public static class Source {
        public final BytesReference source;
        public final String routing;
        public final String parent;
        public final long timestamp;
        public final long ttl;

        public Source(BytesReference source, String routing, String parent, long timestamp, long ttl) {
            this.source = source;
            this.routing = routing;
            this.parent = parent;
            this.timestamp = timestamp;
            this.ttl = ttl;
        }
    }

    public static interface Operation
    extends Streamable {
        public Type opType();

        public long estimateSize();

        public Source getSource();

        public static enum Type {
            CREATE(1),
            SAVE(2),
            DELETE(3),
            DELETE_BY_QUERY(4);

            private final byte id;

            private Type(byte id) {
                this.id = id;
            }

            public byte id() {
                return this.id;
            }

            public static Type fromId(byte id) {
                switch (id) {
                    case 1: {
                        return CREATE;
                    }
                    case 2: {
                        return SAVE;
                    }
                    case 3: {
                        return DELETE;
                    }
                    case 4: {
                        return DELETE_BY_QUERY;
                    }
                }
                throw new IllegalArgumentException("No type mapped for [" + id + "]");
            }
        }
    }

    public static interface Snapshot
    extends Releasable {
        public int estimatedTotalOperations();

        public Operation next() throws IOException;
    }

    public static class Location
    implements Accountable,
    Comparable<Location> {
        public final long generation;
        public final long translogLocation;
        public final int size;

        Location(long generation, long translogLocation, int size) {
            this.generation = generation;
            this.translogLocation = translogLocation;
            this.size = size;
        }

        public long ramBytesUsed() {
            return RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 16 + 4;
        }

        public Collection<Accountable> getChildResources() {
            return Collections.emptyList();
        }

        public String toString() {
            return "[generation: " + this.generation + ", location: " + this.translogLocation + ", size: " + this.size + "]";
        }

        @Override
        public int compareTo(Location o) {
            if (this.generation == o.generation) {
                return Long.compare(this.translogLocation, o.translogLocation);
            }
            return Long.compare(this.generation, o.generation);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Location location = (Location)o;
            if (this.generation != location.generation) {
                return false;
            }
            if (this.translogLocation != location.translogLocation) {
                return false;
            }
            return this.size == location.size;
        }

        public int hashCode() {
            int result = (int)(this.generation ^ this.generation >>> 32);
            result = 31 * result + (int)(this.translogLocation ^ this.translogLocation >>> 32);
            result = 31 * result + this.size;
            return result;
        }
    }

    class Sync
    implements Runnable {
        Sync() {
        }

        @Override
        public void run() {
            if (Translog.this.closed.get()) {
                return;
            }
            final ThreadPool threadPool = Translog.this.config.getThreadPool();
            if (Translog.this.syncNeeded()) {
                threadPool.executor("flush").execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Translog.this.sync();
                        }
                        catch (Exception e) {
                            Translog.this.logger.warn("failed to sync translog", e, new Object[0]);
                        }
                        if (!Translog.this.closed.get()) {
                            Translog.this.syncScheduler = threadPool.schedule(Translog.this.config.getSyncInterval(), "same", Sync.this);
                        }
                    }
                });
            } else {
                Translog.this.syncScheduler = threadPool.schedule(Translog.this.config.getSyncInterval(), "same", this);
            }
        }
    }

    public static final class View
    implements Closeable {
        public static final View EMPTY_VIEW = new View(Collections.EMPTY_LIST, null);
        boolean closed;
        final List<TranslogReader> orderedTranslogs;
        private final Callback<View> onClose;

        View(List<TranslogReader> orderedTranslogs, Callback<View> onClose) {
            this.orderedTranslogs = new ArrayList<TranslogReader>(orderedTranslogs);
            this.onClose = onClose;
        }

        synchronized void onNewTranslog(TranslogReader oldCurrent, TranslogReader newCurrent) throws IOException {
            if (this.closed) {
                IOUtils.close((Closeable[])new Closeable[]{oldCurrent, newCurrent});
                return;
            }
            this.orderedTranslogs.remove(this.orderedTranslogs.size() - 1).close();
            this.orderedTranslogs.add(oldCurrent);
            this.orderedTranslogs.add(newCurrent);
        }

        public synchronized long minTranslogGeneration() {
            this.ensureOpen();
            return this.orderedTranslogs.get(0).getGeneration();
        }

        public synchronized int totalOperations() {
            int ops = 0;
            for (TranslogReader translog : this.orderedTranslogs) {
                int tops = translog.totalOperations();
                if (tops == -1) {
                    return -1;
                }
                assert (tops >= 0);
                ops += tops;
            }
            return ops;
        }

        public synchronized long sizeInBytes() {
            long size = 0L;
            for (TranslogReader translog : this.orderedTranslogs) {
                size += translog.sizeInBytes();
            }
            return size;
        }

        public synchronized Snapshot snapshot() {
            this.ensureOpen();
            return Translog.createSnapshot(this.orderedTranslogs.toArray(new TranslogReader[this.orderedTranslogs.size()]));
        }

        void ensureOpen() {
            if (this.closed) {
                throw new ElasticsearchException("View is already closed", new Object[0]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            ArrayList<TranslogReader> toClose = new ArrayList<TranslogReader>();
            try {
                View view = this;
                synchronized (view) {
                    if (!this.closed) {
                        try {
                            if (this.onClose != null) {
                                this.onClose.handle(this);
                            }
                        }
                        finally {
                            this.closed = true;
                            toClose.addAll(this.orderedTranslogs);
                            this.orderedTranslogs.clear();
                        }
                    }
                }
            }
            finally {
                try {
                    IOUtils.close(toClose);
                }
                catch (Exception e) {
                    throw new ElasticsearchException("failed to close view", (Throwable)e, new Object[0]);
                }
            }
        }
    }

    private final class OnCloseRunnable
    implements Callback<ChannelReference> {
        private OnCloseRunnable() {
        }

        @Override
        public void handle(ChannelReference channelReference) {
            if (!Translog.this.isReferencedGeneration(channelReference.getGeneration())) {
                Path translogPath = channelReference.getPath();
                assert (channelReference.getPath().getParent().equals(Translog.this.location)) : "translog files must be in the location folder: " + Translog.access$400(Translog.this) + " but was: " + translogPath;
                Translog.this.logger.trace("delete translog file - not referenced and not current anymore {}", translogPath);
                IOUtils.deleteFilesIgnoringExceptions((Path[])new Path[]{translogPath});
                IOUtils.deleteFilesIgnoringExceptions((Path[])new Path[]{translogPath.resolveSibling(Translog.getCommitCheckpointFileName(channelReference.getGeneration()))});
            }
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(Translog.this.location);){
                for (Path path : stream) {
                    long generation;
                    Matcher matcher = PARSE_STRICT_ID_PATTERN.matcher(path.getFileName().toString());
                    if (!matcher.matches() || Translog.this.isReferencedGeneration(generation = Long.parseLong(matcher.group(1)))) continue;
                    Translog.this.logger.trace("delete translog file - not referenced and not current anymore {}", path);
                    IOUtils.deleteFilesIgnoringExceptions((Path[])new Path[]{path});
                    IOUtils.deleteFilesIgnoringExceptions((Path[])new Path[]{path.resolveSibling(Translog.getCommitCheckpointFileName(channelReference.getGeneration()))});
                }
            }
            catch (IOException e) {
                Translog.this.logger.warn("failed to delete unreferenced translog files", e, new Object[0]);
            }
        }
    }
}

