/*
 * Decompiled with CFR 0.152.
 */
package javajs.awt;

import javajs.api.GenericColor;
import javajs.awt.Dimension;
import javajs.util.CU;

public abstract class Component {
    protected boolean visible;
    protected boolean enabled = true;
    protected String text;
    protected String name;
    protected int width;
    protected int height;
    protected String id;
    protected Object parent;
    protected Object mouseListener;
    private GenericColor bgcolor;
    protected int minWidth = 30;
    protected int minHeight = 30;
    protected int renderWidth;
    protected int renderHeight;

    public void setParent(Object p) {
        this.parent = p;
    }

    protected Component(String type) {
        this.id = Component.newID(type);
        if (type == null) {
            return;
        }
    }

    public static String newID(String type) {
        return String.valueOf(type) + ("" + Math.random()).substring(3, 10);
    }

    public abstract String toHTML();

    public void setBackground(GenericColor color) {
        this.bgcolor = color;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Object getParent() {
        return this.parent;
    }

    public void setPreferredSize(Dimension dimension) {
        this.width = dimension.width;
        this.height = dimension.height;
    }

    public void addMouseListener(Object listener) {
        this.mouseListener = listener;
    }

    public String getText() {
        return this.text;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setMinimumSize(Dimension d) {
        this.minWidth = d.width;
        this.minHeight = d.height;
    }

    public int getSubcomponentWidth() {
        return this.width;
    }

    public int getSubcomponentHeight() {
        return this.height;
    }

    protected String getCSSstyle(int defaultPercentW, int defaultPercentH) {
        int height;
        int width = this.renderWidth > 0 ? this.renderWidth : this.getSubcomponentWidth();
        int n = height = this.renderHeight > 0 ? this.renderHeight : this.getSubcomponentHeight();
        return String.valueOf(width > 0 ? "width:" + width + "px;" : (defaultPercentW > 0 ? "width:" + defaultPercentW + "%;" : "")) + (height > 0 ? "height:" + height + "px;" : (defaultPercentH > 0 ? "height:" + defaultPercentH + "%;" : "")) + (this.bgcolor == null ? "" : "background-color:" + CU.toCSSString(this.bgcolor) + ";");
    }

    public void repaint() {
    }
}

