/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.remote;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMISocketFactory;
import java.util.Enumeration;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.jcs.auxiliary.remote.RemoteCacheAttributes;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RemoteUtils {
    private static final Log log = LogFactory.getLog(RemoteUtils.class);
    private static final Pattern SERVER_COLON_PORT = Pattern.compile("(\\S+)\\s*:\\s*(\\d+)");

    private RemoteUtils() {
    }

    public static Registry createRegistry(int n) {
        Registry registry = null;
        if (n < 1024) {
            if (log.isWarnEnabled()) {
                log.warn("createRegistry> Port chosen was less than 1024, will use default [1099] instead.");
            }
            n = 1099;
        }
        try {
            registry = LocateRegistry.createRegistry(n);
            log.info("createRegistry> Created the registry on port " + n);
        }
        catch (RemoteException remoteException) {
            log.warn("createRegistry> Problem creating registry. It may already be started. " + remoteException.getMessage());
        }
        catch (Throwable throwable) {
            log.error("createRegistry> Problem creating registry.", throwable);
        }
        if (registry == null) {
            try {
                registry = LocateRegistry.getRegistry(n);
            }
            catch (RemoteException remoteException) {
                log.error("createRegistry> Problem getting a registry reference.", remoteException);
            }
        }
        return registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProps(String string) throws IOException {
        Properties properties = new Properties();
        try (InputStream inputStream = RemoteUtils.class.getResourceAsStream(string);){
            properties.load(inputStream);
            if (log.isDebugEnabled()) {
                log.debug("props.size=" + properties.size());
            }
            if (log.isDebugEnabled()) {
                Enumeration<Object> enumeration = properties.keys();
                StringBuilder stringBuilder = new StringBuilder();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    stringBuilder.append("\n" + string2 + " = " + properties.getProperty(string2));
                }
                log.debug(stringBuilder.toString());
            }
        }
        return properties;
    }

    public static void configureGlobalCustomSocketFactory(final int n) {
        block4: {
            try {
                if (n > 0) {
                    if (log.isInfoEnabled()) {
                        log.info("RmiSocketFactoryTimeoutMillis [" + n + "]. " + " Configuring a custom socket factory.");
                    }
                    RMISocketFactory.setSocketFactory(new RMISocketFactory(){

                        @Override
                        public Socket createSocket(String string, int n2) throws IOException {
                            Socket socket = new Socket();
                            socket.setSoTimeout(n);
                            socket.setSoLinger(false, 0);
                            socket.connect(new InetSocketAddress(string, n2), n);
                            return socket;
                        }

                        @Override
                        public ServerSocket createServerSocket(int n2) throws IOException {
                            return new ServerSocket(n2);
                        }
                    });
                }
            }
            catch (Exception exception) {
                RMISocketFactory rMISocketFactory = RMISocketFactory.getSocketFactory();
                if (rMISocketFactory == null || rMISocketFactory.getClass().getName().startsWith("org.apache.commons.jcs")) break block4;
                log.info("Could not create new custom socket factory. " + exception.getMessage() + " Factory in use = " + RMISocketFactory.getSocketFactory());
            }
        }
    }

    public static String getNamingURL(String string, int n, String string2) {
        if (string.contains(":")) {
            return "//[" + string.replaceFirst("%", "%25") + "]:" + n + "/" + string2;
        }
        String string3 = "//" + string + ":" + n + "/" + string2;
        return string3;
    }

    public static void parseServerAndPort(String string, RemoteCacheAttributes remoteCacheAttributes) {
        Matcher matcher = SERVER_COLON_PORT.matcher(string);
        if (matcher.find() && matcher.groupCount() == 2) {
            remoteCacheAttributes.setRemoteHost(matcher.group(1));
            remoteCacheAttributes.setRemotePort(Integer.parseInt(matcher.group(2)));
        } else {
            log.error("Invalid server descriptor: " + string);
        }
    }
}

