/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.utils.props;

import java.io.InputStream;
import java.util.Properties;

public abstract class PropertyLoader {
    private static final boolean THROW_ON_LOAD_FAILURE = true;
    private static final String SUFFIX = ".ccf";
    private static final String SUFFIX_PROPERTIES = ".properties";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(String string, ClassLoader classLoader) {
        String string2;
        boolean bl = true;
        if (string == null) {
            throw new IllegalArgumentException("null input: name");
        }
        ClassLoader classLoader2 = classLoader == null ? ClassLoader.getSystemClassLoader() : classLoader;
        String string3 = string2 = string.startsWith("/") ? string.substring(1) : string;
        if (string2.endsWith(SUFFIX)) {
            string2 = string2.substring(0, string2.length() - SUFFIX.length());
        }
        if (string2.endsWith(SUFFIX_PROPERTIES)) {
            string2 = string2.substring(0, string2.length() - SUFFIX_PROPERTIES.length());
            bl = false;
        }
        Properties properties = null;
        InputStream inputStream = null;
        try {
            string2 = string2.replace('.', '/');
            if (!string2.endsWith(SUFFIX) && bl) {
                string2 = string2.concat(SUFFIX);
            } else if (!string2.endsWith(SUFFIX_PROPERTIES) && !bl) {
                string2 = string2.concat(SUFFIX_PROPERTIES);
            }
            inputStream = classLoader2.getResourceAsStream(string2);
            if (inputStream != null) {
                properties = new Properties();
                properties.load(inputStream);
            }
        }
        catch (Exception exception) {
            properties = null;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable) {}
            }
        }
        if (properties == null) {
            throw new IllegalArgumentException("could not load [" + string2 + "]" + " as " + "a classloader resource");
        }
        return properties;
    }

    public static Properties loadProperties(String string) {
        return PropertyLoader.loadProperties(string, Thread.currentThread().getContextClassLoader());
    }

    private PropertyLoader() {
    }
}

