/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.Color;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.gui.history.TwoColumnDiff;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class NodeListTableCellRenderer
extends JLabel
implements TableCellRenderer {
    public static final Color BGCOLOR_SELECTED = new Color(143, 170, 255);
    private ImageIcon nodeIcon;

    public NodeListTableCellRenderer() {
        this.setOpaque(true);
        this.nodeIcon = ImageProvider.get("data", "node");
        this.setIcon(this.nodeIcon);
    }

    protected void renderNode(TwoColumnDiff.Item item, boolean bl) {
        String string = "";
        Color color = Color.WHITE;
        this.setIcon(this.nodeIcon);
        if (item.value != null) {
            string = I18n.tr("Node {0}", item.value.toString());
        }
        color = item.state.getColor();
        if (item.state == TwoColumnDiff.Item.DiffItemType.EMPTY) {
            string = "";
            this.setIcon(null);
        }
        if (bl) {
            color = BGCOLOR_SELECTED;
        }
        this.setText(string);
        this.setBackground(color);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.renderNode((TwoColumnDiff.Item)object, bl);
        return this;
    }
}

