/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.tools;

import com.oracle.truffle.api.instrument.InstrumentationTool;
import com.oracle.truffle.api.instrument.Probe;
import com.oracle.truffle.api.instrument.ProbeListener;
import com.oracle.truffle.api.instrument.impl.DefaultProbeListener;
import com.oracle.truffle.api.source.LineLocation;
import com.oracle.truffle.api.source.NullSourceSection;
import com.oracle.truffle.api.source.SourceSection;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class LineToProbesMap
extends InstrumentationTool {
    private static final boolean TRACE = false;
    private static final PrintStream OUT = System.out;
    private final Map<LineLocation, Collection<Probe>> lineToProbesMap = new HashMap<LineLocation, Collection<Probe>>();
    private final ProbeListener probeListener = new LineToProbesListener();

    private static void trace(String msg) {
        OUT.println("LineToProbesMap: " + msg);
    }

    @Override
    protected boolean internalInstall() {
        Probe.addProbeListener(this.probeListener);
        return true;
    }

    @Override
    protected void internalReset() {
        this.lineToProbesMap.clear();
    }

    @Override
    protected void internalDispose() {
        Probe.removeProbeListener(this.probeListener);
    }

    public Probe findFirstProbe(LineLocation lineLocation) {
        Probe probe = null;
        Collection<Probe> probes = this.findProbes(lineLocation);
        for (Probe probesOnLine : probes) {
            if (probe == null) {
                probe = probesOnLine;
                continue;
            }
            if (probesOnLine.getProbedSourceSection().getCharIndex() >= probe.getProbedSourceSection().getCharIndex()) continue;
            probe = probesOnLine;
        }
        return probe;
    }

    public Collection<Probe> findProbes(LineLocation line) {
        Collection<Probe> probes = this.lineToProbesMap.get(line);
        if (probes == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(probes);
    }

    private class LineToProbesListener
    extends DefaultProbeListener {
        private LineToProbesListener() {
        }

        @Override
        public void newProbeInserted(Probe probe) {
            SourceSection sourceSection = probe.getProbedSourceSection();
            if (sourceSection != null && !(sourceSection instanceof NullSourceSection)) {
                LineLocation lineLocation = sourceSection.getLineLocation();
                ArrayList<Probe> probes = (ArrayList<Probe>)LineToProbesMap.this.lineToProbesMap.get(lineLocation);
                if (probes == null) {
                    probes = new ArrayList<Probe>(2);
                    LineToProbesMap.this.lineToProbesMap.put(lineLocation, probes);
                } else assert (!probes.contains(probe));
                probes.add(probe);
            }
        }
    }
}

