/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.array.ArrayGuards;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.array.ArrayUtils;
import org.jruby.truffle.runtime.layouts.Layouts;

@ImportStatic(value={ArrayGuards.class})
@NodeChildren(value={@NodeChild(value="array", type=RubyNode.class)})
public abstract class ArrayDropTailNode
extends RubyNode {
    final int index;

    public ArrayDropTailNode(RubyContext context, SourceSection sourceSection, int index) {
        super(context, sourceSection);
        this.index = index;
    }

    @Specialization(guards={"isRubyArray(array)", "isNullArray(array)"})
    public DynamicObject getHeadNull(DynamicObject array) {
        CompilerDirectives.transferToInterpreter();
        return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), null, 0);
    }

    @Specialization(guards={"isRubyArray(array)", "isIntArray(array)"})
    public DynamicObject getHeadIntegerFixnum(DynamicObject array) {
        CompilerDirectives.transferToInterpreter();
        if (this.index >= Layouts.ARRAY.getSize(array)) {
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), null, 0);
        }
        return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), ArrayUtils.extractRange((int[])Layouts.ARRAY.getStore(array), 0, Layouts.ARRAY.getSize(array) - this.index), Layouts.ARRAY.getSize(array) - this.index);
    }

    @Specialization(guards={"isRubyArray(array)", "isLongArray(array)"})
    public DynamicObject geHeadLongFixnum(DynamicObject array) {
        CompilerDirectives.transferToInterpreter();
        if (this.index >= Layouts.ARRAY.getSize(array)) {
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), null, 0);
        }
        int size = Layouts.ARRAY.getSize(array) - this.index;
        return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), ArrayUtils.extractRange((long[])Layouts.ARRAY.getStore(array), 0, size), size);
    }

    @Specialization(guards={"isRubyArray(array)", "isDoubleArray(array)"})
    public DynamicObject getHeadFloat(DynamicObject array) {
        CompilerDirectives.transferToInterpreter();
        if (this.index >= Layouts.ARRAY.getSize(array)) {
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), null, 0);
        }
        int size = Layouts.ARRAY.getSize(array) - this.index;
        return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), ArrayUtils.extractRange((double[])Layouts.ARRAY.getStore(array), 0, size), size);
    }

    @Specialization(guards={"isRubyArray(array)", "isObjectArray(array)"})
    public DynamicObject getHeadObject(DynamicObject array) {
        CompilerDirectives.transferToInterpreter();
        if (this.index >= Layouts.ARRAY.getSize(array)) {
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), null, 0);
        }
        int size = Layouts.ARRAY.getSize(array) - this.index;
        return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), ArrayUtils.extractRange((Object[])Layouts.ARRAY.getStore(array), 0, size), size);
    }
}

