/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.methods;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.methods.DeclarationContext;
import org.jruby.truffle.nodes.methods.MethodDefinitionNode;
import org.jruby.truffle.nodes.objects.SingletonClassNode;
import org.jruby.truffle.nodes.objects.SingletonClassNodeGen;
import org.jruby.truffle.runtime.ModuleOperations;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.truffle.runtime.methods.InternalMethod;

public class AddMethodNode
extends RubyNode {
    private final boolean isDefs;
    @Node.Child
    private RubyNode receiver;
    @Node.Child
    private MethodDefinitionNode methodNode;
    @Node.Child
    private SingletonClassNode singletonClassNode;

    public AddMethodNode(RubyContext context, SourceSection section, RubyNode receiver, MethodDefinitionNode method, boolean isDefs) {
        super(context, section);
        this.isDefs = isDefs;
        this.receiver = receiver;
        this.methodNode = method;
        this.singletonClassNode = SingletonClassNodeGen.create(context, section, null);
    }

    @Override
    public DynamicObject execute(VirtualFrame frame) {
        CompilerDirectives.transferToInterpreter();
        Object receiverObject = this.receiver.execute(frame);
        InternalMethod methodObject = (InternalMethod)this.methodNode.execute(frame);
        DynamicObject module = (DynamicObject)receiverObject;
        assert (RubyGuards.isRubyModule(module));
        Visibility visibility = this.getVisibility(frame, methodObject.getName());
        InternalMethod method = methodObject.withDeclaringModule(module).withVisibility(visibility);
        if (method.getVisibility() == Visibility.MODULE_FUNCTION) {
            Layouts.MODULE.getFields(module).addMethod(this.getContext(), this, method.withVisibility(Visibility.PRIVATE));
            Layouts.MODULE.getFields(this.singletonClassNode.executeSingletonClass(module)).addMethod(this.getContext(), this, method.withVisibility(Visibility.PUBLIC));
        } else {
            Layouts.MODULE.getFields(module).addMethod(this.getContext(), this, method);
        }
        return this.getSymbol(method.getName());
    }

    private Visibility getVisibility(Frame frame, String name) {
        if (this.isDefs) {
            return Visibility.PUBLIC;
        }
        if (ModuleOperations.isMethodPrivateFromName(name)) {
            return Visibility.PRIVATE;
        }
        return DeclarationContext.findVisibility(frame);
    }
}

