/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.hex;

import de.intarsys.tools.hex.HexData;
import de.intarsys.tools.hex.HexTools;

public class HexRow {
    public static int DEFAULT_LENGTH = 16;
    private HexData hexData;
    private int length = DEFAULT_LENGTH;
    private int offset;

    protected HexRow(HexData hexData, int n, int n2) {
        this.hexData = hexData;
        this.offset = n;
        this.length = n2;
    }

    public String getAsString() {
        return new String(this.hexData.basicGetBytes(), this.offset, Math.min(this.length, this.hexData.length() - this.offset));
    }

    public byte getCellValue(int n) {
        int n2 = this.offset + n;
        if (n2 >= this.hexData.length()) {
            return 0;
        }
        return this.hexData.basicGetValue(this.offset + n);
    }

    public String getCellValueAsString(int n) {
        int n2 = this.offset + n;
        if (n2 >= this.hexData.length()) {
            return "  ";
        }
        return new String(HexTools.ByteToHex[0xFF & this.hexData.basicGetValue(this.offset + n)]);
    }

    public int getLength() {
        return this.length;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setCellValue(int n, byte by) {
        this.hexData.basicSetValue(this.offset + n, by);
    }

    public void setCellValue(int n, String string) {
        this.hexData.basicSetValue(this.offset + n, (byte)HexTools.hexStringToInt(string));
    }

    public void setLength(int n) {
        this.length = n;
    }

    public void setOffset(int n) {
        this.offset = n;
    }
}

