/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.transaction;

import de.intarsys.tools.transaction.ITransaction;
import de.intarsys.tools.transaction.ITransactionManager;
import de.intarsys.tools.transaction.NoTransactionException;
import de.intarsys.tools.transaction.RootTransaction;
import de.intarsys.tools.transaction.Transaction;
import de.intarsys.tools.transaction.TransactionException;

public abstract class CommonTransactionManager
implements ITransactionManager {
    @Override
    public void begin() {
        Transaction transaction = this.lookupTransaction();
        Transaction transaction2 = null;
        transaction2 = transaction == null ? this.createTransaction() : transaction.createTransaction();
        transaction2.start();
        this.registerTransaction(transaction2);
    }

    @Override
    public void commit() throws TransactionException {
        Transaction transaction = this.lookupTransaction();
        if (transaction == null) {
            throw new NoTransactionException("no transaction active when commiting");
        }
        Transaction transaction2 = (Transaction)transaction.getParent();
        transaction.commit();
        this.registerTransaction(transaction2);
    }

    @Override
    public void commitResume() throws TransactionException {
        Transaction transaction = this.lookupTransaction();
        if (transaction == null) {
            throw new NoTransactionException("no transaction active when commiting");
        }
        transaction.commitResume();
    }

    protected Transaction createTransaction() {
        return new RootTransaction();
    }

    @Override
    public ITransaction getTransaction() {
        return this.lookupTransaction();
    }

    protected abstract Transaction lookupTransaction();

    protected abstract void registerTransaction(Transaction var1);

    @Override
    public void resume(ITransaction iTransaction) {
        Transaction transaction = this.lookupTransaction();
        if (transaction == iTransaction) {
            return;
        }
        if (transaction != null) {
            transaction.suspend();
        }
        ((Transaction)iTransaction).resume();
        this.registerTransaction((Transaction)iTransaction);
    }

    @Override
    public void rollback() throws TransactionException {
        Transaction transaction = this.lookupTransaction();
        if (transaction != null) {
            Transaction transaction2 = (Transaction)transaction.getParent();
            transaction.rollback();
            this.registerTransaction(transaction2);
        }
    }

    @Override
    public void rollbackResume() throws TransactionException {
        Transaction transaction = this.lookupTransaction();
        if (transaction != null) {
            transaction.rollbackResume();
        }
    }

    @Override
    public ITransaction suspend() {
        Transaction transaction = this.lookupTransaction();
        if (transaction != null) {
            transaction.suspend();
            this.registerTransaction(null);
        }
        return transaction;
    }
}

