/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.console.business.parser.validators;

import java.io.File;
import java.util.Iterator;
import java.util.TreeMap;
import jcmdline.CmdLineHandler;
import jcmdline.FileParam;
import jcmdline.PdfFileParam;
import jcmdline.StringParam;
import jcmdline.dto.PdfFile;
import org.apache.log4j.Logger;
import org.pdfsam.console.business.dto.PageLabel;
import org.pdfsam.console.business.dto.commands.AbstractParsedCommand;
import org.pdfsam.console.business.dto.commands.PageLabelsParsedCommand;
import org.pdfsam.console.business.parser.validators.interfaces.AbstractCmdValidator;
import org.pdfsam.console.exceptions.console.ConsoleException;
import org.pdfsam.console.exceptions.console.ParseException;
import org.pdfsam.console.exceptions.console.ValidationException;
import org.pdfsam.console.utils.FileUtility;
import org.pdfsam.console.utils.ValidationUtility;

public class PageLabelsCmdValidator
extends AbstractCmdValidator {
    private final Logger log = Logger.getLogger(PageLabelsCmdValidator.class.getPackage().getName());

    protected AbstractParsedCommand validateArguments(CmdLineHandler cmdLineHandler) throws ConsoleException {
        TreeMap<Integer, PageLabel> labels;
        PageLabelsParsedCommand parsedCommandDTO = new PageLabelsParsedCommand();
        if (cmdLineHandler != null) {
            StringParam lpOption;
            FileParam oOption = (FileParam)cmdLineHandler.getOption("o");
            if (!oOption.isSet()) {
                throw new ParseException(15);
            }
            File outFile = oOption.getFile();
            ValidationUtility.assertValidPdfExtension(outFile.getName());
            parsedCommandDTO.setOutputFile(outFile);
            PdfFileParam fOption = (PdfFileParam)cmdLineHandler.getOption("f");
            if (!fOption.isSet()) {
                throw new ParseException(20);
            }
            PdfFile inputFile = fOption.getPdfFile();
            ValidationUtility.assertValidPdfExtension(inputFile.getFile().getName());
            parsedCommandDTO.setInputFile(FileUtility.getPdfFile(inputFile));
            labels = new TreeMap<Integer, PageLabel>();
            StringParam lOption = (StringParam)cmdLineHandler.getOption("l");
            if (lOption.isSet()) {
                Iterator lIterator = lOption.getValues().iterator();
                while (lIterator.hasNext()) {
                    String currentLabel = (String)lIterator.next();
                    PageLabel currentPageLabel = ValidationUtility.getPageLabel(currentLabel);
                    if (labels.containsKey(new Integer(currentPageLabel.getPageNumber()))) {
                        this.log.warn("Duplicate label starting at page " + currentPageLabel.getPageNumber() + " will be ignored.");
                        continue;
                    }
                    labels.put(new Integer(currentPageLabel.getPageNumber()), currentPageLabel);
                }
            }
            if ((lpOption = (StringParam)cmdLineHandler.getOption("lp")).isSet()) {
                Iterator lpIterator = lpOption.getValues().iterator();
                while (lpIterator.hasNext()) {
                    String currentPrefix = (String)lpIterator.next();
                    String[] values = currentPrefix.split(":", 2);
                    if (values.length == 2) {
                        Integer page = null;
                        try {
                            page = Integer.valueOf(values[0]);
                        }
                        catch (Exception e) {
                            throw new ValidationException(8, new String[]{currentPrefix}, e);
                        }
                        Object obj = labels.get(page);
                        if (obj != null) {
                            ((PageLabel)obj).setPrefix(values[1]);
                            continue;
                        }
                        this.log.warn("Unable to find label starting at page " + page + ", prefix will be ignored.");
                        continue;
                    }
                    throw new ValidationException(8, new String[]{currentPrefix});
                }
            }
        } else {
            throw new ConsoleException(2);
        }
        parsedCommandDTO.setLabels(labels.values().toArray(new PageLabel[labels.size()]));
        return parsedCommandDTO;
    }
}

