/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.console.business.pdf.handlers;

import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import com.lowagie.text.pdf.PdfTransition;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.pdfsam.console.business.dto.Transition;
import org.pdfsam.console.business.dto.commands.AbstractParsedCommand;
import org.pdfsam.console.business.dto.commands.SlideShowParsedCommand;
import org.pdfsam.console.business.pdf.handlers.interfaces.AbstractCmdExecutor;
import org.pdfsam.console.exceptions.console.ConsoleException;
import org.pdfsam.console.exceptions.console.SlideShowException;
import org.pdfsam.console.utils.FileUtility;
import org.pdfsam.console.utils.PdfUtility;
import org.pdfsam.console.utils.perfix.PrefixParser;

public class SlideShowCmdExecutor
extends AbstractCmdExecutor {
    private static final Logger LOG = Logger.getLogger(SlideShowCmdExecutor.class.getPackage().getName());
    private Hashtable transitionsMappingMap = null;
    private PdfReader pdfReader = null;
    private PdfStamper pdfStamper = null;

    public void execute(AbstractParsedCommand parsedCommand) throws ConsoleException {
        if (parsedCommand != null && parsedCommand instanceof SlideShowParsedCommand) {
            SlideShowParsedCommand inputCommand = (SlideShowParsedCommand)parsedCommand;
            this.setPercentageOfWorkDone(0);
            Transitions transitions = new Transitions();
            transitions.setDefaultTransition(inputCommand.getDefaultTransition());
            transitions.setTransitions(inputCommand.getTransitions());
            transitions = this.parseXmlInput(inputCommand.getInputXmlFile(), transitions);
            try {
                PrefixParser prefixParser = new PrefixParser(inputCommand.getOutputFilesPrefix(), inputCommand.getInputFile().getFile().getName());
                File tmpFile = FileUtility.generateTmpFile(inputCommand.getOutputFile());
                this.pdfReader = PdfUtility.readerFor(inputCommand.getInputFile());
                this.pdfReader.removeUnusedObjects();
                this.pdfReader.consolidateNamedDestinations();
                LOG.debug("Creating a new document.");
                Character pdfVersion = inputCommand.getOutputPdfVersion();
                this.pdfStamper = pdfVersion != null ? new PdfStamper(this.pdfReader, (OutputStream)new FileOutputStream(tmpFile), inputCommand.getOutputPdfVersion().charValue()) : new PdfStamper(this.pdfReader, (OutputStream)new FileOutputStream(tmpFile), this.pdfReader.getPdfVersion());
                HashMap meta = this.pdfReader.getInfo();
                meta.put("Creator", "pdfsam-console (Ver. 2.4.3e)");
                this.setCompressionSettingOnStamper(inputCommand, this.pdfStamper);
                this.pdfStamper.setMoreInfo(meta);
                if (inputCommand.isFullScreen()) {
                    this.pdfStamper.setViewerPreferences(512);
                }
                if (transitions.getDefaultTransition() == null) {
                    this.setTransitionsWithoutDefault(transitions);
                } else {
                    int totalPages = this.pdfReader.getNumberOfPages();
                    this.setTransitionsWithDefault(transitions, totalPages);
                }
                this.pdfStamper.close();
                this.pdfReader.close();
                File outFile = new File(inputCommand.getOutputFile(), prefixParser.generateFileName());
                FileUtility.renameTemporaryFile(tmpFile, outFile, inputCommand.isOverwrite());
                LOG.debug("File " + outFile.getCanonicalPath() + " created.");
                LOG.info("Slide show options set.");
            }
            catch (Exception e) {
                throw new SlideShowException(e);
            }
            finally {
                this.setWorkCompleted();
            }
        } else {
            throw new ConsoleException(5);
        }
    }

    private void setTransitionsWithDefault(Transitions transitions, int totalPages) {
        LOG.debug("Setting transitions with a default value.");
        Transition[] trans = transitions.getTransitions();
        Hashtable<Integer, Transition> transitionsMap = new Hashtable<Integer, Transition>(0);
        if (trans != null) {
            transitionsMap = new Hashtable(trans.length);
            for (int i = 0; i < trans.length; ++i) {
                transitionsMap.put(new Integer(trans[i].getPageNumber()), trans[i]);
            }
        }
        for (int j = 1; j <= totalPages; ++j) {
            Object rawTransition = transitionsMap.get(new Integer(j));
            if (rawTransition != null) {
                Transition transition = (Transition)rawTransition;
                this.pdfStamper.setDuration(transition.getDuration(), transition.getPageNumber());
                this.pdfStamper.setTransition(new PdfTransition(this.getITextTransition(transition.getTransition()), transition.getTransitionDuration()), transition.getPageNumber());
            } else {
                this.pdfStamper.setDuration(transitions.getDefaultTransition().getDuration(), j);
                this.pdfStamper.setTransition(new PdfTransition(this.getITextTransition(transitions.getDefaultTransition().getTransition()), transitions.getDefaultTransition().getTransitionDuration()), j);
            }
            this.setPercentageOfWorkDone(j * 1000 / totalPages);
        }
    }

    private void setTransitionsWithoutDefault(Transitions transitions) {
        LOG.debug("Setting transitions without a default value.");
        Transition[] trans = transitions.getTransitions();
        if (trans != null && trans.length > 0) {
            for (int i = 0; i < trans.length; ++i) {
                this.pdfStamper.setDuration(trans[i].getDuration(), trans[i].getPageNumber());
                this.pdfStamper.setTransition(new PdfTransition(this.getITextTransition(trans[i].getTransition()), trans[i].getTransitionDuration()), trans[i].getPageNumber());
                this.setPercentageOfWorkDone((i + 1) * 1000 / trans.length);
            }
        } else {
            LOG.warn("No transition to set.");
        }
    }

    private int getITextTransition(String transition) {
        Object iTextTransition;
        int retVal = 6;
        if (this.transitionsMappingMap == null) {
            this.transitionsMappingMap = new Hashtable(20);
            this.transitionsMappingMap.put("blindh", new Integer(6));
            this.transitionsMappingMap.put("blindv", new Integer(5));
            this.transitionsMappingMap.put("wipeb2t", new Integer(11));
            this.transitionsMappingMap.put("glitterd", new Integer(16));
            this.transitionsMappingMap.put("dissolve", new Integer(13));
            this.transitionsMappingMap.put("inwardbox", new Integer(7));
            this.transitionsMappingMap.put("glitterl2r", new Integer(14));
            this.transitionsMappingMap.put("wipel2r", new Integer(9));
            this.transitionsMappingMap.put("outwardbox", new Integer(8));
            this.transitionsMappingMap.put("wiper2l", new Integer(10));
            this.transitionsMappingMap.put("splithin", new Integer(4));
            this.transitionsMappingMap.put("splithout", new Integer(2));
            this.transitionsMappingMap.put("splitvin", new Integer(3));
            this.transitionsMappingMap.put("splitvout", new Integer(1));
            this.transitionsMappingMap.put("glittert2b", new Integer(15));
            this.transitionsMappingMap.put("wipet2b", new Integer(12));
        }
        if ((iTextTransition = this.transitionsMappingMap.get(transition)) != null) {
            retVal = (Integer)iTextTransition;
        }
        return retVal;
    }

    private Transitions parseXmlInput(File inputFile, Transitions transitions) throws SlideShowException {
        Transitions retVal;
        block8: {
            retVal = transitions;
            if (inputFile != null) {
                try {
                    LOG.debug("Parsing xml transitions file " + inputFile.getAbsolutePath());
                    SAXReader reader = new SAXReader();
                    Document document = reader.read(inputFile);
                    Node rootNode = document.selectSingleNode("/transitions");
                    if (rootNode != null) {
                        Node defType = rootNode.selectSingleNode("@defaulttype");
                        Node defTransDur = rootNode.selectSingleNode("@defaulttduration");
                        Node defDur = rootNode.selectSingleNode("@defaultduration");
                        if (defType != null && defTransDur != null && defDur != null) {
                            if (transitions.getDefaultTransition() != null) {
                                throw new SlideShowException(6);
                            }
                            transitions.setDefaultTransition(new Transition(0, new Integer(defTransDur.getText().trim()), defType.getText().trim(), new Integer(defDur.getText().trim())));
                        }
                        List transitionsList = document.selectNodes("/transitions/transition");
                        for (int i = 0; transitionsList != null && i < transitionsList.size(); ++i) {
                            Node transitionNode = (Node)transitionsList.get(i);
                            Node type = transitionNode.selectSingleNode("@type");
                            Node transDuration = transitionNode.selectSingleNode("@tduration");
                            Node duration = transitionNode.selectSingleNode("@duration");
                            Node page = transitionNode.selectSingleNode("@pagenumber");
                            if (type == null || transDuration == null || duration == null || page == null) {
                                throw new SlideShowException(7, new String[]{i + ""});
                            }
                            transitions.addTransition(new Transition(new Integer(page.getText().trim()), new Integer(transDuration.getText().trim()), type.getText().trim(), new Integer(duration.getText().trim())));
                        }
                        break block8;
                    }
                    throw new SlideShowException(5);
                }
                catch (Exception e) {
                    throw new SlideShowException(5, e);
                }
            }
        }
        return retVal;
    }

    public void clean() {
        this.closePdfReader(this.pdfReader);
        this.closePdfStamper(this.pdfStamper);
    }

    private static class Transitions {
        private Transition defaultTransition = null;
        private List transitions = null;

        public Transition getDefaultTransition() {
            return this.defaultTransition;
        }

        public void setDefaultTransition(Transition defaultTransition) {
            this.defaultTransition = defaultTransition;
        }

        public Transition[] getTransitions() {
            Transition[] retVal = null;
            if (this.transitions != null) {
                retVal = this.transitions.toArray(new Transition[this.transitions.size()]);
            }
            return retVal;
        }

        public void setTransitions(Transition[] transitions) {
            if (transitions != null) {
                this.transitions = Arrays.asList(transitions);
            }
        }

        public boolean addTransition(Transition transition) {
            boolean retVal = false;
            if (transition != null) {
                if (this.transitions == null) {
                    this.transitions = new ArrayList();
                }
                retVal = this.transitions.add(transition);
            }
            return retVal;
        }
    }
}

