/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.control.basics;

public class XValues {
    private Double left;
    private Double right;

    public XValues(double d, double d2) {
        this.left = d;
        this.right = d2;
    }

    public double getLeft() {
        return this.left;
    }

    public double getRight() {
        return this.right;
    }

    public double getSpace() {
        return this.right - this.left;
    }

    public void addLeft(double d) {
        this.left = this.left + d;
    }

    public void subRight(double d) {
        this.right = this.right - d;
    }

    public static XValues createForEllipse(double d, double d2, double d3) {
        double d4 = d2 / 2.0;
        double d5 = d3 / 2.0;
        double d6 = Math.sqrt((1.0 - Math.pow(d4 - d, 2.0) / Math.pow(d4, 2.0)) * Math.pow(d5, 2.0));
        XValues xValues = new XValues(d5 - d6, d5 + d6);
        return xValues;
    }

    public XValues intersect(XValues xValues, boolean bl) {
        Double d = this.left;
        Double d2 = this.right;
        if (bl) {
            if (xValues.left.equals(Double.NaN) || xValues.left > this.left) {
                d = xValues.left;
            }
            if (xValues.right.equals(Double.NaN) || xValues.right < this.right) {
                d2 = xValues.right;
            }
        } else {
            if (this.left.equals(Double.NaN) || xValues.left > this.left) {
                d = xValues.left;
            }
            if (this.right.equals(Double.NaN) || xValues.right < this.right) {
                d2 = xValues.right;
            }
        }
        return new XValues(d, d2);
    }

    public String toString() {
        return "XValues [left=" + this.left + ", right=" + this.right + "]";
    }
}

