// Generated by IcedCoffeeScript 1.7.1-c
(function() {
  var constants, tablify;

  constants = require('./constants');

  tablify = require('tablify');

  module.exports = {
    escape: function(s) {

      /*
      we don't want to use either escape (deprecated) or encodeURIComponent (too ugly) and overescapes
       */
      var c, i, res, _i, _len;
      res = '';
      for (i = _i = 0, _len = s.length; _i < _len; i = ++_i) {
        c = s[i];
        if (c.match(/^[a-z0-9\/\._\-\~\#]$/i)) {
          res += c;
        } else {
          res += encodeURIComponent(c).replace(/%20/g, '+');
        }
      }
      return res;
    },
    unescape: function(s) {
      return decodeURIComponent(s.replace(/\+/g, '%20'));
    },
    item_type_name: function(it) {
      switch (it) {
        case constants.item_types.FILE:
          return 'file';
        case constants.item_types.SYMLINK:
          return 'symlink';
        case constants.item_types.DIR:
          return 'directory';
        default:
          throw new Error("Unknown type: " + it);
      }
    },
    plain_tablify: function(d, spaces) {
      var i;
      if (spaces == null) {
        spaces = 2;
      }
      return tablify(d, {
        show_index: true,
        row_start: '',
        row_end: '',
        spacer: ((function() {
          var _i, _results;
          _results = [];
          for (i = _i = 0; 0 <= spaces ? _i < spaces : _i > spaces; i = 0 <= spaces ? ++_i : --_i) {
            _results.push(' ');
          }
          return _results;
        })()).join(''),
        row_sep_char: ''
      });
    }
  };

}).call(this);
