// Generated by IcedCoffeeScript 1.8.0-d
(function() {
  var BaseScraper, DnsScraper, constants, decode_sig, dns, iced, make_ids, txt_reformat, urlmod, v_codes, __iced_k, __iced_k_noop,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    __indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; };

  iced = require('iced-runtime');
  __iced_k = __iced_k_noop = function() {};

  BaseScraper = require('./base').BaseScraper;

  constants = require('../constants').constants;

  v_codes = constants.v_codes;

  decode_sig = require('kbpgp').ukm.decode_sig;

  urlmod = require('url');

  make_ids = require('../base').make_ids;

  urlmod = require('url');

  dns = require('dns');

  txt_reformat = function(v) {
    var sv, _i, _len, _results;
    if (v == null) {
      return [];
    } else if (v.length === 0) {
      return v;
    } else if (Array.isArray(v[0])) {
      _results = [];
      for (_i = 0, _len = v.length; _i < _len; _i++) {
        sv = v[_i];
        _results.push(sv[0]);
      }
      return _results;
    } else {
      return v;
    }
  };

  exports.DnsScraper = DnsScraper = (function(_super) {
    __extends(DnsScraper, _super);

    function DnsScraper(opts) {
      DnsScraper.__super__.constructor.call(this, opts);
    }

    DnsScraper.prototype._check_args = function(args) {
      if (!(args.domain != null)) {
        return new Error("Bad args to DNS proof: no domain given");
      } else {
        return null;
      }
    };

    DnsScraper.prototype.make_url = function(_arg) {
      var domain;
      domain = _arg.domain;
      return "dns://" + (domain.toLowerCase());
    };

    DnsScraper.prototype.url_to_domain = function(u) {
      var _ref;
      return (_ref = urlmod.parse(u)) != null ? _ref.hostname : void 0;
    };

    DnsScraper.prototype.get_tor_error = function() {
      return [new Error("DNS isn't reliable over tor"), v_codes.TOR_SKIPPED];
    };

    DnsScraper.prototype.hunt2 = function(_arg, cb) {
      var domain, err, out, url;
      domain = _arg.domain;
      err = null;
      out = {};
      if (domain == null) {
        err = new Error("invalid arguments: expected a domain");
      } else {
        url = this.make_url({
          domain: domain
        });
        out = {
          api_url: url,
          human_url: url,
          remote_id: url,
          rc: v_codes.OK
        };
      }
      return cb(err, out);
    };

    DnsScraper.prototype._check_api_url = function(_arg) {
      var api_url, domain;
      api_url = _arg.api_url, domain = _arg.domain;
      return api_url.toLowerCase().indexOf(this.make_url({
        domain: domain
      })) >= 0;
    };

    DnsScraper.prototype._validate_text_check = function(_arg) {
      var err, med_id, msg, proof_text_check, signature, _ref;
      signature = _arg.signature, proof_text_check = _arg.proof_text_check;
      _ref = decode_sig({
        armored: signature
      }), err = _ref[0], msg = _ref[1];
      if (err == null) {
        med_id = make_ids(msg.body).med_id;
        if (proof_text_check.indexOf(med_id) < 0) {
          err = new Error("Bad payload text_check");
        }
      }
      return err;
    };

    DnsScraper.prototype.check_status = function(_arg, cb) {
      var api_url, d, domain, err, proof_text_check, rc, search_domains, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      api_url = _arg.api_url, proof_text_check = _arg.proof_text_check;
      rc = err = null;
      (function(_this) {
        return (function(__iced_k) {
          if ((domain = _this.url_to_domain(api_url)) == null) {
            err = new Error("no domain found in URL " + api_url);
            return __iced_k(rc = v_codes.CONTENT_FAILURE);
          } else {
            search_domains = [domain, ["_keybase", domain].join(".")];
            (function(__iced_k) {
              var _i, _len, _ref, _results, _while;
              _ref = search_domains;
              _len = _ref.length;
              _i = 0;
              _results = [];
              _while = function(__iced_k) {
                var _break, _continue, _next;
                _break = function() {
                  return __iced_k(_results);
                };
                _continue = function() {
                  return iced.trampoline(function() {
                    ++_i;
                    return _while(__iced_k);
                  });
                };
                _next = function(__iced_next_arg) {
                  _results.push(__iced_next_arg);
                  return _continue();
                };
                if (!(_i < _len)) {
                  return _break();
                } else {
                  d = _ref[_i];
                  (function(__iced_k) {
                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                      parent: ___iced_passed_deferral,
                      filename: "/Users/max/src/keybase/proofs/src/scrapers/dns.iced",
                      funcname: "DnsScraper.check_status"
                    });
                    _this._check_status({
                      domain: d,
                      proof_text_check: proof_text_check
                    }, __iced_deferrals.defer({
                      assign_fn: (function() {
                        return function() {
                          err = arguments[0];
                          return rc = arguments[1];
                        };
                      })(),
                      lineno: 93
                    }));
                    __iced_deferrals._fulfill();
                  })(function() {
                    (function(__iced_k) {
                      if (rc === v_codes.OK) {
                        (function(__iced_k) {
_break()
                        })(__iced_k);
                      } else {
                        return __iced_k();
                      }
                    })(_next);
                  });
                }
              };
              _while(__iced_k);
            })(__iced_k);
          }
        });
      })(this)((function(_this) {
        return function() {
          return cb(err, rc);
        };
      })(this));
    };

    DnsScraper.prototype._check_status = function(_arg, cb) {
      var dnslib, domain, err, proof_text_check, rc, records, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      domain = _arg.domain, proof_text_check = _arg.proof_text_check;
      this.log("+ DNS check for " + domain);
      dnslib = this.libs.dns || dns;
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/proofs/src/scrapers/dns.iced",
            funcname: "DnsScraper._check_status"
          });
          dnslib.resolveTxt(domain, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                return records = arguments[1];
              };
            })(),
            lineno: 105
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          rc = typeof err !== "undefined" && err !== null ? (_this.log("| DNS error: " + err), v_codes.DNS_ERROR) : (__indexOf.call(txt_reformat(records), proof_text_check) >= 0) ? v_codes.OK : (_this.log("| DNS failed; found TXT entries: " + (JSON.stringify(records))), v_codes.NOT_FOUND);
          _this.log("- DNS check for " + domain + " -> " + rc);
          return cb(err, rc);
        };
      })(this));
    };

    return DnsScraper;

  })(BaseScraper);

}).call(this);
