/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.minimize.forcefield;

import java.util.Map;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.V3d;
import org.jmol.java.BS;
import org.jmol.minimize.MinAngle;
import org.jmol.minimize.MinAtom;
import org.jmol.minimize.MinBond;
import org.jmol.minimize.MinObject;
import org.jmol.minimize.MinPosition;
import org.jmol.minimize.MinTorsion;
import org.jmol.minimize.Util;
import org.jmol.minimize.forcefield.Calculation;
import org.jmol.minimize.forcefield.FFParam;
import org.jmol.minimize.forcefield.ForceField;

abstract class Calculations {
    public static final double RAD_TO_DEG = 57.29577951308232;
    public static final double DEG_TO_RAD = Math.PI / 180;
    static final double KCAL_TO_KJ = 4.1868;
    static final int CALC_DISTANCE = 0;
    static final int CALC_ANGLE = 1;
    static final int CALC_STRETCH_BEND = 2;
    static final int CALC_TORSION = 3;
    static final int CALC_OOP = 4;
    static final int CALC_VDW = 5;
    static final int CALC_ES = 6;
    static final int CALC_MAX = 7;
    FFParam parA;
    FFParam parB;
    FFParam parC;
    ForceField ff;
    Lst<Object[]>[] calculations = AU.createArrayOfArrayList((int)7);
    Map<Object, Object> ffParams;
    int ac;
    int bondCount;
    int angleCount;
    int torsionCount;
    MinAtom[] minAtoms;
    MinBond[] minBonds;
    MinAngle[] minAngles;
    MinTorsion[] minTorsions;
    MinPosition[] minPositions;
    Lst<Object[]> constraints;
    boolean isPreliminary;
    boolean gradients;
    boolean silent;
    SB logData = new SB();
    boolean logging;
    boolean loggingEnabled;
    final V3d da = new V3d();
    final V3d db = new V3d();
    final V3d dc = new V3d();
    final V3d dd = new V3d();
    int ia;
    int ib;
    int ic;
    int id;
    final V3d v1 = new V3d();
    final V3d v2 = new V3d();
    final V3d v3 = new V3d();
    private static final double PI_OVER_2 = 1.5707963267948966;
    private static final double TWO_PI = Math.PI * 2;

    abstract Object getParameterObj(MinObject var1);

    Object getParameter(Object object) {
        return this.ffParams.get(object);
    }

    public void setConstraints(Lst<Object[]> lst) {
        this.constraints = lst;
    }

    Calculations(ForceField forceField, MinAtom[] minAtomArray, MinBond[] minBondArray, MinAngle[] minAngleArray, MinTorsion[] minTorsionArray, MinPosition[] minPositionArray, Lst<Object[]> lst) {
        this.ff = forceField;
        this.minAtoms = minAtomArray;
        this.minBonds = minBondArray;
        this.minAngles = minAngleArray;
        this.minTorsions = minTorsionArray;
        this.minPositions = minPositionArray;
        this.ac = minAtomArray.length;
        this.bondCount = minBondArray.length;
        this.angleCount = minAngleArray.length;
        this.torsionCount = minTorsionArray.length;
        this.constraints = lst;
    }

    abstract boolean setupCalculations();

    abstract String getUnits();

    abstract double compute(int var1, Object[] var2);

    void addForce(V3d v3d, int n, double d) {
        this.minAtoms[n].force[0] = this.minAtoms[n].force[0] + v3d.x * d;
        this.minAtoms[n].force[1] = this.minAtoms[n].force[1] + v3d.y * d;
        this.minAtoms[n].force[2] = this.minAtoms[n].force[2] + v3d.z * d;
    }

    public void setSilent(boolean bl) {
        this.silent = bl;
    }

    public String getLogData() {
        return this.logData.toString();
    }

    void appendLogData(String string) {
        this.logData.append(string).append("\n");
    }

    void setLoggingEnabled(boolean bl) {
        this.loggingEnabled = bl;
        if (this.loggingEnabled) {
            this.logData = new SB();
        }
    }

    void setPreliminary(boolean bl) {
        this.isPreliminary = bl;
    }

    protected void pairSearch(Lst<Object[]> lst, Calculation calculation, Lst<Object[]> lst2, Calculation calculation2) {
        for (int i = 0; i < this.ac - 1; ++i) {
            BS bS = this.minAtoms[i].bsVdw;
            int n = bS.nextSetBit(0);
            while (n >= 0) {
                calculation.setData(lst, i, n, 0.0);
                if (calculation2 != null) {
                    calculation2.setData(lst2, i, n, 0.0);
                }
                n = bS.nextSetBit(n + 1);
            }
        }
    }

    private double calc(int n, boolean bl) {
        int n2;
        this.logging = this.loggingEnabled && !this.silent;
        this.gradients = bl;
        Lst<Object[]> lst = this.calculations[n];
        double d = 0.0;
        if (lst == null || (n2 = lst.size()) == 0) {
            return 0.0;
        }
        if (this.logging) {
            this.appendLogData(this.getDebugHeader(n));
        }
        for (int i = 0; i < n2; ++i) {
            d += this.compute(n, (Object[])this.calculations[n].get(i));
        }
        if (this.logging) {
            this.appendLogData(this.getDebugFooter(n, d));
        }
        if (this.constraints != null && n <= 3) {
            d += this.constraintEnergy(n);
        }
        return d;
    }

    double energyStrBnd(boolean bl) {
        return 0.0;
    }

    double energyBond(boolean bl) {
        return this.calc(0, bl);
    }

    double energyAngle(boolean bl) {
        return this.calc(1, bl);
    }

    double energyTorsion(boolean bl) {
        return this.calc(3, bl);
    }

    double energyStretchBend(boolean bl) {
        return this.calc(2, bl);
    }

    double energyOOP(boolean bl) {
        return this.calc(4, bl);
    }

    double energyVDW(boolean bl) {
        return this.calc(5, bl);
    }

    double energyES(boolean bl) {
        return this.calc(6, bl);
    }

    private double constraintEnergy(int n) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n2 = this.constraints.size();
        while (--n2 >= 0) {
            Object[] objectArray = (Object[])this.constraints.get(n2);
            int n3 = ((int[])objectArray[0])[0];
            if (n3 != n + 2) continue;
            int[] nArray = (int[])objectArray[1];
            double d4 = ((Float)objectArray[2]).doubleValue();
            switch (n) {
                case 3: {
                    this.id = nArray[3];
                    if (this.gradients) {
                        this.dd.setA(this.minAtoms[this.id].coord);
                    }
                }
                case 1: {
                    this.ic = nArray[2];
                    if (this.gradients) {
                        this.dc.setA(this.minAtoms[this.ic].coord);
                    }
                }
                case 0: {
                    this.ib = nArray[1];
                    this.ia = nArray[0];
                    if (!this.gradients) break;
                    this.db.setA(this.minAtoms[this.ib].coord);
                    this.da.setA(this.minAtoms[this.ia].coord);
                }
            }
            d2 = 10000.0;
            switch (n) {
                case 3: {
                    d4 *= Math.PI / 180;
                    double d5 = d = this.gradients ? Util.restorativeForceAndTorsionAngleRadians(this.da, this.db, this.dc, this.dd) : Util.getTorsionAngleRadians(this.minAtoms[this.ia].coord, this.minAtoms[this.ib].coord, this.minAtoms[this.ic].coord, this.minAtoms[this.id].coord, this.v1, this.v2, this.v3);
                    if (d < 0.0 && d4 >= 1.5707963267948966) {
                        d += Math.PI * 2;
                        break;
                    }
                    if (!(d > 0.0) || !(d4 <= -1.5707963267948966)) break;
                    d4 += Math.PI * 2;
                    break;
                }
                case 1: {
                    d4 *= Math.PI / 180;
                    d = this.gradients ? Util.restorativeForceAndAngleRadians(this.da, this.db, this.dc) : Util.getAngleRadiansABC(this.minAtoms[this.ia].coord, this.minAtoms[this.ib].coord, this.minAtoms[this.ic].coord);
                    break;
                }
                case 0: {
                    d = this.gradients ? Util.restorativeForceAndDistance(this.da, this.db, this.dc) : Math.sqrt(Util.distance2(this.minAtoms[this.ia].coord, this.minAtoms[this.ib].coord));
                }
            }
            d3 += this.constrainQuadratic(d, d4, d2, n);
        }
        return d3;
    }

    private double constrainQuadratic(double d, double d2, double d3, int n) {
        if (!Util.isFinite(d)) {
            return 0.0;
        }
        double d4 = d - d2;
        if (this.gradients) {
            double d5 = 2.0 * d3 * d4;
            switch (n) {
                case 3: {
                    this.addForce(this.dd, this.id, d5);
                }
                case 1: {
                    this.addForce(this.dc, this.ic, d5);
                }
                case 0: {
                    this.addForce(this.db, this.ib, d5);
                    this.addForce(this.da, this.ia, d5);
                }
            }
        }
        return d3 * d4 * d4;
    }

    void getConstraintList() {
        if (this.constraints == null || this.constraints.size() == 0) {
            return;
        }
        this.appendLogData("C O N S T R A I N T S\n---------------------");
        int n = this.constraints.size();
        while (--n >= 0) {
            Object[] objectArray = (Object[])this.constraints.get(n);
            int[] nArray = (int[])objectArray[0];
            int[] nArray2 = (int[])objectArray[1];
            double d = ((Float)objectArray[2]).doubleValue();
            int n2 = nArray[0] - 2;
            switch (n2) {
                case 3: {
                    this.id = nArray2[3];
                }
                case 1: {
                    this.ic = nArray2[2];
                }
                case 0: {
                    this.ib = nArray2[1];
                    this.ia = nArray2[0];
                }
            }
            switch (n2) {
                case 0: {
                    this.appendLogData(PT.sprintf((String)"%3d %3d  %-5s %-5s  %12.6f", (String)"ssFI", (Object[])new Object[]{this.minAtoms[this.ia].atom.getAtomName(), this.minAtoms[this.ib].atom.getAtomName(), new float[]{(float)d}, new int[]{this.minAtoms[this.ia].atom.getAtomNumber(), this.minAtoms[this.ib].atom.getAtomNumber()}}));
                    break;
                }
                case 1: {
                    this.appendLogData(PT.sprintf((String)"%3d %3d %3d  %-5s %-5s %-5s  %12.6f", (String)"sssFI", (Object[])new Object[]{this.minAtoms[this.ia].atom.getAtomName(), this.minAtoms[this.ib].atom.getAtomName(), this.minAtoms[this.ic].atom.getAtomName(), new float[]{(float)d}, new int[]{this.minAtoms[this.ia].atom.getAtomNumber(), this.minAtoms[this.ib].atom.getAtomNumber(), this.minAtoms[this.ic].atom.getAtomNumber()}}));
                    break;
                }
                case 3: {
                    this.appendLogData(PT.sprintf((String)"%3d %3d %3d %3d  %-5s %-5s %-5s %-5s  %3d %8.3f     %8.3f     %8.3f     %8.3f", (String)"ssssFI", (Object[])new Object[]{this.minAtoms[this.ia].atom.getAtomName(), this.minAtoms[this.ib].atom.getAtomName(), this.minAtoms[this.ic].atom.getAtomName(), this.minAtoms[this.id].atom.getAtomName(), new float[]{(float)d}, new int[]{this.minAtoms[this.ia].atom.getAtomNumber(), this.minAtoms[this.ib].atom.getAtomNumber(), this.minAtoms[this.ic].atom.getAtomNumber(), this.minAtoms[this.id].atom.getAtomNumber()}}));
                }
            }
        }
        this.appendLogData("---------------------\n");
    }

    String getAtomList(String string) {
        String string2 = "-----------------------------------------------------------------------------------------------\n";
        SB sB = new SB();
        sB.append("\n" + string + "\n\n" + " ATOM    X        Y        Z    TYPE     GRADX    GRADY    GRADZ  " + "---------BONDED ATOMS--------\n" + string2);
        for (int i = 0; i < this.ac; ++i) {
            MinAtom minAtom = this.minAtoms[i];
            int[] nArray = minAtom.getBondedAtomIndexes();
            int[] nArray2 = new int[nArray.length + 1];
            nArray2[0] = minAtom.atom.getAtomNumber();
            String string3 = "   ";
            for (int j = 0; j < nArray.length; ++j) {
                string3 = string3 + " %3d";
                nArray2[j + 1] = this.minAtoms[nArray[j]].atom.getAtomNumber();
            }
            sB.append(PT.sprintf((String)("%3d %8.3f %8.3f %8.3f  %-5s %8.3f %8.3f %8.3f" + string3 + "\n"), (String)"sFI", (Object[])new Object[]{minAtom.sType, new float[]{(float)minAtom.coord[0], (float)minAtom.coord[1], (float)minAtom.coord[2], (float)minAtom.force[0], (float)minAtom.force[1], (float)minAtom.force[2]}, nArray2}));
        }
        sB.append(string2 + "\n\n");
        return sB.toString();
    }

    abstract String getDebugHeader(int var1);

    protected String getDebugHeader2(int n) {
        switch (n) {
            case -1: {
                break;
            }
            case 0: {
                return "\nB O N D   S T R E T C H I N G (" + this.bondCount + " bonds)\n\n" + "  ATOMS  ATOM TYPES   BOND    BOND       IDEAL      FORCE\n" + "  I   J   I     J     TYPE   LENGTH     LENGTH    CONSTANT      DELTA     ENERGY\n" + "--------------------------------------------------------------------------------";
            }
            case 1: {
                return "\nA N G L E   B E N D I N G (" + this.minAngles.length + " angles)\n\n" + "    ATOMS      ATOM TYPES        VALENCE    IDEAL        FORCE\n" + "  I   J   K   I     J     K       ANGLE     ANGLE      CONSTANT     ENERGY\n" + "--------------------------------------------------------------------------";
            }
            case 2: {
                return "\nS T R E T C H   B E N D I N G (" + this.minAngles.length * 2 + " angles)\n\n" + "    ATOMS      ATOM TYPES        VALENCE    IDEAL        FORCE\n" + "  I   J   K   I     J     K       ANGLE     ANGLE      CONSTANT     ENERGY\n" + "--------------------------------------------------------------------------";
            }
            case 3: {
                return "\nT O R S I O N A L (" + this.minTorsions.length + " torsions)\n\n" + "      ATOMS           ATOM TYPES            n    COS          FORCE      TORSION\n" + "  I   J   K   L   I     J     K     L          (n phi0)      CONSTANT     ANGLE        ENERGY\n" + "---------------------------------------------------------------------------------------------";
            }
            case 4: {
                return "\nO U T - O F - P L A N E   B E N D I N G\n\n      ATOMS           ATOM TYPES             OOP        FORCE \n  I   J   K   L   I     J     K     L       ANGLE     CONSTANT      ENERGY\n--------------------------------------------------------------------------";
            }
            case 5: {
                return "\nV A N   D E R   W A A L S  (partial list)\n\n  ATOMS  ATOM TYPES\n  I   J   I     J      Rij       kij     ENERGY\n-----------------------------------------------";
            }
            case 6: {
                return "\nE L E C T R O S T A T I C   I N T E R A C T I O N S  (partial list)\n\n  ATOMS  ATOM TYPES \n  I   J   I     J      Rij      f          Qi          Qj    ENERGY\n-------------------------------------------------------------------";
            }
        }
        return "";
    }

    String getDebugLine(int n, Calculation calculation) {
        return this.getDebugLineC(n, calculation);
    }

    protected String getDebugLineC(int n, Calculation calculation) {
        float f = this.ff.toUserUnits(calculation.energy);
        switch (n) {
            case 0: {
                return PT.sprintf((String)"%3d %3d  %-5s %-5s  %4.2f%8.3f   %8.3f     %8.3f   %8.3f   %8.3f", (String)"ssFI", (Object[])new Object[]{this.minAtoms[calculation.ia].sType, this.minAtoms[calculation.ib].sType, new float[]{0.0f, (float)calculation.rab, (float)calculation.dData[1], (float)calculation.dData[0], (float)calculation.delta, f}, new int[]{this.minAtoms[calculation.ia].atom.getAtomNumber(), this.minAtoms[calculation.ib].atom.getAtomNumber()}});
            }
            case 1: 
            case 2: {
                return PT.sprintf((String)"%3d %3d %3d  %-5s %-5s %-5s  %8.3f  %8.3f     %8.3f   %8.3f", (String)"sssFI", (Object[])new Object[]{this.minAtoms[calculation.ia].sType, this.minAtoms[calculation.ib].sType, this.minAtoms[calculation.ic].sType, new float[]{(float)(calculation.theta * 57.29577951308232), (float)calculation.dData[1], (float)calculation.dData[0], f}, new int[]{this.minAtoms[calculation.ia].atom.getAtomNumber(), this.minAtoms[calculation.ib].atom.getAtomNumber(), this.minAtoms[calculation.ic].atom.getAtomNumber()}});
            }
            case 3: {
                return PT.sprintf((String)"%3d %3d %3d %3d  %-5s %-5s %-5s %-5s  %3d %8.3f     %8.3f     %8.3f     %8.3f", (String)"ssssFI", (Object[])new Object[]{this.minAtoms[calculation.ia].sType, this.minAtoms[calculation.ib].sType, this.minAtoms[calculation.ic].sType, this.minAtoms[calculation.id].sType, new float[]{(float)calculation.dData[1], (float)calculation.dData[0], (float)(calculation.theta * 57.29577951308232), f}, new int[]{this.minAtoms[calculation.ia].atom.getAtomNumber(), this.minAtoms[calculation.ib].atom.getAtomNumber(), this.minAtoms[calculation.ic].atom.getAtomNumber(), this.minAtoms[calculation.id].atom.getAtomNumber(), calculation.iData[4]}});
            }
            case 4: {
                return PT.sprintf((String)"%3d %3d %3d %3d  %-5s %-5s %-5s %-5s  %8.3f   %8.3f     %8.3f", (String)"ssssFI", (Object[])new Object[]{this.minAtoms[calculation.ia].sType, this.minAtoms[calculation.ib].sType, this.minAtoms[calculation.ic].sType, this.minAtoms[calculation.id].sType, new float[]{(float)(calculation.theta * 57.29577951308232), (float)calculation.dData[0], f}, new int[]{this.minAtoms[calculation.ia].atom.getAtomNumber(), this.minAtoms[calculation.ib].atom.getAtomNumber(), this.minAtoms[calculation.ic].atom.getAtomNumber(), this.minAtoms[calculation.id].atom.getAtomNumber()}});
            }
            case 5: {
                return PT.sprintf((String)"%3d %3d  %-5s %-5s %6.3f  %8.3f  %8.3f", (String)"ssFI", (Object[])new Object[]{this.minAtoms[calculation.iData[0]].sType, this.minAtoms[calculation.iData[1]].sType, new float[]{(float)calculation.rab, (float)calculation.dData[0], f}, new int[]{this.minAtoms[calculation.ia].atom.getAtomNumber(), this.minAtoms[calculation.ib].atom.getAtomNumber()}});
            }
            case 6: {
                return PT.sprintf((String)"%3d %3d  %-5s %-5s %6.3f  %8.3f  %8.3f  %8.3f  %8.3f", (String)"ssFI", (Object[])new Object[]{this.minAtoms[calculation.iData[0]].sType, this.minAtoms[calculation.iData[1]].sType, new float[]{(float)calculation.rab, (float)calculation.dData[0], (float)calculation.dData[1], (float)calculation.dData[2], f}, new int[]{this.minAtoms[calculation.ia].atom.getAtomNumber(), this.minAtoms[calculation.ib].atom.getAtomNumber()}});
            }
        }
        return "";
    }

    String getDebugFooter(int n, double d) {
        String string = "";
        switch (n) {
            case 0: {
                string = "BOND STRETCHING";
                break;
            }
            case 1: {
                string = "ANGLE BENDING";
                break;
            }
            case 3: {
                string = "TORSIONAL";
                break;
            }
            case 4: {
                string = "OUT-OF-PLANE BENDING";
                break;
            }
            case 2: {
                string = "STRETCH BENDING";
                break;
            }
            case 5: {
                string = "VAN DER WAALS";
                break;
            }
            case 6: {
                string = "ELECTROSTATIC ENERGY";
            }
        }
        return PT.sprintf((String)"\n     TOTAL %s ENERGY = %8.3f %s/mol\n", (String)"sfs", (Object[])new Object[]{string, Float.valueOf(this.ff.toUserUnits(d)), this.ff.minimizer.units});
    }

    void setPairVariables(Calculation calculation) {
        if (this.gradients) {
            this.setCoords(calculation, 2);
            calculation.rab = Util.restorativeForceAndDistance(this.da, this.db, this.dc);
        } else {
            calculation.rab = Math.sqrt(Util.distance2(this.minAtoms[calculation.ia].coord, this.minAtoms[calculation.ib].coord));
        }
        if (Util.isNearZero2(calculation.rab, 0.001)) {
            calculation.rab = 0.001;
        }
    }

    void setAngleVariables(Calculation calculation) {
        if (this.gradients) {
            this.setCoords(calculation, 3);
            calculation.theta = Util.restorativeForceAndAngleRadians(this.da, this.db, this.dc);
        } else {
            calculation.theta = Util.getAngleRadiansABC(this.minAtoms[calculation.ia].coord, this.minAtoms[calculation.ib].coord, this.minAtoms[calculation.ic].coord);
        }
        if (!Util.isFinite(calculation.theta)) {
            calculation.theta = 0.0;
        }
    }

    void setOopVariables(Calculation calculation, boolean bl) {
        this.setCoords(calculation, 4);
        calculation.theta = this.gradients ? Util.restorativeForceAndOutOfPlaneAngleRadians(this.da, this.db, this.dc, this.dd, this.v1, this.v2, this.v3) : Util.pointPlaneAngleRadians(this.da, this.db, this.dc, this.dd, this.v1, this.v2, this.v3, bl);
        if (!Util.isFinite(calculation.theta)) {
            calculation.theta = 0.0;
        }
    }

    void setTorsionVariables(Calculation calculation) {
        if (this.gradients) {
            this.setCoords(calculation, 4);
            calculation.theta = Util.restorativeForceAndTorsionAngleRadians(this.da, this.db, this.dc, this.dd);
            if (!Util.isFinite(calculation.theta)) {
                calculation.theta = 1.7453292519943296E-5;
            }
        } else {
            calculation.theta = Util.getTorsionAngleRadians(this.minAtoms[calculation.ia].coord, this.minAtoms[calculation.ib].coord, this.minAtoms[calculation.ic].coord, this.minAtoms[calculation.id].coord, this.v1, this.v2, this.v3);
        }
    }

    void setCoords(Calculation calculation, int n) {
        switch (n) {
            case 4: {
                this.da.setA(this.minAtoms[calculation.ia].coord);
            }
            case 3: {
                this.db.setA(this.minAtoms[calculation.ib].coord);
            }
            case 2: {
                this.dc.setA(this.minAtoms[calculation.ic].coord);
            }
            case 1: {
                this.dd.setA(this.minAtoms[calculation.id].coord);
            }
        }
    }

    void addForces(Calculation calculation, int n) {
        switch (n) {
            case 4: {
                this.addForce(this.dd, calculation.id, calculation.dE);
            }
            case 3: {
                this.addForce(this.dc, calculation.ic, calculation.dE);
            }
            case 2: {
                this.addForce(this.db, calculation.ib, calculation.dE);
            }
            case 1: {
                this.addForce(this.da, calculation.ia, calculation.dE);
            }
        }
    }

    boolean isLinear(int n) {
        return false;
    }
}

