/*
 * Decompiled with CFR 0.152.
 */
package javajs.img;

import java.util.Hashtable;
import java.util.Map;
import javajs.export.PDFCreator;
import javajs.img.ImageEncoder;

public class PdfEncoder
extends ImageEncoder {
    private boolean isLandscape;
    private PDFCreator pdf;
    private String comment;

    @Override
    protected void setParams(Map<String, Object> map) {
        this.isLandscape = this.quality > 1;
        this.comment = "Jmol " + (String)map.get("comment");
    }

    @Override
    protected void generate() throws Exception {
        this.pdf = new PDFCreator();
        int n = 576;
        int n2 = 792;
        this.pdf.setOutputStream(this.out);
        this.pdf.newDocument(n, n2, this.isLandscape);
        this.addMyImage(n, n2);
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (this.comment != null) {
            hashtable.put("Producer", this.comment);
        }
        hashtable.put("Author", "JMol");
        hashtable.put("CreationDate", this.date);
        this.pdf.addInfo(hashtable);
        this.pdf.closeDocument();
    }

    private void addMyImage(int n, int n2) {
        this.pdf.addImageResource("img1", this.width, this.height, this.pixels, true);
        int n3 = this.isLandscape ? n2 : n;
        int n4 = this.isLandscape ? n : n2;
        int n5 = this.width;
        int n6 = this.height;
        if ((double)n5 > 0.9 * (double)n3) {
            n6 = (int)((double)n6 * 0.9 * (double)n3 / (double)n5);
            n5 = (int)((double)n3 * 0.9);
        }
        if ((double)n6 > 0.9 * (double)n4) {
            n5 = (int)((double)n5 * 0.9 * (double)n4 / (double)n6);
            n6 = (int)((double)n4 * 0.9);
        }
        int n7 = 0;
        int n8 = 0;
        int n9 = n5;
        int n10 = n6;
        if (n3 > n5) {
            n7 = (n3 - n5) / 2;
            n9 = n5 + n7;
        }
        if (n4 > n6) {
            n8 = (n4 - n6) / 2;
            n10 = n6 + n8;
        }
        this.pdf.drawImage("img1", n7, n8, n9, n10, 0, 0, this.width, this.height);
    }
}

