/*
 * Decompiled with CFR 0.152.
 */
package javajs.util;

import javajs.util.PT;
import javajs.util.SB;

public class XmlUtil {
    public static void openDocument(SB data) {
        data.append("<?xml version=\"1.0\"?>\n");
    }

    public static void openTag(SB sb, String name) {
        sb.append("<").append(name).append(">\n");
    }

    public static void openTagAttr(SB sb, String name, Object[] attributes) {
        XmlUtil.appendTagAll(sb, name, attributes, null, false, false);
        sb.append("\n");
    }

    public static void closeTag(SB sb, String name) {
        sb.append("</").append(name).append(">\n");
    }

    public static void appendTagAll(SB sb, String name, Object[] attributes, Object data, boolean isCdata, boolean doClose) {
        String closer = ">";
        if (name.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
            if (data == null) {
                closer = "/>\n";
                doClose = false;
            }
        }
        sb.append("<").append(name);
        if (attributes != null) {
            int i = 0;
            while (i < attributes.length) {
                Object o = attributes[i];
                if (o != null) {
                    if (o instanceof Object[]) {
                        int j = 0;
                        while (j < ((Object[])o).length) {
                            XmlUtil.appendAttrib(sb, ((Object[])o)[j], ((Object[])o)[j + 1]);
                            j += 2;
                        }
                    } else {
                        XmlUtil.appendAttrib(sb, o, attributes[++i]);
                    }
                }
                ++i;
            }
        }
        sb.append(closer);
        if (data != null) {
            if (isCdata) {
                data = XmlUtil.wrapCdata(data);
            }
            sb.appendO(data);
        }
        if (doClose) {
            XmlUtil.closeTag(sb, name);
        }
    }

    public static String wrapCdata(Object data) {
        String s = "" + data;
        return s.indexOf("&") < 0 && s.indexOf("<") < 0 ? String.valueOf(s.startsWith("\n") ? "" : "\n") + s : "<![CDATA[" + PT.rep(s, "]]>", "]]]]><![CDATA[>") + "]]>";
    }

    public static String unwrapCdata(String s) {
        return s.startsWith("<![CDATA[") && s.endsWith("]]>") ? PT.rep(s.substring(9, s.length() - 3), "]]]]><![CDATA[>", "]]>") : s;
    }

    public static void appendTagObj(SB sb, String name, Object[] attributes, Object data) {
        XmlUtil.appendTagAll(sb, name, attributes, data, false, true);
    }

    public static void appendTag(SB sb, String name, Object data) {
        if (data instanceof Object[]) {
            XmlUtil.appendTagAll(sb, name, (Object[])data, null, false, true);
        } else {
            XmlUtil.appendTagAll(sb, name, null, data, false, true);
        }
    }

    public static void appendCdata(SB sb, String name, Object[] attributes, String data) {
        XmlUtil.appendTagAll(sb, name, attributes, data, true, true);
    }

    public static void appendAttrib(SB sb, Object name, Object value) {
        if (value == null) {
            return;
        }
        sb.append(" ").appendO(name).append("=\"").appendO(value).append("\"");
    }
}

