/*
 * Decompiled with CFR 0.152.
 */
package javajs.util;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.util.Map;
import javajs.api.GenericZipTools;
import javajs.util.BinaryDocument;
import javajs.util.CompoundDocDirEntry;
import javajs.util.CompoundDocHeader;
import javajs.util.Lst;
import javajs.util.SB;
import javajs.util.ZipData;

public class CompoundDocument
extends BinaryDocument {
    CompoundDocHeader header = new CompoundDocHeader(this);
    Lst<CompoundDocDirEntry> directory = new Lst();
    CompoundDocDirEntry rootEntry;
    int[] SAT;
    int[] SSAT;
    int sectorSize;
    int shortSectorSize;
    int nShortSectorsPerStandardSector;
    int nIntPerSector;
    int nDirEntriesperSector;
    SB data;

    public CompoundDocument() {
        this.isBigEndian = true;
    }

    @Override
    public void setStream(GenericZipTools jzt, BufferedInputStream bis, boolean isBigEndian) {
        this.jzt = jzt;
        if (!this.isRandom) {
            this.stream = new DataInputStream(bis);
        }
        this.stream.mark(Integer.MAX_VALUE);
        if (!this.readHeader()) {
            return;
        }
        this.getSectorAllocationTable();
        this.getShortSectorAllocationTable();
        this.getDirectoryTable();
    }

    public Lst<CompoundDocDirEntry> getDirectory() {
        return this.directory;
    }

    public String getDirectoryListing(String separator) {
        String str = "";
        int i = 0;
        while (i < this.directory.size()) {
            CompoundDocDirEntry thisEntry = (CompoundDocDirEntry)this.directory.get(i);
            if (!thisEntry.isEmpty) {
                str = String.valueOf(str) + separator + thisEntry.entryName + "\tlen=" + thisEntry.lenStream + "\tSID=" + thisEntry.SIDfirstSector + (thisEntry.isStandard ? "\tfileOffset=" + this.getOffset(thisEntry.SIDfirstSector) : "");
            }
            ++i;
        }
        return str;
    }

    public SB getAllData() {
        return this.getAllDataFiles(null, null);
    }

    @Override
    public void getAllDataMapped(String prefix, String binaryFileList, Map<String, String> fileData) {
        fileData.put("#Directory_Listing", this.getDirectoryListing("|"));
        binaryFileList = "|" + binaryFileList + "|";
        int i = 0;
        while (i < this.directory.size()) {
            CompoundDocDirEntry thisEntry = (CompoundDocDirEntry)this.directory.get(i);
            if (!thisEntry.isEmpty && thisEntry.entryType != 5) {
                boolean isBinary;
                String name = thisEntry.entryName;
                System.out.println("CompoundDocument file " + name);
                boolean bl = isBinary = binaryFileList.indexOf("|" + name + "|") >= 0;
                if (isBinary) {
                    name = String.valueOf(name) + ":asBinaryString";
                }
                SB data = new SB();
                data.append("BEGIN Directory Entry ").append(name).append("\n");
                data.appendSB(this.getEntryAsString(thisEntry, isBinary));
                data.append("\nEND Directory Entry ").append(name).append("\n");
                fileData.put(String.valueOf(prefix) + "/" + name, data.toString());
            }
            ++i;
        }
        this.close();
    }

    @Override
    public SB getAllDataFiles(String binaryFileList, String firstFile) {
        CompoundDocDirEntry thisEntry;
        int i;
        if (firstFile != null) {
            i = 0;
            while (i < this.directory.size()) {
                thisEntry = (CompoundDocDirEntry)this.directory.get(i);
                if (thisEntry.entryName.equals(firstFile)) {
                    this.directory.remove(i);
                    this.directory.add(1, thisEntry);
                    break;
                }
                ++i;
            }
        }
        this.data = new SB();
        this.data.append("Compound Document File Directory: ");
        this.data.append(this.getDirectoryListing("|"));
        this.data.append("\n");
        binaryFileList = "|" + binaryFileList + "|";
        i = 0;
        while (i < this.directory.size()) {
            thisEntry = (CompoundDocDirEntry)this.directory.get(i);
            if (!thisEntry.isEmpty && thisEntry.entryType != 5) {
                String name = thisEntry.entryName;
                if (name.endsWith(".gz")) {
                    name = name.substring(0, name.length() - 3);
                }
                this.data.append("BEGIN Directory Entry ").append(name).append("\n");
                this.data.appendSB(this.getEntryAsString(thisEntry, binaryFileList.indexOf("|" + thisEntry.entryName + "|") >= 0));
                this.data.append("\n");
                this.data.append("END Directory Entry ").append(thisEntry.entryName).append("\n");
            }
            ++i;
        }
        this.close();
        return this.data;
    }

    public SB getFileAsString(String entryName) {
        int i = 0;
        while (i < this.directory.size()) {
            CompoundDocDirEntry thisEntry = (CompoundDocDirEntry)this.directory.get(i);
            if (thisEntry.entryName.equals(entryName)) {
                return this.getEntryAsString(thisEntry, false);
            }
            ++i;
        }
        return new SB();
    }

    private long getOffset(int SID) {
        return (SID + 1) * this.sectorSize;
    }

    private void gotoSector(int SID) {
        this.seek(this.getOffset(SID));
    }

    private boolean readHeader() {
        if (!this.header.readData()) {
            return false;
        }
        this.sectorSize = 1 << this.header.sectorPower;
        this.shortSectorSize = 1 << this.header.shortSectorPower;
        this.nShortSectorsPerStandardSector = this.sectorSize / this.shortSectorSize;
        this.nIntPerSector = this.sectorSize / 4;
        this.nDirEntriesperSector = this.sectorSize / 128;
        return true;
    }

    private void getSectorAllocationTable() {
        block9: {
            int nSID = 0;
            this.SAT = new int[this.header.nSATsectors * this.nIntPerSector + 109];
            try {
                int thisSID;
                int i = 0;
                while (i < 109) {
                    thisSID = this.header.MSAT0[i];
                    if (thisSID < 0) break;
                    this.gotoSector(thisSID);
                    int j = 0;
                    while (j < this.nIntPerSector) {
                        this.SAT[nSID++] = this.readInt();
                        ++j;
                    }
                    ++i;
                }
                int nMaster = this.header.nAdditionalMATsectors;
                thisSID = this.header.SID_MSAT_next;
                int[] MSAT = new int[this.nIntPerSector];
                while (nMaster-- > 0 && thisSID >= 0) {
                    this.gotoSector(thisSID);
                    int i2 = 0;
                    while (i2 < this.nIntPerSector) {
                        MSAT[i2] = this.readInt();
                        ++i2;
                    }
                    i2 = 0;
                    while (i2 < this.nIntPerSector - 1) {
                        thisSID = MSAT[i2];
                        if (thisSID >= 0) {
                            this.gotoSector(thisSID);
                            int j = this.nIntPerSector;
                            while (--j >= 0) {
                                this.SAT[nSID++] = this.readInt();
                            }
                            ++i2;
                            continue;
                        }
                        break block9;
                    }
                    thisSID = MSAT[this.nIntPerSector - 1];
                }
            }
            catch (Exception e) {
                System.out.println(e.toString());
            }
        }
    }

    private void getShortSectorAllocationTable() {
        int nSSID = 0;
        int thisSID = this.header.SID_SSAT_start;
        int nMax = this.header.nSSATsectors * this.nIntPerSector;
        this.SSAT = new int[nMax];
        try {
            while (thisSID > 0 && nSSID < nMax) {
                this.gotoSector(thisSID);
                int j = 0;
                while (j < this.nIntPerSector) {
                    this.SSAT[nSSID++] = this.readInt();
                    ++j;
                }
                thisSID = this.SAT[thisSID];
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    private void getDirectoryTable() {
        int thisSID = this.header.SID_DIR_start;
        this.rootEntry = null;
        try {
            while (thisSID > 0) {
                this.gotoSector(thisSID);
                int j = this.nDirEntriesperSector;
                while (--j >= 0) {
                    CompoundDocDirEntry thisEntry = new CompoundDocDirEntry(this);
                    thisEntry.readData();
                    if (thisEntry.lenStream > 0) {
                        this.directory.addLast(thisEntry);
                    }
                    if (thisEntry.entryType != 5) continue;
                    this.rootEntry = thisEntry;
                }
                thisSID = this.SAT[thisSID];
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    private SB getEntryAsString(CompoundDocDirEntry thisEntry, boolean asBinaryString) {
        if (thisEntry.isEmpty) {
            return new SB();
        }
        return thisEntry.isStandard ? this.getStandardStringData(thisEntry.SIDfirstSector, thisEntry.lenStream, asBinaryString) : this.getShortStringData(thisEntry.SIDfirstSector, thisEntry.lenStream, asBinaryString);
    }

    private SB getStandardStringData(int thisSID, int nBytes, boolean asBinaryString) {
        SB data = new SB();
        byte[] byteBuf = new byte[this.sectorSize];
        ZipData gzipData = new ZipData(nBytes);
        try {
            while (thisSID > 0 && nBytes > 0) {
                this.gotoSector(thisSID);
                nBytes = this.getSectorData(data, byteBuf, this.sectorSize, nBytes, asBinaryString, gzipData);
                thisSID = this.SAT[thisSID];
            }
            if (nBytes == -9999) {
                return new SB();
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        if (gzipData.isEnabled) {
            gzipData.addTo(this.jzt, data);
        }
        return data;
    }

    private int getSectorData(SB data, byte[] byteBuf, int nSectorBytes, int nBytes, boolean asBinaryString, ZipData gzipData) throws Exception {
        this.readByteArray(byteBuf, 0, byteBuf.length);
        int n = gzipData.addBytes(byteBuf, nSectorBytes, nBytes);
        if (n >= 0) {
            return n;
        }
        if (asBinaryString) {
            int i = 0;
            while (i < nSectorBytes) {
                data.append(Integer.toHexString(byteBuf[i] & 0xFF)).appendC(' ');
                if (--nBytes >= 1) {
                    ++i;
                    continue;
                }
                break;
            }
        } else {
            int i = 0;
            while (i < nSectorBytes) {
                if (byteBuf[i] == 0) {
                    return -9999;
                }
                data.appendC((char)byteBuf[i]);
                if (--nBytes >= 1) {
                    ++i;
                    continue;
                }
                break;
            }
        }
        return nBytes;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SB getShortStringData(int shortSID, int nBytes, boolean asBinaryString) {
        SB data = new SB();
        if (this.rootEntry == null) {
            return data;
        }
        int thisSID = this.rootEntry.SIDfirstSector;
        int ptShort = 0;
        byte[] byteBuf = new byte[this.shortSectorSize];
        ZipData gzipData = new ZipData(nBytes);
        try {
            block2: while (thisSID >= 0 && shortSID >= 0 && nBytes > 0) {
                while (true) {
                    if (shortSID - ptShort < this.nShortSectorsPerStandardSector) {
                        this.seek(this.getOffset(thisSID) + (long)((shortSID - ptShort) * this.shortSectorSize));
                        nBytes = this.getSectorData(data, byteBuf, this.shortSectorSize, nBytes, asBinaryString, gzipData);
                        shortSID = this.SSAT[shortSID];
                        continue block2;
                    }
                    ptShort += this.nShortSectorsPerStandardSector;
                    thisSID = this.SAT[thisSID];
                }
            }
        }
        catch (Exception e) {
            System.out.println(data.toString());
            System.out.println("reader error in CompoundDocument " + e.toString());
        }
        if (gzipData.isEnabled) {
            gzipData.addTo(this.jzt, data);
        }
        return data;
    }
}

