/*
 * Decompiled with CFR 0.152.
 */
package jspecview.application;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javajs.util.CU;
import javajs.util.Lst;
import javajs.util.PT;
import javajs.util.SB;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import jspecview.api.JSVAppInterface;
import jspecview.api.JSVFileDropper;
import jspecview.api.JSVPanel;
import jspecview.api.JSVTreeNode;
import jspecview.api.PanelListener;
import jspecview.app.JSVAppPro;
import jspecview.application.AppToolBar;
import jspecview.application.ApplicationMenu;
import jspecview.application.AwtTree;
import jspecview.application.CommandHistory;
import jspecview.application.DisplaySchemesProcessor;
import jspecview.application.JSpecView;
import jspecview.application.PreferencesDialog;
import jspecview.common.ColorParameters;
import jspecview.common.JSVFileManager;
import jspecview.common.JSViewer;
import jspecview.common.PanelData;
import jspecview.common.PanelNode;
import jspecview.common.Parameters;
import jspecview.common.PeakPickEvent;
import jspecview.common.ScriptToken;
import jspecview.common.Spectrum;
import jspecview.common.SubSpecChangeEvent;
import jspecview.common.ZoomEvent;
import jspecview.export.Exporter;
import jspecview.java.AwtFileHelper;
import jspecview.java.AwtMainPanel;
import jspecview.java.AwtPanel;
import jspecview.source.JDXSource;
import org.jmol.api.JSVInterface;
import org.jmol.api.JmolSyncInterface;
import org.jmol.util.Logger;

public class MainFrame
extends JFrame
implements JmolSyncInterface,
PanelListener,
JSVAppInterface {
    private static final long serialVersionUID = 1L;
    private static final int MAX_RECENT = 10;
    public JSViewer vwr;
    private ApplicationMenu appMenu;
    private AppToolBar toolBar;
    private JTextField commandInput = new JTextField();
    private BorderLayout mainborderLayout = new BorderLayout();
    private JSplitPane mainSplitPane = new JSplitPane();
    private final JPanel nullPanel = new JPanel();
    private JSplitPane sideSplitPane = new JSplitPane();
    private JSVAppPro advancedApplet;
    private CommandHistory commandHistory;
    private DisplaySchemesProcessor dsp;
    private JmolSyncInterface jmol;
    private Component jmolDisplay;
    private Dimension jmolDimensionOld;
    private Container jmolFrame;
    private Dimension jmolDimensionNew = new Dimension(250, 200);
    private JSVInterface jmolOrAdvancedApplet;
    private JSVPanel prevPanel;
    private Lst<String> recentFilePaths = new Lst();
    private JScrollPane spectraTreeScrollPane;
    private Component mainPanel;
    private JPanel statusPanel = new JPanel();
    private JLabel statusLabel = new JLabel();
    private AwtTree tree;
    private boolean sidePanelOn;
    private boolean showExitDialog;
    private boolean statusbarOn;
    private boolean toolbarOn;
    private int mainSplitPosition = 200;
    private int splitPosition;
    private boolean isEmbedded;
    private boolean isHidden;
    private String tempDS;
    private String defaultDisplaySchemeName;
    private boolean isAwake;

    public static void main(String[] args) {
        JSpecView.main(args);
    }

    @Override
    public boolean isPro() {
        return true;
    }

    @Override
    public boolean isSigned() {
        return true;
    }

    public MainFrame(Component jmolDisplay, JSVInterface jmolOrAdvancedApplet) {
        this.vwr = new JSViewer(this, false, false);
        JSVFileManager.setDocumentBase(this.vwr, null);
        this.jmolDisplay = jmolDisplay;
        if (jmolDisplay != null) {
            this.jmolFrame = jmolDisplay.getParent();
        }
        this.jmolOrAdvancedApplet = jmolOrAdvancedApplet;
        this.advancedApplet = jmolOrAdvancedApplet instanceof JSVAppPro ? (JSVAppPro)jmolOrAdvancedApplet : null;
        this.init();
    }

    void exitJSpecView(boolean withDialog) {
        this.jmolOrAdvancedApplet.saveProperties(this.vwr.properties);
        if (this.isEmbedded) {
            this.awaken(false);
            return;
        }
        this.dsp.getDisplaySchemes().remove("Current");
        this.jmolOrAdvancedApplet.exitJSpecView(withDialog && this.showExitDialog, this);
    }

    public void awaken(boolean visible) {
        System.out.println("MAINFRAME visible/awake" + visible + " " + this.isAwake + " " + this.jmolDisplay);
        if (this.jmolDisplay == null || this.isAwake == visible) {
            return;
        }
        try {
            this.isAwake = visible;
            if (visible) {
                this.jmolDimensionOld = new Dimension(0, 0);
                this.jmolDisplay.getSize(this.jmolDimensionOld);
                this.jmolDisplay.setSize(this.jmolDimensionNew);
                this.jmolFrame.remove(this.jmolDisplay);
                this.jmolFrame.add(this.nullPanel);
                this.sideSplitPane.setBottomComponent(this.jmolDisplay);
                this.sideSplitPane.setDividerLocation(this.splitPosition);
                this.sideSplitPane.validate();
                this.jmolFrame.validate();
                System.out.println("awakened");
            } else {
                this.sideSplitPane.setBottomComponent(this.nullPanel);
                this.splitPosition = this.sideSplitPane.getDividerLocation();
                this.jmolFrame.add(this.jmolDisplay);
                this.jmolDisplay.getSize(this.jmolDimensionNew);
                this.jmolDisplay.setSize(this.jmolDimensionOld);
                this.sideSplitPane.validate();
                this.jmolFrame.validate();
                System.out.println("sleeping");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setVisible(visible);
    }

    private void init() {
        DropTargetListener dtl = (DropTargetListener)this.vwr.getPlatformInterface("FileDropper");
        ((JSVFileDropper)((Object)dtl)).set(this.vwr);
        new DropTarget(this, dtl);
        Class<?> cl = this.getClass();
        URL iconURL = cl.getResource("icons/spec16.gif");
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(iconURL));
        Properties properties = this.vwr.properties = new Properties();
        properties.setProperty("recentFilePaths", "");
        properties.setProperty("confirmBeforeExit", "true");
        properties.setProperty("automaticallyOverlay", "false");
        properties.setProperty("automaticallyShowLegend", "false");
        properties.setProperty("useDirectoryLastOpenedFile", "true");
        properties.setProperty("useDirectoryLastExportedFile", "false");
        properties.setProperty("directoryLastOpenedFile", "");
        properties.setProperty("directoryLastExportedFile", "");
        properties.setProperty("showSidePanel", "true");
        properties.setProperty("showToolBar", "true");
        properties.setProperty("showStatusBar", "true");
        properties.setProperty("defaultDisplaySchemeName", "Default");
        properties.setProperty("showGrid", "false");
        properties.setProperty("showCoordinates", "false");
        properties.setProperty("showXScale", "true");
        properties.setProperty("showYScale", "true");
        properties.setProperty("svgForInkscape", "false");
        properties.setProperty("automaticTAConversion", "false");
        properties.setProperty("AtoTSeparateWindow", "false");
        properties.setProperty("automaticallyIntegrate", "false");
        properties.setProperty("integralMinY", "0.1");
        properties.setProperty("integralFactor", "50");
        properties.setProperty("integralOffset", "30");
        properties.setProperty("integralPlotColor", "#ff0000");
        this.jmolOrAdvancedApplet.setProperties(properties);
        this.dsp = new DisplaySchemesProcessor();
        if (!this.dsp.load("displaySchemes.xml") && !this.dsp.load(this.getClass().getResourceAsStream("resources/displaySchemes.xml"))) {
            this.writeStatus("Problem loading Display Scheme");
        }
        this.setApplicationProperties(true);
        this.tempDS = this.defaultDisplaySchemeName;
        this.tree = new AwtTree(this.vwr);
        this.vwr.spectraTree = this.tree;
        this.tree.setCellRenderer(new SpectraTreeCellRenderer());
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        this.tree.setShowsRootHandles(true);
        this.tree.setEditable(false);
        this.tree.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && MainFrame.this.vwr.selectedPanel != null) {
                    MainFrame.this.vwr.selectedPanel.getPanelData().setZoom(0.0, 0.0, 0.0, 0.0);
                    MainFrame.this.repaint();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        new DropTarget(this.tree, dtl);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setApplicationElements();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                MainFrame.this.windowClosing_actionPerformed();
            }
        });
        this.setSize(800, 500);
    }

    private void setApplicationElements() {
        this.appMenu.setSelections(this.sidePanelOn, this.toolbarOn, this.statusbarOn, this.vwr.selectedPanel);
        this.toolBar.setSelections(this.vwr.selectedPanel);
    }

    private void setApplicationProperties(boolean shouldApplySpectrumDisplaySettings) {
        Properties properties = this.vwr.properties;
        String recentFilesString = properties.getProperty("recentFilePaths");
        this.recentFilePaths.clear();
        if (!recentFilesString.equals("")) {
            StringTokenizer st = new StringTokenizer(recentFilesString, ",");
            while (st.hasMoreTokens()) {
                String file = st.nextToken().trim();
                if (file.length() >= 100) continue;
                this.recentFilePaths.addLast(file);
            }
        }
        this.showExitDialog = Boolean.parseBoolean(properties.getProperty("confirmBeforeExit"));
        this.vwr.interfaceOverlaid = Boolean.parseBoolean(properties.getProperty("automaticallyOverlay"));
        this.vwr.autoShowLegend = Boolean.parseBoolean(properties.getProperty("automaticallyShowLegend"));
        AwtFileHelper fh = (AwtFileHelper)this.vwr.fileHelper;
        fh.useDirLastOpened = Boolean.parseBoolean(properties.getProperty("useDirectoryLastOpenedFile"));
        fh.useDirLastExported = Boolean.parseBoolean(properties.getProperty("useDirectoryLastExportedFile"));
        fh.dirLastOpened = properties.getProperty("directoryLastOpenedFile");
        fh.dirLastExported = properties.getProperty("directoryLastExportedFile");
        this.sidePanelOn = Boolean.parseBoolean(properties.getProperty("showSidePanel"));
        this.toolbarOn = Boolean.parseBoolean(properties.getProperty("showToolBar"));
        this.statusbarOn = Boolean.parseBoolean(properties.getProperty("showStatusBar"));
        this.defaultDisplaySchemeName = properties.getProperty("defaultDisplaySchemeName");
        if (shouldApplySpectrumDisplaySettings) {
            this.vwr.parameters.setBoolean(ScriptToken.GRIDON, Parameters.isTrue(properties.getProperty("showGrid")));
            this.vwr.parameters.setBoolean(ScriptToken.COORDINATESON, Parameters.isTrue(properties.getProperty("showCoordinates")));
            this.vwr.parameters.setBoolean(ScriptToken.XSCALEON, Parameters.isTrue(properties.getProperty("showXScale")));
            this.vwr.parameters.setBoolean(ScriptToken.YSCALEON, Parameters.isTrue(properties.getProperty("showYScale")));
        }
        this.vwr.setIRmode(properties.getProperty("automaticTAConversion"));
        try {
            this.vwr.autoIntegrate = Boolean.parseBoolean(properties.getProperty("automaticallyIntegrate"));
            this.vwr.parameters.integralMinY = Double.parseDouble(properties.getProperty("integralMinY"));
            this.vwr.parameters.integralRange = Double.parseDouble(properties.getProperty("integralRange"));
            this.vwr.parameters.integralOffset = Double.parseDouble(properties.getProperty("integralOffset"));
            this.vwr.parameters.set(null, ScriptToken.INTEGRALPLOTCOLOR, properties.getProperty("integralPlotColor"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void jbInit() throws Exception {
        this.toolBar = new AppToolBar(this);
        this.appMenu = new ApplicationMenu(this);
        this.appMenu.setRecentMenu(this.recentFilePaths);
        this.setDefaultCloseOperation(2);
        this.setJMenuBar(this.appMenu);
        this.setTitle("JSpecView");
        this.getContentPane().setLayout(this.mainborderLayout);
        this.sideSplitPane.setOrientation(0);
        this.sideSplitPane.setOneTouchExpandable(true);
        this.statusLabel.setToolTipText("");
        this.statusLabel.setHorizontalTextPosition(10);
        this.statusLabel.setText("  ");
        this.statusPanel.setBorder(BorderFactory.createEtchedBorder());
        BorderLayout bl = new BorderLayout();
        bl.setHgap(2);
        bl.setVgap(2);
        this.statusPanel.setLayout(bl);
        this.mainSplitPane.setOneTouchExpandable(true);
        this.mainSplitPane.setResizeWeight(0.3);
        this.getContentPane().add((Component)this.statusPanel, "South");
        this.statusPanel.add((Component)this.statusLabel, "North");
        this.statusPanel.add((Component)this.commandInput, "South");
        this.commandHistory = new CommandHistory(this.vwr, this.commandInput);
        this.commandInput.setFocusTraversalKeysEnabled(false);
        this.commandInput.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                MainFrame.this.keyPressedEvent(e.getKeyCode(), e.getKeyChar());
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.getContentPane().add((Component)this.toolBar, "North");
        this.getContentPane().add((Component)this.mainSplitPane, "Center");
        this.spectraTreeScrollPane = new JScrollPane(this.tree);
        if (this.jmolDisplay != null) {
            JSplitPane leftPanel = new JSplitPane();
            BorderLayout bl1 = new BorderLayout();
            leftPanel.setLayout(bl1);
            JPanel jmolDisplayPanel = new JPanel();
            jmolDisplayPanel.setBackground(Color.BLACK);
            leftPanel.add((Component)jmolDisplayPanel, "South");
            leftPanel.add((Component)this.spectraTreeScrollPane, "North");
            this.sideSplitPane.setTopComponent(this.spectraTreeScrollPane);
            this.splitPosition = 200;
            this.sideSplitPane.setDividerLocation(200);
            this.awaken(true);
            this.mainSplitPane.setLeftComponent(this.sideSplitPane);
        } else {
            this.mainSplitPane.setLeftComponent(this.spectraTreeScrollPane);
        }
        this.vwr.mainPanel = new AwtMainPanel(new BorderLayout());
        this.mainPanel = (Component)((Object)this.vwr.mainPanel);
        this.mainSplitPane.setRightComponent(this.mainPanel);
    }

    protected void keyPressedEvent(int keyCode, char keyChar) {
        this.commandHistory.keyPressed(keyCode);
        this.checkCommandLineForTip(keyChar);
        this.commandInput.requestFocusInWindow();
    }

    protected void checkCommandLineForTip(char c) {
        String tip;
        if (c != '\t' && (c == '\n' || c < ' ' || c > '~')) {
            return;
        }
        String cmd = String.valueOf(this.commandInput.getText()) + (Character.isISOControl(c) ? "" : "" + c);
        if (cmd.indexOf(";") >= 0) {
            cmd = cmd.substring(cmd.lastIndexOf(";") + 1);
        }
        while (cmd.startsWith(" ")) {
            cmd = cmd.substring(1);
        }
        if (cmd.length() == 0) {
            tip = "Enter a command:";
        } else {
            Lst<String> tokens = ScriptToken.getTokens(cmd);
            if (tokens.size() == 0) {
                return;
            }
            boolean isExact = cmd.endsWith(" ") || tokens.size() > 1;
            Lst<ScriptToken> list = ScriptToken.getScriptTokenList((String)tokens.get(0), isExact);
            switch (list.size()) {
                case 0: {
                    tip = "?";
                    break;
                }
                case 1: {
                    ScriptToken st = (ScriptToken)((Object)list.get(0));
                    tip = st.getTip();
                    try {
                        tip = tip.indexOf("TRUE") >= 0 ? " (" + this.vwr.parameters.getBoolean(st) + ")" : (st.name().indexOf("COLOR") >= 0 ? " (" + CU.toRGBHexString(this.vwr.parameters.getElementColor(st)) + ")" : "");
                    }
                    catch (Exception e) {
                        return;
                    }
                    if (c == '\t' || isExact) {
                        tip = String.valueOf(st.name()) + " " + st.getTip() + tip;
                        if (c != '\t') break;
                        this.commandInput.setText(String.valueOf(st.name()) + " ");
                        break;
                    }
                    tip = String.valueOf(st.name()) + " " + tip;
                    break;
                }
                default: {
                    tip = ScriptToken.getNameList(list);
                }
            }
        }
        this.writeStatus(tip);
    }

    private void setError(boolean isError, boolean isWarningOnly) {
        this.appMenu.setError(isError, isWarningOnly);
        this.toolBar.setError(isError, isWarningOnly);
    }

    public void showNotImplementedOptionPane() {
        JOptionPane.showMessageDialog(this, "Not Yet Implemented", "Not Yet Implemented", 1);
    }

    @Override
    public boolean runScriptNow(String peakScript) {
        return this.vwr.runScriptNow(peakScript);
    }

    @Override
    public void panelEvent(Object eventObj) {
        SubSpecChangeEvent e;
        if (eventObj instanceof PeakPickEvent) {
            this.vwr.processPeakPickEvent(eventObj, true);
        } else if (eventObj instanceof ZoomEvent) {
            this.writeStatus("Double-Click highlighted spectrum in menu to zoom out; CTRL+/CTRL- to adjust Y scaling.");
        } else if (eventObj instanceof SubSpecChangeEvent && !(e = (SubSpecChangeEvent)eventObj).isValid()) {
            this.advanceSpectrumBy(-e.getSubIndex());
        }
    }

    private void advanceSpectrumBy(int n) {
        int i = this.vwr.panelNodes.size();
        while (--i >= 0) {
            if (((PanelNode)this.vwr.panelNodes.get((int)i)).jsvp == this.vwr.selectedPanel) break;
        }
        this.vwr.setFrameAndTreeNode(i + n);
        this.vwr.selectedPanel.getFocusNow(false);
    }

    @Override
    public Lst<String> getScriptQueue() {
        return null;
    }

    public void setSplitPane(boolean TF) {
        if (TF) {
            this.mainSplitPane.setDividerLocation(200);
        } else {
            this.mainSplitPane.setDividerLocation(0);
        }
    }

    public void enableToolbar(boolean isEnabled) {
        if (isEnabled) {
            this.getContentPane().add((Component)this.toolBar, "North");
        } else {
            this.getContentPane().remove(this.toolBar);
        }
        this.validate();
    }

    public void showPreferences() {
        PreferencesDialog pd = new PreferencesDialog(this, this.vwr, "Preferences", true, this.dsp);
        this.vwr.properties = pd.getPreferences();
        boolean shouldApplySpectrumDisplaySetting = pd.shouldApplySpectrumDisplaySettingsNow();
        this.setApplicationProperties(shouldApplySpectrumDisplaySetting);
        int i = this.vwr.panelNodes.size();
        while (--i >= 0) {
            this.siSetPropertiesFromPreferences(((PanelNode)this.vwr.panelNodes.get((int)i)).jsvp, shouldApplySpectrumDisplaySetting);
        }
        this.setApplicationElements();
        this.dsp.getDisplaySchemes();
        if (this.defaultDisplaySchemeName.equals("Current")) {
            this.vwr.setProperty("defaultDisplaySchemeName", this.tempDS);
        }
    }

    void exportSpectrumViaMenu(String command) {
        new Exporter().write(this.vwr, ScriptToken.getTokens(command), false);
    }

    public void enableStatus(boolean TF) {
        if (TF) {
            this.getContentPane().add((Component)this.statusPanel, "South");
        } else {
            this.getContentPane().remove(this.statusPanel);
        }
        this.validate();
    }

    protected void windowClosing_actionPerformed() {
        this.exitJSpecView(true);
    }

    @Override
    public Map<String, Object> getJSpecViewProperty(String key) {
        return this.vwr.getPropertyAsJavaObject(key);
    }

    @Override
    public void register(String appletID, JmolSyncInterface jmolStatusListener) {
        this.jmol = jmolStatusListener;
        this.isEmbedded = true;
    }

    @Override
    public synchronized void syncToJmol(String msg) {
        Logger.info("JSV>Jmol " + msg);
        if (this.jmol != null) {
            this.jmol.syncScript(msg);
            return;
        }
        if (this.jmolOrAdvancedApplet != null) {
            this.jmolOrAdvancedApplet.syncToJmol(msg);
        }
    }

    @Override
    public synchronized void syncScript(String peakScript) {
        this.tree.setEnabled(false);
        this.vwr.syncScript(peakScript);
        this.tree.setEnabled(true);
    }

    @Override
    public void addHighlight(double x1, double x2, int r, int g, int b, int a) {
        this.advancedApplet.addHighlight(x1, x2, r, g, b, a);
    }

    @Override
    public String exportSpectrum(String type, int n) {
        return this.advancedApplet.exportSpectrum(type, n);
    }

    @Override
    public String getCoordinate() {
        return this.advancedApplet.getCoordinate();
    }

    @Override
    public String getPropertyAsJSON(String key) {
        return this.advancedApplet.getPropertyAsJSON(key);
    }

    @Override
    public Map<String, Object> getPropertyAsJavaObject(String key) {
        return this.advancedApplet.getPropertyAsJavaObject(key);
    }

    @Override
    public String getSolnColour() {
        return this.advancedApplet.getSolnColour();
    }

    @Override
    public void loadInline(String data) {
        this.siOpenDataOrFile(data, null, null, null, -1, -1, true, null, null);
    }

    @Override
    public void setFilePath(String tmpFilePath) {
        this.siProcessCommand("load " + tmpFilePath);
    }

    @Override
    public void runScript(String script) {
        this.runScriptNow(script);
    }

    @Override
    public void removeAllHighlights() {
        this.advancedApplet.removeAllHighlights();
    }

    @Override
    public void removeHighlight(double x1, double x2) {
        this.advancedApplet.removeHighlight(x1, x2);
    }

    @Override
    public void reversePlot() {
        this.advancedApplet.reversePlot();
    }

    public void setCursorObject(Object c) {
        this.setCursor((Cursor)c);
    }

    @Override
    public void setSpectrumNumber(int i) {
        this.advancedApplet.setSpectrumNumber(i);
    }

    @Override
    public void toggleCoordinate() {
        this.advancedApplet.toggleCoordinate();
    }

    @Override
    public void toggleGrid() {
        this.advancedApplet.toggleGrid();
    }

    @Override
    public void toggleIntegration() {
        this.advancedApplet.toggleIntegration();
    }

    @Override
    public void writeStatus(String msg) {
        if (msg == null) {
            msg = "Unexpected Error";
        }
        if (msg.length() == 0) {
            msg = "Enter a command:";
        }
        this.statusLabel.setText(msg);
    }

    @Override
    public void siOpenDataOrFile(Object data, String name, Lst<Spectrum> specs, String url, int firstSpec, int lastSpec, boolean isAppend, String script, String id) {
        boolean isOne = this.vwr.currentSource == null;
        switch (this.vwr.openDataOrFile(data, name, specs, url, firstSpec, lastSpec, isAppend, id)) {
            case 0: {
                if (script == null && isOne && this.vwr.currentSource.isCompoundSource && this.vwr.pd().getSpectrum().isGC()) {
                    script = "VIEW ALL;PEAK GC/MS ID=#1";
                }
                if (script == null) break;
                this.runScript(script);
            }
        }
        this.siValidateAndRepaint(false);
    }

    @Override
    public void siSetCurrentSource(JDXSource source) {
        this.vwr.currentSource = source;
        if (source != null) {
            this.appMenu.setCloseMenuItem(JSVFileManager.getTagName(source.getFilePath()));
        }
        boolean isError = source != null && source.getErrorLog().length() > 0;
        this.setError(isError, isError && source.getErrorLog().indexOf("Warning") >= 0);
    }

    @Override
    public void siSetPropertiesFromPreferences(JSVPanel jsvp, boolean includeMeasures) {
        ColorParameters ds = this.dsp.getDisplaySchemes().get(this.defaultDisplaySchemeName);
        jsvp.getPanelData().addListener(this);
        this.vwr.parameters.setFor(jsvp, ds == null ? this.dsp.getDefaultScheme() : ds, includeMeasures);
        this.vwr.checkAutoIntegrate();
        jsvp.doRepaint(true);
    }

    @Override
    public void siProcessCommand(String script) {
        this.runScriptNow(script);
    }

    @Override
    public void siSetSelectedPanel(JSVPanel jsvp) {
        if (this.vwr.selectedPanel != null) {
            this.mainSplitPosition = this.mainSplitPane.getDividerLocation();
        }
        this.vwr.mainPanel.setSelectedPanel(this.vwr, jsvp, this.vwr.panelNodes);
        this.vwr.selectedPanel = jsvp;
        this.vwr.spectraTree.setSelectedPanel(this, jsvp);
        this.validate();
        if (jsvp != null) {
            jsvp.setEnabled(true);
            jsvp.setFocusable(true);
        }
        if (this.mainSplitPosition != 0) {
            this.mainSplitPane.setDividerLocation(this.mainSplitPosition);
        }
    }

    @Override
    public void siSendPanelChange() {
        if (this.vwr.selectedPanel == this.prevPanel) {
            return;
        }
        this.prevPanel = this.vwr.selectedPanel;
        this.vwr.sendPanelChange();
    }

    @Override
    public void siSyncLoad(String filePath) {
        this.vwr.closeSource(null);
        this.siOpenDataOrFile(null, null, null, filePath, -1, -1, false, null, null);
        if (this.vwr.currentSource == null) {
            return;
        }
        if (((PanelNode)this.vwr.panelNodes.get(0)).getSpectrum().isAutoOverlayFromJmolClick()) {
            this.vwr.execView("*", false);
        }
    }

    @Override
    public void siValidateAndRepaint(boolean isAll) {
        this.validate();
        if (isAll) {
            this.repaint();
        } else {
            this.vwr.requestRepaint();
        }
    }

    @Override
    public void siExecHidden(boolean b) {
        this.isHidden = this.jmol != null && b;
        this.setVisible(!this.isHidden);
    }

    @Override
    public String siLoaded(String value) {
        PanelData pd = this.vwr.pd();
        return !pd.getSpectrum().is1D() && pd.getDisplay1D() ? "Click on the spectrum and use UP or DOWN keys to see subspectra." : null;
    }

    @Override
    public void siExecScriptComplete(String msg, boolean isOK) {
        this.vwr.requestRepaint();
        if (msg != null) {
            this.writeStatus(msg);
            if (msg.length() == 0) {
                msg = null;
            }
        }
    }

    @Override
    public void siExecSetCallback(ScriptToken st, String value) {
        if (this.advancedApplet != null) {
            this.advancedApplet.siExecSetCallback(st, value);
        }
    }

    @Override
    public void siUpdateBoolean(ScriptToken st, boolean TF) {
        if (this.vwr.selectedPanel != null) {
            switch (st) {
                case COORDINATESON: {
                    this.toolBar.coordsToggleButton.setSelected(TF);
                    break;
                }
                case GRIDON: {
                    this.toolBar.gridToggleButton.setSelected(TF);
                }
            }
        }
    }

    @Override
    public void siCheckCallbacks(String title) {
    }

    @Override
    public void siNodeSet(PanelNode panelNode) {
        this.siSetMenuEnables(panelNode, false);
        this.writeStatus("");
    }

    @Override
    public void siSourceClosed(JDXSource source) {
        this.appMenu.clearSourceMenu(source);
        this.setError(false, false);
        this.setTitle("JSpecView");
        this.siValidateAndRepaint(false);
    }

    @Override
    public void siSetLoaded(String fileName, String filePath) {
        this.appMenu.setCloseMenuItem(fileName);
        this.setTitle("JSpecView - " + (filePath.startsWith("http://SIMULATION/") ? "SIMULATION" : filePath));
        this.appMenu.setSourceEnabled(true);
    }

    @Override
    public void siUpdateRecentMenus(String filePath) {
        if (filePath.length() > 100) {
            return;
        }
        if (this.recentFilePaths.size() >= 10) {
            this.recentFilePaths.remove(9);
        }
        if (this.recentFilePaths.contains(filePath)) {
            this.recentFilePaths.removeObj(filePath);
        }
        this.recentFilePaths.add(0, filePath);
        SB filePaths = new SB();
        int n = this.recentFilePaths.size();
        int index = 0;
        while (index < n) {
            filePaths.append(", ").append((String)this.recentFilePaths.get(index));
            ++index;
        }
        this.vwr.setProperty("recentFilePaths", n == 0 ? "" : filePaths.substring(2));
        this.appMenu.updateRecentMenus(this.recentFilePaths);
    }

    @Override
    public void siSetMenuEnables(PanelNode node, boolean isSplit) {
        this.appMenu.setMenuEnables(node);
        this.toolBar.setMenuEnables(node);
    }

    @Override
    public JSVPanel siGetNewJSVPanel(Spectrum spec) {
        return spec == null ? null : AwtPanel.getPanelOne(this.vwr, spec);
    }

    @Override
    public JSVPanel siGetNewJSVPanel2(Lst<Spectrum> specs) {
        return AwtPanel.getPanelMany(this.vwr, specs);
    }

    @Override
    public void siExecTest(String value) {
        System.out.println(PT.toJSON(null, this.vwr.getPropertyAsJavaObject(value)));
    }

    @Override
    public void siNewWindow(boolean isSelected, boolean fromFrame) {
    }

    @Override
    public String print(String fileName) {
        return this.vwr.print(fileName);
    }

    private class SpectraTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;
        JSVTreeNode node;

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            this.node = (JSVTreeNode)value;
            return this;
        }

        @Override
        public Font getFont() {
            return new Font("Dialog", this.node == null || this.node.getPanelNode() == null || this.node.getPanelNode().jsvp == null ? 1 : 2, 12);
        }
    }
}

