/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.util.Hashtable;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.PT;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.util.BNode;
import org.jmol.util.Edge;
import org.jmol.util.Elements;
import org.jmol.util.Node;

public class JmolMolecule {
    public Node[] nodes;
    public int moleculeIndex;
    public int modelIndex;
    public int indexInModel;
    public int firstAtomIndex;
    public int ac;
    public int nElements;
    public int[] elementCounts = new int[Elements.elementNumberMax];
    public int[] altElementCounts = new int[Elements.altElementMax];
    public int elementNumberMax;
    public int altElementMax;
    public String mf;
    public BS atomList;

    public static final JmolMolecule[] getMolecules(BNode[] bNodeArray, BS[] bSArray, Lst<BS> lst, BS bS) {
        BS bS2 = null;
        BS bS3 = new BS();
        int n = -1;
        int n2 = 0;
        int n3 = 0;
        JmolMolecule[] jmolMoleculeArray = new JmolMolecule[4];
        if (bS == null) {
            bS = new BS();
        }
        for (int i = 0; i < bNodeArray.length; ++i) {
            if (bS.get(i) || bS3.get(i)) continue;
            if (bNodeArray[i].isDeleted()) {
                bS.set(i);
                continue;
            }
            int n4 = bNodeArray[i].getModelIndex();
            if (n4 != n) {
                n = n4;
                n2 = 0;
                bS2 = bSArray[n4];
            }
            if ((bS3 = JmolMolecule.getBranchBitSet(bNodeArray, i, bS2, lst, -1, true, true)).nextSetBit(0) < 0) continue;
            jmolMoleculeArray = JmolMolecule.addMolecule(jmolMoleculeArray, n3++, bNodeArray, i, bS3, n4, n2++, bS);
        }
        return JmolMolecule.allocateArray(jmolMoleculeArray, n3);
    }

    public static BS getBranchBitSet(Node[] nodeArray, int n, BS bS, Lst<BS> lst, int n2, boolean bl, boolean bl2) {
        BS bS2 = BS.newN(nodeArray.length);
        if (n < 0) {
            return bS2;
        }
        if (n2 >= 0) {
            bS.clear(n2);
        }
        return JmolMolecule.getCovalentlyConnectedBitSet(nodeArray, nodeArray[n], bS, bl, bl2, lst, bS2) ? bS2 : new BS();
    }

    public static final JmolMolecule[] addMolecule(JmolMolecule[] jmolMoleculeArray, int n, Node[] nodeArray, int n2, BS bS, int n3, int n4, BS bS2) {
        bS2.or(bS);
        if (n == jmolMoleculeArray.length) {
            jmolMoleculeArray = JmolMolecule.allocateArray(jmolMoleculeArray, n * 2 + 1);
        }
        jmolMoleculeArray[n] = JmolMolecule.initialize(nodeArray, n, n2, bS, n3, n4);
        return jmolMoleculeArray;
    }

    public static String getMolecularFormula(Node[] nodeArray, BS bS, boolean bl, float[] fArray, boolean bl2) {
        JmolMolecule jmolMolecule = new JmolMolecule();
        jmolMolecule.nodes = nodeArray;
        jmolMolecule.atomList = bS;
        return jmolMolecule.getMolecularFormula(bl, fArray, bl2);
    }

    public String getMolecularFormula(boolean bl, float[] fArray, boolean bl2) {
        int n;
        int n2;
        int n3;
        if (this.mf != null) {
            return this.mf;
        }
        if (this.atomList == null) {
            this.atomList = new BS();
            this.atomList.setBits(0, this.nodes.length);
        }
        this.elementCounts = new int[Elements.elementNumberMax];
        this.altElementCounts = new int[Elements.altElementMax];
        this.ac = this.atomList.cardinality();
        int n4 = 0;
        int n5 = this.atomList.nextSetBit(0);
        while (n5 >= 0) {
            n3 = this.nodes[n5].getAtomicAndIsotopeNumber();
            int n6 = n2 = fArray == null ? 1 : (int)(8.0f * fArray[n4]);
            if (n3 < Elements.elementNumberMax) {
                if (this.elementCounts[n3] == 0) {
                    ++this.nElements;
                }
                int n7 = n3;
                this.elementCounts[n7] = this.elementCounts[n7] + n2;
                this.elementNumberMax = Math.max(this.elementNumberMax, n3);
                if (bl && (n = this.nodes[n5].getImplicitHydrogenCount()) > 0) {
                    if (this.elementCounts[1] == 0) {
                        ++this.nElements;
                    }
                    this.elementCounts[1] = this.elementCounts[1] + n * n2;
                }
            } else {
                if (this.altElementCounts[n3 = Elements.altElementIndexFromNumber(n3)] == 0) {
                    ++this.nElements;
                }
                int n8 = n3;
                this.altElementCounts[n8] = this.altElementCounts[n8] + n2;
                this.altElementMax = Math.max(this.altElementMax, n3);
            }
            n5 = this.atomList.nextSetBit(n5 + 1);
            ++n4;
        }
        if (fArray != null) {
            for (n4 = 1; n4 <= this.elementNumberMax; ++n4) {
                n5 = this.elementCounts[n4] / 8;
                if (n5 * 8 != this.elementCounts[n4]) {
                    return "?";
                }
                this.elementCounts[n4] = n5;
            }
        }
        if (bl2) {
            n4 = 2;
            n5 = 1;
            block2: while (n5 != 0) {
                n4 = 100000;
                for (n2 = 1; n2 <= this.elementNumberMax; ++n2) {
                    n3 = this.elementCounts[n2];
                    if (n3 <= 0 || n3 >= n4) continue;
                    n4 = n3;
                }
                if (n4 == 1) break;
                for (n2 = n4; n2 > 1; --n2) {
                    n5 = 1;
                    for (n = 1; n <= this.elementNumberMax && n5 != 0; ++n) {
                        n3 = this.elementCounts[n];
                        if (n3 / n2 * n2 == n3) continue;
                        n5 = 0;
                    }
                    if (n5 == 0) continue;
                    n = 1;
                    while (n <= this.elementNumberMax) {
                        int n9 = n++;
                        this.elementCounts[n9] = this.elementCounts[n9] / n2;
                    }
                    continue block2;
                }
            }
        }
        String string = "";
        String string2 = "";
        for (n2 = 1; n2 <= this.elementNumberMax; ++n2) {
            n3 = this.elementCounts[n2];
            if (n3 == 0) continue;
            string = string + string2 + Elements.elementSymbolFromNumber(n2) + " " + n3;
            string2 = " ";
        }
        for (n2 = 1; n2 <= this.altElementMax; ++n2) {
            n3 = this.altElementCounts[n2];
            if (n3 == 0) continue;
            string = string + string2 + Elements.elementSymbolFromNumber(Elements.altElementNumberFromIndex(n2)) + " " + n3;
            string2 = " ";
        }
        return string;
    }

    private static JmolMolecule initialize(Node[] nodeArray, int n, int n2, BS bS, int n3, int n4) {
        JmolMolecule jmolMolecule = new JmolMolecule();
        jmolMolecule.nodes = nodeArray;
        jmolMolecule.firstAtomIndex = n2;
        jmolMolecule.atomList = bS;
        jmolMolecule.ac = bS.cardinality();
        jmolMolecule.moleculeIndex = n;
        jmolMolecule.modelIndex = n3;
        jmolMolecule.indexInModel = n4;
        return jmolMolecule;
    }

    private static boolean getCovalentlyConnectedBitSet(Node[] nodeArray, Node node, BS bS, boolean bl, boolean bl2, Lst<BS> lst, BS bS2) {
        int n = node.getIndex();
        if (!bS.get(n)) {
            return bl;
        }
        if (!bl2 && node instanceof BNode && ((BNode)node).getBioStructureTypeName().length() > 0) {
            return bl;
        }
        bS.clear(n);
        if (lst != null && !bS2.get(n)) {
            int n2 = lst.size();
            while (--n2 >= 0) {
                BS bS3 = (BS)lst.get(n2);
                if (!bS3.get(n)) continue;
                bS2.or(bS3);
                bS.andNot(bS3);
                int n3 = bS3.nextSetBit(0);
                while (n3 >= 0) {
                    Node node2 = nodeArray[n3];
                    bS.set(n3);
                    JmolMolecule.getCovalentlyConnectedBitSet(nodeArray, node2, bS, bl, bl2, lst, bS2);
                    bS.clear(n3);
                    n3 = bS3.nextSetBit(n3 + 1);
                }
                break block0;
            }
        }
        bS2.set(n);
        Edge[] edgeArray = node.getEdges();
        if (edgeArray == null) {
            return true;
        }
        int n4 = edgeArray.length;
        while (--n4 >= 0) {
            Edge edge = edgeArray[n4];
            if (edge == null || !edge.isCovalent() || JmolMolecule.getCovalentlyConnectedBitSet(nodeArray, edge.getOtherAtomNode(node), bS, bl, bl2, lst, bS2)) continue;
            return false;
        }
        return true;
    }

    private static JmolMolecule[] allocateArray(JmolMolecule[] jmolMoleculeArray, int n) {
        return n == jmolMoleculeArray.length ? jmolMoleculeArray : (JmolMolecule[])AU.arrayCopyObject(jmolMoleculeArray, n);
    }

    public static BS getBitSetForMF(Atom[] atomArray, BS bS, String string) {
        Hashtable<String, int[]> hashtable = new Hashtable<String, int[]>();
        string = PT.rep(PT.clean(string + "Z"), " ", "");
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        for (int i = 0; i < n3; ++i) {
            char c = string.charAt(i);
            boolean bl = Character.isDigit(c);
            if (!bl && (i <= 0 || !Character.isUpperCase(c))) continue;
            n2 = i;
            String string2 = string.substring(n, n2).trim();
            if (bl) {
                while (i < n3 && Character.isDigit(string.charAt(i))) {
                    ++i;
                }
            }
            n = i;
            hashtable.put(string2, new int[]{bl ? PT.parseInt(string.substring(n2, n)) : 1});
        }
        BS bS2 = new BS();
        n = bS.nextSetBit(0);
        while (n >= 0) {
            String string3 = atomArray[n].getElementSymbol();
            int[] nArray = (int[])hashtable.get(string3);
            if (nArray != null) {
                int n4 = nArray[0];
                nArray[0] = n4 - 1;
                if (n4 >= 1) {
                    bS2.set(n);
                }
            }
            n = bS.nextSetBit(n + 1);
        }
        for (int[] nArray : hashtable.values()) {
            if (nArray[0] <= 0) continue;
            return new BS();
        }
        return bS2;
    }
}

