/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.engine;

import org.apache.commons.jcs.engine.behavior.ICompositeCacheAttributes;

public class CompositeCacheAttributes
implements ICompositeCacheAttributes,
Cloneable {
    private static final long serialVersionUID = 6754049978134196787L;
    private static final boolean DEFAULT_USE_LATERAL = true;
    private static final boolean DEFAULT_USE_REMOTE = true;
    private static final boolean DEFAULT_USE_DISK = true;
    private static final boolean DEFAULT_USE_SHRINKER = false;
    private static final int DEFAULT_MAX_OBJECTS = 100;
    private static final int DEFAULT_MAX_MEMORY_IDLE_TIME_SECONDS = 7200;
    private static final int DEFAULT_SHRINKER_INTERVAL_SECONDS = 30;
    private static final int DEFAULT_MAX_SPOOL_PER_RUN = -1;
    private static final String DEFAULT_MEMORY_CACHE_NAME = "org.apache.commons.jcs.engine.memory.lru.LRUMemoryCache";
    private static final int DEFAULT_CHUNK_SIZE = 2;
    private boolean useLateral = true;
    private boolean useRemote = true;
    private boolean useDisk = true;
    private boolean useMemoryShrinker = false;
    private int maxObjs = 100;
    private long maxMemoryIdleTimeSeconds = 7200L;
    private long shrinkerIntervalSeconds = 30L;
    private int maxSpoolPerRun = -1;
    private String cacheName;
    private String memoryCacheName = "org.apache.commons.jcs.engine.memory.lru.LRUMemoryCache";
    private ICompositeCacheAttributes.DiskUsagePattern diskUsagePattern = ICompositeCacheAttributes.DiskUsagePattern.SWAP;
    private int spoolChunkSize = 2;

    @Override
    public void setMaxObjects(int n) {
        this.maxObjs = n;
    }

    @Override
    public int getMaxObjects() {
        return this.maxObjs;
    }

    @Override
    public void setUseDisk(boolean bl) {
        this.useDisk = bl;
    }

    @Override
    public boolean isUseDisk() {
        return this.useDisk;
    }

    @Override
    public void setUseLateral(boolean bl) {
        this.useLateral = bl;
    }

    @Override
    public boolean isUseLateral() {
        return this.useLateral;
    }

    @Override
    public void setUseRemote(boolean bl) {
        this.useRemote = bl;
    }

    @Override
    public boolean isUseRemote() {
        return this.useRemote;
    }

    @Override
    public void setCacheName(String string) {
        this.cacheName = string;
    }

    @Override
    public String getCacheName() {
        return this.cacheName;
    }

    @Override
    public void setMemoryCacheName(String string) {
        this.memoryCacheName = string;
    }

    @Override
    public String getMemoryCacheName() {
        return this.memoryCacheName;
    }

    @Override
    public void setUseMemoryShrinker(boolean bl) {
        this.useMemoryShrinker = bl;
    }

    @Override
    public boolean isUseMemoryShrinker() {
        return this.useMemoryShrinker;
    }

    @Override
    public void setMaxMemoryIdleTimeSeconds(long l) {
        this.maxMemoryIdleTimeSeconds = l;
    }

    @Override
    public long getMaxMemoryIdleTimeSeconds() {
        return this.maxMemoryIdleTimeSeconds;
    }

    @Override
    public void setShrinkerIntervalSeconds(long l) {
        this.shrinkerIntervalSeconds = l;
    }

    @Override
    public long getShrinkerIntervalSeconds() {
        return this.shrinkerIntervalSeconds;
    }

    @Override
    public void setMaxSpoolPerRun(int n) {
        this.maxSpoolPerRun = n;
    }

    @Override
    public int getMaxSpoolPerRun() {
        return this.maxSpoolPerRun;
    }

    @Override
    public void setDiskUsagePattern(ICompositeCacheAttributes.DiskUsagePattern diskUsagePattern) {
        this.diskUsagePattern = diskUsagePattern;
    }

    @Override
    public void setDiskUsagePatternName(String string) {
        if (string != null) {
            String string2 = string.toUpperCase().trim();
            if (string2.startsWith("SWAP")) {
                this.setDiskUsagePattern(ICompositeCacheAttributes.DiskUsagePattern.SWAP);
            } else if (string2.startsWith("UPDATE")) {
                this.setDiskUsagePattern(ICompositeCacheAttributes.DiskUsagePattern.UPDATE);
            }
        }
    }

    @Override
    public int getSpoolChunkSize() {
        return this.spoolChunkSize;
    }

    @Override
    public void setSpoolChunkSize(int n) {
        this.spoolChunkSize = n;
    }

    @Override
    public ICompositeCacheAttributes.DiskUsagePattern getDiskUsagePattern() {
        return this.diskUsagePattern;
    }

    @Override
    public ICompositeCacheAttributes copy() {
        try {
            CompositeCacheAttributes compositeCacheAttributes = (CompositeCacheAttributes)this.clone();
            return compositeCacheAttributes;
        }
        catch (Exception exception) {
            System.err.println(exception.toString());
            return new CompositeCacheAttributes();
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[ ");
        stringBuilder.append("useLateral = ").append(this.useLateral);
        stringBuilder.append(", useRemote = ").append(this.useRemote);
        stringBuilder.append(", useDisk = ").append(this.useDisk);
        stringBuilder.append(", maxObjs = ").append(this.maxObjs);
        stringBuilder.append(", maxSpoolPerRun = ").append(this.maxSpoolPerRun);
        stringBuilder.append(", diskUsagePattern = ").append((Object)this.diskUsagePattern);
        stringBuilder.append(", spoolChunkSize = ").append(this.spoolChunkSize);
        stringBuilder.append(" ]");
        return stringBuilder.toString();
    }
}

