/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.gui.conflict.tags.PasteTagsConflictResolverDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.TextTagParser;
import org.openstreetmap.josm.tools.Utils;

public final class PasteTagsAction
extends JosmAction {
    private static final String help = HelpUtil.ht("/Action/PasteTags");

    public PasteTagsAction() {
        super(I18n.tr("Paste Tags", new Object[0]), "pastetags", I18n.tr("Apply tags of contents of paste buffer to all selected items.", new Object[0]), Shortcut.registerShortcut("system:pastestyle", I18n.tr("Edit: {0}", I18n.tr("Paste Tags", new Object[0])), 86, 5009), true);
        this.putValue("help", help);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Collection<OsmPrimitive> collection = PasteTagsAction.getCurrentDataSet().getSelected();
        if (collection.isEmpty()) {
            return;
        }
        String string = Utils.getClipboardContent();
        if (string == null || string.isEmpty() || string.matches("((node|way|relation)\\s\\d+,)*(node|way|relation)\\s\\d+")) {
            PasteTagsAction.pasteTagsFromJOSMBuffer(collection);
        } else {
            PasteTagsAction.pasteTagsFromText(collection, string);
        }
    }

    public static boolean pasteTagsFromText(Collection<OsmPrimitive> collection, String string) {
        Map<String, String> map = TextTagParser.readTagsFromText(string);
        if (map == null || map.isEmpty()) {
            TextTagParser.showBadBufferMessage(help);
            return false;
        }
        if (!TextTagParser.validateTags(map)) {
            return false;
        }
        ArrayList<Command> arrayList = new ArrayList<Command>(map.size());
        Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            String string2;
            Map.Entry<String, String> entry;
            arrayList.add(new ChangePropertyCommand(collection, entry.getKey(), "".equals(string2 = (entry = iterator.next()).getValue()) ? null : string2));
        }
        PasteTagsAction.commitCommands(collection, arrayList);
        return !arrayList.isEmpty();
    }

    public static boolean pasteTagsFromJOSMBuffer(Collection<OsmPrimitive> collection) {
        List<PrimitiveData> list = Main.pasteBuffer.getDirectlyAdded();
        if (list == null || list.isEmpty()) {
            return false;
        }
        TagPaster tagPaster = new TagPaster(list, collection);
        ArrayList<Command> arrayList = new ArrayList<Command>();
        for (Tag tag : tagPaster.execute()) {
            arrayList.add(new ChangePropertyCommand(collection, tag.getKey(), "".equals(tag.getValue()) ? null : tag.getValue()));
        }
        PasteTagsAction.commitCommands(collection, arrayList);
        return true;
    }

    private static void commitCommands(Collection<OsmPrimitive> collection, List<Command> list) {
        if (!list.isEmpty()) {
            String string = I18n.trn("Pasting {0} tag", "Pasting {0} tags", list.size(), list.size());
            String string2 = I18n.trn("to {0} object", "to {0} objects", collection.size(), collection.size());
            String string3 = string + ' ' + string2;
            Main.main.undoRedo.add(new SequenceCommand(string3, list));
        }
    }

    @Override
    protected void updateEnabledState() {
        if (PasteTagsAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(!PasteTagsAction.getCurrentDataSet().getSelected().isEmpty());
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> collection) {
        this.setEnabled(collection != null && !collection.isEmpty());
    }

    public static class TagPaster {
        private final Collection<PrimitiveData> source;
        private final Collection<OsmPrimitive> target;
        private final List<Tag> tags = new ArrayList<Tag>();

        public TagPaster(Collection<PrimitiveData> collection, Collection<OsmPrimitive> collection2) {
            this.source = collection;
            this.target = collection2;
        }

        protected boolean isHeteogeneousSource() {
            int n = 0;
            n = !this.getSourcePrimitivesByType(OsmPrimitiveType.NODE).isEmpty() ? n + 1 : n;
            n = !this.getSourcePrimitivesByType(OsmPrimitiveType.WAY).isEmpty() ? n + 1 : n;
            n = !this.getSourcePrimitivesByType(OsmPrimitiveType.RELATION).isEmpty() ? n + 1 : n;
            return n > 1;
        }

        protected Collection<? extends PrimitiveData> getSourcePrimitivesByType(OsmPrimitiveType osmPrimitiveType) {
            return PrimitiveData.getFilteredList(this.source, osmPrimitiveType);
        }

        protected TagCollection getSourceTagsByType(OsmPrimitiveType osmPrimitiveType) {
            return TagCollection.unionOfAllPrimitives(this.getSourcePrimitivesByType(osmPrimitiveType));
        }

        protected boolean hasSourceTagsByType(OsmPrimitiveType osmPrimitiveType) {
            return !this.getSourceTagsByType(osmPrimitiveType).isEmpty();
        }

        protected void buildTags(TagCollection tagCollection) {
            for (String string : tagCollection.getKeys()) {
                this.tags.add(new Tag(string, tagCollection.getValues(string).iterator().next()));
            }
        }

        protected Map<OsmPrimitiveType, Integer> getSourceStatistics() {
            EnumMap<OsmPrimitiveType, Integer> enumMap = new EnumMap<OsmPrimitiveType, Integer>(OsmPrimitiveType.class);
            for (OsmPrimitiveType osmPrimitiveType : OsmPrimitiveType.dataValues()) {
                if (this.getSourceTagsByType(osmPrimitiveType).isEmpty()) continue;
                enumMap.put(osmPrimitiveType, this.getSourcePrimitivesByType(osmPrimitiveType).size());
            }
            return enumMap;
        }

        protected Map<OsmPrimitiveType, Integer> getTargetStatistics() {
            EnumMap<OsmPrimitiveType, Integer> enumMap = new EnumMap<OsmPrimitiveType, Integer>(OsmPrimitiveType.class);
            for (OsmPrimitiveType osmPrimitiveType : OsmPrimitiveType.dataValues()) {
                int n = OsmPrimitive.getFilteredList(this.target, osmPrimitiveType.getOsmClass()).size();
                if (n <= 0) continue;
                enumMap.put(osmPrimitiveType, n);
            }
            return enumMap;
        }

        protected void pasteFromHomogeneousSource() {
            TagCollection tagCollection = null;
            for (OsmPrimitiveType osmPrimitiveType : OsmPrimitiveType.dataValues()) {
                TagCollection tagCollection2 = this.getSourceTagsByType(osmPrimitiveType);
                if (tagCollection2.isEmpty()) continue;
                tagCollection = tagCollection2;
            }
            if (tagCollection == null) {
                return;
            }
            if (!tagCollection.isApplicableToPrimitive()) {
                PasteTagsConflictResolverDialog pasteTagsConflictResolverDialog = new PasteTagsConflictResolverDialog(Main.parent);
                pasteTagsConflictResolverDialog.populate(tagCollection, this.getSourceStatistics(), this.getTargetStatistics());
                pasteTagsConflictResolverDialog.setVisible(true);
                if (pasteTagsConflictResolverDialog.isCanceled()) {
                    return;
                }
                this.buildTags(pasteTagsConflictResolverDialog.getResolution());
            } else {
                this.buildTags(tagCollection);
            }
        }

        protected boolean hasTargetPrimitives(Class<? extends OsmPrimitive> clazz) {
            return !OsmPrimitive.getFilteredList(this.target, clazz).isEmpty();
        }

        protected boolean canPasteFromHeterogeneousSourceWithoutConflict() {
            for (OsmPrimitiveType osmPrimitiveType : OsmPrimitiveType.dataValues()) {
                TagCollection tagCollection;
                if (!this.hasTargetPrimitives(osmPrimitiveType.getOsmClass()) || (tagCollection = TagCollection.unionOfAllPrimitives(this.getSourcePrimitivesByType(osmPrimitiveType))).isEmpty() || tagCollection.isApplicableToPrimitive()) continue;
                return false;
            }
            return true;
        }

        protected void pasteFromHeterogeneousSource() {
            if (this.canPasteFromHeterogeneousSourceWithoutConflict()) {
                for (OsmPrimitiveType osmPrimitiveType : OsmPrimitiveType.dataValues()) {
                    if (!this.hasSourceTagsByType(osmPrimitiveType) || !this.hasTargetPrimitives(osmPrimitiveType.getOsmClass())) continue;
                    this.buildTags(this.getSourceTagsByType(osmPrimitiveType));
                }
            } else {
                PasteTagsConflictResolverDialog pasteTagsConflictResolverDialog = new PasteTagsConflictResolverDialog(Main.parent);
                pasteTagsConflictResolverDialog.populate(this.getSourceTagsByType(OsmPrimitiveType.NODE), this.getSourceTagsByType(OsmPrimitiveType.WAY), this.getSourceTagsByType(OsmPrimitiveType.RELATION), this.getSourceStatistics(), this.getTargetStatistics());
                pasteTagsConflictResolverDialog.setVisible(true);
                if (pasteTagsConflictResolverDialog.isCanceled()) {
                    return;
                }
                for (OsmPrimitiveType osmPrimitiveType : OsmPrimitiveType.dataValues()) {
                    if (!this.hasSourceTagsByType(osmPrimitiveType) || !this.hasTargetPrimitives(osmPrimitiveType.getOsmClass())) continue;
                    this.buildTags(pasteTagsConflictResolverDialog.getResolution(osmPrimitiveType));
                }
            }
        }

        public List<Tag> execute() {
            this.tags.clear();
            if (this.isHeteogeneousSource()) {
                this.pasteFromHeterogeneousSource();
            } else {
                this.pasteFromHomogeneousSource();
            }
            return this.tags;
        }
    }
}

