/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.markerlayer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.Extensions;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxLink;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.CustomizeColor;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.JumpToMarkerActions;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.gpx.ConvertToDataLayerAction;
import org.openstreetmap.josm.gui.layer.markerlayer.AudioMarker;
import org.openstreetmap.josm.gui.layer.markerlayer.Marker;
import org.openstreetmap.josm.gui.layer.markerlayer.PlayHeadMarker;
import org.openstreetmap.josm.tools.AudioPlayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class MarkerLayer
extends Layer
implements JumpToMarkerActions.JumpToMarkerLayer {
    public final List<Marker> data;
    private boolean mousePressed;
    public GpxLayer fromLayer;
    private Marker currentMarker;
    public AudioMarker syncAudioMarker;

    public MarkerLayer(GpxData gpxData, String string, File file, GpxLayer gpxLayer) {
        super(string);
        this.setAssociatedFile(file);
        this.data = new ArrayList<Marker>();
        this.fromLayer = gpxLayer;
        double d = -1.0;
        Object object = "";
        for (WayPoint wayPoint : gpxData.waypoints) {
            Object object2;
            Object object32;
            Iterator iterator;
            double d2 = wayPoint.time;
            boolean bl = wayPoint.attr.containsKey("meta.links");
            if (d < 0.0 && bl) {
                d = d2;
                iterator = wayPoint.getCollection("meta.links").iterator();
                if (iterator.hasNext()) {
                    object32 = (GpxLink)iterator.next();
                    object = ((GpxLink)object32).uri;
                }
            }
            if (bl) {
                for (Object object32 : wayPoint.getCollection("meta.links")) {
                    object2 = ((GpxLink)object32).uri;
                    if (object2 == null) continue;
                    if (!((String)object2).equals(object)) {
                        d = d2;
                    }
                    object = object2;
                    break;
                }
            }
            iterator = null;
            object32 = (Extensions)wayPoint.get("meta.extensions");
            if (object32 != null && ((HashMap)object32).containsKey("offset")) {
                try {
                    iterator = Double.valueOf((String)((LinkedHashMap)object32).get("offset"));
                }
                catch (NumberFormatException numberFormatException) {
                    Main.warn(numberFormatException);
                }
            }
            if (iterator == null) {
                iterator = d2 - d;
            }
            if ((object2 = Marker.createMarkers(wayPoint, gpxData.storageFile, this, d2, (Double)((Object)iterator))) == null) continue;
            this.data.addAll((Collection<Marker>)object2);
        }
    }

    @Override
    public void hookUpMapView() {
        Main.map.mapView.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() != 1) {
                    return;
                }
                boolean bl = false;
                if (mouseEvent.getPoint() != null) {
                    for (Marker marker : MarkerLayer.this.data) {
                        if (!marker.containsPoint(mouseEvent.getPoint())) continue;
                        bl = true;
                        break;
                    }
                }
                if (!bl) {
                    return;
                }
                MarkerLayer.this.mousePressed = true;
                if (MarkerLayer.this.isVisible()) {
                    Main.map.mapView.repaint();
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() != 1 || !MarkerLayer.this.mousePressed) {
                    return;
                }
                MarkerLayer.this.mousePressed = false;
                if (!MarkerLayer.this.isVisible()) {
                    return;
                }
                if (mouseEvent.getPoint() != null) {
                    for (Marker marker : MarkerLayer.this.data) {
                        if (!marker.containsPoint(mouseEvent.getPoint())) continue;
                        marker.actionPerformed(new ActionEvent(this, 0, null));
                    }
                }
                Main.map.mapView.repaint();
            }
        });
    }

    @Override
    public Icon getIcon() {
        return ImageProvider.get("layer", "marker_small");
    }

    @Override
    public Color getColor(boolean bl) {
        String string = this.getName();
        return Main.pref.getColor(I18n.marktr("gps marker"), string != null ? "layer " + string : null, Color.gray);
    }

    public static Color getGenericColor() {
        return Main.pref.getColor(I18n.marktr("gps marker"), Color.gray);
    }

    @Override
    public void paint(Graphics2D graphics2D, MapView mapView, Bounds bounds) {
        boolean bl = this.isTextOrIconShown();
        graphics2D.setColor(this.getColor(true));
        if (this.mousePressed) {
            boolean bl2 = this.mousePressed;
            Point point = mapView.getMousePosition();
            for (Marker marker : this.data) {
                if (point == null || !marker.containsPoint(point)) continue;
                marker.paint(graphics2D, mapView, bl2, bl);
                bl2 = false;
            }
        } else {
            for (Marker marker : this.data) {
                marker.paint(graphics2D, mapView, false, bl);
            }
        }
    }

    @Override
    public String getToolTipText() {
        return this.data.size() + 32 + I18n.trn("marker", "markers", this.data.size(), new Object[0]);
    }

    @Override
    public void mergeFrom(Layer layer) {
        MarkerLayer markerLayer = (MarkerLayer)layer;
        this.data.addAll(markerLayer.data);
        Collections.sort(this.data, new Comparator<Marker>(){

            @Override
            public int compare(Marker marker, Marker marker2) {
                return Double.compare(marker.time, marker2.time);
            }
        });
    }

    @Override
    public boolean isMergable(Layer layer) {
        return layer instanceof MarkerLayer;
    }

    @Override
    public void visitBoundingBox(BoundingXYVisitor boundingXYVisitor) {
        for (Marker marker : this.data) {
            boundingXYVisitor.visit(marker.getEastNorth());
        }
    }

    @Override
    public Object getInfoComponent() {
        return "<html>" + I18n.trn("{0} consists of {1} marker", "{0} consists of {1} markers", this.data.size(), this.getName(), this.data.size()) + "</html>";
    }

    @Override
    public Action[] getMenuEntries() {
        ArrayList<AbstractAction> arrayList = new ArrayList<AbstractAction>();
        arrayList.add(LayerListDialog.getInstance().createShowHideLayerAction());
        arrayList.add(new ShowHideMarkerText(this));
        arrayList.add(LayerListDialog.getInstance().createDeleteLayerAction());
        arrayList.add(LayerListDialog.getInstance().createMergeLayerAction(this));
        arrayList.add(Layer.SeparatorLayerAction.INSTANCE);
        arrayList.add(new CustomizeColor(this));
        arrayList.add(Layer.SeparatorLayerAction.INSTANCE);
        arrayList.add(new SynchronizeAudio());
        if (Main.pref.getBoolean("marker.traceaudio", true)) {
            arrayList.add(new MoveAudio());
        }
        arrayList.add(new JumpToMarkerActions.JumpToNextMarker(this));
        arrayList.add(new JumpToMarkerActions.JumpToPreviousMarker(this));
        arrayList.add(new ConvertToDataLayerAction.FromMarkerLayer(this));
        arrayList.add(new RenameLayerAction(this.getAssociatedFile(), this));
        arrayList.add(Layer.SeparatorLayerAction.INSTANCE);
        arrayList.add(new LayerListPopup.InfoAction(this));
        return arrayList.toArray(new Action[arrayList.size()]);
    }

    public boolean synchronizeAudioMarkers(AudioMarker audioMarker) {
        this.syncAudioMarker = audioMarker;
        if (this.syncAudioMarker != null && !this.data.contains(this.syncAudioMarker)) {
            this.syncAudioMarker = null;
        }
        if (this.syncAudioMarker == null) {
            for (Marker marker : this.data) {
                if (!(marker instanceof AudioMarker)) continue;
                this.syncAudioMarker = (AudioMarker)marker;
                break;
            }
        }
        if (this.syncAudioMarker == null) {
            return false;
        }
        double d = AudioPlayer.position() - this.syncAudioMarker.offset;
        boolean bl = false;
        try {
            URI uRI = this.syncAudioMarker.url().toURI();
            for (Marker marker : this.data) {
                AudioMarker audioMarker2;
                if (marker == this.syncAudioMarker) {
                    bl = true;
                }
                if (!bl || !(marker instanceof AudioMarker) || !(audioMarker2 = (AudioMarker)marker).url().toURI().equals(uRI)) continue;
                audioMarker2.adjustOffset(d);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            Main.warn(uRISyntaxException);
        }
        return true;
    }

    public AudioMarker addAudioMarker(double d, LatLon latLon) {
        double d2 = 0.0;
        AudioMarker audioMarker = null;
        for (Marker object2 : this.data) {
            if (object2.getClass() != AudioMarker.class) continue;
            audioMarker = (AudioMarker)object2;
            d2 = d - audioMarker.time;
            break;
        }
        if (audioMarker == null) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("No existing audio markers in this layer to offset from.", new Object[0]), I18n.tr("Error", new Object[0]), 0);
            return null;
        }
        Object object3 = new AudioMarker(latLon, null, AudioPlayer.url(), this, d, d2);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        audioMarker = null;
        Object object = object3;
        for (Marker marker : this.data) {
            if (marker.getClass() == AudioMarker.class) {
                audioMarker = (AudioMarker)marker;
                if (object3 != null && d2 < audioMarker.offset) {
                    ((AudioMarker)object3).adjustOffset(audioMarker.syncOffset());
                    arrayList.add(object3);
                    object3 = null;
                }
            }
            arrayList.add(marker);
        }
        if (object3 != null) {
            if (audioMarker != null) {
                ((AudioMarker)object3).adjustOffset(audioMarker.syncOffset());
            }
            arrayList.add(object3);
        }
        this.data.clear();
        this.data.addAll(arrayList);
        return object;
    }

    @Override
    public void jumpToNextMarker() {
        if (this.currentMarker == null) {
            this.currentMarker = this.data.get(0);
        } else {
            boolean bl = false;
            for (Marker marker : this.data) {
                if (bl) {
                    this.currentMarker = marker;
                    break;
                }
                if (this.currentMarker != marker) continue;
                bl = true;
            }
        }
        Main.map.mapView.zoomTo(this.currentMarker.getEastNorth());
    }

    @Override
    public void jumpToPreviousMarker() {
        if (this.currentMarker == null) {
            this.currentMarker = this.data.get(this.data.size() - 1);
        } else {
            boolean bl = false;
            for (int i = this.data.size() - 1; i >= 0; --i) {
                Marker marker = this.data.get(i);
                if (bl) {
                    this.currentMarker = marker;
                    break;
                }
                if (this.currentMarker != marker) continue;
                bl = true;
            }
        }
        Main.map.mapView.zoomTo(this.currentMarker.getEastNorth());
    }

    public static void playAudio() {
        MarkerLayer.playAdjacentMarker(null, true);
    }

    public static void playNextMarker() {
        MarkerLayer.playAdjacentMarker(AudioMarker.recentlyPlayedMarker(), true);
    }

    public static void playPreviousMarker() {
        MarkerLayer.playAdjacentMarker(AudioMarker.recentlyPlayedMarker(), false);
    }

    private static Marker getAdjacentMarker(Marker marker, boolean bl, Layer layer) {
        Marker marker2 = null;
        boolean bl2 = false;
        if (layer.getClass() == MarkerLayer.class) {
            MarkerLayer markerLayer = (MarkerLayer)layer;
            for (Marker marker3 : markerLayer.data) {
                if (marker3 == marker) {
                    if (bl) {
                        bl2 = true;
                        continue;
                    }
                    if (marker2 == null) {
                        marker2 = marker;
                    }
                    return marker2;
                }
                if (marker3.getClass() != AudioMarker.class) continue;
                if (bl2 || marker == null) {
                    return marker3;
                }
                marker2 = marker3;
            }
            if (bl2) {
                return marker;
            }
        }
        return null;
    }

    private static void playAdjacentMarker(Marker marker, boolean bl) {
        if (!Main.isDisplayingMapView()) {
            return;
        }
        Marker marker2 = null;
        Layer layer = Main.map.mapView.getActiveLayer();
        if (layer != null) {
            marker2 = MarkerLayer.getAdjacentMarker(marker, bl, layer);
        }
        if (marker2 == null) {
            Layer layer2;
            Iterator<Layer> iterator = Main.map.mapView.getAllLayers().iterator();
            while (iterator.hasNext() && (marker2 = MarkerLayer.getAdjacentMarker(marker, bl, layer2 = iterator.next())) == null) {
            }
        }
        if (marker2 != null) {
            ((AudioMarker)marker2).play();
        }
    }

    private boolean isTextOrIconShown() {
        String string = Main.pref.get("marker.show " + this.getName(), "show");
        return "show".equalsIgnoreCase(string);
    }

    private class MoveAudio
    extends AbstractAction {
        MoveAudio() {
            super(I18n.tr("Make Audio Marker at Play Head", new Object[0]), ImageProvider.get("addmarkers"));
            this.putValue("help", HelpUtil.ht("/Action/MakeAudioMarkerAtPlayHead"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!AudioPlayer.paused()) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("You need to have paused audio at the point on the track where you want the marker.", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
                return;
            }
            PlayHeadMarker playHeadMarker = Main.map.mapView.playHeadMarker;
            if (playHeadMarker == null) {
                return;
            }
            MarkerLayer.this.addAudioMarker(playHeadMarker.time, playHeadMarker.getCoor());
            Main.map.mapView.repaint();
        }
    }

    private class SynchronizeAudio
    extends AbstractAction {
        SynchronizeAudio() {
            super(I18n.tr("Synchronize Audio", new Object[0]), ImageProvider.get("audio-sync"));
            this.putValue("help", HelpUtil.ht("/Action/SynchronizeAudio"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!AudioPlayer.paused()) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("You need to pause audio at the moment when you hear your synchronization cue.", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
                return;
            }
            AudioMarker audioMarker = AudioMarker.recentlyPlayedMarker();
            if (MarkerLayer.this.synchronizeAudioMarkers(audioMarker)) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Audio synchronized at point {0}.", MarkerLayer.this.syncAudioMarker.getText()), I18n.tr("Information", new Object[0]), 1);
            } else {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Unable to synchronize in layer being played.", new Object[0]), I18n.tr("Error", new Object[0]), 0);
            }
        }
    }

    public static final class ShowHideMarkerText
    extends AbstractAction
    implements Layer.LayerAction {
        private final transient MarkerLayer layer;

        public ShowHideMarkerText(MarkerLayer markerLayer) {
            super(I18n.tr("Show Text/Icons", new Object[0]), ImageProvider.get("dialogs", "showhide"));
            this.putValue("ShortDescription", I18n.tr("Toggle visible state of the marker text and icons.", new Object[0]));
            this.putValue("help", HelpUtil.ht("/Action/ShowHideTextIcons"));
            this.layer = markerLayer;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Main.pref.put("marker.show " + this.layer.getName(), this.layer.isTextOrIconShown() ? "hide" : "show");
            Main.map.mapView.repaint();
        }

        @Override
        public Component createMenuComponent() {
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(this);
            jCheckBoxMenuItem.setState(this.layer.isTextOrIconShown());
            return jCheckBoxMenuItem;
        }

        @Override
        public boolean supportLayers(List<Layer> list) {
            return list.size() == 1 && list.get(0) instanceof MarkerLayer;
        }
    }
}

