/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import java.io.File;
import java.io.FileOutputStream;
import org.jruby.internal.runtime.methods.InvocationMethodFactory;
import org.jruby.org.objectweb.asm.ClassWriter;

public class DumpingInvocationMethodFactory
extends InvocationMethodFactory {
    private String dumpPath;

    public DumpingInvocationMethodFactory(String path2, ClassLoader classLoader) {
        super(classLoader);
        this.dumpPath = path2;
    }

    @Override
    protected Class endClass(ClassWriter cw, String name2) {
        cw.visitEnd();
        byte[] code = cw.toByteArray();
        String cname = name2.replace('.', '/');
        File f = new File(this.dumpPath, cname + ".class");
        f.getParentFile().mkdirs();
        try {
            FileOutputStream fos = new FileOutputStream(f);
            fos.write(code);
            fos.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        return this.classLoader.defineClass(name2, code);
    }
}

