/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.array.ArrayGuards;
import org.jruby.truffle.nodes.core.array.ArrayReadSliceNormalizedNode;
import org.jruby.truffle.runtime.RubyContext;

@GeneratedBy(value=ArrayReadSliceNormalizedNode.class)
public final class ArrayReadSliceNormalizedNodeGen
extends ArrayReadSliceNormalizedNode
implements SpecializedNode {
    @Node.Child
    private RubyNode array_;
    @Node.Child
    private RubyNode index_;
    @Node.Child
    private RubyNode length_;
    @CompilerDirectives.CompilationFinal
    private Class<?> indexType_;
    @CompilerDirectives.CompilationFinal
    private Class<?> lengthType_;
    @Node.Child
    private BaseNode_ specialization_;

    private ArrayReadSliceNormalizedNodeGen(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode index, RubyNode length) {
        super(context, sourceSection);
        this.array_ = array;
        this.index_ = index;
        this.length_ = length;
        this.specialization_ = UninitializedNode_.create(this);
    }

    @Override
    public NodeCost getCost() {
        return this.specialization_.getNodeCost();
    }

    @Override
    public DynamicObject executeReadSlice(DynamicObject arrayValue, int indexValue, int lengthValue) {
        return this.specialization_.executeDynamicObject1(arrayValue, indexValue, lengthValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        return this.specialization_.execute(frameValue);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.specialization_.executeVoid(frameValue);
    }

    @Override
    public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
        return this.specialization_.executeDynamicObject0(frameValue);
    }

    @Override
    public SpecializationNode getSpecializationNode() {
        return this.specialization_;
    }

    @Override
    public Node deepCopy() {
        return SpecializationNode.updateRoot(super.deepCopy());
    }

    public static ArrayReadSliceNormalizedNode create(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode index, RubyNode length) {
        return new ArrayReadSliceNormalizedNodeGen(context, sourceSection, array, index, length);
    }

    @GeneratedBy(methodName="readObjectOutOfBounds(DynamicObject, int, int)", value=ArrayReadSliceNormalizedNode.class)
    private static final class ReadObjectOutOfBoundsNode_
    extends BaseNode_ {
        ReadObjectOutOfBoundsNode_(ArrayReadSliceNormalizedNodeGen root) {
            super(root, 11);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeDynamicObject0(frameValue);
        }

        @Override
        public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
            int lengthValue_;
            int indexValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_(frameValue);
                Object lengthValue = this.executeLength_(frameValue);
                return this.getNext().executeDynamicObject_(ex.getResult(), indexValue, lengthValue);
            }
            try {
                indexValue_ = this.root.index_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object lengthValue = this.executeLength_(frameValue);
                return this.getNext().executeDynamicObject_(arrayValue_, ex.getResult(), lengthValue);
            }
            try {
                lengthValue_ = this.root.length_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeDynamicObject_(arrayValue_, indexValue_, ex.getResult());
            }
            if (RubyGuards.isRubyArray(arrayValue_) && ArrayReadSliceNormalizedNode.indexInBounds(arrayValue_, indexValue_) && ArrayReadSliceNormalizedNode.lengthPositive(lengthValue_) && !ArrayReadSliceNormalizedNode.endInBounds(arrayValue_, indexValue_, lengthValue_) && ArrayGuards.isObjectArray(arrayValue_)) {
                return this.root.readObjectOutOfBounds(arrayValue_, indexValue_, lengthValue_);
            }
            return this.getNext().executeDynamicObject_(arrayValue_, indexValue_, lengthValue_);
        }

        @Override
        public DynamicObject executeDynamicObject1(DynamicObject arrayValue, int indexValue, int lengthValue) {
            if (RubyGuards.isRubyArray(arrayValue) && ArrayReadSliceNormalizedNode.indexInBounds(arrayValue, indexValue) && ArrayReadSliceNormalizedNode.lengthPositive(lengthValue) && !ArrayReadSliceNormalizedNode.endInBounds(arrayValue, indexValue, lengthValue) && ArrayGuards.isObjectArray(arrayValue)) {
                return this.root.readObjectOutOfBounds(arrayValue, indexValue, lengthValue);
            }
            return this.getNext().executeDynamicObject1(arrayValue, indexValue, lengthValue);
        }

        @Override
        public DynamicObject executeDynamicObject_(Object arrayValue, Object indexValue, Object lengthValue) {
            if (arrayValue instanceof DynamicObject && indexValue instanceof Integer && lengthValue instanceof Integer) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int indexValue_ = (Integer)indexValue;
                int lengthValue_ = (Integer)lengthValue;
                if (RubyGuards.isRubyArray(arrayValue_) && ArrayReadSliceNormalizedNode.indexInBounds(arrayValue_, indexValue_) && ArrayReadSliceNormalizedNode.lengthPositive(lengthValue_) && !ArrayReadSliceNormalizedNode.endInBounds(arrayValue_, indexValue_, lengthValue_) && ArrayGuards.isObjectArray(arrayValue_)) {
                    return this.root.readObjectOutOfBounds(arrayValue_, indexValue_, lengthValue_);
                }
            }
            return this.getNext().executeDynamicObject_(arrayValue, indexValue, lengthValue);
        }

        static BaseNode_ create(ArrayReadSliceNormalizedNodeGen root) {
            return new ReadObjectOutOfBoundsNode_(root);
        }
    }

    @GeneratedBy(methodName="readDoubleOutOfBounds(DynamicObject, int, int)", value=ArrayReadSliceNormalizedNode.class)
    private static final class ReadDoubleOutOfBoundsNode_
    extends BaseNode_ {
        ReadDoubleOutOfBoundsNode_(ArrayReadSliceNormalizedNodeGen root) {
            super(root, 10);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeDynamicObject0(frameValue);
        }

        @Override
        public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
            int lengthValue_;
            int indexValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_(frameValue);
                Object lengthValue = this.executeLength_(frameValue);
                return this.getNext().executeDynamicObject_(ex.getResult(), indexValue, lengthValue);
            }
            try {
                indexValue_ = this.root.index_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object lengthValue = this.executeLength_(frameValue);
                return this.getNext().executeDynamicObject_(arrayValue_, ex.getResult(), lengthValue);
            }
            try {
                lengthValue_ = this.root.length_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeDynamicObject_(arrayValue_, indexValue_, ex.getResult());
            }
            if (RubyGuards.isRubyArray(arrayValue_) && ArrayReadSliceNormalizedNode.indexInBounds(arrayValue_, indexValue_) && ArrayReadSliceNormalizedNode.lengthPositive(lengthValue_) && !ArrayReadSliceNormalizedNode.endInBounds(arrayValue_, indexValue_, lengthValue_) && ArrayGuards.isDoubleArray(arrayValue_)) {
                return this.root.readDoubleOutOfBounds(arrayValue_, indexValue_, lengthValue_);
            }
            return this.getNext().executeDynamicObject_(arrayValue_, indexValue_, lengthValue_);
        }

        @Override
        public DynamicObject executeDynamicObject1(DynamicObject arrayValue, int indexValue, int lengthValue) {
            if (RubyGuards.isRubyArray(arrayValue) && ArrayReadSliceNormalizedNode.indexInBounds(arrayValue, indexValue) && ArrayReadSliceNormalizedNode.lengthPositive(lengthValue) && !ArrayReadSliceNormalizedNode.endInBounds(arrayValue, indexValue, lengthValue) && ArrayGuards.isDoubleArray(arrayValue)) {
                return this.root.readDoubleOutOfBounds(arrayValue, indexValue, lengthValue);
            }
            return this.getNext().executeDynamicObject1(arrayValue, indexValue, lengthValue);
        }

        @Override
        public DynamicObject executeDynamicObject_(Object arrayValue, Object indexValue, Object lengthValue) {
            if (arrayValue instanceof DynamicObject && indexValue instanceof Integer && lengthValue instanceof Integer) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int indexValue_ = (Integer)indexValue;
                int lengthValue_ = (Integer)lengthValue;
                if (RubyGuards.isRubyArray(arrayValue_) && ArrayReadSliceNormalizedNode.indexInBounds(arrayValue_, indexValue_) && ArrayReadSliceNormalizedNode.lengthPositive(lengthValue_) && !ArrayReadSliceNormalizedNode.endInBounds(arrayValue_, indexValue_, lengthValue_) && ArrayGuards.isDoubleArray(arrayValue_)) {
                    return this.root.readDoubleOutOfBounds(arrayValue_, indexValue_, lengthValue_);
                }
            }
            return this.getNext().executeDynamicObject_(arrayValue, indexValue, lengthValue);
        }

        static BaseNode_ create(ArrayReadSliceNormalizedNodeGen root) {
            return new ReadDoubleOutOfBoundsNode_(root);
        }
    }

    @GeneratedBy(methodName="readLongOutOfBounds(DynamicObject, int, int)", value=ArrayReadSliceNormalizedNode.class)
    private static final class ReadLongOutOfBoundsNode_
    extends BaseNode_ {
        ReadLongOutOfBoundsNode_(ArrayReadSliceNormalizedNodeGen root) {
            super(root, 9);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeDynamicObject0(frameValue);
        }

        @Override
        public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
            int lengthValue_;
            int indexValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_(frameValue);
                Object lengthValue = this.executeLength_(frameValue);
                return this.getNext().executeDynamicObject_(ex.getResult(), indexValue, lengthValue);
            }
            try {
                indexValue_ = this.root.index_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object lengthValue = this.executeLength_(frameValue);
                return this.getNext().executeDynamicObject_(arrayValue_, ex.getResult(), lengthValue);
            }
            try {
                lengthValue_ = this.root.length_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeDynamicObject_(arrayValue_, indexValue_, ex.getResult());
            }
            if (RubyGuards.isRubyArray(arrayValue_) && ArrayReadSliceNormalizedNode.indexInBounds(arrayValue_, indexValue_) && ArrayReadSliceNormalizedNode.lengthPositive(lengthValue_) && !ArrayReadSliceNormalizedNode.endInBounds(arrayValue_, indexValue_, lengthValue_) && ArrayGuards.isLongArray(arrayValue_)) {
                return this.root.readLongOutOfBounds(arrayValue_, indexValue_, lengthValue_);
            }
            return this.getNext().executeDynamicObject_(arrayValue_, indexValue_, lengthValue_);
        }

        @Override
        public DynamicObject executeDynamicObject1(DynamicObject arrayValue, int indexValue, int lengthValue) {
            if (RubyGuards.isRubyArray(arrayValue) && ArrayReadSliceNormalizedNode.indexInBounds(arrayValue, indexValue) && ArrayReadSliceNormalizedNode.lengthPositive(lengthValue) && !ArrayReadSliceNormalizedNode.endInBounds(arrayValue, indexValue, lengthValue) && ArrayGuards.isLongArray(arrayValue)) {
                return this.root.readLongOutOfBounds(arrayValue, indexValue, lengthValue);
            }
            return this.getNext().executeDynamicObject1(arrayValue, indexValue, lengthValue);
        }

        @Override
        public DynamicObject executeDynamicObject_(Object arrayValue, Object indexValue, Object lengthValue) {
            if (arrayValue instanceof DynamicObject && indexValue instanceof Integer && lengthValue instanceof Integer) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int indexValue_ = (Integer)indexValue;
                int lengthValue_ = (Integer)lengthValue;
                if (RubyGuards.isRubyArray(arrayValue_) && ArrayReadSliceNormalizedNode.indexInBounds(arrayValue_, indexValue_) && ArrayReadSliceNormalizedNode.lengthPositive(lengthValue_) && !ArrayReadSliceNormalizedNode.endInBounds(arrayValue_, indexValue_, lengthValue_) && ArrayGuards.isLongArray(arrayValue_)) {
                    return this.root.readLongOutOfBounds(arrayValue_, indexValue_, lengthValue_);
                }
            }
            return this.getNext().executeDynamicObject_(arrayValue, indexValue, lengthValue);
        }

        static BaseNode_ create(ArrayReadSliceNormalizedNodeGen root) {
            return new ReadLongOutOfBoundsNode_(root);
        }
    }

    @GeneratedBy(methodName="readIntOutOfBounds(DynamicObject, int, int)", value=ArrayReadSliceNormalizedNode.class)
    private static final class ReadIntOutOfBoundsNode_
    extends BaseNode_ {
        ReadIntOutOfBoundsNode_(ArrayReadSliceNormalizedNodeGen root) {
            super(root, 8);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeDynamicObject0(frameValue);
        }

        @Override
        public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
            int lengthValue_;
            int indexValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_(frameValue);
                Object lengthValue = this.executeLength_(frameValue);
                return this.getNext().executeDynamicObject_(ex.getResult(), indexValue, lengthValue);
            }
            try {
                indexValue_ = this.root.index_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object lengthValue = this.executeLength_(frameValue);
                return this.getNext().executeDynamicObject_(arrayValue_, ex.getResult(), lengthValue);
            }
            try {
                lengthValue_ = this.root.length_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeDynamicObject_(arrayValue_, indexValue_, ex.getResult());
            }
            if (RubyGuards.isRubyArray(arrayValue_) && ArrayReadSliceNormalizedNode.indexInBounds(arrayValue_, indexValue_) && ArrayReadSliceNormalizedNode.lengthPositive(lengthValue_) && !ArrayReadSliceNormalizedNode.endInBounds(arrayValue_, indexValue_, lengthValue_) && ArrayGuards.isIntArray(arrayValue_)) {
                return this.root.readIntOutOfBounds(arrayValue_, indexValue_, lengthValue_);
            }
            return this.getNext().executeDynamicObject_(arrayValue_, indexValue_, lengthValue_);
        }

        @Override
        public DynamicObject executeDynamicObject1(DynamicObject arrayValue, int indexValue, int lengthValue) {
            if (RubyGuards.isRubyArray(arrayValue) && ArrayReadSliceNormalizedNode.indexInBounds(arrayValue, indexValue) && ArrayReadSliceNormalizedNode.lengthPositive(lengthValue) && !ArrayReadSliceNormalizedNode.endInBounds(arrayValue, indexValue, lengthValue) && ArrayGuards.isIntArray(arrayValue)) {
                return this.root.readIntOutOfBounds(arrayValue, indexValue, lengthValue);
            }
            return this.getNext().executeDynamicObject1(arrayValue, indexValue, lengthValue);
        }

        @Override
        public DynamicObject executeDynamicObject_(Object arrayValue, Object indexValue, Object lengthValue) {
            if (arrayValue instanceof DynamicObject && indexValue instanceof Integer && lengthValue instanceof Integer) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int indexValue_ = (Integer)indexValue;
                int lengthValue_ = (Integer)lengthValue;
                if (RubyGuards.isRubyArray(arrayValue_) && ArrayReadSliceNormalizedNode.indexInBounds(arrayValue_, indexValue_) && ArrayReadSliceNormalizedNode.lengthPositive(lengthValue_) && !ArrayReadSliceNormalizedNode.endInBounds(arrayValue_, indexValue_, lengthValue_) && ArrayGuards.isIntArray(arrayValue_)) {
                    return this.root.readIntOutOfBounds(arrayValue_, indexValue_, lengthValue_);
                }
            }
            return this.getNext().executeDynamicObject_(arrayValue, indexValue, lengthValue);
        }

        static BaseNode_ create(ArrayReadSliceNormalizedNodeGen root) {
            return new ReadIntOutOfBoundsNode_(root);
        }
    }

    @GeneratedBy(methodName="readObjectInBounds(DynamicObject, int, int)", value=ArrayReadSliceNormalizedNode.class)
    private static final class ReadObjectInBoundsNode_
    extends BaseNode_ {
        ReadObjectInBoundsNode_(ArrayReadSliceNormalizedNodeGen root) {
            super(root, 7);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeDynamicObject0(frameValue);
        }

        @Override
        public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
            int lengthValue_;
            int indexValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_(frameValue);
                Object lengthValue = this.executeLength_(frameValue);
                return this.getNext().executeDynamicObject_(ex.getResult(), indexValue, lengthValue);
            }
            try {
                indexValue_ = this.root.index_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object lengthValue = this.executeLength_(frameValue);
                return this.getNext().executeDynamicObject_(arrayValue_, ex.getResult(), lengthValue);
            }
            try {
                lengthValue_ = this.root.length_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeDynamicObject_(arrayValue_, indexValue_, ex.getResult());
            }
            if (RubyGuards.isRubyArray(arrayValue_) && ArrayReadSliceNormalizedNode.indexInBounds(arrayValue_, indexValue_) && ArrayReadSliceNormalizedNode.lengthPositive(lengthValue_) && ArrayReadSliceNormalizedNode.endInBounds(arrayValue_, indexValue_, lengthValue_) && ArrayGuards.isObjectArray(arrayValue_)) {
                return this.root.readObjectInBounds(arrayValue_, indexValue_, lengthValue_);
            }
            return this.getNext().executeDynamicObject_(arrayValue_, indexValue_, lengthValue_);
        }

        @Override
        public DynamicObject executeDynamicObject1(DynamicObject arrayValue, int indexValue, int lengthValue) {
            if (RubyGuards.isRubyArray(arrayValue) && ArrayReadSliceNormalizedNode.indexInBounds(arrayValue, indexValue) && ArrayReadSliceNormalizedNode.lengthPositive(lengthValue) && ArrayReadSliceNormalizedNode.endInBounds(arrayValue, indexValue, lengthValue) && ArrayGuards.isObjectArray(arrayValue)) {
                return this.root.readObjectInBounds(arrayValue, indexValue, lengthValue);
            }
            return this.getNext().executeDynamicObject1(arrayValue, indexValue, lengthValue);
        }

        @Override
        public DynamicObject executeDynamicObject_(Object arrayValue, Object indexValue, Object lengthValue) {
            if (arrayValue instanceof DynamicObject && indexValue instanceof Integer && lengthValue instanceof Integer) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int indexValue_ = (Integer)indexValue;
                int lengthValue_ = (Integer)lengthValue;
                if (RubyGuards.isRubyArray(arrayValue_) && ArrayReadSliceNormalizedNode.indexInBounds(arrayValue_, indexValue_) && ArrayReadSliceNormalizedNode.lengthPositive(lengthValue_) && ArrayReadSliceNormalizedNode.endInBounds(arrayValue_, indexValue_, lengthValue_) && ArrayGuards.isObjectArray(arrayValue_)) {
                    return this.root.readObjectInBounds(arrayValue_, indexValue_, lengthValue_);
                }
            }
            return this.getNext().executeDynamicObject_(arrayValue, indexValue, lengthValue);
        }

        static BaseNode_ create(ArrayReadSliceNormalizedNodeGen root) {
            return new ReadObjectInBoundsNode_(root);
        }
    }

    @GeneratedBy(methodName="readDoubleInBounds(DynamicObject, int, int)", value=ArrayReadSliceNormalizedNode.class)
    private static final class ReadDoubleInBoundsNode_
    extends BaseNode_ {
        ReadDoubleInBoundsNode_(ArrayReadSliceNormalizedNodeGen root) {
            super(root, 6);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeDynamicObject0(frameValue);
        }

        @Override
        public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
            int lengthValue_;
            int indexValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_(frameValue);
                Object lengthValue = this.executeLength_(frameValue);
                return this.getNext().executeDynamicObject_(ex.getResult(), indexValue, lengthValue);
            }
            try {
                indexValue_ = this.root.index_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object lengthValue = this.executeLength_(frameValue);
                return this.getNext().executeDynamicObject_(arrayValue_, ex.getResult(), lengthValue);
            }
            try {
                lengthValue_ = this.root.length_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeDynamicObject_(arrayValue_, indexValue_, ex.getResult());
            }
            if (RubyGuards.isRubyArray(arrayValue_) && ArrayReadSliceNormalizedNode.indexInBounds(arrayValue_, indexValue_) && ArrayReadSliceNormalizedNode.lengthPositive(lengthValue_) && ArrayReadSliceNormalizedNode.endInBounds(arrayValue_, indexValue_, lengthValue_) && ArrayGuards.isDoubleArray(arrayValue_)) {
                return this.root.readDoubleInBounds(arrayValue_, indexValue_, lengthValue_);
            }
            return this.getNext().executeDynamicObject_(arrayValue_, indexValue_, lengthValue_);
        }

        @Override
        public DynamicObject executeDynamicObject1(DynamicObject arrayValue, int indexValue, int lengthValue) {
            if (RubyGuards.isRubyArray(arrayValue) && ArrayReadSliceNormalizedNode.indexInBounds(arrayValue, indexValue) && ArrayReadSliceNormalizedNode.lengthPositive(lengthValue) && ArrayReadSliceNormalizedNode.endInBounds(arrayValue, indexValue, lengthValue) && ArrayGuards.isDoubleArray(arrayValue)) {
                return this.root.readDoubleInBounds(arrayValue, indexValue, lengthValue);
            }
            return this.getNext().executeDynamicObject1(arrayValue, indexValue, lengthValue);
        }

        @Override
        public DynamicObject executeDynamicObject_(Object arrayValue, Object indexValue, Object lengthValue) {
            if (arrayValue instanceof DynamicObject && indexValue instanceof Integer && lengthValue instanceof Integer) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int indexValue_ = (Integer)indexValue;
                int lengthValue_ = (Integer)lengthValue;
                if (RubyGuards.isRubyArray(arrayValue_) && ArrayReadSliceNormalizedNode.indexInBounds(arrayValue_, indexValue_) && ArrayReadSliceNormalizedNode.lengthPositive(lengthValue_) && ArrayReadSliceNormalizedNode.endInBounds(arrayValue_, indexValue_, lengthValue_) && ArrayGuards.isDoubleArray(arrayValue_)) {
                    return this.root.readDoubleInBounds(arrayValue_, indexValue_, lengthValue_);
                }
            }
            return this.getNext().executeDynamicObject_(arrayValue, indexValue, lengthValue);
        }

        static BaseNode_ create(ArrayReadSliceNormalizedNodeGen root) {
            return new ReadDoubleInBoundsNode_(root);
        }
    }

    @GeneratedBy(methodName="readLongInBounds(DynamicObject, int, int)", value=ArrayReadSliceNormalizedNode.class)
    private static final class ReadLongInBoundsNode_
    extends BaseNode_ {
        ReadLongInBoundsNode_(ArrayReadSliceNormalizedNodeGen root) {
            super(root, 5);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeDynamicObject0(frameValue);
        }

        @Override
        public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
            int lengthValue_;
            int indexValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_(frameValue);
                Object lengthValue = this.executeLength_(frameValue);
                return this.getNext().executeDynamicObject_(ex.getResult(), indexValue, lengthValue);
            }
            try {
                indexValue_ = this.root.index_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object lengthValue = this.executeLength_(frameValue);
                return this.getNext().executeDynamicObject_(arrayValue_, ex.getResult(), lengthValue);
            }
            try {
                lengthValue_ = this.root.length_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeDynamicObject_(arrayValue_, indexValue_, ex.getResult());
            }
            if (RubyGuards.isRubyArray(arrayValue_) && ArrayReadSliceNormalizedNode.indexInBounds(arrayValue_, indexValue_) && ArrayReadSliceNormalizedNode.lengthPositive(lengthValue_) && ArrayReadSliceNormalizedNode.endInBounds(arrayValue_, indexValue_, lengthValue_) && ArrayGuards.isLongArray(arrayValue_)) {
                return this.root.readLongInBounds(arrayValue_, indexValue_, lengthValue_);
            }
            return this.getNext().executeDynamicObject_(arrayValue_, indexValue_, lengthValue_);
        }

        @Override
        public DynamicObject executeDynamicObject1(DynamicObject arrayValue, int indexValue, int lengthValue) {
            if (RubyGuards.isRubyArray(arrayValue) && ArrayReadSliceNormalizedNode.indexInBounds(arrayValue, indexValue) && ArrayReadSliceNormalizedNode.lengthPositive(lengthValue) && ArrayReadSliceNormalizedNode.endInBounds(arrayValue, indexValue, lengthValue) && ArrayGuards.isLongArray(arrayValue)) {
                return this.root.readLongInBounds(arrayValue, indexValue, lengthValue);
            }
            return this.getNext().executeDynamicObject1(arrayValue, indexValue, lengthValue);
        }

        @Override
        public DynamicObject executeDynamicObject_(Object arrayValue, Object indexValue, Object lengthValue) {
            if (arrayValue instanceof DynamicObject && indexValue instanceof Integer && lengthValue instanceof Integer) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int indexValue_ = (Integer)indexValue;
                int lengthValue_ = (Integer)lengthValue;
                if (RubyGuards.isRubyArray(arrayValue_) && ArrayReadSliceNormalizedNode.indexInBounds(arrayValue_, indexValue_) && ArrayReadSliceNormalizedNode.lengthPositive(lengthValue_) && ArrayReadSliceNormalizedNode.endInBounds(arrayValue_, indexValue_, lengthValue_) && ArrayGuards.isLongArray(arrayValue_)) {
                    return this.root.readLongInBounds(arrayValue_, indexValue_, lengthValue_);
                }
            }
            return this.getNext().executeDynamicObject_(arrayValue, indexValue, lengthValue);
        }

        static BaseNode_ create(ArrayReadSliceNormalizedNodeGen root) {
            return new ReadLongInBoundsNode_(root);
        }
    }

    @GeneratedBy(methodName="readIntInBounds(DynamicObject, int, int)", value=ArrayReadSliceNormalizedNode.class)
    private static final class ReadIntInBoundsNode_
    extends BaseNode_ {
        ReadIntInBoundsNode_(ArrayReadSliceNormalizedNodeGen root) {
            super(root, 4);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeDynamicObject0(frameValue);
        }

        @Override
        public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
            int lengthValue_;
            int indexValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_(frameValue);
                Object lengthValue = this.executeLength_(frameValue);
                return this.getNext().executeDynamicObject_(ex.getResult(), indexValue, lengthValue);
            }
            try {
                indexValue_ = this.root.index_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object lengthValue = this.executeLength_(frameValue);
                return this.getNext().executeDynamicObject_(arrayValue_, ex.getResult(), lengthValue);
            }
            try {
                lengthValue_ = this.root.length_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeDynamicObject_(arrayValue_, indexValue_, ex.getResult());
            }
            if (RubyGuards.isRubyArray(arrayValue_) && ArrayReadSliceNormalizedNode.indexInBounds(arrayValue_, indexValue_) && ArrayReadSliceNormalizedNode.lengthPositive(lengthValue_) && ArrayReadSliceNormalizedNode.endInBounds(arrayValue_, indexValue_, lengthValue_) && ArrayGuards.isIntArray(arrayValue_)) {
                return this.root.readIntInBounds(arrayValue_, indexValue_, lengthValue_);
            }
            return this.getNext().executeDynamicObject_(arrayValue_, indexValue_, lengthValue_);
        }

        @Override
        public DynamicObject executeDynamicObject1(DynamicObject arrayValue, int indexValue, int lengthValue) {
            if (RubyGuards.isRubyArray(arrayValue) && ArrayReadSliceNormalizedNode.indexInBounds(arrayValue, indexValue) && ArrayReadSliceNormalizedNode.lengthPositive(lengthValue) && ArrayReadSliceNormalizedNode.endInBounds(arrayValue, indexValue, lengthValue) && ArrayGuards.isIntArray(arrayValue)) {
                return this.root.readIntInBounds(arrayValue, indexValue, lengthValue);
            }
            return this.getNext().executeDynamicObject1(arrayValue, indexValue, lengthValue);
        }

        @Override
        public DynamicObject executeDynamicObject_(Object arrayValue, Object indexValue, Object lengthValue) {
            if (arrayValue instanceof DynamicObject && indexValue instanceof Integer && lengthValue instanceof Integer) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int indexValue_ = (Integer)indexValue;
                int lengthValue_ = (Integer)lengthValue;
                if (RubyGuards.isRubyArray(arrayValue_) && ArrayReadSliceNormalizedNode.indexInBounds(arrayValue_, indexValue_) && ArrayReadSliceNormalizedNode.lengthPositive(lengthValue_) && ArrayReadSliceNormalizedNode.endInBounds(arrayValue_, indexValue_, lengthValue_) && ArrayGuards.isIntArray(arrayValue_)) {
                    return this.root.readIntInBounds(arrayValue_, indexValue_, lengthValue_);
                }
            }
            return this.getNext().executeDynamicObject_(arrayValue, indexValue, lengthValue);
        }

        static BaseNode_ create(ArrayReadSliceNormalizedNodeGen root) {
            return new ReadIntInBoundsNode_(root);
        }
    }

    @GeneratedBy(methodName="readNull(DynamicObject, int, int)", value=ArrayReadSliceNormalizedNode.class)
    private static final class ReadNullNode_
    extends BaseNode_ {
        ReadNullNode_(ArrayReadSliceNormalizedNodeGen root) {
            super(root, 3);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeDynamicObject0(frameValue);
        }

        @Override
        public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
            int lengthValue_;
            int indexValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_(frameValue);
                Object lengthValue = this.executeLength_(frameValue);
                return this.getNext().executeDynamicObject_(ex.getResult(), indexValue, lengthValue);
            }
            try {
                indexValue_ = this.root.index_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object lengthValue = this.executeLength_(frameValue);
                return this.getNext().executeDynamicObject_(arrayValue_, ex.getResult(), lengthValue);
            }
            try {
                lengthValue_ = this.root.length_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeDynamicObject_(arrayValue_, indexValue_, ex.getResult());
            }
            if (RubyGuards.isRubyArray(arrayValue_) && ArrayReadSliceNormalizedNode.indexInBounds(arrayValue_, indexValue_) && ArrayReadSliceNormalizedNode.lengthPositive(lengthValue_) && ArrayGuards.isNullArray(arrayValue_)) {
                return this.root.readNull(arrayValue_, indexValue_, lengthValue_);
            }
            return this.getNext().executeDynamicObject_(arrayValue_, indexValue_, lengthValue_);
        }

        @Override
        public DynamicObject executeDynamicObject1(DynamicObject arrayValue, int indexValue, int lengthValue) {
            if (RubyGuards.isRubyArray(arrayValue) && ArrayReadSliceNormalizedNode.indexInBounds(arrayValue, indexValue) && ArrayReadSliceNormalizedNode.lengthPositive(lengthValue) && ArrayGuards.isNullArray(arrayValue)) {
                return this.root.readNull(arrayValue, indexValue, lengthValue);
            }
            return this.getNext().executeDynamicObject1(arrayValue, indexValue, lengthValue);
        }

        @Override
        public DynamicObject executeDynamicObject_(Object arrayValue, Object indexValue, Object lengthValue) {
            if (arrayValue instanceof DynamicObject && indexValue instanceof Integer && lengthValue instanceof Integer) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int indexValue_ = (Integer)indexValue;
                int lengthValue_ = (Integer)lengthValue;
                if (RubyGuards.isRubyArray(arrayValue_) && ArrayReadSliceNormalizedNode.indexInBounds(arrayValue_, indexValue_) && ArrayReadSliceNormalizedNode.lengthPositive(lengthValue_) && ArrayGuards.isNullArray(arrayValue_)) {
                    return this.root.readNull(arrayValue_, indexValue_, lengthValue_);
                }
            }
            return this.getNext().executeDynamicObject_(arrayValue, indexValue, lengthValue);
        }

        static BaseNode_ create(ArrayReadSliceNormalizedNodeGen root) {
            return new ReadNullNode_(root);
        }
    }

    @GeneratedBy(methodName="readNegativeLength(DynamicObject, int, int)", value=ArrayReadSliceNormalizedNode.class)
    private static final class ReadNegativeLengthNode_
    extends BaseNode_ {
        ReadNegativeLengthNode_(ArrayReadSliceNormalizedNodeGen root) {
            super(root, 2);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeDynamicObject0(frameValue);
        }

        @Override
        public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
            int lengthValue_;
            int indexValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_(frameValue);
                Object lengthValue = this.executeLength_(frameValue);
                return this.getNext().executeDynamicObject_(ex.getResult(), indexValue, lengthValue);
            }
            try {
                indexValue_ = this.root.index_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object lengthValue = this.executeLength_(frameValue);
                return this.getNext().executeDynamicObject_(arrayValue_, ex.getResult(), lengthValue);
            }
            try {
                lengthValue_ = this.root.length_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeDynamicObject_(arrayValue_, indexValue_, ex.getResult());
            }
            if (RubyGuards.isRubyArray(arrayValue_) && !ArrayReadSliceNormalizedNode.lengthPositive(lengthValue_)) {
                return this.root.readNegativeLength(arrayValue_, indexValue_, lengthValue_);
            }
            return this.getNext().executeDynamicObject_(arrayValue_, indexValue_, lengthValue_);
        }

        @Override
        public DynamicObject executeDynamicObject1(DynamicObject arrayValue, int indexValue, int lengthValue) {
            if (RubyGuards.isRubyArray(arrayValue) && !ArrayReadSliceNormalizedNode.lengthPositive(lengthValue)) {
                return this.root.readNegativeLength(arrayValue, indexValue, lengthValue);
            }
            return this.getNext().executeDynamicObject1(arrayValue, indexValue, lengthValue);
        }

        @Override
        public DynamicObject executeDynamicObject_(Object arrayValue, Object indexValue, Object lengthValue) {
            if (arrayValue instanceof DynamicObject && indexValue instanceof Integer && lengthValue instanceof Integer) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int indexValue_ = (Integer)indexValue;
                int lengthValue_ = (Integer)lengthValue;
                if (RubyGuards.isRubyArray(arrayValue_) && !ArrayReadSliceNormalizedNode.lengthPositive(lengthValue_)) {
                    return this.root.readNegativeLength(arrayValue_, indexValue_, lengthValue_);
                }
            }
            return this.getNext().executeDynamicObject_(arrayValue, indexValue, lengthValue);
        }

        static BaseNode_ create(ArrayReadSliceNormalizedNodeGen root) {
            return new ReadNegativeLengthNode_(root);
        }
    }

    @GeneratedBy(methodName="readIndexOutOfBounds(DynamicObject, int, int)", value=ArrayReadSliceNormalizedNode.class)
    private static final class ReadIndexOutOfBoundsNode_
    extends BaseNode_ {
        ReadIndexOutOfBoundsNode_(ArrayReadSliceNormalizedNodeGen root) {
            super(root, 1);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeDynamicObject0(frameValue);
        }

        @Override
        public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
            int lengthValue_;
            int indexValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_(frameValue);
                Object lengthValue = this.executeLength_(frameValue);
                return this.getNext().executeDynamicObject_(ex.getResult(), indexValue, lengthValue);
            }
            try {
                indexValue_ = this.root.index_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object lengthValue = this.executeLength_(frameValue);
                return this.getNext().executeDynamicObject_(arrayValue_, ex.getResult(), lengthValue);
            }
            try {
                lengthValue_ = this.root.length_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeDynamicObject_(arrayValue_, indexValue_, ex.getResult());
            }
            if (RubyGuards.isRubyArray(arrayValue_) && !ArrayReadSliceNormalizedNode.indexInBounds(arrayValue_, indexValue_)) {
                return this.root.readIndexOutOfBounds(arrayValue_, indexValue_, lengthValue_);
            }
            return this.getNext().executeDynamicObject_(arrayValue_, indexValue_, lengthValue_);
        }

        @Override
        public DynamicObject executeDynamicObject1(DynamicObject arrayValue, int indexValue, int lengthValue) {
            if (RubyGuards.isRubyArray(arrayValue) && !ArrayReadSliceNormalizedNode.indexInBounds(arrayValue, indexValue)) {
                return this.root.readIndexOutOfBounds(arrayValue, indexValue, lengthValue);
            }
            return this.getNext().executeDynamicObject1(arrayValue, indexValue, lengthValue);
        }

        @Override
        public DynamicObject executeDynamicObject_(Object arrayValue, Object indexValue, Object lengthValue) {
            if (arrayValue instanceof DynamicObject && indexValue instanceof Integer && lengthValue instanceof Integer) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int indexValue_ = (Integer)indexValue;
                int lengthValue_ = (Integer)lengthValue;
                if (RubyGuards.isRubyArray(arrayValue_) && !ArrayReadSliceNormalizedNode.indexInBounds(arrayValue_, indexValue_)) {
                    return this.root.readIndexOutOfBounds(arrayValue_, indexValue_, lengthValue_);
                }
            }
            return this.getNext().executeDynamicObject_(arrayValue, indexValue, lengthValue);
        }

        static BaseNode_ create(ArrayReadSliceNormalizedNodeGen root) {
            return new ReadIndexOutOfBoundsNode_(root);
        }
    }

    @GeneratedBy(value=ArrayReadSliceNormalizedNode.class)
    private static final class PolymorphicNode_
    extends BaseNode_ {
        PolymorphicNode_(ArrayReadSliceNormalizedNodeGen root) {
            super(root, 0);
        }

        @Override
        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arrayValue, Object indexValue, Object lengthValue) {
            return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arrayValue, indexValue, lengthValue));
        }

        @Override
        public DynamicObject executeDynamicObject_(Object arrayValue, Object indexValue, Object lengthValue) {
            return this.getNext().executeDynamicObject_(arrayValue, indexValue, lengthValue);
        }

        static BaseNode_ create(ArrayReadSliceNormalizedNodeGen root) {
            return new PolymorphicNode_(root);
        }
    }

    @GeneratedBy(value=ArrayReadSliceNormalizedNode.class)
    private static final class UninitializedNode_
    extends BaseNode_ {
        UninitializedNode_(ArrayReadSliceNormalizedNodeGen root) {
            super(root, Integer.MAX_VALUE);
        }

        @Override
        public DynamicObject executeDynamicObject_(Object arrayValue, Object indexValue, Object lengthValue) {
            return (DynamicObject)this.uninitialized((Frame)null, arrayValue, indexValue, lengthValue);
        }

        static BaseNode_ create(ArrayReadSliceNormalizedNodeGen root) {
            return new UninitializedNode_(root);
        }
    }

    @GeneratedBy(value=ArrayReadSliceNormalizedNode.class)
    private static abstract class BaseNode_
    extends SpecializationNode {
        protected final ArrayReadSliceNormalizedNodeGen root;

        BaseNode_(ArrayReadSliceNormalizedNodeGen root, int index) {
            super(index);
            this.root = root;
        }

        @Override
        protected final Node[] getSuppliedChildren() {
            return new Node[]{this.root.array_, this.root.index_, this.root.length_};
        }

        @Override
        public final Object acceptAndExecute(Frame frameValue, Object arrayValue, Object indexValue, Object lengthValue) {
            return this.executeDynamicObject_(arrayValue, indexValue, lengthValue);
        }

        public abstract DynamicObject executeDynamicObject_(Object var1, Object var2, Object var3);

        public DynamicObject executeDynamicObject1(DynamicObject arrayValue, int indexValue, int lengthValue) {
            return this.executeDynamicObject_(arrayValue, indexValue, lengthValue);
        }

        public Object execute(VirtualFrame frameValue) {
            Object arrayValue_ = this.root.array_.execute(frameValue);
            Object indexValue_ = this.executeIndex_(frameValue);
            Object lengthValue_ = this.executeLength_(frameValue);
            return this.executeDynamicObject_(arrayValue_, indexValue_, lengthValue_);
        }

        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
            return (DynamicObject)this.execute(frameValue);
        }

        @Override
        protected final SpecializationNode createNext(Frame frameValue, Object arrayValue, Object indexValue, Object lengthValue) {
            if (arrayValue instanceof DynamicObject && indexValue instanceof Integer && lengthValue instanceof Integer) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int indexValue_ = (Integer)indexValue;
                int lengthValue_ = (Integer)lengthValue;
                if (RubyGuards.isRubyArray(arrayValue_) && !ArrayReadSliceNormalizedNode.indexInBounds(arrayValue_, indexValue_)) {
                    return ReadIndexOutOfBoundsNode_.create(this.root);
                }
                if (RubyGuards.isRubyArray(arrayValue_) && !ArrayReadSliceNormalizedNode.lengthPositive(lengthValue_)) {
                    return ReadNegativeLengthNode_.create(this.root);
                }
                if (RubyGuards.isRubyArray(arrayValue_) && ArrayReadSliceNormalizedNode.indexInBounds(arrayValue_, indexValue_) && ArrayReadSliceNormalizedNode.lengthPositive(lengthValue_) && ArrayGuards.isNullArray(arrayValue_)) {
                    return ReadNullNode_.create(this.root);
                }
                if (RubyGuards.isRubyArray(arrayValue_) && ArrayReadSliceNormalizedNode.indexInBounds(arrayValue_, indexValue_) && ArrayReadSliceNormalizedNode.lengthPositive(lengthValue_) && ArrayReadSliceNormalizedNode.endInBounds(arrayValue_, indexValue_, lengthValue_) && ArrayGuards.isIntArray(arrayValue_)) {
                    return ReadIntInBoundsNode_.create(this.root);
                }
                if (RubyGuards.isRubyArray(arrayValue_) && ArrayReadSliceNormalizedNode.indexInBounds(arrayValue_, indexValue_) && ArrayReadSliceNormalizedNode.lengthPositive(lengthValue_) && ArrayReadSliceNormalizedNode.endInBounds(arrayValue_, indexValue_, lengthValue_) && ArrayGuards.isLongArray(arrayValue_)) {
                    return ReadLongInBoundsNode_.create(this.root);
                }
                if (RubyGuards.isRubyArray(arrayValue_) && ArrayReadSliceNormalizedNode.indexInBounds(arrayValue_, indexValue_) && ArrayReadSliceNormalizedNode.lengthPositive(lengthValue_) && ArrayReadSliceNormalizedNode.endInBounds(arrayValue_, indexValue_, lengthValue_) && ArrayGuards.isDoubleArray(arrayValue_)) {
                    return ReadDoubleInBoundsNode_.create(this.root);
                }
                if (RubyGuards.isRubyArray(arrayValue_) && ArrayReadSliceNormalizedNode.indexInBounds(arrayValue_, indexValue_) && ArrayReadSliceNormalizedNode.lengthPositive(lengthValue_) && ArrayReadSliceNormalizedNode.endInBounds(arrayValue_, indexValue_, lengthValue_) && ArrayGuards.isObjectArray(arrayValue_)) {
                    return ReadObjectInBoundsNode_.create(this.root);
                }
                if (RubyGuards.isRubyArray(arrayValue_) && ArrayReadSliceNormalizedNode.indexInBounds(arrayValue_, indexValue_) && ArrayReadSliceNormalizedNode.lengthPositive(lengthValue_) && !ArrayReadSliceNormalizedNode.endInBounds(arrayValue_, indexValue_, lengthValue_) && ArrayGuards.isIntArray(arrayValue_)) {
                    return ReadIntOutOfBoundsNode_.create(this.root);
                }
                if (RubyGuards.isRubyArray(arrayValue_) && ArrayReadSliceNormalizedNode.indexInBounds(arrayValue_, indexValue_) && ArrayReadSliceNormalizedNode.lengthPositive(lengthValue_) && !ArrayReadSliceNormalizedNode.endInBounds(arrayValue_, indexValue_, lengthValue_) && ArrayGuards.isLongArray(arrayValue_)) {
                    return ReadLongOutOfBoundsNode_.create(this.root);
                }
                if (RubyGuards.isRubyArray(arrayValue_) && ArrayReadSliceNormalizedNode.indexInBounds(arrayValue_, indexValue_) && ArrayReadSliceNormalizedNode.lengthPositive(lengthValue_) && !ArrayReadSliceNormalizedNode.endInBounds(arrayValue_, indexValue_, lengthValue_) && ArrayGuards.isDoubleArray(arrayValue_)) {
                    return ReadDoubleOutOfBoundsNode_.create(this.root);
                }
                if (RubyGuards.isRubyArray(arrayValue_) && ArrayReadSliceNormalizedNode.indexInBounds(arrayValue_, indexValue_) && ArrayReadSliceNormalizedNode.lengthPositive(lengthValue_) && !ArrayReadSliceNormalizedNode.endInBounds(arrayValue_, indexValue_, lengthValue_) && ArrayGuards.isObjectArray(arrayValue_)) {
                    return ReadObjectOutOfBoundsNode_.create(this.root);
                }
            }
            return null;
        }

        @Override
        protected final SpecializationNode createPolymorphic() {
            return PolymorphicNode_.create(this.root);
        }

        protected final BaseNode_ getNext() {
            return (BaseNode_)this.next;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected final Object executeIndex_(Frame frameValue) {
            Object object;
            Class indexType_ = this.root.indexType_;
            if (indexType_ == Integer.TYPE) {
                return this.root.index_.executeInteger((VirtualFrame)frameValue);
            }
            if (indexType_ != null) return this.root.index_.execute((VirtualFrame)frameValue);
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Class<Object> _type = Object.class;
            try {
                Object _value = this.root.index_.execute((VirtualFrame)frameValue);
                _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                object = _value;
            }
            catch (Throwable throwable) {
                try {
                    this.root.indexType_ = _type;
                    throw throwable;
                }
                catch (UnexpectedResultException ex) {
                    this.root.indexType_ = Object.class;
                    return ex.getResult();
                }
            }
            this.root.indexType_ = _type;
            return object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected final Object executeLength_(Frame frameValue) {
            Object object;
            Class lengthType_ = this.root.lengthType_;
            if (lengthType_ == Integer.TYPE) {
                return this.root.length_.executeInteger((VirtualFrame)frameValue);
            }
            if (lengthType_ != null) return this.root.length_.execute((VirtualFrame)frameValue);
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Class<Object> _type = Object.class;
            try {
                Object _value = this.root.length_.execute((VirtualFrame)frameValue);
                _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                object = _value;
            }
            catch (Throwable throwable) {
                try {
                    this.root.lengthType_ = _type;
                    throw throwable;
                }
                catch (UnexpectedResultException ex) {
                    this.root.lengthType_ = Object.class;
                    return ex.getResult();
                }
            }
            this.root.lengthType_ = _type;
            return object;
        }
    }
}

