/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.methods;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.methods.InternalMethod;

@NodeChildren(value={@NodeChild(value="method"), @NodeChild(value="arguments", type=RubyNode[].class)})
public abstract class CallMethodNode
extends RubyNode {
    public CallMethodNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    public abstract Object executeCallMethod(VirtualFrame var1, InternalMethod var2, Object[] var3);

    @Specialization(guards={"method.getCallTarget() == cachedCallTarget"}, limit="getCacheLimit()")
    protected Object callMethodCached(VirtualFrame frame, InternalMethod method, Object[] frameArguments, @Cached(value="method.getCallTarget()") CallTarget cachedCallTarget, @Cached(value="create(cachedCallTarget)") DirectCallNode callNode) {
        return callNode.call(frame, frameArguments);
    }

    @Specialization
    protected Object callMethodUncached(VirtualFrame frame, InternalMethod method, Object[] frameArguments, @Cached(value="create()") IndirectCallNode indirectCallNode) {
        return indirectCallNode.call(frame, method.getCallTarget(), frameArguments);
    }

    protected int getCacheLimit() {
        return this.getContext().getOptions().DISPATCH_CACHE;
    }
}

