/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient.commons.models;

import java.util.ResourceBundle;
import java.util.Vector;
import org.pdfsam.guiclient.commons.models.AbstractPdfSelectionTableModel;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.guiclient.dto.PdfSelectionTableItem;
import org.pdfsam.i18n.GettextResource;

public class SimplePdfSelectionTableModel
extends AbstractPdfSelectionTableModel {
    private static final long serialVersionUID = 1655126010246744193L;
    protected Vector<PdfSelectionTableItem> data = new Vector();
    protected Configuration config = Configuration.getInstance();

    public SimplePdfSelectionTableModel() {
        this(6, Integer.MAX_VALUE);
    }

    public SimplePdfSelectionTableModel(int showedColumns, int maxRowsNumber) {
        String[] i18nColumnNames = new String[]{"#", GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"File name"), GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Path"), GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Pages"), GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Password"), GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Version"), GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Page Selection")};
        this.setColumnNames(i18nColumnNames);
        String[] i18nToolTips = new String[]{"", "", "", GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Total pages of the document"), GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Password to open the document (if needed)"), GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Pdf version of the document"), GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Double click to set pages you want to merge (ex: 2 or 5-23 or 2,5-7,12-)")};
        this.setToolTips(i18nToolTips);
        this.setShowedColumns(showedColumns);
        this.setMaxRowsNumber(maxRowsNumber);
    }

    @Override
    public int getRowCount() {
        return this.data != null ? this.data.size() : 0;
    }

    @Override
    public Object getValueAt(int row, int col) {
        String retVal = "";
        if (row < this.data.size() && col < this.getShowedColumns()) {
            PdfSelectionTableItem tmpElement = this.data.get(row);
            switch (col) {
                case 0: {
                    retVal = row + 1 + "";
                    break;
                }
                case 1: {
                    retVal = tmpElement.getInputFile() != null ? tmpElement.getInputFile().getName() : "";
                    break;
                }
                case 2: {
                    retVal = tmpElement.getInputFile() != null ? tmpElement.getInputFile().getAbsolutePath() : "";
                    break;
                }
                case 3: {
                    retVal = tmpElement.getPagesNumber() != null ? tmpElement.getPagesNumber() : "";
                    break;
                }
                case 4: {
                    retVal = tmpElement.getPassword() != null ? tmpElement.getPassword() : "";
                    break;
                }
                case 5: {
                    retVal = tmpElement.getPdfVersionDescription();
                    break;
                }
                case 6: {
                    retVal = tmpElement.getPageSelection() != null ? tmpElement.getPageSelection() : "";
                    break;
                }
            }
        }
        return retVal;
    }

    @Override
    public PdfSelectionTableItem getRow(int row) {
        PdfSelectionTableItem retVal = null;
        if (row <= this.data.size()) {
            retVal = this.data.get(row);
        }
        return retVal;
    }

    @Override
    public void setData(PdfSelectionTableItem[] inputData) {
        this.data.clear();
        for (int i = 0; i < inputData.length && this.data.size() < this.getMaxRowsNumber(); ++i) {
            this.data.add(inputData[i]);
        }
        this.fireTableDataChanged();
    }

    @Override
    public void clearData() {
        this.data.clear();
        this.fireTableDataChanged();
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        if (value != null && (6 == column || 4 == column) && row >= 0 && row < this.data.size()) {
            if (6 == column) {
                this.data.get(row).setPageSelection(value.toString());
            } else if (4 == column) {
                this.data.get(row).setPassword(value.toString());
            }
        }
    }

    @Override
    public void addRow(PdfSelectionTableItem inputData) {
        if (inputData != null && this.data.size() < this.getMaxRowsNumber()) {
            this.data.add(inputData);
            this.fireTableRowsInserted(this.data.size(), this.data.size());
        }
    }

    @Override
    public void deleteRow(int row) throws IndexOutOfBoundsException {
        this.data.remove(row);
        this.fireTableRowsDeleted(row, row);
    }

    @Override
    public void deleteRows(int[] rows) throws IndexOutOfBoundsException {
        if (rows.length > 0 && rows.length <= this.data.size()) {
            this.data.subList(rows[0], rows[rows.length - 1] + 1).clear();
            this.fireTableRowsDeleted(rows[0], rows[rows.length - 1]);
        }
    }

    @Override
    public PdfSelectionTableItem[] getRows() {
        PdfSelectionTableItem[] retVal = null;
        if (this.data != null) {
            retVal = this.data.toArray(new PdfSelectionTableItem[this.data.size()]);
        }
        return retVal;
    }

    @Override
    public void addRowAt(int index, PdfSelectionTableItem inputData) {
        if (inputData != null && this.data.size() < this.getMaxRowsNumber() && index >= 0 && index <= this.data.size()) {
            this.data.add(index, inputData);
            this.fireTableRowsInserted(index, index);
        }
    }

    @Override
    public void updateRowAt(int index, PdfSelectionTableItem inputData) {
        if (inputData != null && index >= 0 && index < this.data.size()) {
            this.data.set(index, inputData);
            this.fireTableRowsUpdated(index, index);
        }
    }

    @Override
    public void moveUpRow(int row) throws IndexOutOfBoundsException {
        if (row >= 1 && row < this.data.size()) {
            PdfSelectionTableItem tmpElement = this.data.get(row);
            this.data.set(row, this.data.get(row - 1));
            this.data.set(row - 1, tmpElement);
            this.fireTableRowsUpdated(row - 1, row);
        }
    }

    @Override
    public void moveUpRows(int[] rows) throws IndexOutOfBoundsException {
        if (rows.length > 0 && rows.length < this.data.size() && rows[0] > 0) {
            PdfSelectionTableItem tmpElement = this.data.get(rows[0] - 1);
            for (int i = 0; i < rows.length; ++i) {
                if (rows[i] <= 0) continue;
                this.data.set(rows[i] - 1, this.data.get(rows[i]));
            }
            this.data.set(rows[rows.length - 1], tmpElement);
            this.fireTableRowsUpdated(rows[0] - 1, rows[rows.length - 1]);
        }
    }

    @Override
    public void moveDownRow(int row) throws IndexOutOfBoundsException {
        if (row >= 0 && row < this.data.size() - 1) {
            PdfSelectionTableItem tmpElement = this.data.get(row);
            this.data.set(row, this.data.get(row + 1));
            this.data.set(row + 1, tmpElement);
            this.fireTableRowsUpdated(row, row + 1);
        }
    }

    @Override
    public void moveDownRows(int[] rows) throws IndexOutOfBoundsException {
        if (rows.length > 0 && rows.length < this.data.size() && rows[rows.length - 1] < this.data.size() - 1) {
            PdfSelectionTableItem tmpElement = this.data.get(rows[rows.length - 1] + 1);
            for (int i = rows.length - 1; i >= 0; --i) {
                if (rows[rows.length - 1] >= this.data.size() - 1) continue;
                this.data.set(rows[i] + 1, this.data.get(rows[i]));
            }
            this.data.set(rows[0], tmpElement);
            this.fireTableRowsUpdated(rows[0], rows[rows.length - 1] + 1);
        }
    }

    @Override
    public void sort() {
    }

    @Override
    public AbstractPdfSelectionTableModel.SortingState getSortingState() {
        return null;
    }

    @Override
    public void setSortingState(AbstractPdfSelectionTableModel.SortingState sortingState) {
    }
}

