/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.functions.postscript;

public class OperatorNames {
    public static final int NO_OP = 0;
    public static final int OP_ABS = 1;
    public static final int OP_ADD = 2;
    public static final int OP_AND = 3;
    public static final int OP_ATAN = 4;
    public static final int OP_BITSHIFT = 5;
    public static final int OP_CEILING = 6;
    public static final int OP_COS = 7;
    public static final int OP_COPY = 8;
    public static final int OP_CVI = 9;
    public static final int OP_CVR = 10;
    public static final int OP_DIV = 11;
    public static final int OP_DUP = 12;
    public static final int OP_EQ = 13;
    public static final int OP_EXCH = 14;
    public static final int OP_EXP = 15;
    public static final int OP_FALSE = 16;
    public static final int OP_FLOOR = 17;
    public static final int OP_GE = 18;
    public static final int OP_GT = 19;
    public static final int OP_IDIV = 20;
    public static final int OP_IF = 21;
    public static final int OP_IFELSE = 22;
    public static final int OP_LN = 23;
    public static final int OP_INDEX = 24;
    public static final int OP_LE = 25;
    public static final int OP_LOG = 26;
    public static final int OP_LT = 27;
    public static final int OP_MOD = 28;
    public static final int OP_MUL = 29;
    public static final int OP_NE = 30;
    public static final int OP_NEG = 31;
    public static final int OP_NOT = 32;
    public static final int OP_OR = 33;
    public static final int OP_POP = 34;
    public static final int OP_ROLL = 35;
    public static final int OP_ROUND = 36;
    public static final int OP_SIN = 37;
    public static final int OP_SQRT = 38;
    public static final int OP_SUB = 39;
    public static final int OP_TRUE = 40;
    public static final int OP_TRUNCATE = 41;
    public static final int OP_XOR = 42;
    public static final int OP_EXP_START = 43;
    public static final int OP_EXP_END = 44;

    public static int getType(char[] ch, int offset, int length) {
        char c = ch[offset];
        switch (c) {
            case 'A': 
            case 'a': {
                if (length == 4) {
                    return 4;
                }
                char c1 = ch[offset + 1];
                if (c1 == 'b' || c1 == 'B') {
                    return 1;
                }
                if (c1 != 'd' && c1 != 'D') break;
                return 2;
            }
            case 'B': 
            case 'b': {
                return 5;
            }
            case 'C': 
            case 'c': {
                if (length == 8) {
                    return 6;
                }
                if (length == 4) {
                    return 8;
                }
                char c1 = ch[offset + 1];
                if (c1 == 'o' || c1 == 'O') {
                    return 7;
                }
                if (c1 != 'v' && c1 != 'V') break;
                char c2 = ch[offset + 2];
                if (c2 == 'i' || c2 == 'I') {
                    return 9;
                }
                if (c2 != 'r' && c2 != 'R') break;
                return 10;
            }
            case 'D': 
            case 'd': {
                char c1 = ch[offset + 1];
                if (c1 == 'i' || c1 == 'I') {
                    return 11;
                }
                if (c1 != 'u' && c1 != 'U') break;
                return 12;
            }
            case 'E': 
            case 'e': {
                if (length == 2) {
                    return 13;
                }
                if (length == 3) {
                    return 15;
                }
                if (length != 4) break;
                return 14;
            }
            case 'F': 
            case 'f': {
                return 17;
            }
            case 'G': 
            case 'g': {
                char c1 = ch[offset + 1];
                if (c1 == 'e' || c1 == 'E') {
                    return 18;
                }
                if (c1 != 't' && c1 != 'T') break;
                return 19;
            }
            case 'I': 
            case 'i': {
                if (length == 6) {
                    return 22;
                }
                char c1 = ch[offset + 1];
                if (c1 == 'd' || c1 == 'D') {
                    return 20;
                }
                if (c1 == 'f' || c1 == 'F') {
                    return 21;
                }
                if (c1 != 'n' && c1 != 'N') break;
                if (length == 5) {
                    return 24;
                }
                if (length != 2) break;
                return 23;
            }
            case 'L': 
            case 'l': {
                if (length == 3) {
                    return 26;
                }
                char c1 = ch[offset + 1];
                if (c1 == 'e' || c1 == 'E') {
                    return 25;
                }
                if (c1 != 't' && c1 != 'T') break;
                return 27;
            }
            case 'M': 
            case 'm': {
                char c1 = ch[offset + 1];
                if (c1 == 'o' || c1 == 'O') {
                    return 28;
                }
                if (c1 != 'u' && c1 != 'U') break;
                return 29;
            }
            case 'N': 
            case 'n': {
                if (length == 2) {
                    return 30;
                }
                char c1 = ch[offset + 1];
                if (c1 == 'e' || c1 == 'e') {
                    return 31;
                }
                if (c1 != 'o' && c1 != 'O') break;
                return 32;
            }
            case 'O': 
            case 'o': {
                return 33;
            }
            case 'P': 
            case 'p': {
                return 34;
            }
            case 'R': 
            case 'r': {
                if (length == 4) {
                    return 35;
                }
                if (length != 5) break;
                return 36;
            }
            case 'S': 
            case 's': {
                if (length == 4) {
                    return 38;
                }
                char c1 = ch[offset + 1];
                if (c1 == 'u' || c1 == 'U') {
                    return 39;
                }
                if (c1 != 'i' && c1 != 'I') break;
                return 37;
            }
            case 'T': 
            case 't': {
                return 41;
            }
            case 'X': 
            case 'x': {
                return 42;
            }
            case '{': {
                return 43;
            }
            case '}': {
                return 44;
            }
        }
        return 0;
    }
}

