/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics.text;

import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import org.icepdf.core.pobjects.graphics.text.GlyphText;
import org.icepdf.core.pobjects.graphics.text.LineText;
import org.icepdf.core.pobjects.graphics.text.TextSelect;
import org.icepdf.core.pobjects.graphics.text.WordText;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageText
implements TextSelect {
    private LineText currentLine;
    private ArrayList<LineText> pageLines = new ArrayList(50);

    public void newLine() {
        if (this.currentLine != null && this.currentLine.getWords().size() == 0) {
            return;
        }
        this.currentLine = new LineText();
        this.pageLines.add(this.currentLine);
    }

    public void addGlyph(GlyphText sprite) {
        if (this.currentLine == null) {
            this.newLine();
        }
        this.currentLine.addText(sprite);
    }

    public ArrayList<LineText> getPageLines() {
        return this.pageLines;
    }

    public void applyXObjectTransform(AffineTransform transform) {
        for (LineText lineText : this.pageLines) {
            lineText.clearBounds();
            for (WordText wordText : lineText.getWords()) {
                wordText.clearBounds();
                for (GlyphText glyph : wordText.getGlyphs()) {
                    glyph.normalizeToUserSpace(transform);
                }
            }
        }
    }

    @Override
    public void clearSelected() {
        for (LineText lineText : this.pageLines) {
            lineText.clearSelected();
        }
    }

    @Override
    public void clearHighlighted() {
        for (LineText lineText : this.pageLines) {
            lineText.clearHighlighted();
        }
    }

    @Override
    public StringBuilder getSelected() {
        StringBuilder selectedText = new StringBuilder();
        for (LineText lineText : this.pageLines) {
            selectedText.append((CharSequence)lineText.getSelected());
        }
        return selectedText;
    }

    @Override
    public void selectAll() {
        for (LineText lineText : this.pageLines) {
            lineText.selectAll();
        }
    }

    public void deselectAll() {
        for (LineText lineText : this.pageLines) {
            lineText.clearSelected();
        }
    }

    public void dispose() {
        if (this.pageLines != null) {
            this.pageLines.clear();
            this.pageLines.trimToSize();
        }
    }

    public String toString() {
        StringBuilder extractedText = new StringBuilder();
        for (LineText lineText : this.pageLines) {
            for (WordText wordText : lineText.getWords()) {
                extractedText.append(wordText.getText());
            }
            extractedText.append('\n');
        }
        return extractedText.toString();
    }
}

