/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.console.business;

import java.util.Observer;
import org.apache.log4j.Logger;
import org.pdfsam.console.business.dto.commands.AbstractParsedCommand;
import org.pdfsam.console.business.parser.CmdParseManager;
import org.pdfsam.console.business.pdf.CmdExecuteManager;
import org.pdfsam.console.exceptions.console.ConsoleException;

public class ConsoleServicesFacade {
    private static final Logger LOG = Logger.getLogger(ConsoleServicesFacade.class.getPackage().getName());
    public static final String VERSION = "2.4.3e";
    public static final String CREATOR = "pdfsam-console (Ver. 2.4.3e)";
    private CmdParseManager cmdParserManager = new CmdParseManager();
    private CmdExecuteManager cmdExecuteManager = new CmdExecuteManager();

    public synchronized void execute(AbstractParsedCommand parsedCommand) throws ConsoleException {
        this.cmdExecuteManager.execute(parsedCommand);
    }

    public synchronized AbstractParsedCommand parseAndValidate(String[] inputArguments) throws Exception {
        try {
            AbstractParsedCommand retVal = null;
            if (this.cmdParserManager.parse(inputArguments)) {
                retVal = this.cmdParserManager.validate();
            } else {
                LOG.error("Parse failed.");
            }
            return retVal;
        }
        catch (ConsoleException ce) {
            throw new Exception((Throwable)((Object)ce));
        }
    }

    public synchronized void addExecutionObserver(Observer observer) throws NullPointerException {
        this.cmdExecuteManager.addObserver(observer);
    }

    public static String getLicense() {
        StringBuffer sb = new StringBuffer();
        sb.append("pdfsam-console (Ver. 2.4.3e)  Copyright (C) 2007  Andrea Vacondio\n");
        sb.append("This library is provided under dual license.\n");
        sb.append("You may choose the terms of the Lesser General Public License version 2.1 or the General Public License version 2\n");
        sb.append("License at your discretion.\n\n");
        sb.append("This library is free software; you can redistribute it and/or\n");
        sb.append("modify it under the terms of the GNU Lesser General Public\n");
        sb.append("License as published by the Free Software Foundation;\n");
        sb.append("version 2.1 of the License.\n\n");
        sb.append("This library is distributed in the hope that it will be useful,\n");
        sb.append("but WITHOUT ANY WARRANTY; without even the implied warranty of\n");
        sb.append("MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU\n");
        sb.append("Lesser General Public License for more details.\n\n");
        sb.append("You should have received a copy of the GNU Lesser General Public\n");
        sb.append("License along with this library; if not, write to the Free Software\n");
        sb.append("Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA\n\n\n");
        sb.append("This program is free software: you can redistribute it and/or modify\n");
        sb.append("it under the terms of the GNU General Public License as published by\n");
        sb.append("the Free Software Foundation,version 2 of the License\n\n");
        sb.append("This program is distributed in the hope that it will be useful,\n");
        sb.append("but WITHOUT ANY WARRANTY; without even the implied warranty of\n");
        sb.append("MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n");
        sb.append("GNU General Public License for more details.\n\n");
        sb.append("You should have received a copy of the GNU General Public License\n");
        sb.append("along with this program.  If not, see <http://www.gnu.org/licenses/>..\n");
        sb.append("This is free software, and you are welcome to redistribute it\n");
        sb.append("under certain conditions;\n");
        return sb.toString();
    }
}

