/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.font.afm;

import de.intarsys.cwt.font.afm.AFMChar;
import de.intarsys.cwt.font.afm.AFMParser;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.stream.StreamTools;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class AFM {
    public static final String ATTR_FontName = "FontName";
    private ILocator locator;
    private Map<Integer, AFMChar> charsByCode = new HashMap<Integer, AFMChar>();
    private Map<String, AFMChar> charsByName = new HashMap<String, AFMChar>();
    private Map<String, String> attributes = new HashMap<String, String>();

    public static AFM createFromLocator(ILocator iLocator) throws IOException {
        AFM aFM = new AFM();
        aFM.setLocator(iLocator);
        aFM.initializeFromLocator();
        return aFM;
    }

    public static AFM createNew() {
        return new AFM();
    }

    protected AFM() {
    }

    protected void addChar(AFMChar aFMChar) {
        if (aFMChar.getCode() != -1) {
            this.charsByCode.put(new Integer(aFMChar.getCode()), aFMChar);
        }
        if (aFMChar.getName() != null) {
            this.charsByName.put(aFMChar.getName(), aFMChar);
        }
    }

    public String getAttribute(String string) {
        return this.attributes.get(string);
    }

    public AFMChar getCharByCode(int n) {
        return this.charsByCode.get(new Integer(n));
    }

    public AFMChar getCharByName(String string) {
        return this.charsByName.get(string);
    }

    public String getFontName() {
        return this.getAttribute(ATTR_FontName);
    }

    public ILocator getLocator() {
        return this.locator;
    }

    protected void initializeFromLocator() throws IOException {
        IRandomAccess iRandomAccess = null;
        try {
            iRandomAccess = this.getLocator().getRandomAccess();
            AFMParser aFMParser = new AFMParser(this);
            aFMParser.parse(iRandomAccess);
        }
        finally {
            StreamTools.close((IRandomAccess)iRandomAccess);
        }
    }

    protected void setAttribute(String string, String string2) {
        this.attributes.put(string, string2);
    }

    protected void setLocator(ILocator iLocator) {
        this.locator = iLocator;
    }
}

