/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.color.awt;

import de.intarsys.pdf.pd.PDCSDeviceCMYK;
import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.pdf.pd.PDImage;
import de.intarsys.pdf.platform.cwt.color.awt.AwtColorSpaceFactory;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;

public abstract class AwtColorSpace {
    public static final ColorSpace FALLBACK = new FallbackColorSpace();
    private ColorSpace colorSpace;
    private PDColorSpace pdColorSpace;

    protected static AwtColorSpace getColorSpace(PDColorSpace pDColorSpace) {
        return AwtColorSpaceFactory.get().createColorSpace(pDColorSpace);
    }

    public AwtColorSpace(PDColorSpace pDColorSpace) {
        this.pdColorSpace = pDColorSpace;
    }

    protected abstract ColorSpace createColorSpace();

    public abstract ColorModel getColorModel(PDImage var1);

    public final ColorSpace getColorSpace() {
        if (this.colorSpace == null) {
            this.colorSpace = this.createColorSpace();
        }
        return this.colorSpace;
    }

    public int getNumComponents() {
        return this.getColorSpace().getNumComponents();
    }

    public PDColorSpace getPDColorSpace() {
        return this.pdColorSpace;
    }

    public float[] getRGB(float[] fArray) {
        return this.getColorSpace().toRGB(fArray);
    }

    static class FallbackColorSpace
    extends ColorSpace {
        private ColorSpace cmykColorSpace;
        private ColorSpace grayColorSpace;
        private ColorSpace rgbColorSpace;

        FallbackColorSpace() {
            super(6, 1);
        }

        protected float[] average(float[] fArray) {
            if (fArray.length == 1) {
                return fArray;
            }
            float f = 0.0f;
            float[] fArray2 = fArray;
            int n = fArray.length;
            int n2 = 0;
            while (n2 < n) {
                float f2 = fArray2[n2];
                f += f2;
                ++n2;
            }
            return new float[]{f / (float)fArray.length};
        }

        @Override
        public float[] fromCIEXYZ(float[] fArray) {
            throw new UnsupportedOperationException();
        }

        @Override
        public float[] fromRGB(float[] fArray) {
            throw new UnsupportedOperationException();
        }

        protected ColorSpace getCmykColorSpace() {
            if (this.cmykColorSpace == null) {
                this.cmykColorSpace = AwtColorSpaceFactory.get().createColorSpace((PDColorSpace)PDCSDeviceCMYK.SINGLETON).getColorSpace();
            }
            return this.cmykColorSpace;
        }

        protected ColorSpace getGrayColorSpace() {
            if (this.grayColorSpace == null) {
                this.grayColorSpace = ColorSpace.getInstance(1003);
            }
            return this.grayColorSpace;
        }

        protected ColorSpace getRgbColorSpace() {
            if (this.rgbColorSpace == null) {
                this.rgbColorSpace = ColorSpace.getInstance(1003);
            }
            return this.rgbColorSpace;
        }

        @Override
        public float[] toCIEXYZ(float[] fArray) {
            if (fArray.length == 3) {
                return this.getRgbColorSpace().toCIEXYZ(fArray);
            }
            if (fArray.length == 4) {
                return this.getCmykColorSpace().toCIEXYZ(fArray);
            }
            return this.getGrayColorSpace().toCIEXYZ(this.average(fArray));
        }

        @Override
        public float[] toRGB(float[] fArray) {
            if (fArray.length == 3) {
                return this.getRgbColorSpace().toRGB(fArray);
            }
            if (fArray.length == 4) {
                return this.getCmykColorSpace().toRGB(fArray);
            }
            return this.getGrayColorSpace().toRGB(this.average(fArray));
        }
    }
}

